/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.support;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.types.Customer;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class TechLeaveSupportSessionEvent
extends SimpleHelpLogEvent {
    public static final String ID = "TechLeaveSupportSessionEvent";
    public Customer customerInfo;
    public String sessionDuration;
    public long sessionDurationMS;
    public TechUser techUser;
    public String ipAddress;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_TECH_LEAVE_SUPPORT");
    }

    @Override
    public String getDescription() {
        return "A technician leaves a remote support session.";
    }

    @Override
    public String getLogText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[").append(this.getEventID()).append("] Technician ended a remote support session with a customer:\n");
        buffer.append("\tTechnician:\n");
        buffer.append(this.techUser.getLogString(2));
        buffer.append("\tCustomer:\n");
        buffer.append(this.customerInfo.toLogString(2));
        buffer.append("\tDuration:\n");
        buffer.append("\t\t").append(this.sessionDuration).append(" (").append(this.sessionDurationMS).append("ms)");
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/support/technician_leave");
    }

    public static TechLeaveSupportSessionEvent createEvent(Customer customerInfo, TechUser techUser, long sessionDurationMS, String sessionDurationFormatted, String ipAddress) {
        TechLeaveSupportSessionEvent event = new TechLeaveSupportSessionEvent();
        event.customerInfo = customerInfo;
        event.techUser = techUser;
        event.sessionDuration = sessionDurationFormatted;
        event.sessionDurationMS = sessionDurationMS;
        event.ipAddress = ipAddress;
        return event;
    }

    @Override
    public String getEventID() {
        return "TechnicianLeaveSupportSession";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent((int)indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.customerInfo != null) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"customerInfo", (String)this.customerInfo.toString(true));
        }
        if (this.techUser != null) {
            this.techUser.appendToXML(buffer, indent + 1);
        }
        if (this.sessionDuration != null) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"sessionDuration", (String)this.sessionDuration);
        }
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"sessionDurationMS", (String)Long.toString(this.sessionDurationMS));
        if (this.ipAddress != null) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"ipAddress", (String)this.ipAddress);
        }
        buffer.append(XML14Util.getIndent((int)indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "customerInfo", this.customerInfo.toString(true));
        this.safePut(properties, "techUser", this.techUser.toString());
        this.safePut(properties, "sessionDuration", this.sessionDuration);
        this.safePut(properties, "sessionDurationMS", Long.toString(this.sessionDurationMS));
        this.safePut(properties, "ipAddress", this.ipAddress);
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        variableList.add(new LogEvent.LogEventVariable("sessionDuration", null, this.sessionDuration));
        variableList.add(new LogEvent.LogEventVariable("sessionDurationMS", null, this.sessionDurationMS));
        variableList.add(new LogEvent.LogEventVariable("ipAddress", null, this.ipAddress));
    }
}

