/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging;

import com.aem.utils.Debugger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class EmailTemplateLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] processTemplateFile(File templateFile) {
        if (!templateFile.exists()) {
            templateFile = new File(templateFile.getAbsolutePath() + ".default");
        }
        String[] result = new String[]{"", ""};
        if (!templateFile.exists()) {
            System.out.println("[Server Config] Email template not found: " + templateFile);
        } else {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(templateFile), StandardCharsets.UTF_8));
                String line = reader.readLine();
                boolean first = true;
                while (line != null) {
                    if (!(line = line.trim()).startsWith("#")) {
                        if (first) {
                            result[0] = line;
                            first = false;
                        } else {
                            result[1] = result[1].length() > 0 ? result[1] + "\n" + line : result[1] + line;
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable t) {
                Debugger.error("[Server Config] Error reading template '" + templateFile + "' (" + t.getMessage() + ")");
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Throwable line) {}
            }
        }
        return result;
    }
}

