/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.history;

import java.util.HashMap;
import utils.message.Message;
import utils.progtools.mutable.MutableLong;

public class HistoryMetricBlock {
    long startMS;
    long endMS;
    long supportSessionCount;
    long supportSessionDurations;
    public long presentationSessionCount;
    public long presentationSessionDurations;
    long accessSessionCount;
    long accessSessionDurations;
    private transient HashMap<String, MutableLong> machineSessionCountMap;
    private transient HashMap<String, MutableLong> customerSessionCountMap;
    private int machineSessionCount = -1;
    private int customerSessionCount = -1;

    public HistoryMetricBlock(long start, long end) {
        this.startMS = start;
        this.endMS = end;
    }

    public Message toMessage() {
        Message m = new Message();
        m.append(this.startMS);
        m.append(this.endMS);
        m.append(this.supportSessionCount);
        m.append(this.supportSessionDurations);
        m.append(this.presentationSessionCount);
        m.append(this.presentationSessionDurations);
        m.append(this.accessSessionCount);
        m.append(this.accessSessionDurations);
        m.append(this.getCustomerSessionCount());
        m.append(this.getMachineSessionCount());
        return m;
    }

    public static HistoryMetricBlock fromMessage(Message m) {
        HistoryMetricBlock result = new HistoryMetricBlock(m.getNextLong(), m.getNextLong());
        result.supportSessionCount = m.getNextLong();
        result.supportSessionDurations = m.getNextLong();
        result.presentationSessionCount = m.getNextLong();
        result.presentationSessionDurations = m.getNextLong();
        result.accessSessionCount = m.getNextLong();
        result.accessSessionDurations = m.getNextLong();
        result.customerSessionCount = m.getNextInt();
        result.machineSessionCount = m.getNextInt();
        return result;
    }

    public void registerAccessSession(long duration, String machineID) {
        MutableLong l;
        ++this.accessSessionCount;
        this.accessSessionDurations += duration;
        if (this.machineSessionCountMap == null) {
            this.machineSessionCountMap = new HashMap();
        }
        if ((l = this.machineSessionCountMap.get(machineID)) == null) {
            this.machineSessionCountMap.put(machineID, new MutableLong(1L));
        } else {
            ++l.value;
        }
    }

    public void registerCustomerSession(long duration, String customerID) {
        MutableLong l;
        ++this.supportSessionCount;
        this.supportSessionDurations += duration;
        if (this.customerSessionCountMap == null) {
            this.customerSessionCountMap = new HashMap();
        }
        if ((l = this.customerSessionCountMap.get(customerID)) == null) {
            this.customerSessionCountMap.put(customerID, new MutableLong(1L));
        } else {
            ++l.value;
        }
    }

    public int getMachineSessionCount() {
        if (this.machineSessionCountMap != null) {
            return this.machineSessionCountMap.keySet().size();
        }
        return this.machineSessionCount;
    }

    public int getCustomerSessionCount() {
        if (this.customerSessionCountMap != null) {
            return this.customerSessionCountMap.keySet().size();
        }
        return this.customerSessionCount;
    }
}

