/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.common.notifications;

import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.tech.reporting.ReportResult;
import utils.message.Message;

public class ReportNotification
extends Notification {
    public ReportNotification() {
    }

    public ReportNotification(ReportResult reportResult) {
        super((byte)3, (byte)0, System.currentTimeMillis(), "${REPORT_SUCCESS}", "${REPORT_SUCCESS_MESSAGE,${" + reportResult.getReportRequest().getReportNameTag() + "}}", new ReportMetadata(reportResult.getFilename(), reportResult.getCreationTime()));
    }

    @Override
    protected void loadMetadataFrom(Message m) {
        this.metadata = new ReportMetadata();
        this.metadata.fromMessage(m);
    }

    public ReportMetadata getMetadata() {
        return (ReportMetadata)this.metadata;
    }

    public static class ReportMetadata
    implements Notification.NotificationMetadata {
        public String filename;
        public long creationTime;

        public ReportMetadata(String filename, long time) {
            this.filename = filename;
            this.creationTime = time;
        }

        private ReportMetadata() {
        }

        @Override
        public Message toMessage() {
            Message m = new Message();
            m.append(this.filename);
            m.append(this.creationTime);
            return m;
        }

        @Override
        public void fromMessage(Message m) {
            this.filename = m.getNextString();
            this.creationTime = m.getNextLong();
        }
    }
}

