/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.common;

import com.aem.shelp.proxy.common.alerts.AlertReason;
import com.aem.shelp.proxy.types.Machine;
import java.util.ArrayList;
import utils.message.Message;
import utils.message.MessageUtils;

public class HistoryElement {
    private static final byte VERSION = 0;
    private final long time;
    private final boolean triggered;
    private final Object LOCK = new Object();
    private ArrayList<TriggerEvent> triggerEvents = null;

    public String getReasonSummary() {
        if (this.triggerEvents == null || this.triggerEvents.size() == 0) {
            return null;
        }
        String result = this.triggerEvents.get((int)0).reason.reason;
        if (this.triggerEvents.size() > 1) {
            result = " [1/" + this.triggerEvents.size() + "]";
        }
        return result;
    }

    public ArrayList<TriggerEvent> getTriggerEvents() {
        return this.triggerEvents;
    }

    public HistoryElement(long time, boolean triggered) {
        this.triggered = triggered;
        this.time = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTriggerEvent(TriggerEvent event) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.triggerEvents == null) {
                this.triggerEvents = new ArrayList();
            }
            this.triggerEvents.add(event);
        }
    }

    public void addTriggerEvent(long time, Machine machine, AlertReason reason) {
        TriggerEvent event = new TriggerEvent();
        event.time = time;
        event.machineID = machine.getMachineID();
        event.machineName = machine.getMachineName().toString();
        event.reason = reason;
        this.addTriggerEvent(event);
    }

    public byte[] toBytes() {
        return MessageUtils.messageToBytes((Message)this.toMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message toMessage() {
        Message m = new Message();
        m.append((byte)0);
        m.append(this.time);
        m.append(this.triggered);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.triggerEvents != null) {
                m.append(this.triggerEvents.size());
                for (TriggerEvent event : this.triggerEvents) {
                    event.appendTo(m);
                }
            } else {
                m.append(0);
            }
        }
        return m;
    }

    public static HistoryElement fromBytes(byte[] bytes) {
        Message m = MessageUtils.bytesToMessage((byte[])bytes);
        return HistoryElement.fromMessage(m);
    }

    public static HistoryElement fromMessage(Message m) {
        byte version = m.getNextByte();
        long time = m.getNextLong();
        boolean triggered = m.getNextBoolean();
        HistoryElement result = new HistoryElement(time, triggered);
        int size = m.getNextInt();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                TriggerEvent event = new TriggerEvent();
                event.readFrom(m);
                result.addTriggerEvent(event);
            }
        }
        return result;
    }

    public String toString() {
        return "time:" + this.time + " triggered:" + this.triggered + " triggerEvents:" + (this.triggerEvents != null ? this.triggerEvents.size() : 0);
    }

    public long getTime() {
        return this.time;
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public static class TriggerEvent {
        public long time;
        public String machineID;
        public String machineName;
        public AlertReason reason;

        public void appendTo(Message m) {
            m.append(this.time);
            m.append(this.machineID);
            m.append(this.machineName);
            if (this.reason != null) {
                m.append(this.reason.reason);
                m.append(this.reason.contextDump);
            } else {
                m.append((String)null);
                m.append((String)null);
            }
        }

        public void readFrom(Message m) {
            this.time = m.getNextLong();
            this.machineID = m.getNextString();
            this.machineName = m.getNextString();
            String reason = m.getNextString();
            String contextDump = m.getNextString();
            if (reason == null && contextDump == null) {
                this.reason = null;
            } else {
                this.reason = new AlertReason();
                this.reason.reason = reason;
                this.reason.contextDump = contextDump;
            }
        }
    }
}

