/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.shelp.licence.License;
import com.aem.shelp.proxy.config.ServerConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import utils.message.Message;

public class LicenseSet
implements Iterable<License> {
    private ArrayList<License> allLicenses = new ArrayList();
    private ArrayList<License> activeLicenses = new ArrayList();

    public static LicenseSet fromMessage(Message licenseSetMessage) throws IOException {
        LicenseSet set = new LicenseSet();
        set.loadFrom(licenseSetMessage);
        return set;
    }

    public void updateActiveLicenses() {
        this.activeLicenses.clear();
        if (this.allLicenses.size() == 1) {
            this.activeLicenses.add(this.allLicenses.get(0));
        } else {
            boolean hasStandard = false;
            boolean hasBusiness = false;
            boolean hasEnterprise = false;
            for (License license : this.allLicenses) {
                if (license.isVersion2Standard()) {
                    hasStandard = true;
                    continue;
                }
                if (license.isVersion2Enterprise()) {
                    hasEnterprise = true;
                    continue;
                }
                if (!license.isVersion2Business()) continue;
                hasBusiness = true;
            }
            for (License license : this.allLicenses) {
                if (license.isVersion2Standard() && !hasBusiness && !hasEnterprise) {
                    this.activeLicenses.add(license);
                    continue;
                }
                if (license.isVersion2Business() && !hasEnterprise) {
                    this.activeLicenses.add(license);
                    continue;
                }
                if (!license.isVersion2Enterprise()) continue;
                this.activeLicenses.add(license);
            }
        }
    }

    public String toString() {
        if (this.activeLicenses.size() == 1) {
            return this.getFirstLicense().toString();
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.activeLicenses.size(); ++i) {
            builder.append("-- License ").append(i + 1).append(" --\n");
            builder.append(this.activeLicenses.get(i));
            builder.append("\n");
        }
        return builder.toString();
    }

    public Message toMessage() {
        int success = 0;
        Message m = new Message();
        m.append(0);
        for (License license : this.allLicenses) {
            try {
                m.append(license.toBytes());
                ++success;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        m.set(0, (Object)success);
        return m;
    }

    public void loadFrom(Message m) throws IOException {
        this.allLicenses.clear();
        int count = m.getNextInt();
        for (int i = 0; i < count; ++i) {
            this.allLicenses.add(License.fromBytes(m.getNextByteArray()));
        }
        this.updateActiveLicenses();
    }

    private boolean includeLicense(License license) {
        if (license.isExpired()) {
            return false;
        }
        return !ServerConfig.get().feature_multiLicense || !license.isOutOfSupport();
    }

    public boolean isVersion2Business() {
        if (this.activeLicenses.size() == 0) {
            return false;
        }
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || license.isVersion2Business()) continue;
            return false;
        }
        return true;
    }

    public boolean isVersion2Enterprise() {
        if (this.activeLicenses.size() == 0) {
            return false;
        }
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || license.isVersion2Enterprise()) continue;
            return false;
        }
        return true;
    }

    public boolean isTrial() {
        if (this.activeLicenses.size() == 0) {
            return true;
        }
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || !license.isTrial()) continue;
            return true;
        }
        return false;
    }

    public void addLicense(License newLicense) {
        if (newLicense.getSecRandom() == null) {
            System.out.println("[LicenseSet] Unable to load license, as it is too old.");
            return;
        }
        if (newLicense.isTrial() || this.allLicenses.size() > 0 && this.isLicensedTrial()) {
            this.allLicenses.clear();
            this.allLicenses.add(newLicense);
            return;
        }
        for (License license : this.allLicenses) {
            if (license.getV2LicenseID() != newLicense.getV2LicenseID()) continue;
            System.out.println("[LicenseSet] Attempted to add a license that already exists");
            return;
        }
        this.allLicenses.add(newLicense);
        this.updateActiveLicenses();
    }

    public int getSessionCount() {
        int sessionCount = 0;
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license)) continue;
            sessionCount += license.getSessions();
        }
        return sessionCount;
    }

    public boolean allowsMassToolbox() {
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || license.allowsMassToolbox()) continue;
            return false;
        }
        return true;
    }

    public boolean allowsProvider() {
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || license.allowsProvider()) continue;
            return false;
        }
        return true;
    }

    public boolean allowsRADIUS() {
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || license.allowsRadius()) continue;
            return false;
        }
        return true;
    }

    public boolean allowsAlerts() {
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || license.allowsAlerts()) continue;
            return false;
        }
        return true;
    }

    public boolean allowsTunnels() {
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || license.allowsTunnels()) continue;
            return false;
        }
        return true;
    }

    public boolean allowsMassNotify() {
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || license.allowsMassNotify()) continue;
            return false;
        }
        return true;
    }

    public long getOldestSupportFinishedDate() {
        long finishDate = 0L;
        for (int i = 0; i < this.activeLicenses.size(); ++i) {
            if (!this.includeLicense(this.activeLicenses.get(i))) continue;
            finishDate = i == 0 ? this.activeLicenses.get(i).getSupportFinishMs() : Math.max(finishDate, this.activeLicenses.get(i).getSupportFinishMs());
        }
        return finishDate;
    }

    public long getTrialExpiry() {
        if (this.isTrial() && this.activeLicenses.size() > 0) {
            return this.activeLicenses.get(0).getExpiryMs();
        }
        return 0L;
    }

    public boolean isPlan1Management() {
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || license.isPlan1Management()) continue;
            return false;
        }
        return true;
    }

    public boolean isOutOfSupport() {
        return this.getOldestSupportFinishedDate() < System.currentTimeMillis();
    }

    public int size() {
        return this.activeLicenses.size();
    }

    public License getFirstLicense() {
        return this.activeLicenses.get(0);
    }

    public void clear() {
        this.allLicenses.clear();
        this.activeLicenses.clear();
    }

    public void setLicenses(License lic) {
        this.allLicenses.clear();
        if (lic != null) {
            this.allLicenses.add(lic);
        }
        this.updateActiveLicenses();
    }

    public boolean supportsServerBuild(String yyyyMMddBuildDate) {
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || !license.supportsServerBuild(yyyyMMddBuildDate)) continue;
            return true;
        }
        return false;
    }

    public int getAlertLimit() {
        int limit = 0;
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license)) continue;
            if (limit == 0) {
                limit = license.getAlertLimit();
                continue;
            }
            limit = Math.min(license.getAlertLimit(), limit);
        }
        return limit;
    }

    public int getDemoAttendees() {
        int limit = 0;
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license)) continue;
            if (limit == 0) {
                limit = license.getDemoAttendees();
                continue;
            }
            limit = Math.min(license.getDemoAttendees(), limit);
        }
        return limit;
    }

    public int getLicensePlanVersion() {
        return this.activeLicenses.get(0).getLicensePlanVersion();
    }

    public int getMachineLimit() {
        int limit = 0;
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license)) continue;
            if (limit == 0) {
                limit = license.getMachineLimit();
                continue;
            }
            limit = Math.min(license.getMachineLimit(), limit);
        }
        return limit;
    }

    @Override
    public Iterator<License> iterator() {
        return this.allLicenses.iterator();
    }

    public boolean isLicensed() {
        return this.activeLicenses.size() > 0 && !this.isTrial();
    }

    public boolean isLicensedTrial() {
        return this.activeLicenses.size() > 0 && this.isTrial();
    }

    public boolean isUnlicensedTrial() {
        return this.activeLicenses.size() == 0;
    }

    public boolean allowsRebranding() {
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license) || license.allowsRebranding()) continue;
            return false;
        }
        return true;
    }

    public boolean isExpiredTrial() {
        return this.isTrial() && this.activeLicenses.size() > 0 && this.getFirstLicense().isExpired();
    }

    public int getValidLicenseCount() {
        int count = 0;
        for (License license : this.activeLicenses) {
            if (!this.includeLicense(license)) continue;
            ++count;
        }
        return count;
    }

    public boolean containsLicenseWithID(long v2LicenseID) {
        for (License license : this.allLicenses) {
            if (license.getV2LicenseID() != v2LicenseID) continue;
            return true;
        }
        return false;
    }

    public boolean isActiveLicense(License license) {
        return this.activeLicenses.contains(license);
    }
}

