/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.fs.journal;

import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.GenericFS;
import utils.message.Message;

public class FSEvent {
    public static final int TYPE_ADD = 0;
    public static final int TYPE_CHANGE = 1;
    public static final int TYPE_DELETE = 2;
    public static final int TYPE_MOVE = 3;
    public int type;
    public GFile file;
    public long clock;
    public long eventNum;
    public boolean remote = false;
    public GFile src;

    private FSEvent() {
    }

    public FSEvent(int type, GFile file, long clock) {
        this.file = file;
        this.clock = clock;
    }

    public FSEvent(int type, GFile file, long clock, GFile src) {
        this.file = file;
        this.clock = clock;
        this.src = src;
    }

    public String getEventName() {
        if (this.type == 0) {
            return "FSAddEvent";
        }
        if (this.type == 1) {
            return "FSChangeEvent";
        }
        if (this.type == 2) {
            return "FSDeleteEvent";
        }
        if (this.type == 3) {
            return "FSMoveEvent";
        }
        return "FSUnknownEvent";
    }

    public String toString() {
        return "E" + this.clock + ": (" + this.eventNum + ") " + this.getEventName() + " " + this.file;
    }

    public Message toMessage(GenericFS remoteFS) {
        Message m = new Message();
        m.append(this.type);
        m.append(this.file.toMessage(remoteFS));
        m.append(this.clock);
        m.append(this.eventNum);
        m.append(this.remote);
        if (this.type == 3) {
            m.append(this.src.toMessage(remoteFS));
        }
        return m;
    }

    public static FSEvent fromMessage(Message m) {
        FSEvent fe = new FSEvent();
        fe.type = m.getNextInt();
        fe.file = GFile.fromMessage(m.getNextMessage());
        fe.clock = m.getNextLong();
        fe.eventNum = m.getNextLong();
        fe.remote = m.getNextBoolean();
        if (fe.type == 3) {
            fe.src = GFile.fromMessage(m.getNextMessage());
        }
        return fe;
    }
}

