/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.fs;

import com.aem.sdesktop.interfaces.MSG;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.GVolume;
import com.aem.shelp.mdupload.fs.GenericFS;
import com.aem.shelp.mdupload.fs.MirrorStreamProvider;
import com.aem.shelp.mdupload.fs.journal.FSEvent;
import com.aem.utils.mutex.UnqueuedSemaphore;
import java.io.File;
import java.util.List;
import utils.files.FileMirror;
import utils.message.Message;
import utils.progtools.Cache;

public class RemoteFSHandler {
    private GenericFS fs;
    UnqueuedSemaphore semaphore = new UnqueuedSemaphore(10);
    Object LOCK = new Object();
    Cache<Short, FileMirror> mirrorCache = new Cache("RemoteFSHandlerMirrors", 500);

    public RemoteFSHandler(GenericFS fs) {
        this.fs = fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message handle(Message message, MirrorStreamProvider provider) {
        Message response;
        System.out.println("[FS Instruction] " + message.toPrettyHead(new Class[]{MSG.class}));
        int type = message.getType();
        try {
            if (type == 1589723157) {
                GFile path = GFile.fromMessage(message.getNextMessage());
                long start = message.getNextLong();
                int len = message.getNextInt();
                byte[] tmp = this.fs.readFileChunk(path, start, len);
                response = new Message(1589723177);
                response.append(tmp);
            } else if (type == 1589723158) {
                GFile path = GFile.fromMessage(message.getNextMessage());
                long start = message.getNextLong();
                byte[] dat = message.getNextByteArray();
                long lastmod = message.getNextLong();
                this.fs.writeFileChunk(path, start, dat, 0, dat.length, lastmod);
                response = null;
            } else if (type == 1589723159) {
                for (int i = 0; i < message.length(); ++i) {
                    GFile del = GFile.fromMessage(message.getAsMessage(i));
                    this.fs.deleteFiles(new GFile[]{del});
                }
                response = null;
            } else if (type == 1589723160) {
                GFile path = GFile.fromMessage(message.getNextMessage());
                String name = message.getNextString();
                GFile np = this.fs.renameFile(path, name);
                response = new Message(1589723177);
                response.append(np.toMessage(this.fs));
            } else if (type == 1589723161 || type == 1589723168) {
                if (type == 1589723161) {
                    GFile path = GFile.fromMessage(message.getNextMessage());
                    GFile[] tmp = this.fs.listDir(path);
                    response = new Message(1589723177);
                    for (GFile ge : tmp) {
                        response.append(ge.toMessage(this.fs));
                    }
                } else {
                    GVolume[] tmp = this.fs.listRoots();
                    response = new Message(1589723177);
                    for (GVolume ge : tmp) {
                        response.append(ge.toMessage());
                    }
                }
            } else if (type == 1589723169 || type == 1589723170) {
                GFile ge;
                GFile path = GFile.fromMessage(message.getNextMessage());
                if (type == 1589723169) {
                    ge = this.fs.createFolder(path);
                } else {
                    String newname = message.getNextString();
                    ge = this.fs.createFolder(path, newname);
                }
                response = new Message(1589723177);
                response.append(ge.toMessage(this.fs));
            } else if (type == 1589723171) {
                GFile path = GFile.fromMessage(message.getNextMessage());
                GFile ge = this.fs.getParent(path);
                response = new Message(1589723177);
                response.append(ge.toMessage(this.fs));
            } else if (type == 1589723172) {
                GFile path = GFile.fromMessage(message.getNextMessage());
                this.fs.startJournaling(path);
                response = null;
            } else if (type == 1589723173) {
                GFile path = GFile.fromMessage(message.getNextMessage());
                this.fs.stopJournaling(path);
                response = null;
            } else if (type == 1589723185) {
                GFile file = GFile.fromMessage(message.getNextMessage());
                this.fs.closeFile(file);
                response = null;
            } else if (type == 1589723174) {
                GFile journal = GFile.fromMessage(message.getNextMessage());
                GFile file = GFile.fromMessage(message.getNextMessage());
                this.fs.notifyJournalFileCreated(journal, file);
                response = null;
            } else if (type == 1589723175) {
                GFile journal = GFile.fromMessage(message.getNextMessage());
                GFile file = GFile.fromMessage(message.getNextMessage());
                this.fs.notifyJournalFileDeleted(journal, file);
                response = null;
            } else if (type == 1589723176) {
                GFile journal = GFile.fromMessage(message.getNextMessage());
                long latestEvent = message.getNextLong();
                List<FSEvent> list = this.fs.getJournalEvents(journal, latestEvent);
                response = new Message(1589723177);
                for (FSEvent fe : list) {
                    response.append(fe.toMessage(this.fs));
                }
            } else if (type == 1589723186) {
                GFile file = GFile.fromMessage(message.getNextMessage());
                response = new Message(1589723177);
                response.append(this.fs.getFileSize(file));
            } else if (type == 1589723190) {
                response = new Message(1589723177);
                response.append(System.currentTimeMillis());
            } else if (type == 1589723187) {
                GFile file = GFile.fromMessage(message.getNextMessage());
                response = new Message(1589723177);
                response.append(this.fs.getLastModifiedTime(file));
            } else if (type == 1589723188) {
                GFile file = GFile.fromMessage(message.getNextMessage());
                boolean entireFile = message.getNextBoolean();
                int[] result = this.fs.getHashes(file, entireFile);
                response = new Message(1589723177);
                response.append(result);
            } else if (type == 1589723189) {
                GFile file = GFile.fromMessage(message.getNextMessage());
                long time = message.getNextLong();
                this.fs.setLastModifiedTime(file, time);
                response = null;
            } else if (type == 1589723193) {
                GFile file = GFile.fromMessage(message.getNextMessage());
                long time = message.getNextLong();
                this.fs.setLength(file, time);
                response = null;
            } else if (type == 1589723191) {
                short chan = (short)message.getNextInt();
                GFile file = GFile.fromMessage(message.getNextMessage());
                File local = new File(file.path());
                System.out.println("[RemoteFS] Receiving file to local dir " + local);
                FileMirror mirror = FileMirror.getFileIntoDir(provider.getIn(chan), provider.getOut(chan), local, false);
                Object object = this.LOCK;
                synchronized (object) {
                    this.mirrorCache.addToCache((Object)chan, (Object)mirror);
                }
                this.semaphore.doWait(1);
                try {
                    mirror.waitForFinish();
                }
                finally {
                    this.semaphore.doSignal(1);
                }
                response = null;
            } else if (type == 1589723200) {
                short chan = (short)message.getNextInt();
                try {
                    Object file = this.LOCK;
                    synchronized (file) {
                        ((FileMirror)this.mirrorCache.getFromCache((Object)chan)).cancelTransfer();
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                response = null;
            } else if (type == 1589723192) {
                short chan = (short)message.getNextInt();
                GFile file = GFile.fromMessage(message.getNextMessage());
                File local = new File(file.path());
                System.out.println("[RemoteFS] Sending local file " + local);
                FileMirror mirror = FileMirror.putFileIntoDir(provider.getIn(chan), provider.getOut(chan), local);
                Object object = this.LOCK;
                synchronized (object) {
                    this.mirrorCache.addToCache((Object)chan, (Object)mirror);
                }
                this.semaphore.doWait(1);
                try {
                    mirror.waitForFinish();
                }
                finally {
                    this.semaphore.doSignal(1);
                }
                response = null;
            } else {
                throw new Exception("Unrecognised FS message " + type + "/" + Integer.toHexString(type));
            }
            if (response == null) {
                response = new Message(1589723177);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            response = new Message(1589723184);
            response.append("" + x);
        }
        return response;
    }
}

