/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.fs;

import com.aem.shelp.mdupload.fs.GenericFS;
import java.io.IOException;
import utils.message.Message;

public class GFile {
    private String path;
    public String name;
    public long lastmodified;
    public long size;
    public boolean dir;
    public boolean hidden = false;

    public String path() {
        return this.path;
    }

    private GFile() {
    }

    public GFile(String path, String name, long lastmod, long size, boolean dir, boolean hidden) {
        this.path = path;
        this.name = name;
        this.lastmodified = lastmod;
        this.size = size;
        this.dir = dir;
        this.hidden = hidden;
    }

    public Message toMessage(GenericFS associatedFS) {
        Message m = new Message(783731298);
        if (associatedFS == null) {
            m.append(this.path);
        } else {
            try {
                if (associatedFS.isWindowsFS()) {
                    m.append(this.path.replace('/', '\\'));
                } else {
                    m.append(this.path.replace('\\', '/'));
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                m.append(this.path);
            }
        }
        m.append(this.name);
        m.append(this.lastmodified);
        m.append(this.size);
        m.append(this.dir);
        m.append(this.hidden);
        return m;
    }

    public long getSize() {
        if (this.dir) {
            return -1L;
        }
        return this.size;
    }

    public static GFile fromMessage(Message m) {
        if (m.getType() != 783731298) {
            throw new NullPointerException("Message was wrong type for GFile: " + m.getType());
        }
        GFile gf = new GFile();
        gf.path = m.getNextString();
        gf.name = m.getNextString();
        gf.lastmodified = m.getNextLong();
        gf.size = m.getNextLong();
        gf.dir = m.getNextBoolean();
        gf.hidden = m.getNextBoolean();
        return gf;
    }

    public String toString() {
        return "[GFile (" + this.path + ") " + this.dir + "/" + this.name + "/" + this.size + "/" + this.lastmodified + "]";
    }

    public static GFile getFileRelativeTo(GFile sourceDir, GFile sourceFile, GFile targetDir) {
        String diff = sourceFile.path.substring(sourceDir.path.length());
        char sep = '\\';
        if (targetDir.path.indexOf("/") != -1) {
            sep = '/';
        }
        String npath = targetDir.path + diff;
        npath = npath.replace('\\', sep);
        npath = npath.replace('/', sep);
        GFile gf = new GFile(npath, sourceFile.name, sourceFile.lastmodified, sourceFile.size, sourceFile.dir, sourceFile.hidden);
        return gf;
    }
}

