/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.fs;

import aurelienribon.slidinglayout.SLTransition;
import bcutil.BCUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.mdupload.fs.CrossCopyHandler;
import com.aem.shelp.mdupload.fs.FSPaneListener;
import com.aem.shelp.mdupload.fs.FSProgress;
import com.aem.shelp.mdupload.fs.FSSync;
import com.aem.shelp.mdupload.fs.FSTransferCancelled;
import com.aem.shelp.mdupload.fs.FsAutoUpgrade;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.GVolume;
import com.aem.shelp.mdupload.fs.GenericFS;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.proxy.techclient.RAClient;
import com.aem.shelp.tech.gstarted.MonitoringOnlyUtil;
import com.aem.shelp.util.EasyDateTimeFormatter;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import utils.ostools.OS;
import utils.progtools.ExceptionNameStripper;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.PrintingUtil;
import utils.progtools.Sizes;
import utils.swing.SafeJFileChooser;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.SHJTable;
import utils.swing.components.animated.arrow.ArrowOverlayIcon;
import utils.swing.components.path.PathBar;
import utils.swing.components.path.PathBarListener;
import utils.swing.components.path.elements.FilePathElement;
import utils.swing.components.path.elements.PathElement;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.ScalingUtil;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dnd.FileDropListener;
import utils.swing.dnd.FileTransferable;
import utils.swing.dnd.TableFileDropListener;
import utils.swing.dnd.TextDropListener;
import utils.swing.dnd.awt.DragAndDropHandler;
import utils.swing.dnd.awt.DropStatusListener;
import utils.swing.dnd.swing.DndTransferHandler;
import utils.swing.formatters.DataSizeFormatter;
import utils.swing.icons.SystemIconUtil;
import utils.swing.images.ImageHelper;
import utils.swing.images.ImageLoader;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.GbPanel;
import utils.swing.layout.HierarchyPanel;
import utils.swing.layout.VariableLinePanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.filter.FilterWrapper;
import utils.switches.Switches;

public class FSPane2
extends BorderPanel
implements ActionListener,
TableFileDropListener {
    private static final int DL_FILES = 0;
    private static final int DL_ZIP = 1;
    private static final int DL_SYNC = 2;
    private boolean USE_SPLIT_PANE = false;
    private OnDemandThreadPool requestThreadPool = new OnDemandThreadPool("FSPaneThreadPool", 1, 1, 5);
    private OnDemandThreadPool fsConfigFetcher = new OnDemandThreadPool("FSPaneFetcher", 5, 5, 5);
    private GenericFS fs;
    private FsAutoUpgrade fsUpgrader;
    private boolean monitoringOnly = false;
    private boolean readOnly = false;
    private final JPanel qbuttons;
    private final JScrollPane tableScrollPane;
    private SHJTable table;
    private SimpleList<GFile> slist;
    private FilterWrapper wrapper;
    private final JPanel overlay;
    private final GbPanel buttonBar;
    private final PathBar pathBar = new PathBar(false);
    private final JPanel buttonsPanel;
    private final JToggleButton showqueue;
    private final JButton rename;
    private final JButton delete;
    private final JButton newfolder;
    private final JToggleButton dozip;
    private final JLayeredPane qLayeredPane;
    private final JPanel queueOverlay;
    private final NoContentsInfoPanel noContentsInfoPanel;
    private final JScrollPane queueScrollPane;
    private final VariableLinePanel queuePanel;
    private RootPaneContainer rpc;
    private boolean dragFromQueueInProgress = false;
    private boolean dragFromTableInProgress = false;
    private boolean showTableDrop = false;
    private boolean requestImmediateFsUpgrade = false;
    private boolean showSecureIcons = false;
    private static boolean useLargerScale = false;
    boolean formatAsMB = false;
    FSPaneListener fslistener;
    private final EasyDateTimeFormatter elapsedTimeFormatter = new EasyDateTimeFormatter();
    private GVolume[] roots;
    boolean noDirReports = false;
    private GFile cdir;
    private int remoteOS;
    CrossCopyHandler crossCopy;
    private String SELECTED_DROP = "TableSelectedDrop" + BCUtil.getNextAbsID();
    private static final Comparator<GFile> FILE_ENTRY_WINDOWS = new Comparator<GFile>(){

        @Override
        public int compare(GFile o1, GFile o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.dir && o2.dir || !o1.dir && !o2.dir) {
                return o1.name.toLowerCase().compareTo(o2.name.toLowerCase());
            }
            if (o1.dir) {
                return -1;
            }
            return 1;
        }
    };
    private static final Comparator<GFile> FILE_ENTRY_OTHER = new Comparator<GFile>(){

        @Override
        public int compare(GFile o1, GFile o2) {
            return o1.name.toLowerCase().compareTo(o2.name.toLowerCase());
        }
    };

    public void setShowSecureIcons(boolean b) {
        this.showSecureIcons = b;
    }

    public static void useLargerScale() {
        useLargerScale = true;
    }

    public boolean amSecure() {
        if (this.fs instanceof RAClient) {
            return ((RAClient)this.fs).isSecure();
        }
        return true;
    }

    public boolean amDirect() {
        if (this.fsUpgrader == null) {
            return false;
        }
        return this.fsUpgrader.amDirect();
    }

    public void setFS(GenericFS fs) {
        this.fs = fs;
    }

    private void upgradeFS() {
        GenericFS upgraded;
        if (this.fsUpgrader != null && (upgraded = this.fsUpgrader.upgradeIfPossible(this.fs)) != null) {
            System.out.println("[FSPane] Upgraded FS to " + upgraded);
            this.fs = upgraded;
        }
    }

    public String isTransferring() {
        ArrayList<Component> comps = new ArrayList<Component>();
        Component[] list = this.queuePanel.getComponents();
        for (Component c : list) {
            Component[] list2;
            comps.add(c);
            if (!(c instanceof JPanel)) continue;
            for (Component cc : list2 = ((JPanel)c).getComponents()) {
                comps.add(cc);
            }
        }
        for (Component comp : comps) {
            try {
                TransferBlock block;
                if (!(comp instanceof TransferBlock) || !(block = (TransferBlock)((Object)comp)).isTransferring()) continue;
                return block.transfer.getText() + " " + block.name.getText();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public void requestImmediateFsUpgrade() {
        this.requestImmediateFsUpgrade = true;
    }

    public String getSelectedFileOrFolder(boolean acceptCurrentFolderIfNoSelection) {
        if (this.table.getSelectedRow() != -1) {
            GFile gfile = this.slist.get(this.table.getSelectedRow());
            return gfile.path();
        }
        if (acceptCurrentFolderIfNoSelection) {
            return this.getCurrentFolder();
        }
        return null;
    }

    private String getCurrentFolder() {
        return this.pathBar.getCurrentFolder().getRemotePath();
    }

    private void refreshQueue() {
        this.queuePanel.revalidate();
        this.queuePanel.repaint();
        this.queueScrollPane.repaint();
        this.noContentsInfoPanel.setHasContents(this.queuePanel.getContainedComponentCount() > 0);
    }

    private void uploadToDir(GenericFS curfs, File local, GFile dir, FSProgress progress) throws IOException {
        curfs.uploadIntoDir(local, dir, progress);
    }

    private File downloadToDir(File localDir, GFile remote, FSProgress progress) throws IOException {
        return this.fs.downloadIntoDir(localDir, remote, progress);
    }

    public GFile getCurrentDir() {
        return this.cdir;
    }

    private void initUI(RootPaneContainer rpc, GenericFS fs) {
        this.initUI(rpc, fs, null, null);
    }

    public void initUI(RootPaneContainer rpc, GenericFS fs, GFile dir, FsAutoUpgrade fsUpgrader) {
        this.rpc = rpc;
        this.fs = fs;
        this.fsUpgrader = fsUpgrader;
        this.fsConfigFetcher.runAsync((Runnable)new Load(dir));
    }

    public void useTallRows() {
        this.table.setRowHeight(SimpleHelpLookAndFeel.scale((int)24));
    }

    public void formatAsMB() {
        this.formatAsMB = true;
    }

    public void setMonitoringOnly(boolean mon) {
        this.monitoringOnly = mon;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public FSPane2() {
        this(false);
    }

    public FSPane2(boolean readOnly) {
        this(readOnly, null);
    }

    public FSPane2(boolean readOnly, FSPaneListener fslistener) {
        this.fslistener = fslistener;
        this.fsConfigFetcher.setDumpOldJobsOnBufferMaxed(true);
        this.buttonBar = new GbPanel();
        this.initTable();
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout((LayoutManager)new ScaledFlowLayout(2));
        this.qbuttons = new JPanel();
        this.qbuttons.setLayout((LayoutManager)new ScaledFlowLayout(2));
        this.queuePanel = new VariableLinePanel(0, false, true);
        this.queuePanel.setGridSpacing(new ScaledInsets(5, 5, 0, 5));
        this.queuePanel.setBackground(SHStyle.PANEL_BACKGROUND_LIGHT);
        this.noContentsInfoPanel = new NoContentsInfoPanel(Language.get("FSPANE2_DOWNLOAD"), ImageLoader.getImageIcon((String)"images/svg/computing/download-light.svg,48"), false, false);
        this.queueScrollPane = new JScrollPane((Component)this.queuePanel);
        this.queueScrollPane.setHorizontalScrollBarPolicy(31);
        this.queueScrollPane.setBorder(SHBorderFactory.createMatteBorder((int)1, (int)1, (int)0, (int)0, (Color)SHStyle.BORDER_COLOR));
        this.noContentsInfoPanel.setContentsPanel(this.queueScrollPane);
        this.queueOverlay = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHints(ImageHelper.getQualityRenderingHints());
                if (FSPane2.this.queuePanel.getContainedComponentCount() > 0 && FSPane2.this.dragFromTableInProgress) {
                    int gg = SHStyle.PANEL_BACKGROUND_DARKER.getRed();
                    g.setColor(new Color(gg, gg, gg, 180));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(SHStyle.EXAMPLE_TEXT_COLOR);
                    g.setFont(SHStyle.largeFont);
                    String message = Language.get("FSPANE2_DOWNLOAD");
                    int sw = g.getFontMetrics().stringWidth(message);
                    g.drawString(message, this.getWidth() / 2 - sw / 2, this.getHeight() / 2);
                }
            }
        };
        this.queueOverlay.setOpaque(false);
        this.qLayeredPane = new JLayeredPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = SimpleHelpLookAndFeel.scale((int)250);
                return d;
            }
        };
        this.qLayeredPane.setLayout(new FillLayeredPaneLayout());
        this.qLayeredPane.add((Component)this.noContentsInfoPanel, 0);
        this.qLayeredPane.add((Component)this.queueOverlay, JLayeredPane.POPUP_LAYER);
        this.qLayeredPane.setVisible(false);
        this.rename = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/pencil.svg,16"));
        this.delete = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
        this.newfolder = new JButton(ImageLoader.getImageIcon((String)"images/svg/files-folders/folder.svg,16"));
        this.showqueue = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/computing/download.svg,16"));
        this.dozip = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/files-folders/zip.svg,16"));
        this.rename.setToolTipText(Language.get("TT_RENAME_FILE_REMOTE"));
        this.delete.setToolTipText(Language.get("CONFIRM_DELETE_REMOTE_TITLE"));
        this.newfolder.setToolTipText(Language.get("TT_NEW_FOLDER_REMOTE"));
        this.dozip.setToolTipText(Language.get("TT_ZIP_REMOTE"));
        if (!readOnly) {
            // empty if block
        }
        if (!readOnly) {
            this.buttonsPanel.add(this.rename);
            this.buttonsPanel.add(this.delete);
            this.buttonsPanel.add(this.newfolder);
            if (Switches.SH_fspaneZipButton && !Switches.SH_noZipDownload) {
                this.buttonsPanel.add(this.dozip);
            }
            this.buttonsPanel.add(this.showqueue);
        }
        this.buttonsPanel.revalidate();
        this.qbuttons.setPreferredSize(new Dimension(this.buttonsPanel.getPreferredSize()));
        this.tableScrollPane = new JScrollPane(this.table);
        this.tableScrollPane.setVerticalScrollBarPolicy(22);
        this.tableScrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.overlay = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHints(ImageHelper.getQualityRenderingHints());
                if (FSPane2.this.showTableDrop && !FSPane2.this.dragFromTableInProgress) {
                    int gg = SHStyle.PANEL_BACKGROUND_DARKER.getRed();
                    g.setColor(new Color(gg, gg, gg, 180));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(SHStyle.EXAMPLE_TEXT_COLOR);
                    g.setFont(SHStyle.largeFont);
                    String message = Language.get("FSPANE_UPLOAD");
                    int sw = g.getFontMetrics().stringWidth(message);
                    g.drawString(message, this.getWidth() / 2 - sw / 2, this.getHeight() / 2);
                }
            }
        };
        this.overlay.setOpaque(false);
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.setLayout(new FillLayeredPaneLayout());
        layeredPane.add((Component)this.tableScrollPane, 0);
        layeredPane.add((Component)this.overlay, JLayeredPane.POPUP_LAYER);
        this.buttonBar.add((Component)this.pathBar.getRootComponent(), 0, 0, 1, 1, 1, 0, 13, 2);
        this.buttonBar.add((Component)this.buttonsPanel, 1, 0, 1, 1, 0, 0, 13, 2);
        this.addNorth((JComponent)this.buttonBar);
        if (this.USE_SPLIT_PANE) {
            HierarchyPanel split = new HierarchyPanel();
            split.getHierarchyPanel().setLayout(new GridLayout(1, 1));
            split.getHierarchyPanel().add(layeredPane);
            split.getContentsPanel().setLayout(new GridLayout(1, 1));
            split.getContentsPanel().add(this.qLayeredPane);
            split.setDetailsPanelVisible(false);
            split.setContentsPanelVisible(true);
            split.setHierarchyPanelVisible(true);
            split.setDividerLocations(SimpleHelpLookAndFeel.scale((int)500), 0);
            this.addCenter(split.getRootComponent());
        } else {
            this.addEast(this.qLayeredPane);
            this.addCenter(layeredPane);
        }
        this.pathBar.addPathBarListener(new PathBarListener(){

            @Override
            public void selectedPathElement(PathBar source, PathElement element) {
                if (element instanceof FilePathElement) {
                    FilePathElement fileElement = (FilePathElement)element;
                    File targetFile = fileElement.getFile();
                    System.out.println("[FSPane] Switching to " + targetFile + " (" + targetFile.getPath() + ")");
                    try {
                        FSPane2.this.setDir(new GFile(targetFile.getPath(), targetFile.getName(), 0L, 0L, true, false), true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    FSPane2.this.showVolumes();
                }
            }

            @Override
            public void setShowHiddenFiles(PathBar source, boolean showHiddenFiles) {
            }

            @Override
            public String resolveEnvironmental(String env, PathBar source) {
                return null;
            }
        });
        FSRenderer renderer = new FSRenderer();
        this.table.setDefaultRenderer(Object.class, renderer);
        this.table.setDefaultRenderer(Boolean.class, renderer);
        this.table.setDefaultRenderer(GFile.class, renderer);
        this.table.setDefaultRenderer(Long.class, renderer);
        if (!readOnly) {
            this.table.setTransferHandler(new TransferHandler(){

                @Override
                public int getSourceActions(JComponent c) {
                    return 3;
                }

                @Override
                public Transferable createTransferable(JComponent c) {
                    int row = FSPane2.this.table.getSelectedRow();
                    if (row != -1) {
                        StringSelection src = new StringSelection(FSPane2.this.getValueForRow(row));
                        FSPane2.this.dragStarted();
                        FSPane2.this.dragFromTableInProgress = true;
                        FSPane2.this.noContentsInfoPanel.setIcon(ImageLoader.getImageIcon((String)"images/svg/computing/download.svg,48"));
                        FSPane2.this.noContentsInfoPanel.repaint();
                        FSPane2.this.queueOverlay.repaint();
                        FSPane2.this.showQueue();
                        return src;
                    }
                    return null;
                }

                @Override
                protected void exportDone(JComponent source, Transferable data, int action) {
                    FSPane2.this.dragFromTableInProgress = false;
                    FSPane2.this.noContentsInfoPanel.setIcon(ImageLoader.getImageIcon((String)"images/svg/computing/download-light.svg,48"));
                    FSPane2.this.noContentsInfoPanel.repaint();
                    FSPane2.this.queueOverlay.repaint();
                }
            });
            this.tableScrollPane.addMouseListener(new DragMouseListener());
            TransferHandler transferHandler = new TransferHandler(){
                final DndTransferHandler handler;
                {
                    this.handler = new DndTransferHandler(new QueueDropListener());
                }

                @Override
                public int getSourceActions(JComponent c) {
                    return 3;
                }

                @Override
                public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                    for (DataFlavor flavor : transferFlavors) {
                        if (!flavor.isFlavorTextType()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean importData(JComponent comp, Transferable tf) {
                    this.handler.addListFromDrop(tf);
                    return true;
                }
            };
            this.queuePanel.setTransferHandler(transferHandler);
            this.noContentsInfoPanel.setTransferHandler(transferHandler);
        }
        new Thread(new Load(null)).start();
        this.table.addMouseListener(new TableMouseListener());
        this.rename.addActionListener(this);
        this.delete.addActionListener(this);
        this.newfolder.addActionListener(this);
        this.showqueue.addActionListener(this);
        if (!readOnly) {
            DragAndDropHandler dh = new DragAndDropHandler(new FileDropListener(){

                @Override
                public void filesDropped(File[] files) {
                    ArrayList list = new ArrayList();
                    Collections.addAll(list, files);
                    FSPane2.this.showTableDrop = false;
                    FSPane2.this.overlay.repaint();
                    FSPane2.this.tableSelectionDropped(FSPane2.this.table, list);
                }
            }){

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    DataFlavor[] flavs;
                    for (DataFlavor flav : flavs = dtde.getTransferable().getTransferDataFlavors()) {
                        if (!flav.isFlavorSerializedObjectType()) continue;
                        try {
                            dtde.acceptDrop(3);
                            Object o = dtde.getTransferable().getTransferData(flav);
                            if (!(o instanceof String) || FSPane2.this.crossCopy == null) continue;
                            PackageUpload pkg = new PackageUpload("Pending");
                            String filename = FSPane2.this.crossCopy.crossCopy("" + o, pkg);
                            if (filename == null) {
                                pkg.removeFromQueue();
                            } else {
                                pkg.setName(filename);
                            }
                            FSPane2.this.showQueue();
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                    FSPane2.this.showTableDrop = false;
                    FSPane2.this.repaint();
                    super.drop(dtde);
                }
            };
            dh.setStatusListener(new DropStatusListener(){

                @Override
                public void dragEnter() {
                    FSPane2.this.showTableDrop = true;
                    FSPane2.this.overlay.repaint();
                }

                @Override
                public void dragExit() {
                    FSPane2.this.showTableDrop = false;
                    FSPane2.this.overlay.repaint();
                }

                @Override
                public void dragOver() {
                    FSPane2.this.showTableDrop = true;
                }
            });
            dh.addDragAndDropToComponent(this.table);
        }
        this.initAWTEventListener();
    }

    private void initTable() {
        TableStructure ts = TableStructure.createTableStructure(GFile.class, new String[]{"", "getSize", "lastmodified"}, new String[]{"", Language.get("FILES_COL_SIZE"), Language.get("FILES_COL_MOD")});
        this.slist = new SimpleList();
        this.wrapper = new FilterWrapper<GFile>(this.slist);
        SimpleTableModel slm = new SimpleTableModel(this.wrapper, ts);
        this.table = new SHJTable();
        this.table.setFillsViewportHeight(true);
        this.table.setModel(slm);
        if (!this.readOnly) {
            this.table.setDragEnabled(true);
        }
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FSPane2.this.updateEnabled();
            }
        });
        this.table.setRowHeight(SimpleHelpLookAndFeel.scale((int)20));
        this.table.getTableHeader().setDefaultRenderer(new FSPaneTableHeaderRenderer(this.table));
        this.table.getColumnModel().getColumn(1).setMaxWidth(SimpleHelpLookAndFeel.scale((int)70));
        this.table.getColumnModel().getColumn(2).setMaxWidth(SimpleHelpLookAndFeel.scale((int)140));
        this.table.getColumnModel().getColumn(1).setPreferredWidth(SimpleHelpLookAndFeel.scale((int)70));
        this.table.getColumnModel().getColumn(2).setPreferredWidth(SimpleHelpLookAndFeel.scale((int)140));
        this.table.getColumnModel().getColumn(0).setIdentifier("NAME");
        this.table.getColumnModel().getColumn(1).setIdentifier("SIZE");
        this.table.getColumnModel().getColumn(2).setIdentifier("MOD");
    }

    private void initAWTEventListener() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            private TransferBlock last = null;

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent && FSPane2.this.queuePanel.getContainedComponentCount() > 0 && event.getID() == 504) {
                    Object source = event.getSource();
                    TransferBlock tb = source instanceof TransferBlock ? (TransferBlock)((Object)source) : (TransferBlock)((Object)SwingUtilities.getAncestorOfClass(TransferBlock.class, (Component)source));
                    if (tb != null) {
                        if (this.last != null) {
                            this.last.hideRemoveIcon();
                        }
                        tb.showRemoveIcon();
                        this.last = tb;
                    } else {
                        if (this.last != null) {
                            this.last.hideRemoveIcon();
                        }
                        this.last = null;
                    }
                }
            }
        }, 16L);
    }

    private void showQueue() {
        if (!this.showqueue.isSelected()) {
            this.showqueue.doClick();
        }
    }

    private void hideTableDrop() {
        this.showTableDrop = false;
        this.table.setEnabled(true);
        this.overlay.repaint();
    }

    private void showTableDrop() {
        this.showTableDrop = true;
        this.table.setEnabled(false);
        this.overlay.repaint();
    }

    private int countSlashes(String s) {
        char[] cs;
        int n = 0;
        for (char c : cs = s.toCharArray()) {
            if (c != '/' && c != '\\') continue;
            ++n;
        }
        return n;
    }

    private void updateEnabled() {
        this.newfolder.setEnabled(true);
        if (this.table.getSelectedRowCount() == 0) {
            this.rename.setEnabled(false);
            this.delete.setEnabled(false);
        } else {
            this.rename.setEnabled(true);
            this.delete.setEnabled(true);
        }
    }

    private String getPrimaryDrivePath(GVolume[] roots) {
        if (this.remoteOS == 0) {
            for (GVolume vol : roots) {
                if (!vol.path.startsWith("C:")) continue;
                return vol.path;
            }
        }
        return roots[0].path;
    }

    public static void main(String[] args) throws Exception {
        ScalingUtil.forceScalingPercentage((int)150);
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        FSPane2 fsp = new FSPane2();
        fsp.useTallRows();
        frame.getContentPane().add((Component)((Object)fsp));
        fsp.initUI((RootPaneContainer)frame, new LocalFS());
        frame.setVisible(true);
    }

    private void setDir(GFile file, boolean userInitiated) {
        boolean retry = true;
        while (retry) {
            retry = false;
            try {
                this.setDirAttempt(file, userInitiated);
            }
            catch (IOException x) {
                x.printStackTrace();
                System.out.println("[FSPane] SetDir FAILED: " + x);
                if (this.fslistener != null) {
                    retry = this.fslistener.transferFailed(null, ExceptionNameStripper.toFriendly(x));
                }
                if (retry) {
                    System.out.println("[FSPane] SetDir will RETRY");
                }
                System.out.println("[FSPane] SetDir will NOT retry");
            }
            try {
                if (!userInitiated || this.fslistener == null || this.noDirReports) continue;
                this.fslistener.changedDirectory(file);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirAttempt(final GFile file, final boolean userInitiated) throws IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.requestThreadPool.runAsync(new Runnable(){

                @Override
                public void run() {
                    try {
                        FSPane2.this.setDir(file, userInitiated);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            return;
        }
        this.cdir = file;
        GFile[] all = this.fs.listDir(file);
        Arrays.sort(all, FSPane2.getOSDependentComparator());
        this.slist.clear();
        this.slist.startBatch();
        try {
            Collections.addAll(this.slist, all);
        }
        finally {
            this.slist.endBatch();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FSPane2.this.updateEnabled();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showVolumes() {
        this.slist.clear();
        this.slist.startBatch();
        try {
            for (GVolume volume : this.roots) {
                this.slist.add(new GFile(volume.path, volume.name, 0L, 0L, true, false));
            }
        }
        finally {
            this.slist.endBatch();
        }
        this.updateEnabled();
    }

    int getSelectionCount() {
        return this.table.getSelectedRowCount();
    }

    private GFile getSelectedFile() {
        if (this.table.getSelectedRow() == -1) {
            return null;
        }
        return this.slist.get(this.table.getSelectedRow());
    }

    public GFile[] getCrossCopyFiles() {
        return this.getSelectedFiles();
    }

    private GFile[] getSelectedFiles() {
        GFile[] tmp = new GFile[this.table.getSelectedRowCount()];
        int[] rows = this.table.getSelectedRows();
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.slist.get(rows[i]);
        }
        return tmp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block10: {
            String name;
            Object o;
            block12: {
                block11: {
                    block9: {
                        String newname;
                        o = e.getSource();
                        if (o != this.rename) break block9;
                        GFile gf = this.getSelectedFile();
                        if (gf == null || (newname = SHGlassOptionPane.showInputDialog((RootPaneContainer)this.rpc, (String)Language.get("RENAME_LOCAL_FILE_NAME"), (String)Language.get("RENAME_FILE"), (Icon)ImageLoader.getImageIcon((String)"O[images/svg/text/text.svg,48 | images/svg/general/pencil.svg,24"), (String)Language.get("OK"), (String)gf.name)) == null) break block10;
                        System.out.println("Renaming " + gf.path() + " to " + newname);
                        try {
                            for (GFile tmp : this.slist) {
                                if (!newname.equals(tmp.name)) continue;
                                SHGlassOptionPane.showErrorDialog((RootPaneContainer)this.rpc, (String)Language.get("FILE_EXISTS_SORRY"), (String)Language.get("FILE_EXISTS"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), (String)Language.get("CLOSE"));
                                return;
                            }
                            GFile newfile = this.fs.renameFile(gf, newname);
                            int index = this.slist.indexOf(gf);
                            this.slist.remove(index);
                            this.slist.add(index, newfile);
                        }
                        catch (IOException iOException) {}
                        break block10;
                    }
                    if (o != this.delete) break block11;
                    GFile[] all = this.getSelectedFiles();
                    if (all.length <= 0 || !SHGlassOptionPane.showConfirmDialog((RootPaneContainer)this.rpc, (String)Language.get("CONFIRM_DELETE_REMOTE_MSG"), (String)Language.get("DELETE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), (String)Language.get("DELETE"))) break block10;
                    System.out.println("[FSPane] Deleting files");
                    for (GFile file : all) {
                        System.out.println("[FSPane] Deleting " + file);
                    }
                    try {
                        this.fs.deleteFiles(all);
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                    for (GFile anAll : all) {
                        this.slist.remove(anAll);
                    }
                    break block10;
                }
                if (o != this.showqueue) break block12;
                this.qLayeredPane.setVisible(this.showqueue.isSelected());
                this.revalidate();
                this.repaint();
                break block10;
            }
            if (o != this.newfolder || (name = SHGlassOptionPane.showInputDialog((RootPaneContainer)this.rpc, (String)Language.get("NEW_LOCAL_FOLDER_NAME"), (String)Language.get("NEW_FOLDER"), (Icon)ImageLoader.getImageIcon((String)"O[images/svg/files-folders/folder.svg,48 | images/svg/general/add.svg,24]"), (String)Language.get("OK"), (String)Language.get("FILES_COL_NAME"))) == null) break block10;
            try {
                this.fs.createFolder(this.cdir, name);
                this.setDir(this.cdir, true);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }

    @Override
    public void dragStarted() {
    }

    @Override
    public void dragCancelled() {
    }

    @Override
    public void tableSelectionDropped(JTable srcTable, List filesToCopy) {
        this.hideTableDrop();
        for (Object aFilesToCopy : filesToCopy) {
            File f = (File)aFilesToCopy;
            System.out.println("[FSPane] Upload: " + f);
        }
        this.showQueue();
        new Uploader(filesToCopy).start();
    }

    public void setCrossCopyHandler(CrossCopyHandler handler) {
        this.crossCopy = handler;
    }

    public boolean verifyCrossCopySource(String id) {
        System.out.println("[ShftpApp] Our drop ID is " + this.SELECTED_DROP + " vs current drop " + id);
        return this.SELECTED_DROP.equalsIgnoreCase(id);
    }

    @Override
    public String getValueForRow(int row) {
        return this.SELECTED_DROP;
    }

    public void setRemoteOS(int remoteOS) {
        this.remoteOS = remoteOS;
        this.pathBar.setOS(remoteOS);
    }

    private static Comparator<GFile> getOSDependentComparator() {
        if (OS.isWindows()) {
            return FILE_ENTRY_WINDOWS;
        }
        return FILE_ENTRY_OTHER;
    }

    static /* synthetic */ GVolume[] access$3602(FSPane2 x0, GVolume[] x1) {
        x0.roots = x1;
        return x1;
    }

    private class FillLayeredPaneLayout
    implements LayoutManager {
        private FillLayeredPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            for (Component c : parent.getComponents()) {
                c.setSize(parent.getSize());
            }
        }
    }

    public class FSPaneTableHeaderRenderer
    implements TableCellRenderer {
        final DefaultTableCellRenderer renderer;

        public FSPaneTableHeaderRenderer(JTable table) {
            this.renderer = (DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer();
            this.renderer.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)3, (int)0, (int)3));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            switch (col) {
                case 0: {
                    this.renderer.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    this.renderer.setHorizontalAlignment(4);
                }
            }
            JLabel result = (JLabel)this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            result.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)3, (int)0, (int)3));
            return result;
        }
    }

    private class Uploader
    extends Thread {
        final List files;

        public Uploader(List list) {
            this.files = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (FSPane2.this.monitoringOnly) {
                MonitoringOnlyUtil.disallowedPopup(FSPane2.this.rpc, (Component)((Object)FSPane2.this));
                return;
            }
            GFile dir = FSPane2.this.cdir;
            String filename = dir.name;
            if (this.files != null && this.files.size() > 0) {
                filename = ((File)this.files.get(0)).getName();
            }
            PackageUpload pkg = new PackageUpload(filename);
            FSPane2.this.upgradeFS();
            try {
                boolean retry = true;
                while (retry) {
                    retry = false;
                    for (Object file : this.files) {
                        File f = (File)file;
                        try {
                            FSPane2.this.uploadToDir(FSPane2.this.fs, f, dir, pkg);
                        }
                        catch (FSTransferCancelled x) {
                            System.out.println("[FSPane] Upload cancelled");
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                            System.out.println("[FSPane] Upload FAILED: " + x);
                            if (FSPane2.this.fslistener != null) {
                                retry = FSPane2.this.fslistener.transferFailed(filename, ExceptionNameStripper.toFriendly(x));
                            }
                            if (retry) {
                                System.out.println("[FSPane] Upload will RETRY");
                                continue;
                            }
                            System.out.println("[FSPane] Upload will NOT retry");
                        }
                    }
                }
                try {
                    FSPane2.this.setDir(FSPane2.this.cdir, false);
                    FSPane2.this.repaint();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            finally {
                pkg.removeFromQueue();
            }
        }
    }

    class Load
    implements Runnable {
        GFile dir;

        public Load(GFile dir) {
            this.dir = dir;
        }

        @Override
        public void run() {
            try {
                FSPane2.this.noDirReports = true;
                if (FSPane2.this.fs != null) {
                    FSPane2.access$3602(FSPane2.this, FSPane2.this.fs.listRoots());
                    FSPane2.this.pathBar.setFileSystemRoots(FSPane2.this.roots);
                }
                FSPane2.this.rename.setEnabled(false);
                FSPane2.this.delete.setEnabled(false);
                FSPane2.this.newfolder.setEnabled(false);
                if (FSPane2.this.fs != null && FSPane2.this.roots.length > 0) {
                    FSPane2.this.pathBar.setEnabled(true);
                    if (this.dir == null) {
                        String path = FSPane2.this.getPrimaryDrivePath(FSPane2.this.roots);
                        File primaryFile = new File(path);
                        FSPane2.this.pathBar.setCurrentFolder(primaryFile);
                        FSPane2.this.setDir(new GFile(path, path, 0L, 0L, true, false), false);
                    } else {
                        FSPane2.this.pathBar.setCurrentFolder(new File(this.dir.path()));
                        FSPane2.this.setDir(this.dir, false);
                    }
                } else {
                    FSPane2.this.pathBar.setEnabled(false);
                    FSPane2.this.slist.clear();
                }
                if (FSPane2.this.requestImmediateFsUpgrade) {
                    System.out.println("[FSPane] Requesting immediate FS upgrade");
                    FSPane2.this.upgradeFS();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            finally {
                FSPane2.this.noDirReports = false;
            }
        }
    }

    private class FSRenderer
    extends DefaultTableCellRenderer {
        private FSRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)4, (int)0, (int)4));
            label.setIcon(null);
            if (value == null) {
                return label;
            }
            String cid = (String)table.getColumnModel().getColumn(column).getIdentifier();
            if (cid.equals("NAME")) {
                GFile file;
                block28: {
                    file = (GFile)value;
                    if (FSPane2.this.pathBar.isVolumeListSelected()) {
                        try {
                            String path = file.path();
                            if (path.startsWith("/Volumes")) {
                                label.setIcon(SystemIconUtil.getDefaultFolderIcon());
                                break block28;
                            }
                            if (FSPane2.this.countSlashes(file.path()) > 1) {
                                label.setIcon(SystemIconUtil.getDefaultFolderIcon());
                                break block28;
                            }
                            label.setIcon(SystemIconUtil.getDefaultDriveIcon());
                        }
                        catch (Exception x) {
                            label.setIcon(SystemIconUtil.getDefaultDriveIcon());
                        }
                    } else if (file.dir) {
                        label.setIcon(SystemIconUtil.getDefaultFolderIcon());
                    } else {
                        label.setIcon(SystemIconUtil.getDefaultFileIcon());
                    }
                }
                label.setText(file.name);
                label.setHorizontalAlignment(2);
                if (isSelected) {
                    label.setForeground(UIManager.getColor("Table.selectionForeground"));
                } else {
                    label.setForeground(UIManager.getColor("Table.foreground"));
                }
            } else if (cid.equals("MOD")) {
                long val = (Long)value;
                if (val == 0L) {
                    label.setText("");
                } else {
                    label.setText(FSPane2.this.elapsedTimeFormatter.formatDateTime(val));
                }
                label.setHorizontalAlignment(4);
                if (isSelected) {
                    label.setForeground(UIManager.getColor("Table.selectionForeground"));
                } else {
                    label.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
                }
            } else if (cid.equals("SIZE")) {
                long val = (Long)value;
                if (val == -1L) {
                    label.setText("");
                } else if (FSPane2.this.formatAsMB) {
                    double MBs = val;
                    if ((MBs /= (double)Sizes.MB) < 10.0) {
                        label.setText(PrintingUtil.df1((double)MBs) + " MB");
                    } else {
                        label.setText(PrintingUtil.df0((double)MBs) + " MB");
                    }
                } else {
                    label.setText(DataSizeFormatter.INSTANCE.getFormattedSize(val));
                }
                label.setHorizontalAlignment(4);
                if (isSelected) {
                    label.setForeground(UIManager.getColor("Table.selectionForeground"));
                } else {
                    label.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
                }
            }
            return label;
        }
    }

    class DoTransition
    extends Thread {
        final SLTransition trans;
        long delay;
        boolean cancelled = false;

        public DoTransition(SLTransition trans, long delay) {
            this.trans = trans;
            this.delay = delay;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.cancelled) {
                return;
            }
            long until = System.currentTimeMillis() + 1000L;
            while (System.currentTimeMillis() < until && !this.trans.play()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class TableMouseListener
    implements MouseListener {
        private TableMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && !e.isShiftDown() && !e.isControlDown()) {
                GFile gfile = (GFile)FSPane2.this.slist.get(FSPane2.this.table.getSelectedRow());
                if (gfile.dir) {
                    FSPane2.this.pathBar.setCurrentFolder(new File(gfile.path()));
                    try {
                        FSPane2.this.setDir(gfile, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class DragMouseListener
    implements MouseListener {
        private DragMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            FSPane2.this.dragCancelled();
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            FSPane2.this.dragCancelled();
        }
    }

    abstract class MouseDragStateListener
    implements MouseMotionListener,
    MouseListener {
        boolean amDragging = false;

        MouseDragStateListener() {
        }

        protected abstract void startedDrag(MouseEvent var1);

        protected abstract void finishedDrag();

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.amDragging) {
                this.finishedDrag();
            }
            this.amDragging = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.amDragging) {
                this.finishedDrag();
            }
            this.amDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.amDragging) {
                this.finishedDrag();
            }
            this.amDragging = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FSPane2.this.hideTableDrop();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.amDragging) {
                this.startedDrag(e);
            }
            this.amDragging = true;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    class PackageDownload
    extends TransferHandler
    implements Runnable,
    FSProgress,
    TransferBlockListener {
        final int dl_type;
        TransferBlock block;
        final GFile[] all;
        boolean cancelled = false;
        final ArrayList<File> readyFiles = new ArrayList();
        long totalBytes;

        public PackageDownload(GFile[] all, int dl_type) {
            if (Switches.SH_noZipDownload) {
                dl_type = 0;
            }
            this.dl_type = dl_type;
            this.all = all;
            this.block = new TransferBlock(this, all[0].name, dl_type);
            for (int i = 0; i < all.length; ++i) {
                System.out.println("[FSPane] Downloading " + (i + 1) + "/" + all.length + " : " + all[i].path() + " using " + FSPane2.this.fs);
            }
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FSPane2.this.queuePanel.add((Component)((Object)PackageDownload.this.block));
                    FSPane2.this.refreshQueue();
                }
            });
            FSPane2.this.upgradeFS();
            File sample = null;
            try {
                File file;
                File temp;
                if (this.dl_type == 0) {
                    temp = File.createTempFile("FsPaneFilesDL", "fspane");
                    temp.delete();
                    temp.mkdirs();
                    boolean retry = true;
                    while (retry) {
                        retry = false;
                        try {
                            for (GFile gf : this.all) {
                                File local = FSPane2.this.downloadToDir(temp, gf, this);
                                System.out.println("[FSPane] Locally downloaded file is " + local + " from " + FSPane2.this.fs);
                                this.readyFiles.add(local);
                                if (sample != null) continue;
                                sample = local;
                            }
                        }
                        catch (FSTransferCancelled x) {
                            System.out.println("[FSPane] Download cancelled");
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                            System.out.println("[FSPane] Download FAILED: " + x);
                            if (FSPane2.this.fslistener != null) {
                                retry = FSPane2.this.fslistener.transferFailed(this.all[0].name, ExceptionNameStripper.toFriendly(x));
                            }
                            if (retry) {
                                System.out.println("[FSPane] Download will RETRY");
                                continue;
                            }
                            System.out.println("[FSPane] Download will NOT retry");
                        }
                    }
                } else if (this.dl_type == 1) {
                    temp = File.createTempFile("FsPaneZippedDL", "fspane");
                    temp.delete();
                    temp.mkdirs();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                    File zip = new File(temp, "Downloaded-" + sdf.format(new Date()) + ".zip");
                    ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zip)));
                    this.readyFiles.add(zip);
                    sample = zip;
                    for (GFile gf : this.all) {
                        File file2 = new File(temp, gf.name);
                    }
                    zout.finish();
                    zout.close();
                } else if (this.dl_type == 2 && (file = SafeJFileChooser.pickFile((Component)FSPane2.this.buttonBar)) != null) {
                    LocalFS lfs = new LocalFS();
                    GFile locfile = LocalFS.getFile(file);
                    FSSync sync = new FSSync(lfs, locfile, FSPane2.this.fs, this.all[0]);
                    sync.start();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.block.hideProgress();
            this.block.repaint();
            this.block.setTransferHandler(this);
            MouseDragStateListener listener = new MouseDragStateListener(){

                @Override
                protected void startedDrag(MouseEvent e) {
                    System.out.println("[FSPane] Detected drag from queue");
                    FSPane2.this.dragFromQueueInProgress = true;
                    PackageDownload.this.block.getTransferHandler().exportAsDrag((JComponent)((Object)PackageDownload.this.block), e, 2);
                }

                @Override
                protected void finishedDrag() {
                    FSPane2.this.dragFromQueueInProgress = false;
                }
            };
            this.block.setDragStateListener(listener);
            while (sample != null && sample.exists()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            FSPane2.this.queuePanel.remove((Component)((Object)this.block));
            FSPane2.this.refreshQueue();
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            return new FileTransferable(this.readyFiles);
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
            FSPane2.this.dragFromQueueInProgress = false;
        }

        @Override
        public void transferredBytes(long bytes) throws FSTransferCancelled {
            if (this.isCancelled()) {
                throw new FSTransferCancelled();
            }
            this.totalBytes += bytes;
            this.block.setTransferredBytes(this.totalBytes);
        }

        @Override
        public void cancelAndRemove() {
            FSPane2.this.queuePanel.remove((Component)((Object)this.block));
            FSPane2.this.refreshQueue();
            this.cancelled = true;
        }
    }

    class PackageUpload
    implements FSProgress,
    TransferBlockListener {
        TransferBlock transferBlock;
        boolean cancelled = false;
        long totalBytes;

        public PackageUpload(String filename) {
            this.transferBlock = new TransferBlock(this, filename, 0);
            FSPane2.this.queuePanel.add((Component)((Object)this.transferBlock));
            FSPane2.this.refreshQueue();
        }

        public void setName(String filename) {
            this.transferBlock.setName(filename);
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void removeFromQueue() {
            FSPane2.this.queuePanel.remove((Component)((Object)this.transferBlock));
            FSPane2.this.refreshQueue();
        }

        @Override
        public void transferredBytes(long bytes) throws FSTransferCancelled {
            if (bytes == -1L) {
                System.out.println("[PackageUpload] Cross copy finished, removing");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PackageUpload.this.removeFromQueue();
                        try {
                            FSPane2.this.setDir(FSPane2.this.cdir, false);
                            FSPane2.this.repaint();
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                });
                return;
            }
            if (this.isCancelled()) {
                throw new FSTransferCancelled();
            }
            this.totalBytes += bytes;
            this.transferBlock.setTransferredBytes(this.totalBytes);
        }

        @Override
        public void cancelAndRemove() {
            this.removeFromQueue();
            this.cancelled = true;
        }
    }

    class TransferBlock
    extends BorderPanel {
        JLabel name;
        DownloadPanel downloadPanel;
        JLabel transfer;
        JLabel remove;
        final TransferBlockListener listener;
        long nextRepaint = System.currentTimeMillis();
        long lastRevalidate = 0L;

        void hideProgress() {
            this.transfer.setText("");
            this.downloadPanel.hideProgress();
        }

        public boolean isTransferring() {
            return this.transfer.getText().length() > 0;
        }

        public void setTransferredBytes(long bytes) {
            if (System.currentTimeMillis() > this.nextRepaint) {
                this.nextRepaint = System.currentTimeMillis() + 50L;
                this.transfer.setText(bytes / (long)Sizes.ONE_MEGABYTE + " MB");
                if (System.currentTimeMillis() - this.lastRevalidate > 1000L) {
                    this.revalidate();
                    this.lastRevalidate = System.currentTimeMillis();
                }
                this.repaint();
            }
        }

        public void setName(String filename) {
            this.name.setText(filename);
            this.name.setToolTipText(filename);
            this.repaint();
        }

        public TransferBlock(final TransferBlockListener listener, String filename, int dl_type) {
            Icon fadedIcon;
            Icon icon;
            this.listener = listener;
            System.out.println("[FSPane] New package download : " + filename);
            if (dl_type == 0) {
                if (useLargerScale) {
                    icon = ImageLoader.getImageIcon((String)"images/svg/files-folders/folder.svg,38");
                    fadedIcon = ImageLoader.getImageIconLighter((String)"images/svg/files-folders/folder.svg,38");
                } else if (!FSPane2.this.showSecureIcons) {
                    icon = ImageLoader.getImageIcon((String)"images/svg/files-folders/folder.svg,32");
                    fadedIcon = ImageLoader.getImageIconLighter((String)"images/svg/files-folders/folder.svg,32");
                } else if (FSPane2.this.amSecure()) {
                    icon = ImageLoader.getImageIcon((String)"O[images/svg/files-folders/folder.svg,32 | images/svg/general/shield.svg,12]");
                    fadedIcon = ImageLoader.getImageIconLighter((String)"O[images/svg/files-folders/folder.svg,32 | images/svg/general/shield.svg,12]");
                } else {
                    icon = ImageLoader.getImageIcon((String)"O[images/svg/files-folders/folder.svg,32 | images/svg/general/plainfile.svg,12]");
                    fadedIcon = ImageLoader.getImageIconLighter((String)"O[images/svg/files-folders/folder.svg,32 | images/svg/general/plainfile.svg,12]");
                }
            } else if (dl_type == 1) {
                icon = ImageLoader.getImageIcon((String)"images/svg/files-folders/zip.svg,32");
                fadedIcon = ImageLoader.getImageIconLighter((String)"images/svg/files-folders/zip.svg,32");
            } else if (dl_type == 2) {
                icon = ImageLoader.getImageIcon((String)"images/svg/files-folders/sync-files.svg,32");
                fadedIcon = ImageLoader.getImageIconLighter((String)"images/svg/files-folders/sync-files.svg,32");
            } else {
                System.out.println("[FSPane] Unknown download type : " + dl_type);
                icon = null;
                fadedIcon = null;
            }
            this.transfer = new JLabel(Language.get("COMPARING").toLowerCase());
            this.transfer.setHorizontalAlignment(0);
            this.transfer.setFont(SHStyle.smallFont);
            this.transfer.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            this.remove = new JLabel();
            this.remove.setVisible(false);
            this.remove.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
            this.remove.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    listener.cancelAndRemove();
                }
            });
            this.name = new JLabel(filename);
            this.name.setToolTipText(filename);
            this.name.setHorizontalAlignment(2);
            this.name.setFont(SHStyle.smallFont);
            this.name.setPreferredSize(new Dimension(10, 10));
            this.downloadPanel = new DownloadPanel(icon, fadedIcon);
            this.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)5));
            Border leftBorder = SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)0);
            this.downloadPanel.setBorder(leftBorder);
            this.remove.setBorder(leftBorder);
            this.addWest((JComponent)((Object)this.downloadPanel));
            this.addEast(this.remove);
            BorderPanel inner = new BorderPanel();
            inner.addCenter((JComponent)this.name);
            inner.addEast((JComponent)this.transfer);
            this.addCenter((JComponent)inner);
            this.name.setBorder(leftBorder);
            this.transfer.setBorder(leftBorder);
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (!TransferBlock.this.remove.isVisible()) {
                        TransferBlock.this.showRemoveIcon();
                    }
                }
            });
        }

        private void showRemoveIcon() {
            this.remove.setVisible(true);
            this.repaint();
        }

        private void hideRemoveIcon() {
            this.remove.setVisible(false);
            this.repaint();
        }

        public void setDragStateListener(MouseDragStateListener listener) {
            this.addMouseMotionListener(listener);
            this.addMouseListener(listener);
            this.name.addMouseMotionListener(listener);
            this.name.addMouseListener(listener);
        }
    }

    static interface TransferBlockListener {
        public void cancelAndRemove();
    }

    class DownloadPanel
    extends BorderPanel {
        final ArrowOverlayIcon progressBar;
        private final JLabel iconLabel;
        private final Icon icon;
        private final Icon fadedIcon;

        public DownloadPanel(Icon icon, Icon fadedIcon) {
            this.icon = icon;
            this.fadedIcon = fadedIcon;
            this.progressBar = new ArrowOverlayIcon(fadedIcon);
            this.progressBar.setDrawerColor(Color.white);
            this.progressBar.setArrowOffsets(0, SimpleHelpLookAndFeel.scale((int)3));
            this.iconLabel = new JLabel(this.progressBar);
            this.addCenter(this.iconLabel);
        }

        public void hideProgress() {
            this.iconLabel.setIcon(this.icon);
        }
    }

    private class QueueDropListener
    implements TextDropListener {
        private QueueDropListener() {
        }

        @Override
        public void textDropped(String s) {
            if (s.equals(FSPane2.this.SELECTED_DROP)) {
                int option;
                System.out.println("[FSPane] Adding selected files to queue");
                GFile[] all = FSPane2.this.getSelectedFiles();
                boolean showSync = true;
                if (all.length > 1) {
                    showSync = false;
                }
                if (!all[0].dir) {
                    showSync = false;
                }
                if (Switches.SH_fspaneZipButton) {
                    option = FSPane2.this.dozip.isSelected() ? 1 : 0;
                } else {
                    String[] options = showSync ? new String[]{Language.get("DOWNLOAD_AS_FILES"), Language.get("DOWNLOAD_AS_ZIP"), Language.get("DOWNLOAD_AS_SYNC")} : new String[]{Language.get("DOWNLOAD_AS_FILES"), Language.get("DOWNLOAD_AS_ZIP")};
                    option = SHGlassOptionPane.showChoiceConfirmDialog((RootPaneContainer)FSPane2.this.rpc, (String)Language.get("FSPANE_PACKAGE_MESSAGE"), (String)Language.get("FSPANE_PACKAGE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,48"), (String[])options);
                }
                new Thread(new PackageDownload(all, option)).start();
            }
        }
    }
}

