/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.toolbox;

import utils.message.Message;

public class ToolBoxStatus {
    private static final byte VERSION = 0;
    public static final byte STATUS_INITIALISING = 1;
    public static final byte STATUS_COPY_RESOURCES = 2;
    public static final byte STATUS_LAUNCHING_PROCESS = 3;
    public static final byte STATUS_RUNNING = 4;
    public static final byte STATUS_FINISHED_SUCCESS = 5;
    public static final byte STATUS_FINISHED_ERROR = 6;
    public byte statusCode;
    public String error;
    public String stdout;
    public String stderr;

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Status:").append(this.statusCode);
        if (this.error != null) {
            result.append(" Error:").append(this.error);
        }
        if (this.stdout != null) {
            result.append(" StdOut-len:").append(this.stdout.length());
        }
        if (this.stderr != null) {
            result.append(" StdErr-len:").append(this.stderr.length());
        }
        return result.toString();
    }

    public ToolBoxStatus(String stdout, String stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public ToolBoxStatus(byte statusCode) {
        this.statusCode = statusCode;
    }

    public ToolBoxStatus(String error) {
        this.error = error;
        this.statusCode = (byte)6;
    }

    private ToolBoxStatus() {
    }

    public Message toMessage() {
        Message status = new Message(1589706790);
        status.append((byte)0);
        status.append(this.statusCode);
        status.append(this.error);
        status.append(this.stdout);
        status.append(this.stderr);
        return status;
    }

    public static ToolBoxStatus fromMessage(Message m) {
        ToolBoxStatus status = new ToolBoxStatus();
        byte version = m.getNextByte();
        status.statusCode = m.getNextByte();
        status.error = m.getNextString();
        status.stdout = m.getNextString();
        status.stderr = m.getNextString();
        return status;
    }
}

