/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.toolbox;

import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResource;
import com.aem.shelp.common.toolbox.server.ToolBoxRunner;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.tech.properties.ToolBoxPropertiesPanel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import org.w3c.dom.Element;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.streams.CountingInputStream;
import utils.progtools.streams.CountingOutputStream;
import utils.stream.StreamUtils;
import utils.string.HexData;
import utils.swing.images.ImageLoader;
import utils.xml.XML14Util;

public class ToolBoxGroup
implements Iterable<ToolBoxItem> {
    private long id;
    private String name;
    private byte sharingMode = 0;
    private String sharingDescription = null;
    private boolean isImported = false;
    private String sharedOwnerName = null;
    private int sharedOwnerID = -1;
    private ArrayList<ToolBoxItem> boxItems = new ArrayList();
    public static final byte SHARE_NONE = 0;
    public static final byte SHARE_GROUP = 1;
    public static final byte SHARE_EVERYONE = 2;
    private String iconFieldName;

    public String toString() {
        return this.name + " " + this.sharingDescription + " " + this.sharedOwnerName;
    }

    public void setToolBoxItemIndex(ToolBoxItem item, int index) {
        this.boxItems.remove(item);
        this.boxItems.add(index, item);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ToolBoxGroup)) {
            return false;
        }
        return ((ToolBoxGroup)o).id == this.id;
    }

    private ToolBoxGroup() {
    }

    public ToolBoxGroup(long id) {
        this.id = id;
    }

    public void addToolBoxItem(ToolBoxItem item) {
        this.boxItems.add(item);
    }

    public void removeToolBoxItem(ToolBoxItem item) {
        this.boxItems.remove(item);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Iterator<ToolBoxItem> getToolBoxItems() {
        return this.boxItems.iterator();
    }

    public Message toMessage(boolean isImported) {
        Message message = new Message();
        message.append(2);
        message.append(this.id);
        message.append(this.name);
        message.append(this.boxItems.size());
        for (ToolBoxItem item : this.boxItems) {
            message.append(item.toMessage());
        }
        message.append(this.sharingMode);
        message.append(this.sharingDescription);
        message.append(isImported);
        if (isImported) {
            message.append(this.sharedOwnerName);
            message.append(this.sharedOwnerID);
        }
        message.append(this.iconFieldName);
        return message;
    }

    public void fromMessage(Message message) {
        int version = 0;
        Object next = message.get(0);
        if (!(next instanceof Long)) {
            version = (Integer)next;
            this.id = message.getNextLong();
        } else {
            this.id = (Long)next;
        }
        this.name = message.getNextString();
        int size = message.getNextInt();
        for (int i = 0; i < size; ++i) {
            Message m = message.getNextMessage();
            ToolBoxItem item = new ToolBoxItem();
            item.fromMessage(m);
            this.boxItems.add(item);
        }
        if (version > 0) {
            this.sharingMode = message.getNextByte();
            this.sharingDescription = message.getNextString();
            this.isImported = message.getNextBoolean();
            if (this.isImported) {
                this.sharedOwnerName = message.getNextString();
                this.sharedOwnerID = message.getNextInt();
            } else {
                this.sharedOwnerName = null;
                this.sharedOwnerID = -1;
            }
        }
        if (version > 1) {
            this.iconFieldName = message.getNextString();
        }
    }

    public void toXML(StringBuffer result, int indent) {
        result.append(XML14Util.getIndent((int)indent)).append("<ID>").append(Long.toString(this.id)).append("</ID>\n");
        result.append(XML14Util.getIndent((int)indent)).append("<Name>").append(XML14Util.escape((String)this.name)).append("</Name>\n");
        result.append(XML14Util.getIndent((int)indent)).append("<Sharing>").append(Byte.toString(this.sharingMode)).append("</Sharing>\n");
        result.append(XML14Util.getIndent((int)indent)).append("<IsImported>").append(this.isImported).append("</IsImported>\n");
        result.append(XML14Util.getIndent((int)indent)).append("<OwnerName>").append(this.sharedOwnerName).append("</OwnerName>\n");
        if (this.sharingDescription != null) {
            result.append(XML14Util.getIndent((int)indent)).append("<SharingDescription>").append(HexData.stringToHexString((String)this.sharingDescription)).append("</SharingDescription>\n");
        }
        if (this.iconFieldName != null) {
            result.append(XML14Util.getIndent((int)indent)).append("<Icon>").append(this.iconFieldName).append("</Icon>\n");
        }
        for (ToolBoxItem item : this.boxItems) {
            result.append(XML14Util.getIndent((int)indent)).append("<ToolBoxItem>\n");
            item.toXML(result, indent + 1);
            result.append(XML14Util.getIndent((int)indent)).append("</ToolBoxItem>\n");
        }
    }

    public static ToolBoxGroup loadFromXML(Element element) {
        ToolBoxGroup group = new ToolBoxGroup();
        group.id = Long.parseLong(XML14Util.getChildText((Element)element, (String)"ID", null));
        group.name = XML14Util.getChildText((Element)element, (String)"Name", null);
        String sharing = XML14Util.getChildText((Element)element, (String)"Sharing", null);
        if (sharing != null) {
            group.sharingMode = Byte.parseByte(sharing);
        }
        group.sharingDescription = XML14Util.getChildText((Element)element, (String)"SharingDescription", null);
        if (group.sharingDescription != null) {
            group.sharingDescription = HexData.hexStringToString((String)group.sharingDescription);
        }
        group.iconFieldName = XML14Util.getChildText((Element)element, (String)"Icon", null);
        ArrayList children = XML14Util.getChildrenByName((Element)element, (String)"ToolBoxItem");
        for (Element child : children) {
            ToolBoxItem item = ToolBoxItem.loadFromXML(group, child);
            group.boxItems.add(item);
        }
        return group;
    }

    public long getID() {
        return this.id;
    }

    public boolean containsAnItemForThisOS(int[] targetOS) {
        for (ToolBoxItem item : this.boxItems) {
            if (!item.showOnThisOS(targetOS)) continue;
            return true;
        }
        return false;
    }

    public byte getSharingMode() {
        return this.sharingMode;
    }

    public String getSharingDescription() {
        return this.sharingDescription;
    }

    public void setSharingDescription(String sharingDescription) {
        this.sharingDescription = sharingDescription;
    }

    public void setSharingMode(byte mode) {
        this.sharingMode = mode;
    }

    public int getItemCount() {
        return this.boxItems.size();
    }

    public boolean isImported() {
        return this.isImported;
    }

    public int getSharedOwnerID() {
        return this.sharedOwnerID;
    }

    public String getSharedOwnerName() {
        if (this.sharedOwnerName == null) {
            return OemBranding.OEM_ADMIN_USERNAME;
        }
        return this.sharedOwnerName;
    }

    public void setImported(boolean isImported) {
        this.isImported = isImported;
    }

    public void setSharedToolboxOwnerID(String sharedOwnerName, int sharedOwnerID) {
        this.sharedOwnerID = sharedOwnerID;
        this.sharedOwnerName = sharedOwnerName;
    }

    public ToolBoxItem getItem(int j) {
        return this.boxItems.get(j);
    }

    public void updateFrom(ToolBoxGroup newGroup) {
        this.id = newGroup.id;
    }

    public boolean isIncludedByFilter(String[] filterText) {
        for (ToolBoxItem item : this.boxItems) {
            if (!item.isIncludedByFilter(filterText)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFrom(File importFile) throws IOException {
        try (CountingInputStream bin = new CountingInputStream(new BufferedInputStream(new FileInputStream(importFile)));){
            Message message = MessageUtils.readMessage((InputStream)bin);
            long preservedID = this.id;
            this.fromMessage(message);
            this.id = preservedID;
            while (bin.available() > 0) {
                String itemID = StreamUtils.readStringUTF8((InputStream)bin);
                String resourceID = StreamUtils.readStringUTF8((InputStream)bin);
                boolean isDir = StreamUtils.readBoolean((InputStream)bin);
                String parentDir = isDir ? StreamUtils.readStringUTF8((InputStream)bin) : null;
                String resourceFilename = StreamUtils.readStringUTF8((InputStream)bin);
                long size = StreamUtils.readLong((InputStream)bin);
                ToolBoxItem item = this.getItemByID(itemID);
                if (item != null) {
                    ToolBoxResource newResource = new ToolBoxResource(resourceID, importFile, resourceFilename, bin.getSize(), size);
                    item.addToRecentlyAddedResources(newResource);
                }
                for (long toSkip = size; toSkip > 0L; toSkip -= bin.skip(toSkip)) {
                }
            }
        }
    }

    private ToolBoxItem getItemByID(String itemID) {
        for (ToolBoxItem item : this.boxItems) {
            if (!item.getID().equals(itemID)) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File targetFile, String serverHostname, int serverPort, final ToolBoxPropertiesPanel.SyncCancelledListener listener) throws IOException {
        File saveFile = new File(targetFile.getParentFile(), targetFile.getName() + ".download");
        Message message = this.toMessage(false);
        final CountingOutputStream bout = new CountingOutputStream(new BufferedOutputStream(new FileOutputStream(saveFile)));
        MessageUtils.writeMessage((OutputStream)bout, (Message)message);
        final OffsetTracker tracker = new OffsetTracker();
        try {
            for (ToolBoxItem item : this.boxItems) {
                ToolBoxRunner.fetchResources(item, serverHostname, serverPort, new ToolBoxRunner.ResourceHandler(){

                    @Override
                    public void save(String itemID, String resourceID, String fileURL, long size, String resourceFilename) throws IOException {
                        StreamUtils.writeStringUTF8((OutputStream)bout, (String)itemID);
                        StreamUtils.writeStringUTF8((OutputStream)bout, (String)resourceID);
                        StreamUtils.writeBoolean((OutputStream)bout, (boolean)false);
                        StreamUtils.writeStringUTF8((OutputStream)bout, (String)resourceFilename);
                        ToolBoxGroup.downloadFileWithSize(new URL(fileURL), bout, tracker);
                    }

                    @Override
                    public void save(String itemID, String resourceID, String fileURL, long size, String parentDir, String resourceFilename) throws IOException {
                        StreamUtils.writeStringUTF8((OutputStream)bout, (String)itemID);
                        StreamUtils.writeStringUTF8((OutputStream)bout, (String)resourceID);
                        StreamUtils.writeBoolean((OutputStream)bout, (boolean)true);
                        StreamUtils.writeStringUTF8((OutputStream)bout, (String)parentDir);
                        StreamUtils.writeStringUTF8((OutputStream)bout, (String)resourceFilename);
                        ToolBoxGroup.downloadFileWithSize(new URL(fileURL), bout, tracker);
                    }

                    @Override
                    public boolean cancel() {
                        return listener != null && listener.isCancelled();
                    }
                });
            }
        }
        finally {
            bout.close();
        }
        tracker.setOffsetValues(saveFile);
        if (listener != null && listener.isCancelled()) {
            saveFile.delete();
        } else {
            if (targetFile.exists()) {
                targetFile.delete();
            }
            saveFile.renameTo(targetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadFileWithSize(URL url, CountingOutputStream out, OffsetTracker tracker) throws IOException {
        URLConnection conn = url.openConnection();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream(), 20000);
        long offset = out.getSize();
        StreamUtils.writeLong((OutputStream)out, (long)conn.getContentLengthLong());
        try {
            byte[] dat = new byte[20000];
            int n = 0;
            long total = 0L;
            while (n != -1) {
                n = ((InputStream)in).read(dat);
                if (n <= 0) continue;
                total += (long)n;
                out.write(dat, 0, n);
            }
            tracker.addOffset(offset, total);
        }
        finally {
            FileUtil.robustClose((InputStream)in);
        }
    }

    @Override
    public Iterator<ToolBoxItem> iterator() {
        return this.getToolBoxItems();
    }

    public String getIconFieldName() {
        return this.iconFieldName;
    }

    public void setIconFieldName(String iconFieldName) {
        this.iconFieldName = iconFieldName;
    }

    public Icon getIcon(int size) {
        String iconFieldName = this.getIconFieldName();
        Icon icon = null;
        if (iconFieldName != null) {
            try {
                icon = ImageLoader.getImageIcon((String)(iconFieldName + "," + size));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (icon == null) {
            return ImageLoader.getImageIcon((String)("images/svg/general/box.svg," + size));
        }
        return icon;
    }

    class OffsetTracker {
        private ArrayList<Long> offsets = new ArrayList();
        private ArrayList<Long> values = new ArrayList();

        OffsetTracker() {
        }

        void addOffset(long offset, long value) {
            this.offsets.add(offset);
            this.values.add(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setOffsetValues(File sourceFile) throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(sourceFile, "rw");){
                for (int i = 0; i < this.offsets.size(); ++i) {
                    raf.seek(this.offsets.get(i));
                    raf.writeLong(this.values.get(i));
                }
            }
        }
    }
}

