/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.shelp.common.TechLaunchAPI;
import com.aem.shelp.tech.TechHelpUIArguments;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Properties;
import jwrapper.updater.JWLaunchProperties;

public class TechLaunchAPIResolver {
    public static void resolveIntoLaunchProps(TechLaunchAPI api) throws MalformedURLException {
        Properties jwprops = api.lprops;
        Enumeration<Object> keys = jwprops.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = jwprops.getProperty(key);
            if (val != null && val.length() > 100) {
                System.out.println("[TechLaunchAPI] JWLaunchProperty: <" + key + ">=(" + val.substring(0, 99) + "...)");
                continue;
            }
            System.out.println("[TechLaunchAPI] JWLaunchProperty: <" + key + ">=(" + val + ")");
        }
        String launchURL = JWLaunchProperties.getProperty((String)"serverurl");
        if (launchURL == null || launchURL.length() == 0) {
            launchURL = JWLaunchProperties.getProperty((String)"update_url");
        }
        TechHelpUIArguments args = api.buildTechHelpUIArguments(launchURL);
        Properties techargs = args.getPopulatedProperties();
        Enumeration<Object> keys2 = techargs.keys();
        while (keys2.hasMoreElements()) {
            String key = (String)keys2.nextElement();
            String val = techargs.getProperty(key);
            System.out.println("[TechLaunchAPI] Overriding tech launch prop " + key);
            JWLaunchProperties.overrideDynamicProperty((String)key, (String)val);
        }
    }
}

