/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import build.BuildConstants;
import com.aem.shelp.common.Language;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import jwrapper.cmdline.JWCommandLineWrapper;
import utils.files.FileUtil;
import utils.progtools.URIUtil;
import utils.string.Base64;

public class SupportLaunchAPI {
    public static final String ON = "on";
    public static final String OFF = "off";
    public static final String OPTIONAL = "optional";
    Properties lprops = new Properties();

    public SupportLaunchAPI() {
        this.lprops.setProperty("supported_langs", Language.getAllSupportedLanguages());
    }

    public void setForceSingleLanguage(String langcode) {
        this.lprops.setProperty("supported_langs", langcode);
    }

    public void setConnectNow(String name, Properties info) {
        StringBuffer result = new StringBuffer();
        result.append(ON);
        result.append(",");
        try {
            result.append(URIUtil.urlEncodeSingleURLQueryKeyValue((String)name));
        }
        catch (Throwable t) {
            result.append(name);
        }
        Object[] keys = info.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = info.getProperty(key);
            try {
                key = URIUtil.urlEncodeSingleURLQueryKeyValue((String)key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                value = URIUtil.urlEncodeSingleURLQueryKeyValue((String)value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            result.append(",").append(key).append("=").append(value);
        }
        this.lprops.setProperty("connectnow", result.toString());
    }

    public void setFileTransfer(String option) {
        this.lprops.setProperty("filetransfer", option);
    }

    public void setRemoteDesktop(String option) {
        this.lprops.setProperty("remotedesktop", option);
    }

    public void setTextChat(String option) {
        this.lprops.setProperty("chat", option);
    }

    public void setInvitationCode(String code) {
        this.lprops.setProperty("invite", code);
    }

    public void setRequestElevation(boolean request) {
        if (request) {
            this.lprops.setProperty("requestelevation", "admin");
        } else {
            this.lprops.setProperty("requestelevation", OFF);
        }
    }

    public void setFilterTechnician(String name) {
        this.lprops.setProperty("technician", name);
    }

    public void setFilterTechnicianGroup(String name) {
        this.lprops.setProperty("techniciangroup", name);
    }

    public void setDetailsWindowSize(int width, int height) {
        this.lprops.setProperty("details_width", "" + width);
        this.lprops.setProperty("details_height", "" + width);
    }

    public void setDisclaimerWindowSize(int width, int height) {
        this.lprops.setProperty("disclaimer_width", "" + width);
        this.lprops.setProperty("disclaimer_height", "" + width);
    }

    public void launch(String serverHost, int serverPort) {
        this.launch(serverHost, serverPort, false);
    }

    public void launch(String serverHost, int serverPort, boolean https) {
        if (https) {
            this.launch("https://" + serverHost + ":" + serverPort + "/");
        } else {
            this.launch("http://" + serverHost + ":" + serverPort + "/");
        }
    }

    public void setSplashImagePNG(File PNG) throws IOException {
        this.lprops.setProperty("splash_image", Base64.byteArrayToBase64((byte[])FileUtil.readFile((String)PNG.getAbsolutePath())));
    }

    public void setSplashImagePNG(byte[] PNG) {
        this.lprops.setProperty("splash_image", Base64.byteArrayToBase64((byte[])PNG));
    }

    public void launch(String url) {
        JWCommandLineWrapper jwc = new JWCommandLineWrapper();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        jwc.overrideUpdateURL(url + "customer/");
        jwc.overrideApp(BuildConstants.BUNDLE_CUSTOMER, true, "temp_user");
        jwc.setLaunchProperties(this.lprops);
        jwc.updateAndLaunchAppNow();
    }
}

