/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.shelp.common.Language;

public class GenericVariableUtil {
    public static String substituteVariable(String source, String key, String value) {
        return GenericVariableUtil.substituteVariables(source, new String[]{key}, new String[]{value});
    }

    public static String substituteVariables(String source, String[] keys, String[] values) {
        int index = 0;
        StringBuilder result = new StringBuilder();
        int nextVariableStart = source.indexOf("${");
        while (nextVariableStart != -1) {
            int variableEnd = source.indexOf("}", nextVariableStart);
            if (variableEnd != -1) {
                if (index < nextVariableStart) {
                    result.append(source.substring(index, nextVariableStart));
                }
                index = variableEnd + 1;
                String variable = source.substring(nextVariableStart + 2, variableEnd);
                boolean matched = false;
                for (int i = 0; i < keys.length; ++i) {
                    if (!variable.toLowerCase().equals(keys[i].toLowerCase())) continue;
                    result.append(values[i]);
                    matched = true;
                    break;
                }
                if (!matched) {
                    result.append("${").append(variable).append("}");
                }
            }
            nextVariableStart = source.indexOf("${", nextVariableStart + 2);
        }
        if (index < source.length()) {
            result.append(source.substring(index));
        }
        return result.toString();
    }

    public static String parseAndTranslateString(String source) {
        String variable = GenericVariableUtil.getNextVariable(source);
        while (variable != null) {
            String key = variable.substring(2, variable.length() - 1);
            String[] parts = key.split("\\,");
            for (int i = 1; i < parts.length; ++i) {
                parts[i] = GenericVariableUtil.parseAndTranslateString(parts[i].trim());
            }
            String primaryKey = parts[0];
            Object[] arguments = new Object[parts.length - 1];
            System.arraycopy(parts, 1, arguments, 0, arguments.length);
            String value = Language.get(primaryKey, arguments);
            source = source.replace("${" + key + "}", value);
            variable = GenericVariableUtil.getNextVariable(source);
        }
        return source;
    }

    private static String getNextVariable(String source) {
        int nextIndex = source.indexOf("${");
        if (nextIndex == -1) {
            return null;
        }
        int openCount = 0;
        for (int index = nextIndex + 2; index < source.length(); ++index) {
            if (source.charAt(index) == '{' && source.charAt(index - 1) == '$') {
                ++openCount;
                continue;
            }
            if (source.charAt(index) != '}') continue;
            if (openCount == 0) {
                return source.substring(nextIndex, index + 1);
            }
            --openCount;
        }
        return null;
    }
}

