/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.ui;

import com.aem.shelp.common.Language;
import com.aem.shelp.util.RequestFocusListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import utils.swing.components.SHNakedComboBox;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.panels.DelegateHandler;
import utils.swing.dialog.panels.DialogHandler;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ServerProtocolChoicePanel
implements HierarchyListener {
    static final Protocol UDP = new Protocol("udp://", "UDP (" + Language.get("RECOMMENDED") + ")  ");
    static final Protocol HTTP = new Protocol("http://", "HTTP  ");
    static final Protocol HTTPS = new Protocol("https://", "HTTPS  ");
    private static final Protocol[] PROTOCOLS_UDP = new Protocol[]{UDP, HTTP, HTTPS};
    private static final Protocol[] PROTOCOLS = new Protocol[]{HTTP, HTTPS};
    private DialogGbPanel rootComponent = new DialogGbPanel(new ScaledInsets(0, 0, 0, 0));
    private boolean supportsUDP;
    private JTextField address;
    private JComboBox protocolBox;
    private JLabel warningLabel;

    public String getFullAddress() {
        Protocol p = (Protocol)this.protocolBox.getSelectedItem();
        return p.shortName + this.address.getText().trim();
    }

    public JComponent getFocusComponent() {
        return this.address;
    }

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public ServerProtocolChoicePanel(boolean supportsUDP) {
        this.supportsUDP = supportsUDP;
        this.initUI(null);
    }

    public ServerProtocolChoicePanel(boolean supportsUDP, String urlToEdit) {
        this.supportsUDP = supportsUDP;
        this.initUI(urlToEdit);
    }

    private boolean isValid() {
        return this.address.getText().length() > 0 && !this.address.getText().startsWith("simple-help.com") && !this.address.getText().startsWith("www.simple-help.com");
    }

    private void showWarning() {
        this.warningLabel.setVisible(true);
    }

    private void hideWarning() {
        this.warningLabel.setVisible(false);
    }

    private boolean isUDP(String urlToEdit) {
        return urlToEdit.startsWith("udp:");
    }

    private boolean isHTTP(String urlToEdit) {
        return urlToEdit.startsWith("http:");
    }

    private boolean isHTTPS(String urlToEdit) {
        return urlToEdit.startsWith("https:");
    }

    private String getAddressFrom(String urlToEdit) {
        int index = urlToEdit.indexOf("://");
        if (index >= 0) {
            return urlToEdit.substring(index += 3);
        }
        return "";
    }

    private void initUI(String urlToEdit) {
        this.rootComponent.addHierarchyListener(this);
        int diff = 18;
        this.protocolBox = this.supportsUDP ? new SHNakedComboBox(PROTOCOLS_UDP) : new SHNakedComboBox(PROTOCOLS);
        this.protocolBox.setRenderer(new ProtocolListRenderer());
        if (urlToEdit != null) {
            if (this.supportsUDP) {
                if (this.isUDP(urlToEdit)) {
                    this.protocolBox.setSelectedIndex(0);
                } else if (this.isHTTP(urlToEdit)) {
                    this.protocolBox.setSelectedIndex(1);
                } else {
                    this.protocolBox.setSelectedIndex(2);
                }
            } else if (this.isHTTP(urlToEdit)) {
                this.protocolBox.setSelectedIndex(0);
            } else {
                this.protocolBox.setSelectedIndex(1);
            }
        }
        this.protocolBox.addActionListener(new ActionListener(){
            Object oldSelection = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ServerProtocolChoicePanel.this.protocolBox.getSelectedItem() == HTTPS) {
                    ServerProtocolChoicePanel.this.showWarning();
                    if (this.oldSelection != HTTPS) {
                        Container dialog = ServerProtocolChoicePanel.this.getDialog();
                        Dimension size = dialog.getSize();
                        size.height += 18;
                        dialog.setSize(size);
                    }
                } else {
                    if (this.oldSelection == HTTPS) {
                        Container dialog = ServerProtocolChoicePanel.this.getDialog();
                        Dimension size = dialog.getSize();
                        size.height -= 18;
                        dialog.setSize(size);
                    }
                    ServerProtocolChoicePanel.this.hideWarning();
                }
                this.oldSelection = ServerProtocolChoicePanel.this.protocolBox.getSelectedItem();
                ServerProtocolChoicePanel.this.address.requestFocusInWindow();
            }
        });
        this.address = new JTextField();
        RequestFocusListener requestFocusListener = new RequestFocusListener();
        this.address.addAncestorListener(requestFocusListener);
        this.address.addHierarchyListener(requestFocusListener);
        this.address.addFocusListener(new AutoDetectProtocolListener());
        this.address.addKeyListener(new AutoDetectProtocolKeyListener());
        if (urlToEdit != null) {
            String addressText = this.getAddressFrom(urlToEdit);
            this.address.setText(addressText);
            this.address.setSelectionStart(0);
            this.address.setSelectionEnd(addressText.length());
        }
        JLabel exampleLabel = new JLabel(Language.get("EXAMPLE") + ": http://www.myserver.com:443");
        exampleLabel.setFont(exampleLabel.getFont().deriveFont(SHStyle.EXAMPLE_TEXT_FONT_SIZE));
        exampleLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.warningLabel = new JLabel();
        this.warningLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.warningLabel.setVerticalTextPosition(1);
        this.warningLabel.setHorizontalAlignment(2);
        this.warningLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
        this.warningLabel.setText("The server must have a valid SSL certificate installed.");
        Dimension warningLabelWidth = this.warningLabel.getPreferredSize();
        this.hideWarning();
        this.rootComponent.add(new JLabel(Language.get("PLEASE_ENTER_SG_WEB_ADDRESS")), 0, 0, 2, 1, 1, 1, 10, 2);
        this.rootComponent.add(exampleLabel, 0, 1, 2, 1, 1, 1, 10, 2);
        this.rootComponent.add(this.protocolBox, 0, 2, 1, 1, 0, 1, 10, 0, (Insets)new ScaledInsets(10, 0, 2, 0));
        this.rootComponent.add(this.address, 1, 2, 1, 1, 1000, 1, 10, 2, (Insets)new ScaledInsets(10, 2, 2, 0));
        this.rootComponent.add(this.warningLabel, 0, 3, 2, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(1, 2, 0, 0));
        Dimension preferredSize2 = this.rootComponent.getPreferredSize();
        preferredSize2.width = Math.max(warningLabelWidth.width, preferredSize2.width) + 50;
        this.rootComponent.setPreferredSize(preferredSize2);
        this.address.addAncestorListener(new RequestFocusListener());
    }

    private Container getDialog() {
        for (Container parent = this.rootComponent.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JInternalFrame) && !(parent instanceof Frame) && !(parent instanceof Dialog)) continue;
            return parent;
        }
        return null;
    }

    private void updateEnabled() {
        if (this.rootComponent.dialogHandler != null) {
            this.rootComponent.dialogHandler.setOkEnabled(this.isValid());
        }
    }

    private void detectProtocol() {
        String text = this.address.getText();
        if (text.startsWith("http://")) {
            this.address.setText(text.substring("http://".length()));
            this.protocolBox.setSelectedItem(HTTP);
        } else if (text.startsWith("https://")) {
            this.address.setText(text.substring("https://".length()));
            this.protocolBox.setSelectedItem(HTTPS);
        } else if (text.startsWith("udp://")) {
            this.address.setText(text.substring("udp://".length()));
            if (this.supportsUDP) {
                this.protocolBox.setSelectedItem(UDP);
            } else {
                this.protocolBox.setSelectedItem(HTTP);
            }
        }
        this.updateEnabled();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        this.updateEnabled();
    }

    class AutoDetectProtocolKeyListener
    implements KeyListener {
        AutoDetectProtocolKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            ServerProtocolChoicePanel.this.detectProtocol();
            if (e.getKeyCode() == 10 && ServerProtocolChoicePanel.this.isValid()) {
                ServerProtocolChoicePanel.this.rootComponent.dialogHandler.okPressed();
            } else if (e.getKeyCode() == 27) {
                ServerProtocolChoicePanel.this.rootComponent.dialogHandler.cancelPressed();
            }
        }
    }

    class AutoDetectProtocolListener
    implements FocusListener {
        AutoDetectProtocolListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            ServerProtocolChoicePanel.this.detectProtocol();
        }
    }

    static class ProtocolListRenderer
    extends BasicComboBoxRenderer {
        ProtocolListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel listCellRendererComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                Protocol p = (Protocol)value;
                if (index == -1) {
                    listCellRendererComponent.setText(p.shortName);
                } else {
                    listCellRendererComponent.setText("  " + p.longName);
                }
                listCellRendererComponent.setFont(list.getFont());
            }
            return this;
        }
    }

    static class Protocol {
        String shortName;
        String longName;

        public Protocol(String shortName, String longName) {
            this.shortName = shortName;
            this.longName = longName;
        }
    }

    class DialogGbPanel
    extends GbPanel
    implements DelegateHandler {
        private DialogHandler dialogHandler;

        public DialogGbPanel(ScaledInsets insets) {
            super(insets);
        }

        public void setDialogHandler(DialogHandler handler) {
            this.dialogHandler = handler;
            if (this.dialogHandler != null) {
                this.dialogHandler.setOkEnabled(this.isValid());
            }
        }
    }
}

