/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.common;

import com.aem.sgateway.common.AbstractServiceUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.MiniClient;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Machine;

public class SGServiceUpdateUtil
extends AbstractServiceUtil {
    TechClient client;
    Machine machine;
    String error;

    public SGServiceUpdateUtil(TechClient client, Machine machine) {
        this.client = client;
        this.machine = machine;
    }

    @Override
    public int doUpdate(String machinePassword, String username, String password) {
        try {
            MiniClient mc;
            System.out.println("[SGServiceUpdateUtil] Attempting to update " + this.machine);
            try {
                mc = this.client.startMiniSession(this.machine.getMachineID());
            }
            catch (Exception x) {
                this.error = Language.get("SERVICE_UI_ERROR_CONNECT");
                System.out.println("[SGServiceUpdateUtil] Update of " + this.machine + " failed: " + this.error);
                return RESULT_ERROR;
            }
            if (mc.isLoginRequired()) {
                System.out.println("[SGServiceUpdateUtil] Login required...");
                try {
                    if (!mc.doLogin(machinePassword)) {
                        throw new Exception();
                    }
                }
                catch (Exception x) {
                    this.error = Language.get("SERVICE_UI_ERROR_MACHINE_PASSWORD");
                    System.out.println("[SGServiceUpdateUtil] Update of " + this.machine + " failed: " + this.error + " (login)");
                    return RESULT_MACHINE_PASSWORD;
                }
            }
            System.out.println("[SGServiceUpdateUtil] Login NOT required");
            if (!mc.isElevated()) {
                try {
                    mc.doElevate(username, password);
                }
                catch (Exception x) {
                    this.error = Language.get("SERVICE_UI_ERROR_CREDENTIALS");
                    System.out.println("[SGServiceUpdateUtil] Update of " + this.machine + " failed: " + this.error + " (elevate)");
                    return RESULT_CREDENTIALS;
                }
            }
            if (mc.isSGv3Installation()) {
                try {
                    mc.doSGv4Install();
                    try {
                        mc.close();
                    }
                    catch (Throwable x) {
                        // empty catch block
                    }
                    System.out.println("[SGServiceUpdateUtil] Update of " + this.machine + " was successful");
                    return RESULT_OK;
                }
                catch (Exception x) {
                    if (x.getMessage().contains("java.net.BindException: Address already in use: JVM_Bind")) {
                        System.out.println("[SGServiceUpdateUtil] NOTE: a v4 service is already running.");
                        x.printStackTrace();
                        return RESULT_OK;
                    }
                    x.printStackTrace();
                    this.error = Language.get("SERVICE_UI_ERROR_GENERAL");
                    System.out.println("[SGServiceUpdateUtil] Update of " + this.machine + " failed: " + this.error + " - " + x);
                    return RESULT_ERROR;
                }
            }
            return RESULT_OK;
        }
        catch (Exception x) {
            x.printStackTrace();
            this.error = Language.get("SERVICE_UI_ERROR_GENERAL");
            System.out.println("[SGServiceUpdateUtil] Update of " + this.machine + " failed: " + this.error + " - " + x);
            return RESULT_ERROR;
        }
    }

    @Override
    public String getErrorExplanation() {
        return this.error;
    }
}

