/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import bcutil.BCUtil;
import com.aem.shelp.util.PasswordAuthenticator;
import com.aem.utils.NativeUtils;
import com.aem.utils.blowfish.Blowfish;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.progtools.net.SafeHostname;
import utils.stream.StreamUtils;
import utils.string.HexData;
import utils.string.SafeCmp;
import utils.string.StringUtil;
import utils.xml.FastXMLParser;
import utils.xml.XML14Util;
import utils.xml.XMLParserListener;

public class SimpleGatewayConfig {
    private long lastModified;
    private String cachedNameWithMacros;
    private String name = "AUTODETECT";
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyUser = null;
    private String proxyPass = null;
    private String password = null;
    public boolean allowMonitoring = true;
    public boolean allowScripting = true;
    public boolean sessionsRequirePermission = false;
    public long requirePermissionTimeoutMS = 0L;
    public boolean allowRecovery = true;
    private String[] URLs;
    private final HashMap<String, String> pkhashes = new HashMap();
    private final HashMap<String, String> recoverykeys = new HashMap();
    private static final String AUTODETECT = "AUTODETECT";

    public HashMap<String, String> getPkHashMapCopy() {
        return new HashMap<String, String>(this.pkhashes);
    }

    public static File getConfigLocation() {
        System.out.println("[SimpleGatewayConfig] Retrieving configuration file location");
        File parent = JWSystem.getAllAppVersionsSharedFolder();
        if (parent == null) {
            return new File("serviceconfig.xml");
        }
        return new File(parent, "serviceconfig.xml");
    }

    private static String decryptPass(String pword) {
        Blowfish bfish = new Blowfish();
        bfish.init("dankjcxnaksd89p7*(7*(uPj8943up34pjn0mXC)N&p987&*#(#()3)&40&)098970*78**");
        byte[] dat = HexData.hexStringToByteArray((String)pword);
        dat = bfish.decryptSecure(dat, 0, false);
        try {
            return new String(dat, "UnicodeBig");
        }
        catch (Exception x) {
            return new String(dat);
        }
    }

    private static String encryptPassv2(String pword) throws IOException {
        return BCUtil.encryptedPassword((String)pword, (String)"SDOIcxnaksdawwqrz,o5o2n4o6en1HA89p7*(7*(uPj8943j??+=aoji92klasdj1210ASA09a!(82");
    }

    private static String decryptPassv2(String pword) throws IOException {
        return BCUtil.decryptPassword((String)pword, (String)"SDOIcxnaksdawwqrz,o5o2n4o6en1HA89p7*(7*(uPj8943j??+=aoji92klasdj1210ASA09a!(82");
    }

    public void setAllowRecovery(boolean b) {
        this.allowRecovery = b;
    }

    public void setAllowMonitoring(boolean b) {
        this.allowMonitoring = b;
    }

    public void setAllowScripting(boolean b) {
        this.allowScripting = b;
    }

    public void setRequireSessionConfirmation(boolean requirePermission, long timeout) {
        this.sessionsRequirePermission = requirePermission;
        this.requirePermissionTimeoutMS = timeout;
    }

    public boolean getAllowRecovery() {
        return this.allowRecovery;
    }

    public boolean getAllowMonitoring() {
        return this.allowMonitoring;
    }

    public boolean getAllowScripting() {
        return this.allowScripting;
    }

    public boolean getRequireSessionConfirmation() {
        return this.sessionsRequirePermission;
    }

    public long getRequirePermissionTimeoutMS() {
        return this.requirePermissionTimeoutMS;
    }

    public String getPassword() {
        return this.password;
    }

    private String getSecureElement(Element root, String tag) throws IOException {
        String passwordText = XML14Util.getChildText((Element)root, (String)("Secure" + tag + "v2"), null);
        if (passwordText != null) {
            return SimpleGatewayConfig.decryptPassv2(passwordText);
        }
        passwordText = XML14Util.getChildText((Element)root, (String)("Secure" + tag), null);
        if (passwordText != null) {
            return SimpleGatewayConfig.decryptPass(passwordText);
        }
        passwordText = XML14Util.getChildText((Element)root, (String)tag, null);
        if (passwordText != null) {
            return XML14Util.unescape((String)passwordText);
        }
        return null;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public void removeUrlHashes(String url) {
        this.pkhashes.remove(url);
        this.recoverykeys.remove(url);
    }

    public ArrayList<String> getAllPubkeyHashes() {
        Object[] array = this.pkhashes.values().toArray();
        ArrayList<String> hashes = new ArrayList<String>();
        for (Object o : array) {
            hashes.add((String)o);
        }
        return hashes;
    }

    public ArrayList<String> getAllUrlsWithHashes() {
        Object[] array = this.pkhashes.keySet().toArray();
        ArrayList<String> urls = new ArrayList<String>();
        for (Object o : array) {
            urls.add((String)o);
        }
        return urls;
    }

    public String getUrlRecoveryKey(String url) {
        return this.recoverykeys.get(url);
    }

    public void setUrlRecoveryKey(String url, String pkhash) {
        this.recoverykeys.put(url, pkhash);
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String[] getSafeURLs() {
        String[] tmp = new String[this.URLs.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.URLs[i];
            if (tmp[i].contains("://")) continue;
            tmp[i] = "udp://" + tmp[i];
        }
        return tmp;
    }

    public String[] getRawURLs() {
        return this.URLs;
    }

    public byte[] save(boolean encryptedPass) throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<SimpleGatewayService>\n");
        buffer.append("\t<Name>").append(XML14Util.escape((String)this.getName())).append("</Name>\n");
        if (encryptedPass) {
            if (this.getPassword() != null && this.getPassword().length() > 0) {
                buffer.append("\t<SecurePasswordv2>").append(SimpleGatewayConfig.encryptPassv2(this.getPassword())).append("</SecurePasswordv2>\n");
            }
        } else if (this.getPassword() != null && this.getPassword().length() > 0) {
            buffer.append("\t<Password>").append(XML14Util.escape((String)this.getPassword())).append("</Password>\n");
        }
        if (this.URLs != null) {
            for (String URL2 : this.URLs) {
                String urlRecoveryKey = this.getUrlRecoveryKey(URL2);
                buffer.append("\t<ConnectTo");
                if (urlRecoveryKey != null) {
                    buffer.append(" reckey=\"").append(urlRecoveryKey).append("\"");
                }
                buffer.append(">").append(URL2).append("</ConnectTo>\n");
            }
        }
        if (this.getProxyHost() != null && this.getProxyHost().length() > 0) {
            buffer.append("\t<Proxy>\n");
            buffer.append("\t\t<Host>").append(this.getProxyHost()).append("</Host>\n");
            buffer.append("\t\t<Port>").append(this.getProxyPort()).append("</Port>\n");
            if (this.getProxyUser() != null && this.getProxyUser().length() > 0) {
                if (encryptedPass) {
                    buffer.append("\t\t<SecureUsernamev2>").append(SimpleGatewayConfig.encryptPassv2(this.getProxyUser())).append("</SecureUsernamev2>\n");
                    buffer.append("\t\t<SecurePasswordv2>").append(SimpleGatewayConfig.encryptPassv2(this.getProxyPass())).append("</SecurePasswordv2>\n");
                } else {
                    buffer.append("\t\t<Username>").append(XML14Util.escape((String)this.getProxyUser())).append("</Username>\n");
                    buffer.append("\t\t<Password>").append(XML14Util.escape((String)this.getProxyPass())).append("</Password>\n");
                }
            }
            buffer.append("\t</Proxy>\n");
        }
        buffer.append("\t<AllowMonitoring>").append(this.allowMonitoring).append("</AllowMonitoring>\n");
        buffer.append("\t<AllowScripting>").append(this.allowScripting).append("</AllowScripting>\n");
        buffer.append("\t<RequireSessionConfirmation>").append(this.sessionsRequirePermission).append("</RequireSessionConfirmation>\n");
        buffer.append("\t<SessionConfirmationTimeout>").append(this.requirePermissionTimeoutMS).append("</SessionConfirmationTimeout>\n");
        buffer.append("\t<AllowRecovery>").append(this.allowRecovery).append("</AllowRecovery>\n");
        buffer.append("</SimpleGatewayService>\n");
        return buffer.toString().getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, boolean encryptedPass) throws Exception {
        boolean exists = file.exists();
        byte[] dat = this.save(encryptedPass);
        File tmpfile = File.createTempFile("SGConfig", "temp");
        try {
            FileUtil.writeFile((File)tmpfile, (byte[])dat);
            new SimpleGatewayConfig(tmpfile);
            System.out.println("[SimpleGatewayConfig] Config sanity test successful");
        }
        finally {
            tmpfile.delete();
        }
        FileUtil.writeFile((File)file, (byte[])dat);
        if (!exists) {
            System.out.println("[SimpleGatewayConfig] Restricting permissions to readable only.");
            try {
                JWGenericOS.setReadableForAllUsersAndWait((File)file, (boolean)false);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public SimpleGatewayConfig() {
    }

    private String generateAutoDetectedName() {
        String hostname = null;
        try {
            hostname = SafeHostname.getLocalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    private String getArchitecture() {
        String osArch = System.getProperty("os.arch");
        try {
            if (NativeUtils.getInstance() != null && OS.isWindows()) {
                if (NativeUtils.getInstance().is32Bit()) {
                    return "x86";
                }
                return "x64";
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return osArch;
    }

    public boolean subsituteMacros() {
        String oldName = this.name;
        this.name = this.generateSubstitutedName(this.cachedNameWithMacros);
        boolean isChanged = !SafeCmp.equal(oldName, this.name);
        System.out.println("[SimpleGatewayConfig] Substituted macros returned " + isChanged);
        return isChanged;
    }

    private boolean init(InputStream fin) throws Exception {
        int closeSGServicElement;
        String xmlData = StreamUtils.readAllAsStringUTF8((InputStream)fin);
        if (xmlData != null && (closeSGServicElement = xmlData.indexOf("</SimpleGatewayService>")) != -1) {
            int end = closeSGServicElement + "</SimpleGatewayService>".length();
            xmlData = xmlData.substring(0, end);
        }
        boolean insecurePassword = false;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = builder.parse(new InputSource(new StringReader(xmlData)));
            Element root = dom.getDocumentElement();
            this.name = XML14Util.getChildText((Element)root, (String)"Name", (String)AUTODETECT);
            this.name = XML14Util.unescape((String)this.name);
            this.cachedNameWithMacros = this.name = this.name.replace('%', '_');
            System.out.println("[SimpleGatewayConfig] Name: " + this.name);
            ArrayList<String> urls = new ArrayList<String>();
            ArrayList connects = XML14Util.getChildren((Element)root, (String)"ConnectTo");
            for (Object connect : connects) {
                String recKey;
                Element url = (Element)connect;
                String urlText = XML14Util.getTextContent((Node)url);
                String pkhash = url.getAttribute("pkhash");
                if (pkhash != null) {
                    if (pkhash.trim().length() != 0) {
                        this.pkhashes.put(urlText, pkhash);
                    } else {
                        pkhash = null;
                    }
                }
                if ((recKey = url.getAttribute("reckey")) != null) {
                    if (recKey.trim().length() != 0) {
                        this.recoverykeys.put(urlText, recKey);
                    } else {
                        recKey = null;
                    }
                }
                if (pkhash != null) {
                    if (recKey != null) {
                        System.out.println("[SimpleGatewayConfig] Making available on " + urlText + " (" + pkhash + ") (" + recKey.length() + ")");
                    } else {
                        System.out.println("[SimpleGatewayConfig] Making available on " + urlText + " (" + pkhash + ")");
                    }
                } else if (recKey != null) {
                    System.out.println("[SimpleGatewayConfig] Making available on " + urlText + " (" + recKey.length() + ")");
                } else {
                    System.out.println("[SimpleGatewayConfig] Making available on " + urlText);
                }
                urls.add(urlText);
            }
            Element proxyElement = XML14Util.getChild((Element)root, (String)"Proxy");
            if (proxyElement != null) {
                try {
                    this.proxyHost = XML14Util.getChildText((Element)proxyElement, (String)"Host", null);
                    this.proxyPort = Integer.parseInt(XML14Util.getChildText((Element)proxyElement, (String)"Port", (String)"80"));
                    try {
                        this.proxyUser = this.getSecureElement(proxyElement, "Username");
                        this.proxyPass = this.getSecureElement(proxyElement, "Password");
                    }
                    catch (Exception e) {
                        this.proxyUser = null;
                        this.proxyPass = null;
                    }
                }
                catch (Exception e) {
                    this.proxyHost = null;
                    this.proxyPort = 0;
                }
            }
            this.URLs = new String[urls.size()];
            urls.toArray(this.URLs);
            this.password = this.getSecureElement(root, "Password");
            insecurePassword = XML14Util.getChildText((Element)root, (String)"Password", null) != null;
            this.allowMonitoring = this.grabBooleanPerm(root, "AllowMonitoring", this.password == null);
            this.allowScripting = this.grabBooleanPerm(root, "AllowScripting", this.password == null);
            this.sessionsRequirePermission = this.grabBooleanPerm(root, "RequireSessionConfirmation", false);
            try {
                this.requirePermissionTimeoutMS = Long.parseLong(this.grabStringPerm(root, "SessionConfirmationTimeout", "0"));
            }
            catch (Throwable t) {
                this.requirePermissionTimeoutMS = 0L;
                t.printStackTrace();
            }
            this.allowRecovery = this.grabBooleanPerm(root, "AllowRecovery", true);
        }
        catch (SAXParseException ex) {
            System.out.println("[SimpleGatewayConfig] Error parsing XML. Will fall back onto robust parser. (" + ex.getMessage() + " " + ex + ")");
            FastXMLParser parser = new FastXMLParser(xmlData);
            SafeParser listener = new SafeParser();
            parser.parse(listener);
            this.URLs = listener.getURLs().toArray(new String[0]);
            return listener.isInsecure();
        }
        return insecurePassword;
    }

    private boolean grabBooleanPerm(Element root, String name, boolean def) {
        String value = XML14Util.getChildText((Element)root, (String)name, null);
        if (value == null) {
            return def;
        }
        return value.equals("true");
    }

    private String grabStringPerm(Element root, String name, String def) {
        String value = XML14Util.getChildText((Element)root, (String)name, null);
        if (value == null) {
            return def;
        }
        return value;
    }

    private String generateSubstitutedName(String name) {
        String osname;
        if (name == null || name.length() == 0) {
            return this.generateAutoDetectedName();
        }
        String duplicate = new String(name);
        if (duplicate.contains(AUTODETECT)) {
            String autoDetectedName = this.generateAutoDetectedName();
            duplicate = duplicate.replaceAll(AUTODETECT, autoDetectedName).trim();
        }
        String hostname = null;
        String fqhostname = null;
        String ip = null;
        String macAddress = null;
        try {
            hostname = JWGenericOS.getInstance().getHostname();
        }
        catch (Throwable e) {
            hostname = "";
        }
        try {
            InetAddress addr = SimpleGatewayConfig.getLocalAddress(true);
            if (addr == null) {
                System.out.println("[SimpleGatewayConfig] Warning: no IP address detected.");
                addr = InetAddress.getLocalHost();
            }
            macAddress = SimpleGatewayConfig.getMacAddressFromInterface(NetworkInterface.getByInetAddress(addr));
            fqhostname = addr.getCanonicalHostName();
            ip = addr.toString();
            if (ip != null && ip.indexOf(47) != -1) {
                ip = ip.substring(ip.indexOf(47) + 1);
            }
        }
        catch (Throwable e) {
            fqhostname = "";
            ip = "";
        }
        try {
            osname = JWGenericOS.getInstance().getOSName();
        }
        catch (Throwable t) {
            osname = System.getProperty("os.name");
        }
        String osArch = this.getArchitecture();
        int processorCount = Runtime.getRuntime().availableProcessors();
        duplicate = duplicate.replaceAll("\\$\\{OSName\\}", osname).trim();
        duplicate = duplicate.replaceAll("\\$\\{MacAddress\\}", macAddress).trim();
        duplicate = duplicate.replaceAll("\\$\\{OSArchitecture\\}", osArch).trim();
        duplicate = duplicate.replaceAll("\\$\\{ProcessorCount\\}", "" + processorCount).trim();
        duplicate = duplicate.replaceAll("\\$\\{Hostname\\}", hostname).trim();
        duplicate = duplicate.replaceAll("\\$\\{FQHostname\\}", fqhostname).trim();
        duplicate = duplicate.replaceAll("\\$\\{IP\\}", ip).trim();
        return duplicate;
    }

    public SimpleGatewayConfig(byte[] data) throws Exception {
        this.init(new ByteArrayInputStream(data));
        this.lastModified = System.currentTimeMillis();
    }

    public SimpleGatewayConfig(File file) throws Exception {
        try {
            this.lastModified = file.lastModified();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                this.init(in);
            }
            finally {
                FileUtil.robustClose((InputStream)in);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception("Config load failed", t);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProxyHost(String proxyHost) {
        if (proxyHost != null) {
            proxyHost = proxyHost.trim();
        }
        this.proxyHost = proxyHost;
    }

    public void setProxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUser(String proxyUser) {
        if (proxyUser != null) {
            proxyUser = proxyUser.trim();
        }
        this.proxyUser = proxyUser;
    }

    public void setURLs(String[] ls) {
        this.URLs = ls;
    }

    public static void setJavaUrlProxyFromConfig(SimpleGatewayConfig config) {
        if (config.getProxyHost() != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getProxyHost(), config.getProxyPort()));
            System.out.println("[SimpleGatewayConfig] SG Config, Setting proxy on");
            if (config.getProxyUser() != null) {
                System.out.println("SG Config, Setting authenticator " + config.getProxyUser() + "@...");
                Authenticator.setDefault(new PasswordAuthenticator(config.getProxyUser(), config.getProxyPass()));
                try {
                    JWSystem.addAppSpecificProxy((Proxy)proxy, (String)config.getProxyUser(), (String)config.getProxyPass());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    JWSystem.addAppSpecificProxy((Proxy)proxy);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            System.setProperty("http.proxySet", "true");
            System.setProperty("http.proxyHost", config.getProxyHost());
            System.setProperty("http.proxyPort", "" + config.getProxyPort());
            System.setProperty("http.nonProxyHosts", "localhost|127.*");
            System.out.println("[SimpleGatewayConfig] SG Config, Setting proxy " + config.getProxyHost() + ":" + config.getProxyPort());
        } else {
            System.out.println("[SimpleGatewayConfig] SG Config, Setting proxy off");
            System.setProperty("http.proxySet", "false");
            System.setProperty("http.proxyHost", "");
        }
    }

    public static void main(String[] args) throws Exception {
        SimpleGatewayConfig config = new SimpleGatewayConfig(new File("/Users/gchristelis/Desktop/serviceconfig1.xml"));
        config.save(new File("/Users/gchristelis/Desktop/serviceconfig3.xml"), true);
        config = new SimpleGatewayConfig(new File("/Users/gchristelis/Desktop/serviceconfig3.xml"));
        System.out.println(config.password);
        System.out.println(config.proxyUser);
        System.out.println(config.proxyPass);
    }

    private static InetAddress getLocalAddress(boolean preferInet4) {
        try {
            InetAddress add;
            NetworkInterface iface = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                iface = ifaces.nextElement();
                if (!iface.getName().startsWith("en") || (add = SimpleGatewayConfig.getAddressFromInterface(iface, preferInet4)) == null) continue;
                return add;
            }
            ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                iface = ifaces.nextElement();
                add = SimpleGatewayConfig.getAddressFromInterface(iface, preferInet4);
                if (add == null) continue;
                return add;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    private static InetAddress getAddressFromInterface(NetworkInterface iface, boolean preferInet4) {
        InetAddress ia = null;
        Enumeration<InetAddress> ips = iface.getInetAddresses();
        while (ips.hasMoreElements()) {
            ia = ips.nextElement();
            if (ia.getAddress()[0] == 127 || ia.isLoopbackAddress() || ia.isLinkLocalAddress()) {
                return null;
            }
            if (ia instanceof Inet4Address && preferInet4) {
                return ia;
            }
            if (!(ia instanceof Inet6Address) || preferInet4) continue;
            return ia;
        }
        return null;
    }

    private static String getMacAddressFromInterface(NetworkInterface iface) {
        try {
            if (iface != null) {
                Method method = iface.getClass().getMethod("getHardwareAddress", new Class[0]);
                byte[] mac = (byte[])method.invoke((Object)iface, new Object[0]);
                if (mac != null) {
                    StringBuffer result = new StringBuffer();
                    for (int i = 0; i < mac.length; ++i) {
                        if (i > 0) {
                            result.append("-");
                        }
                        HexData.byteToHex((byte)mac[i], (StringBuffer)result);
                    }
                    return result.toString();
                }
                System.out.println("[SimpleGatewayConfig] Address doesn't exist or is not accessible for interface " + iface.getDisplayName());
            } else {
                System.out.println("[SimpleGatewayConfig] Network Interface for the specified address is not found.");
            }
        }
        catch (Throwable t) {
            System.out.println("[SimpleGatewayConfig] Unable to determine hardware address of " + iface.getDisplayName());
        }
        return "N/A";
    }

    class SafeParser
    implements XMLParserListener {
        String lastTag = null;
        HashMap lastArgs = null;
        boolean insecure = false;
        final ArrayList<String> urls = new ArrayList();
        private boolean havePassword = false;
        private boolean inProxy = false;

        SafeParser() {
        }

        public ArrayList<String> getURLs() {
            return this.urls;
        }

        public boolean isInsecure() {
            return this.insecure;
        }

        @Override
        public void startElement(String tag, HashMap h) throws Exception {
            this.lastTag = tag;
            this.lastArgs = h;
            if (tag.equalsIgnoreCase("Proxy")) {
                this.inProxy = true;
            }
        }

        @Override
        public void endElement(String tag) throws Exception {
            this.lastTag = null;
            if (tag.equalsIgnoreCase("Proxy")) {
                this.inProxy = false;
            }
        }

        @Override
        public void startDocument() throws Exception {
            this.lastTag = null;
        }

        @Override
        public void endDocument() throws Exception {
            this.lastTag = null;
        }

        @Override
        public void text(String str) throws Exception {
            if (this.lastTag == null) {
                return;
            }
            if (this.lastTag.equalsIgnoreCase("Name")) {
                SimpleGatewayConfig.this.name = str;
            } else if (this.lastTag.equalsIgnoreCase("SecurePassword")) {
                if (str != null) {
                    this.havePassword = true;
                    SimpleGatewayConfig.this.password = SimpleGatewayConfig.decryptPass(str);
                }
            } else if (this.lastTag.equalsIgnoreCase("SecurePasswordv2")) {
                if (str != null) {
                    if (!this.inProxy) {
                        this.havePassword = true;
                        SimpleGatewayConfig.this.password = SimpleGatewayConfig.decryptPassv2(str);
                    } else {
                        SimpleGatewayConfig.this.proxyPass = SimpleGatewayConfig.decryptPassv2(str);
                    }
                }
            } else if (this.lastTag.equalsIgnoreCase("Password")) {
                if (str != null) {
                    if (!this.inProxy) {
                        this.havePassword = true;
                        SimpleGatewayConfig.this.password = str;
                        this.insecure = true;
                    } else {
                        SimpleGatewayConfig.this.proxyPass = str;
                    }
                }
            } else if (this.lastTag.equalsIgnoreCase("ConnectTo")) {
                String pkhash = (String)this.lastArgs.get("pkhash");
                String recKey = (String)this.lastArgs.get("reckey");
                if (pkhash != null) {
                    if (pkhash.trim().length() != 0) {
                        SimpleGatewayConfig.this.pkhashes.put(str, pkhash);
                    } else {
                        pkhash = null;
                    }
                }
                if (recKey != null) {
                    if (recKey.trim().length() != 0) {
                        SimpleGatewayConfig.this.recoverykeys.put(str, recKey);
                    } else {
                        recKey = null;
                    }
                }
                if (pkhash != null) {
                    if (recKey != null) {
                        System.out.println("[SimpleGatewayConfig] Making available on " + str + " (" + pkhash + ") (" + recKey.length() + ")");
                    } else {
                        System.out.println("[SimpleGatewayConfig] Making available on " + str + " (" + pkhash + ")");
                    }
                } else if (recKey != null) {
                    System.out.println("[SimpleGatewayConfig] Making available on " + str + " (" + recKey.length() + ")");
                } else {
                    System.out.println("[SimpleGatewayConfig] Making available on " + str);
                }
                this.urls.add(str);
            } else if (this.lastTag.equalsIgnoreCase("Host")) {
                SimpleGatewayConfig.this.proxyHost = str;
            } else if (this.lastTag.equalsIgnoreCase("Port")) {
                try {
                    SimpleGatewayConfig.this.proxyPort = Integer.parseInt(str);
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            } else if (this.lastTag.equalsIgnoreCase("Username")) {
                SimpleGatewayConfig.this.proxyUser = str;
            } else if (this.lastTag.equalsIgnoreCase("SecureUsernamev2")) {
                SimpleGatewayConfig.this.proxyUser = SimpleGatewayConfig.decryptPassv2(str);
            } else if (this.lastTag.equalsIgnoreCase("AllowMonitoring")) {
                SimpleGatewayConfig.this.allowMonitoring = StringUtil.stringToBoolean((String)str, (!this.havePassword ? 1 : 0) != 0);
            } else if (this.lastTag.equalsIgnoreCase("AllowScripting")) {
                SimpleGatewayConfig.this.allowScripting = StringUtil.stringToBoolean((String)str, (!this.havePassword ? 1 : 0) != 0);
            } else if (this.lastTag.equalsIgnoreCase("SessionConfirmationTimeout")) {
                try {
                    SimpleGatewayConfig.this.requirePermissionTimeoutMS = Long.parseLong(str);
                }
                catch (Throwable t) {
                    SimpleGatewayConfig.this.requirePermissionTimeoutMS = 0L;
                    t.printStackTrace();
                }
            } else if (this.lastTag.equalsIgnoreCase("RequireSessionConfirmation")) {
                SimpleGatewayConfig.this.sessionsRequirePermission = StringUtil.stringToBoolean((String)str, (!this.havePassword ? 1 : 0) != 0);
            } else if (this.lastTag.equalsIgnoreCase("AllowRecovery")) {
                SimpleGatewayConfig.this.allowRecovery = StringUtil.stringToBoolean((String)str, (!this.havePassword ? 1 : 0) != 0);
            }
        }
    }
}

