/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import utils.progtools.TimeoutMap;
import utils.switches.Switches;

public class ServerClaim {
    TimeoutMap<Long, String> map = new TimeoutMap();
    Object LOCK = new Object();
    static ServerClaim test;

    public ServerClaim() {
    }

    private ServerClaim(int timeout) {
        this.map = new TimeoutMap(timeout);
    }

    public boolean requestAccessTo(String myUniqueName, Long serverInstance) {
        return this.manageAccessTo(myUniqueName, serverInstance, false);
    }

    public boolean claimAccessTo(String myUniqueName, Long serverInstance) {
        return this.manageAccessTo(myUniqueName, serverInstance, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean manageAccessTo(String myUniqueName, Long serverInstance, boolean andClaim) {
        Object object = this.LOCK;
        synchronized (object) {
            String owner = this.map.get(serverInstance);
            if (owner == null || owner.equalsIgnoreCase(myUniqueName)) {
                if (andClaim) {
                    this.map.put(serverInstance, myUniqueName, Switches.SH_2235_pollThreadClaimTimeout);
                }
                return true;
            }
            return false;
        }
    }

    public static void main(String[] args) {
        Switches.SH_2235_pollThreadClaimTimeout = 5000;
        test = new ServerClaim(1000);
        for (int i = 0; i < 5; ++i) {
            new TestThread().start();
        }
    }

    static class TestThread
    extends Thread {
        String myName = "" + this.hashCode();

        TestThread() {
        }

        @Override
        public void run() {
            int accessed = 0;
            while (true) {
                if (test.claimAccessTo(this.myName, new Long(0L))) {
                    System.out.println(this.myName + " has access to the server");
                    if (++accessed >= 10) {
                        System.out.println(this.myName + " has had enough now, going to sleep");
                        try {
                            Thread.sleep(7500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                accessed = 0;
                try {
                    Thread.sleep((long)(Math.random() * 1000.0));
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

