/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.sdesktop.client.controller.MultiController;
import com.aem.sdesktop.client.gui.GUI;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.shelp.common.Language;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import com.aem.utils.keyhandling.KeyRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.StrippedContentPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.keysample.KeySampleButton;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class SendKeyPanel
implements ActionListener {
    private GbPanel rootComponent = new GbPanel();
    private StrippedContentPanel contentPanel = new SHStrippedContentPanel(this.rootComponent, true);
    private final String remoteLayout;
    private final JButton setKeymapButton = new JButton(Language.get("SET_FOR_ALL_TYPING"));
    private final JButton send = new JButton(Language.get("SEND"));
    private final JToggleButton mod_shift = new JToggleButton(Language.get("MOD_SHIFT"));
    private final JToggleButton mod_alt = new JToggleButton(Language.get("MOD_ALT"));
    private final JToggleButton mod_altgr = new JToggleButton(Language.get("MOD_ALTGR"));
    private final JToggleButton mod_control = new JToggleButton(Language.get("MOD_CONTROL"));
    private final JToggleButton mod_meta = new JToggleButton(Language.get("MOD_META"));
    private final KeySampleButton sampler = new KeySampleButton(Language.get("SAMPLE_KEY_INSTRUCTIONS"), Language.get("SAMPLE_KEY_PRESSNOW"), Language.get("SAMPLE_KEY_CODE") + " ");
    private final GUI uinterface;
    private final ClientController controller;
    private PanelGlassDialog glassDialog;

    public SendKeyPanel(RootPaneContainer rpc, ClientController controller, GUI uinterface, int remoteOS) {
        this.glassDialog = new PanelGlassDialog(rpc, Language.get("SEND_KEY_TITLE"), 592, Language.get("CLOSE"), null);
        this.remoteLayout = controller != null ? controller.getRemoteKeyMappingName() : "Windows_fr_fr_French_00000409_France";
        this.controller = controller;
        this.uinterface = uinterface;
        this.initGraphics(remoteOS);
        this.glassDialog.setContentPanel((JComponent)this.rootComponent);
        this.glassDialog.showDialog();
        if (!this.glassDialog.isOK() || this.setKeymapButton.isEnabled()) {
            // empty if block
        }
    }

    private void initGraphics(int remoteOS) {
        JPanel keymapPanel = new JPanel(new BorderLayout(10, 0));
        keymapPanel.add((Component)new JLabel(this.remoteLayout), "Center");
        keymapPanel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        this.contentPanel.addContent(keymapPanel, Language.get("USE_REMOTE_KEYMAP"));
        ColorPropagatingPanel keysPanel = new ColorPropagatingPanel((LayoutManager)new BorderLayout());
        keysPanel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        GbPanel gb = new GbPanel(new ScaledInsets(2, 0, 2, 0));
        gb.add((Component)this.mod_control, 0, 0, 1, 1, 1, 1, 17, 2);
        gb.add((Component)this.mod_shift, 1, 0, 1, 1, 1, 1, 17, 2);
        gb.add((Component)this.mod_alt, 2, 0, 1, 1, 1, 1, 17, 2);
        gb.add((Component)this.mod_altgr, 3, 0, 1, 1, 1, 1, 17, 2);
        gb.add((Component)this.mod_meta, 4, 0, 1, 1, 1, 1, 17, 2);
        gb.add((Component)this.sampler, 0, 1, 5, 1, 1, 1, 17, 2);
        gb.add((Component)this.send, 5, 0, 1, 2, 0, 0, 12, 0, (Insets)new ScaledInsets(2, 10, 0, 0));
        SwingUtil.setSizesToTallest((JComponent[])new JComponent[]{this.mod_meta, this.mod_altgr, this.mod_alt, this.mod_control, this.mod_shift, this.sampler, this.send});
        SwingUtil.setSizesToWidest((JComponent)this.send, (JComponent)this.setKeymapButton);
        this.sampler.addKeyPressedActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendKeyPanel.this.send.setEnabled(true);
                SendKeyPanel.this.send.repaint();
            }
        });
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton[])new AbstractButton[]{this.mod_control, this.mod_shift, this.mod_alt, this.mod_altgr, this.mod_meta});
        keysPanel.add("Center", (Component)gb);
        this.send.setEnabled(false);
        this.contentPanel.addContent((JComponent)keysPanel, Language.get("SEND_SPECIFIC_KEYS"));
        this.contentPanel.addVerticalFiller();
        this.contentPanel.setBackgroundColours(false);
        this.send.addActionListener(this);
        this.setKeymapButton.addActionListener(this);
        this.setKeymapButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(e.getSource());
    }

    private void sendRequest() {
        KeyRequest sk = this.getRequest();
        System.out.println("[SendKeyPanel] " + sk);
        if (Switches.SH_multiControl && MultiController.on()) {
            MultiController.get().sendKeyRequest(sk);
        } else {
            this.controller.sendKeyRequest(sk);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        sk.keyPressed = false;
        if (Switches.SH_multiControl && MultiController.on()) {
            MultiController.get().sendKeyRequest(sk);
        } else {
            this.controller.sendKeyRequest(sk);
        }
        this.uinterface.setTopLeftGreyOverlay(Language.get("KEY_COMBO_SENT"), 1500L);
    }

    private KeyRequest getRequest() {
        KeyRequest k = new KeyRequest();
        k.keyPressed = true;
        k.modifiers = 0;
        k.characterTyped = 65535;
        if (this.mod_shift.isSelected()) {
            k.modifiers = KeyRequest.setShiftDown(k.modifiers);
        }
        if (this.mod_control.isSelected()) {
            k.modifiers = KeyRequest.setControlDown(k.modifiers);
        }
        if (this.mod_alt.isSelected()) {
            k.modifiers = KeyRequest.setAltDown(k.modifiers);
        }
        if (this.mod_altgr.isSelected()) {
            k.modifiers = KeyRequest.setAltGraphDown(k.modifiers);
        }
        if (this.mod_meta.isSelected()) {
            k.modifiers = KeyRequest.setMetaDown(k.modifiers);
        }
        k.keyCode = this.sampler.getSampledKeycode();
        return k;
    }

    private void actionPerformed(Object o) {
        if (o == this.send) {
            this.sendRequest();
        }
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        new SendKeyPanel((RootPaneContainer)frame, null, null, 0);
    }
}

