/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.sdesktop.util.GuiConstants;
import com.aem.sdesktop.util.MainPanel;
import com.aem.utils.Debugger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import utils.swing.SafeLookAndFeel;

public class MainApplet
extends JApplet
implements GuiConstants,
MainPanel {
    public JPanel main_panel = new JPanel();
    public JPanel north_panel = new JPanel();
    public JPanel east_panel = new JPanel();
    public JPanel south_panel = new JPanel();
    public JPanel west_panel = new JPanel();
    public JPanel centre_panel = new JPanel();
    HashMap flip_containers = new HashMap();
    HashMap flip_options = new HashMap();
    static MainApplet applet = null;

    @Override
    public boolean isFullScreenCapable() {
        return false;
    }

    @Override
    public JPanel main_panel() {
        return this.main_panel;
    }

    @Override
    public JPanel north_panel() {
        return this.north_panel;
    }

    @Override
    public JPanel east_panel() {
        return this.east_panel;
    }

    @Override
    public JPanel south_panel() {
        return this.south_panel;
    }

    @Override
    public JPanel west_panel() {
        return this.west_panel;
    }

    @Override
    public JPanel centre_panel() {
        return this.centre_panel;
    }

    public static MainApplet getApplet() {
        applet.initGraphics();
        return applet;
    }

    public MainApplet() {
        applet = this;
    }

    private void initGraphics() {
        this.getContentPane().add(this.main_panel);
        this.main_panel.setLayout(new BorderLayout());
        this.aflip(this.main_panel, "North", this.north_panel);
        this.aflip(this.main_panel, "East", this.east_panel);
        this.aflip(this.main_panel, "South", this.south_panel);
        this.aflip(this.main_panel, "West", this.west_panel);
        this.aflip(this.main_panel, "Center", this.centre_panel);
    }

    @Override
    public void init() {
        System.out.println("SimpleDesktop client applet initialising");
        try {
            String lfname = UIManager.getSystemLookAndFeelClassName();
            Class<?> c = ClassLoader.getSystemClassLoader().loadClass(lfname);
            SafeLookAndFeel.setLookAndFeel((LookAndFeel)((LookAndFeel)c.newInstance()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void aflip(Container box, String options, Component item) {
        if (options == null) {
            box.add(item);
        } else {
            System.out.println("[MainApplet] adding panel with options " + options);
            box.add(options, item);
            this.flip_options.put(item, options);
        }
        this.flip_containers.put(item, box);
    }

    public void flipPanel(String s, boolean on) {
        if (s.equalsIgnoreCase("North")) {
            this.flipPanel(this.north_panel, on);
        } else if (s.equalsIgnoreCase("East")) {
            this.flipPanel(this.east_panel, on);
        } else if (s.equalsIgnoreCase("West")) {
            this.flipPanel(this.west_panel, on);
        } else if (s.equalsIgnoreCase("South")) {
            this.flipPanel(this.south_panel, on);
        } else if (s.equalsIgnoreCase("Centre") || s.equalsIgnoreCase("center")) {
            this.flipPanel(this.centre_panel, on);
        } else {
            Debugger.warning("Asked to flip unknown panel \"" + s + "\"");
        }
    }

    @Override
    public void flipPanel(JPanel item, boolean on) {
        Container box = (Container)this.flip_containers.get(item);
        String options = (String)this.flip_options.get(item);
        if (box == null) {
            Debugger.warning("Asked to flip unflippable component " + item);
        }
        box.remove(item);
        if (on) {
            if (options == null) {
                box.add(item);
            } else {
                box.add(options, item);
            }
        }
        this.main_panel.revalidate();
        this.main_panel.repaint();
    }
}

