/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.CentralDebugging;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.server.controller.ImmediateFileTransferListener;
import com.aem.sdesktop.server.controller.InputServer;
import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.sdesktop.util.FTPUtilServer;
import com.aem.shelp.common.Language;
import com.aem.utils.crc.CRC64;
import com.aem.utils.zip.GZIPer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;

public class FTPUtil
implements MSG {
    private static final int BUF_SLOW = 2000;
    private static final int BUF_FAST = 80000;
    public static long BE_SLOW_UNTIL = Long.MAX_VALUE;

    public static void SPEED_UP_FOREVER() {
        BE_SLOW_UNTIL = 0L;
    }

    public static void SLOW_DOWN_FOREVER() {
        BE_SLOW_UNTIL = Long.MAX_VALUE;
    }

    public static boolean deleteFiles(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FTPUtil.deleteFiles(files[i]);
            }
        }
        return f.delete();
    }

    public static byte[] getCRC64(File file, long length) throws IOException {
        if (!file.exists()) {
            return new byte[0];
        }
        BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));
        CRC64 crc = new CRC64();
        crc.reset();
        long total = 0L;
        int n = 0;
        byte[] buf = new byte[4096];
        while (n != -1 && total < length) {
            long rest = length - total;
            n = rest < (long)buf.length ? ((InputStream)fin).read(buf, 0, (int)rest) : ((InputStream)fin).read(buf, 0, 4096);
            if (n <= 0) continue;
            for (int i = 0; i < n; ++i) {
                crc.add(buf[i]);
            }
            total += (long)n;
        }
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[ReceiveFile] computed CRC for " + file.getName() + " based on bytes 0 to " + total + " (max " + length + ")");
        }
        ((InputStream)fin).close();
        return crc.getDigest();
    }

    public static boolean crcsMatch(byte[] crc1, byte[] crc2) {
        if (crc1.length != crc2.length) {
            return false;
        }
        for (int i = 0; i < crc1.length; ++i) {
            if (crc1[i] == crc2[i]) continue;
            return false;
        }
        return true;
    }

    public static void putFile(int jobID, int version, FTPUtilServer utilserver, MessageWriter mout, String localdir, String remotedir, String localfile, long maxAllowedFileSize) throws IOException {
        FTPUtil.putFile(jobID, version, utilserver, mout, localdir, remotedir, localfile, new boolean[]{false}, null, maxAllowedFileSize);
    }

    public static void putFile(int jobID, int version, FTPUtilServer utilserver, MessageWriter mout, String localdir, String remotedir, String localfile, boolean[] cancel, ClientUserInterface gui, long maxAllowedFileSize) throws IOException {
        File toput = new File(localdir + File.separatorChar + localfile);
        Message m = new Message(458756);
        m.append(remotedir);
        mout.write(m);
        SizeReporter sizeReporter = new SizeReporter(new File(localdir, localfile));
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[PutFile] basedir " + remotedir);
        }
        FTPUtil.putFile(jobID, version, utilserver, mout, remotedir, toput, cancel, gui, -1L, sizeReporter, maxAllowedFileSize);
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[PutFile] end session");
        }
        m = new Message(458761);
        m.append(remotedir);
        mout.write(m);
    }

    public static void putFileNoRestart(int jobID, int version, FTPUtilServer utilserver, MessageWriter mout, String localdir, String remotedir, String localfile, boolean[] cancel, ClientUserInterface gui, long maxAllowedFileSize) throws IOException {
        File toput = new File(localdir + File.separatorChar + localfile);
        Message m = new Message(458756);
        m.append(remotedir);
        mout.write(m);
        SizeReporter sizeReporter = new SizeReporter(new File(localdir, localfile));
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[PutFile] basedir " + remotedir);
        }
        FTPUtil.putFile(jobID, version, utilserver, mout, remotedir, toput, cancel, gui, 0L, sizeReporter, maxAllowedFileSize);
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[PutFile] end session");
        }
        m = new Message(458761);
        m.append(remotedir);
        mout.write(m);
    }

    private static void putFile(int jobID, int version, FTPUtilServer utilserver, MessageWriter mout, String remotedir, File file, boolean[] cancel, ClientUserInterface gui, long startPoint, SizeReporter sizeReporter, long maxAllowedFileSize) throws IOException {
        boolean GZIP_DATA = false;
        if (cancel[0]) {
            sizeReporter.die();
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            if (CentralDebugging.FILE_TRANSFER) {
                System.out.println("[PutFile] into folder " + file);
            }
            if ((files = file.listFiles()) != null) {
                Message m = new Message(458757);
                m.append(file.getName());
                mout.write(m);
                String path = remotedir;
                if (path.endsWith("\\") || path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                path = path + "/" + file.getName();
                long[] startPoints = utilserver.getStartPoints(files, path);
                for (int i = 0; i < files.length && !cancel[0]; ++i) {
                    FTPUtil.putFile(jobID, version, utilserver, mout, path, files[i], cancel, gui, startPoints[i], sizeReporter, maxAllowedFileSize);
                }
                if (CentralDebugging.FILE_TRANSFER) {
                    System.out.println("[PutFile] exit folder " + file);
                }
                m = new Message(458768);
                m.append(file.getName());
                mout.write(m);
            }
        } else {
            long start;
            String dir = file.getParent();
            String fname = file.getName();
            int gzip_strike = 0;
            if (version >= 200200) {
                GZIP_DATA = true;
            }
            if ((start = startPoint) == -1L && utilserver != null) {
                try {
                    start = utilserver.getStartPoint(file, remotedir, file.getName());
                }
                catch (FileNotFoundException e) {
                    if (gui != null) {
                        gui.updateFTPProgressError(jobID, e.getMessage());
                    }
                }
                catch (Exception e) {
                    System.out.println("(Ignored) Error getting start point for " + file.getName() + " - " + e);
                    start = 0L;
                }
            }
            if (CentralDebugging.FILE_TRANSFER) {
                System.out.println("[PutFile] got start point for " + fname + " " + start);
            }
            long max = file.length();
            long total = start;
            int n = 0;
            int bufLimit = 80000;
            byte[] buffer = new byte[80000];
            try {
                boolean fileTransferExceedsLimit;
                if (CentralDebugging.FILE_TRANSFER) {
                    System.out.println("[PutFile] beginning transfer of " + fname + " " + start);
                }
                boolean bl = fileTransferExceedsLimit = maxAllowedFileSize > -1L && max > maxAllowedFileSize;
                if (fileTransferExceedsLimit) {
                    System.out.println("[FTPUtil] File transfer of " + file.getName() + " exceeds file transfer size limit (" + max + " > " + maxAllowedFileSize + ")");
                    if (gui != null) {
                        gui.updateFTPProgressError(jobID, FTPUtil.getFileSizeError(maxAllowedFileSize));
                    }
                    Message m = new Message(458800);
                    m.append(maxAllowedFileSize);
                    mout.write(m);
                } else if (start != file.length()) {
                    Message m = new Message(458758);
                    m.append(fname);
                    m.append(dir);
                    m.append(max);
                    m.append(start);
                    m.append(file.lastModified());
                    mout.write(m);
                    if (gui != null) {
                        gui.updateFTPProgress(jobID, true, dir, fname, total, max, total);
                    }
                    RandomAccessFile fin = new RandomAccessFile(file, "r");
                    fin.seek(start);
                    try {
                        while (n != -1 && !cancel[0]) {
                            bufLimit = 80000;
                            if (System.currentTimeMillis() < BE_SLOW_UNTIL) {
                                bufLimit = 2000;
                            }
                            if ((n = fin.read(buffer, 0, bufLimit)) <= 0) continue;
                            if (sizeReporter.totalSize != -1L) {
                                m = new Message(458793);
                                m.append(sizeReporter.totalSize);
                                sizeReporter.totalSize = -1L;
                                mout.write(m);
                            }
                            if (CentralDebugging.FILE_TRANSFER) {
                                System.out.println("[PutFile] sending data " + n);
                            }
                            if (gui != null) {
                                gui.updateFTPProgress(jobID, true, dir, fname, total, max, n);
                            }
                            total += (long)n;
                            if (GZIP_DATA && n > 1024) {
                                m = new Message(458776);
                                int orig_size = n;
                                byte[] tmp = GZIPer.s_compress(buffer, 0, n);
                                int new_size = tmp.length;
                                double comp_rat = (double)new_size / (double)orig_size;
                                gzip_strike = comp_rat > 0.85 ? ++gzip_strike : 0;
                                if (gzip_strike >= 4) {
                                    GZIP_DATA = false;
                                }
                                if (CentralDebugging.FILE_TRANSFER) {
                                    System.out.println("[PutFile] compressed data " + n + " (" + tmp.length + ")");
                                }
                                m.append(tmp);
                            } else {
                                if (CentralDebugging.FILE_TRANSFER) {
                                    System.out.println("[PutFile] uncompressed data " + n);
                                }
                                m = new Message(458759);
                                m.appendRef_WARNING_NO_GETS(buffer, 0, n);
                            }
                            long taken = System.currentTimeMillis();
                            mout.write(m);
                            taken = System.currentTimeMillis() - taken;
                            if (taken <= 50L) continue;
                            System.out.println("FTP write took " + taken + "ms");
                        }
                    }
                    catch (Exception tt) {
                        try {
                            fin.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw tt;
                    }
                    try {
                        fin.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (CentralDebugging.FILE_TRANSFER) {
                        System.out.println("[PutFile] file end " + fname);
                    }
                    m = new Message(458760);
                    mout.write(m);
                } else if (CentralDebugging.FILE_TRANSFER) {
                    System.out.println("[PutFile] no data transfer required for " + fname);
                }
                if (gui != null) {
                    gui.updateFTPProgress(jobID, true, dir, fname, total, max, 0L);
                }
            }
            catch (Exception e) {
                System.out.println("Failed to transfer file " + fname);
            }
        }
    }

    private static String getFileSizeError(long maxAllowedFileSize) {
        String sizeString = maxAllowedFileSize % 0x100000L == 0L ? maxAllowedFileSize / 0x100000L + " " + Language.get("MEGABYTES") : (maxAllowedFileSize % 0x100000L == 0L ? maxAllowedFileSize / 0x100000L + " " + Language.get("KILOBYTES") : maxAllowedFileSize + " " + Language.get("BYTES"));
        return Language.get("FILE_SIZE_EXCEEDED_ERROR", sizeString);
    }

    public static void receiveFile(int jobID, MessageReader min) throws IOException {
        FTPUtil.receiveFile(jobID, min, null, null, null);
    }

    public static void receiveFile(int jobID, MessageReader min, InputServer pasty) throws IOException {
        FTPUtil.receiveFile(jobID, min, null, pasty, null);
    }

    public static void receiveFile(int jobID, MessageReader min, ClientUserInterface gui) throws IOException {
        FTPUtil.receiveFile(jobID, min, gui, null, null);
    }

    public static void receiveFile(int jobID, MessageReader min, ClientUserInterface gui, ImmediateFileTransferListener listener) throws IOException {
        FTPUtil.receiveFile(jobID, min, gui, null, listener);
    }

    public static void receiveFile(int jobID, MessageReader min, ClientUserInterface gui, InputServer pasty, ImmediateFileTransferListener listener) throws IOException {
        block71: {
            Message m = min.read();
            boolean useMMove = false;
            if (pasty != null) {
                useMMove = pasty.isVistaFileTransferRequired();
            }
            if (CentralDebugging.FILE_TRANSFER) {
                System.out.println("[ReceiveFile] use mmove " + useMMove);
            }
            if (m.getType() == 458777 || m.getType() == 458785) {
                ArrayList<File> list = new ArrayList<File>();
                for (int i = 0; i < m.length(); ++i) {
                    File f = new File((String)m.get(i));
                    list.add(f);
                    if (!CentralDebugging.FILE_TRANSFER) continue;
                    System.out.println("[ReceiveFile] clipboard file " + f.getName());
                }
                try {
                    ClipboardUtil.setClipboardAsFiles(list);
                    if (m.getType() == 458777) {
                        if (CentralDebugging.FILE_TRANSFER) {
                            System.out.println("[ReceiveFile] sending paste");
                        }
                        pasty.sendPasteKeys();
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
                return;
            }
            if (m.getType() == 458792) {
                pasty.notifyJobFinished(m);
                return;
            }
            if (m.getType() != 458756) {
                throw new IOException("Out of sync - expected FTP_BASEDIR(458756) but got " + m.getType());
            }
            File basedir = new File((String)m.get(0));
            if (CentralDebugging.FILE_TRANSFER) {
                System.out.println("[ReceiveFile] basedir " + basedir);
            }
            try {
                while (m.getType() != 458761) {
                    m = min.read();
                    if (listener != null && m.getType() != 458758 && m.getType() != 458800) continue;
                    if (m.getType() == 458800) {
                        System.out.println("[FTPUtil] File transfer exceeded file limit.");
                        long max = m.getNextLong();
                        if (gui == null) continue;
                        gui.updateFTPProgressError(jobID, FTPUtil.getFileSizeError(max));
                        continue;
                    }
                    if (m.getType() == 458758) {
                        String name = m.getNextString();
                        String dir = m.getNextString();
                        long max = m.getNextLong();
                        int total = 0;
                        if (CentralDebugging.FILE_TRANSFER) {
                            System.out.println("[ReceiveFile] file name " + name);
                        }
                        if (CentralDebugging.FILE_TRANSFER) {
                            System.out.println("[ReceiveFile] file dir " + dir);
                        }
                        long start = 0L;
                        if (m.length() > 3) {
                            start = m.getNextLong();
                        }
                        long lastmod = -1L;
                        if (m.length() > 4) {
                            lastmod = m.getNextLong();
                        }
                        boolean doesTransferExceedFileSizeLimit = false;
                        if (m.length() > 5) {
                            doesTransferExceedFileSizeLimit = m.getNextBoolean();
                        }
                        if (doesTransferExceedFileSizeLimit) {
                            System.out.println("-------------- TOO BIG!");
                            continue;
                        }
                        if (CentralDebugging.FILE_TRANSFER) {
                            System.out.println("[ReceiveFile] start point " + start);
                        }
                        String path = null;
                        RandomAccessFile fout = null;
                        long fp = 0L;
                        String filename = null;
                        if (listener != null) {
                            listener.setFileLength(max);
                        } else {
                            path = basedir.getCanonicalPath();
                            if (!path.endsWith(File.separator)) {
                                path = path + File.separator;
                            }
                            filename = path + name;
                            try {
                                if (useMMove) {
                                    if (CentralDebugging.FILE_TRANSFER) {
                                        System.out.println("[ReceiveFile] vista set file length " + start);
                                    }
                                    pasty.vistaSetFileLength(filename, start);
                                    fp = start;
                                } else {
                                    if (start > 0L) {
                                        if (new File(path + name).length() != start) {
                                            System.out.println("Appending to file (before end)");
                                        }
                                        fout = new RandomAccessFile(path + name, "rw");
                                        fout.seek(start);
                                    } else {
                                        fout = new RandomAccessFile(path + name, "rw");
                                    }
                                    fout.setLength(start);
                                    if (CentralDebugging.FILE_TRANSFER) {
                                        System.out.println("[ReceiveFile] nonvista set file length " + start);
                                    }
                                }
                            }
                            catch (Exception e) {
                                System.out.println("Failed to open file for writing " + e);
                                fout = null;
                            }
                        }
                        try {
                            m = min.read();
                            while (m.getType() == 458759 || m.getType() == 458776 || m.getType() == 458793) {
                                if (m.getType() == 458793) {
                                    long size = m.getNextLong();
                                    System.out.println("[FTPUtil] Remote size reported total size of " + size);
                                    if (gui != null && (useMMove || fout != null)) {
                                        gui.updateFTPProgress(jobID, size);
                                    }
                                } else {
                                    byte[] dat = (byte[])m.get(0);
                                    if (m.getType() == 458776) {
                                        if (CentralDebugging.FILE_TRANSFER) {
                                            System.out.println("[ReceiveFile] compressed file data " + dat.length);
                                        }
                                        dat = GZIPer.s_decompress(dat);
                                    }
                                    if (CentralDebugging.FILE_TRANSFER) {
                                        System.out.println("[ReceiveFile] file data " + dat.length);
                                    }
                                    try {
                                        if (listener != null) {
                                            listener.fileDataReceived(dat);
                                        } else if (useMMove) {
                                            if (CentralDebugging.FILE_TRANSFER) {
                                                System.out.println("[ReceiveFile] vista write file data " + dat.length + "@" + fp);
                                            }
                                            pasty.vistaWriteFilePath(filename, fp, dat);
                                            fp += (long)dat.length;
                                        } else {
                                            if (fout != null) {
                                                fout.write(dat);
                                            }
                                            if (CentralDebugging.FILE_TRANSFER) {
                                                System.out.println("[ReceiveFile] nonvista write file data " + dat.length);
                                            }
                                        }
                                        if (gui != null) {
                                            gui.updateFTPProgress(jobID, false, dir, name, total, max, dat.length);
                                        }
                                        total += dat.length;
                                    }
                                    catch (Exception e) {
                                        System.out.println("Problem writing to file " + e);
                                        fout = null;
                                    }
                                }
                                m = min.read();
                            }
                            if (gui != null && (useMMove || fout != null)) {
                                gui.updateFTPProgress(jobID, false, dir, name, total, max, 0L);
                            }
                            if (m.getType() != 458760) {
                                throw new IOException("Out of sync - expected FTP_FILEEND(458760) but got " + m.getType());
                            }
                            if (CentralDebugging.FILE_TRANSFER) {
                                System.out.println("[ReceiveFile] file end " + name);
                            }
                        }
                        catch (IOException e) {
                            try {
                                pasty.vistaCloseFile(filename);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                fout.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw e;
                        }
                        if (listener != null) {
                            listener.finished();
                        } else if (useMMove) {
                            pasty.vistaCloseFile(filename);
                        } else {
                            fout.close();
                        }
                        if (listener != null || lastmod == -1L) continue;
                        if (useMMove) {
                            pasty.vistaSetLastMod(filename, lastmod);
                            continue;
                        }
                        new File(filename).setLastModified(lastmod);
                        continue;
                    }
                    if (m.getType() == 458757) {
                        String path;
                        String name = (String)m.get(0);
                        if (CentralDebugging.FILE_TRANSFER) {
                            System.out.println("[ReceiveFile] into folder " + name);
                        }
                        if (!(path = basedir.getCanonicalPath()).endsWith(File.separator)) {
                            path = path + File.separator;
                        }
                        if ((basedir = new File(path + name)).exists() || basedir.mkdirs() || useMMove) continue;
                        throw new IOException("Could not make directory " + basedir);
                    }
                    if (m.getType() == 458768) {
                        basedir = basedir.getParentFile();
                        if (!CentralDebugging.FILE_TRANSFER) continue;
                        System.out.println("[ReceiveFile] exit folder");
                        continue;
                    }
                    if (m.getType() != 458761) continue;
                }
                if (!CentralDebugging.FILE_TRANSFER) break block71;
                System.out.println("[ReceiveFile] end session");
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.out.println("Error in FTP session - reading until end of session");
                while (m.getType() != 458761) {
                    m = min.read();
                }
            }
        }
    }

    static class SizeReporter
    extends Thread {
        private File fileOrDir;
        private boolean die = false;
        public long totalSize = -1L;

        public SizeReporter(File fileOrDir) {
            super("SizeReporter");
            this.setPriority(1);
            this.fileOrDir = fileOrDir;
            this.start();
        }

        public long recursiveSize(File fileOrDir) {
            if (this.die) {
                return -1L;
            }
            if (fileOrDir.isDirectory()) {
                File[] files = fileOrDir.listFiles();
                long total = 0L;
                for (File f : files) {
                    long result = this.recursiveSize(f);
                    if (result == -1L) {
                        return -1L;
                    }
                    total += result;
                }
                return total;
            }
            return fileOrDir.length();
        }

        @Override
        public void run() {
            this.totalSize = FileUtil.recursiveSize((File)this.fileOrDir);
        }

        public void die() {
            this.die = true;
        }
    }
}

