/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.utils.NativeLibraryLoader;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import sun.awt.datatransfer.ClipboardTransferable;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.SunClipboard;
import utils.ostools.OS;
import utils.progtools.arrays.ArrayUtils;

public class ClipboardUtil {
    public static void main(String[] args) throws Exception {
        System.out.println(ClipboardUtil.getClipboardAsText());
    }

    public static List getClipboardAsFiles() throws Exception {
        Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transfer = clipb.getContents(null);
        return (List)transfer.getTransferData(DataFlavor.javaFileListFlavor);
    }

    public static void setClipboardAsFiles(List files) throws Exception {
        try {
            Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
            FileSelection sel = new FileSelection(files);
            clipb.setContents(sel, sel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String handleBrokenWindowsCopyText(String original) {
        if (!OS.isWindows()) {
            return original;
        }
        try {
            Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Field cdfs = SunClipboard.class.getDeclaredField("currentFormats");
            cdfs.setAccessible(true);
            long[] currentFormats = (long[])cdfs.get(clipb);
            System.out.println("[ClipboardUtil] Current Formats = " + Arrays.toString(currentFormats));
            boolean isBroken = ArrayUtils.contains((long[])currentFormats, (long)0L);
            if (!isBroken) {
                return original;
            }
            Method openClipboard = clipb.getClass().getDeclaredMethod("openClipboard", SunClipboard.class);
            openClipboard.setAccessible(true);
            openClipboard.invoke((Object)clipb, new Object[]{null});
            try {
                long format = 13L;
                Method getData = clipb.getClass().getDeclaredMethod("getClipboardData", Long.TYPE);
                getData.setAccessible(true);
                byte[] result = (byte[])getData.invoke((Object)clipb, format);
                ClipboardTransferable ct = new ClipboardTransferable((SunClipboard)clipb);
                Object s = DataTransferer.getInstance().translateBytes(result, DataFlavor.stringFlavor, format, ct);
                if (!(s instanceof String)) return original;
                String string = (String)s;
                return string;
            }
            finally {
                Method close = clipb.getClass().getDeclaredMethod("closeClipboard", new Class[0]);
                close.setAccessible(true);
                close.invoke((Object)clipb, new Object[0]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return original;
    }

    public static String getClipboardAsText() throws Exception {
        if (new File("lib").exists()) {
            NativeLibraryLoader.loadLibrary(new File("lib"));
        } else {
            NativeLibraryLoader.loadLibrary(new File("SimpleHelp/lib"));
        }
        String result = null;
        try {
            Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transfer = clipb.getContents(null);
            result = (String)transfer.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ClipboardUtil.handleBrokenWindowsCopyText(result);
    }

    public static void setClipboardAsText(String data) {
        try {
            Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection sel = new StringSelection(data);
            clipb.setContents(sel, sel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipb.addFlavorListener(new FlavorListener(){

            @Override
            public void flavorsChanged(FlavorEvent e) {
            }
        });
    }

    static class FileSelection
    implements Transferable,
    ClipboardOwner {
        List files;

        public FileSelection(List list) {
            this.files = list;
        }

        @Override
        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            if (df == DataFlavor.javaFileListFlavor) {
                return this.files;
            }
            throw new UnsupportedFlavorException(df);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            return df == DataFlavor.javaFileListFlavor;
        }

        @Override
        public void lostOwnership(Clipboard arg0, Transferable arg1) {
        }
    }
}

