/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller.settings;

import com.aem.CentralDebugging;
import com.aem.ClientManagement;
import com.aem.shelp.util.FixedTimeSettingsRunner;
import com.aem.shelp.util.WReg;
import com.aem.shelp.util.WSessionInfo;
import com.aem.utils.NativeUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import jwrapper.hidden.JWNativeAPI;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;
import utils.stream.StreamUtils;

public class WallpaperDisabler
extends FixedTimeSettingsRunner {
    private static final String WALLPAPERKEY = "Wallpaper";
    private static final String TILEWALLPAPERKEY = "TileWallpaper";
    private static final String WALLPAPERSTYLEKEY = "WallpaperStyle";
    private static final String SHWALLPAPERKEY = "WallpaperShOrigSetting";
    private static String SHWALLPAPERVALUE = "";
    public static WallpaperDisabler INSTANCE = new WallpaperDisabler();

    public WallpaperDisabler() {
        super("WallpaperDisabler");
    }

    private static String[] getOSXDisplayWallpapers() throws IOException, InterruptedException {
        Process exec = Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell application \"System Events\" to get picture of every desktop"});
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ProcessPrinter(exec, (OutputStream)bout, (OutputStream)bout);
        int returnCode = exec.waitFor();
        if (returnCode == 0) {
            String result = new String(bout.toByteArray());
            String[] desktopStrings = result.split(",");
            ArrayList<String> wallpapers = new ArrayList<String>();
            for (int i = 0; i < desktopStrings.length; ++i) {
                String desktopString = desktopStrings[i].trim();
                if (desktopString.startsWith("file ")) {
                    desktopString = desktopString.substring("file ".length());
                }
                wallpapers.add(desktopString);
            }
            System.out.println("[WallpaperDisabler] Picked up " + wallpapers.size() + " wallpapers.");
            String[] resultArray = new String[wallpapers.size()];
            wallpapers.toArray(resultArray);
            return resultArray;
        }
        return null;
    }

    private static void setOSXDisplayWallpapers(String[] wallpapers) throws IOException, InterruptedException {
        if (wallpapers == null) {
            return;
        }
        System.out.println("[WallpaperDisabler] Setting OSX display wallpapers (" + wallpapers.length + ")");
        ArrayList<String> command = new ArrayList<String>();
        command.add("osascript");
        for (int i = 0; i < wallpapers.length; ++i) {
            command.add("-e");
            command.add("tell application \"System Events\" to set picture of desktop " + (i + 1) + " to \"" + wallpapers[i] + "\"");
        }
        String[] commandString = new String[command.size()];
        command.toArray(commandString);
        Process exec = Runtime.getRuntime().exec(commandString);
        new ProcessPrinter(exec, (OutputStream)System.out, (OutputStream)System.out);
    }

    private static boolean isGnome() throws IOException, InterruptedException {
        Process exec = Runtime.getRuntime().exec(new String[]{"pidof", "gnome-session"});
        new ProcessPrinter(exec, (OutputStream)System.out, (OutputStream)System.err);
        int code = exec.waitFor();
        return code == 0;
    }

    private static boolean isKDE() throws IOException, InterruptedException {
        Process exec = Runtime.getRuntime().exec(new String[]{"pidof", "ksmserver"});
        new ProcessPrinter(exec, (OutputStream)System.out, (OutputStream)System.err);
        int code = exec.waitFor();
        return code == 0;
    }

    private static boolean isXFCE() throws IOException, InterruptedException {
        Process exec = Runtime.getRuntime().exec(new String[]{"pidof", "xfce-mcs-manage"});
        new ProcessPrinter(exec, (OutputStream)System.out, (OutputStream)System.err);
        int code = exec.waitFor();
        return code == 0;
    }

    @Override
    protected void disableSetting() {
        try {
            if (OS.isWindows()) {
                this.enableWindows();
            } else if (OS.isMacOS()) {
                this.enableMacOS();
            } else if (OS.isLinux()) {
                this.enableLinux();
            }
        }
        catch (Exception ex) {
            if (CentralDebugging.WALLPAPER_DISABLING) {
                ex.printStackTrace();
            }
            System.out.println("[WallpaperDisabler] unable to enable wallpaper: " + ex);
        }
    }

    private void enableLinux() throws Exception {
        block4: {
            String oldLocation;
            File oldLinuxBackgroundFile = new File("oldLinuxBackground.txt");
            if (oldLinuxBackgroundFile.exists() && (oldLocation = StreamUtils.readAllAsStringASCII((InputStream)new FileInputStream(oldLinuxBackgroundFile))) != null && oldLocation.trim().length() > 0 && WallpaperDisabler.isGnome()) {
                System.out.println("[WallpaperDisabler] Detected Gnome. Setting wallpaper.");
                try {
                    Process exec = Runtime.getRuntime().exec(new String[]{"gsettings", "set", "org.gnome.desktop.background", oldLocation});
                    new ProcessPrinter(exec, (OutputStream)System.out, (OutputStream)System.err);
                    int ret = exec.waitFor();
                    if (ret != 0) {
                        throw new Exception("GSettings failed. Trying alternative.");
                    }
                }
                catch (Throwable t) {
                    System.out.println("[WallpaperDisabler] Unable to use gsettings to set background. Trying alternative. (" + t.getMessage() + ")");
                    Process exec = Runtime.getRuntime().exec(new String[]{"gconftool-2", "-type", "string", "-set", "/desktop/gnome/background/picture_filename", oldLocation});
                    new ProcessPrinter(exec, (OutputStream)System.out, (OutputStream)System.err);
                    int ret = exec.waitFor();
                    if (ret == 0) break block4;
                    exec = Runtime.getRuntime().exec(new String[]{"gconftool-1", "-type", "string", "-set", "/desktop/gnome/background/picture_filename", oldLocation});
                    new ProcessPrinter(exec, (OutputStream)System.out, (OutputStream)System.err);
                    ret = exec.waitFor();
                    if (ret == 0) break block4;
                    throw new Exception("Unable to set Linux background.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableMacOS() throws Exception {
        String localUsername = System.getProperty("user.name");
        String normalisedUsername = FileUtil.normaliseAsFilename((String)localUsername);
        File backgroundSettings = new File("bg_" + normalisedUsername);
        String[] wallpapers = null;
        try (FileInputStream fin = new FileInputStream(backgroundSettings);){
            int count = StreamUtils.readInt((InputStream)fin);
            wallpapers = new String[count];
            for (int i = 0; i < count; ++i) {
                wallpapers[i] = StreamUtils.readStringUTF8((InputStream)fin);
            }
        }
        backgroundSettings.delete();
        if (wallpapers != null) {
            WallpaperDisabler.setOSXDisplayWallpapers(wallpapers);
        }
    }

    private void enableWindows() {
        String wallpaperPath;
        String ssid = "";
        try {
            ssid = JWNativeAPI.getInstance().getMySessionUserSid();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("[WallpaperDisabler] SSID is " + ssid);
        if (ssid.length() > 0) {
            wallpaperPath = "HKU\\" + ssid + "\\Control Panel\\Desktop";
        } else {
            if (ClientManagement.isSimpleGateway()) {
                System.out.println("[WallpaperDisabler] no sid to identify proper wallpaper, unable to identify user to switch wallpaper in non-user (SG) session");
                return;
            }
            wallpaperPath = "HKCU\\Control Panel\\Desktop";
        }
        String wpath = WReg.get(wallpaperPath, SHWALLPAPERKEY, "REG_SZ");
        if (wpath.length() == 0) {
            System.out.println("[WallpaperDisabler] wallpaper already enabled");
            return;
        }
        String currentSettings = WReg.get(wallpaperPath, WALLPAPERKEY, "REG_SZ");
        if (!currentSettings.equals(SHWALLPAPERVALUE)) {
            System.out.println("[WallpaperDisabler] Wallpaper altered in the interim, unable to re-enable, deleting old settings");
            WReg.deleteValue(wallpaperPath, SHWALLPAPERKEY);
            return;
        }
        WReg.set(wallpaperPath, WALLPAPERKEY, wpath, "REG_SZ");
        WReg.deleteValue(wallpaperPath, SHWALLPAPERKEY);
        String tileWallpaperValue = WReg.get(wallpaperPath, TILEWALLPAPERKEY, "REG_SZ");
        String styleValue = WReg.get(wallpaperPath, WALLPAPERSTYLEKEY, "REG_SZ");
        WallpaperDisabler.pickupWallpaper(styleValue, wpath, tileWallpaperValue);
    }

    @Override
    protected void enableSetting() {
        try {
            if (OS.isWindows()) {
                this.disableWindows();
            } else if (OS.isMacOS()) {
                this.disableMacOS();
            } else if (OS.isLinux()) {
                this.disableLinux();
            }
        }
        catch (Exception x) {
            if (CentralDebugging.WALLPAPER_DISABLING) {
                x.printStackTrace();
            }
            System.out.println("[WallpaperDisabler] unable to disable wallpaper: " + x);
        }
    }

    private void disableWindows() {
        String wallpaperPath;
        String ssid;
        block7: {
            ssid = "";
            try {
                ssid = JWNativeAPI.getInstance().getMySessionUserSid();
            }
            catch (Throwable t) {
                t.printStackTrace();
                long T = System.currentTimeMillis();
                WSessionInfo.clearStaticWSessionInfo();
                WSessionInfo session = WSessionInfo.getStaticWSessionInfo_Slow();
                T = System.currentTimeMillis() - T;
                System.out.println("[WallpaperDisabler] Took " + T + " to get session info");
                if (session == null || session.getSessionSid() == null) break block7;
                ssid = session.getSessionSid();
            }
        }
        System.out.println("[WallpaperDisabler] SSID is " + ssid);
        if (ssid.length() > 0) {
            wallpaperPath = "HKU\\" + ssid + "\\Control Panel\\Desktop";
        } else {
            if (ClientManagement.isSimpleGateway()) {
                System.out.println("[WallpaperDisabler] no sid to identify proper wallpaper, unable to identify user to switch wallpaper in non-user (SG) session");
                return;
            }
            wallpaperPath = "HKCU\\Control Panel\\Desktop";
        }
        System.out.println("[WallpaperDisabler] Wallpaperpath is " + wallpaperPath);
        String setAlready = WReg.get(wallpaperPath, SHWALLPAPERKEY, "REG_SZ");
        if (CentralDebugging.WALLPAPER_DISABLING) {
            System.out.println("[WallpaperDisabler] Currently stored wallpaper is " + setAlready);
        }
        if (setAlready.trim().length() > 0) {
            System.out.println("[WallpaperDisabler] Wallpaper already disabled");
            return;
        }
        String wpath = WReg.get(wallpaperPath, WALLPAPERKEY, "REG_SZ");
        System.out.println("[WallpaperDisabler] Windows wallpaper path is currently " + wpath);
        WReg.set(wallpaperPath, SHWALLPAPERKEY, wpath, "REG_SZ");
        WReg.set(wallpaperPath, WALLPAPERKEY, SHWALLPAPERVALUE, "REG_SZ");
        String tileWallpaperValue = WReg.get(wallpaperPath, TILEWALLPAPERKEY, "REG_SZ");
        String styleValue = WReg.get(wallpaperPath, WALLPAPERSTYLEKEY, "REG_SZ");
        WallpaperDisabler.pickupWallpaper(styleValue, SHWALLPAPERVALUE, tileWallpaperValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableMacOS() throws Exception {
        File targetFile = new File("/Library/Desktop Pictures/Solid Colors/Solid Aqua Dark Blue.png");
        if (!targetFile.exists() && !(targetFile = new File("simplehelp_grey_tile.png")).exists()) {
            WallpaperDisabler.createTemporaryImage(targetFile);
        }
        String localUsername = System.getProperty("user.name");
        String normalisedUsername = FileUtil.normaliseAsFilename((String)localUsername);
        File backgroundSettings = new File("bg_" + normalisedUsername);
        try (FileOutputStream fout = null;){
            fout = new FileOutputStream(backgroundSettings);
            String[] existingDisplayWallpapers = WallpaperDisabler.getOSXDisplayWallpapers();
            if (existingDisplayWallpapers != null) {
                StreamUtils.writeInt((OutputStream)fout, (int)existingDisplayWallpapers.length);
                for (int i = 0; i < existingDisplayWallpapers.length; ++i) {
                    StreamUtils.writeStringUTF8((OutputStream)fout, (String)existingDisplayWallpapers[i]);
                }
            }
        }
        Process exec = Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell application \"System Events\" to set picture of every desktop to \"" + targetFile.getAbsolutePath() + "\""});
        new ProcessPrinter(exec, (OutputStream)System.out, (OutputStream)System.out);
        int returnCode = exec.waitFor();
        if (returnCode != 0) {
            exec = Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell application \"Finder\" to set picture of every desktop to \"" + targetFile.getAbsolutePath() + "\""});
            new ProcessPrinter(exec, (OutputStream)System.out, (OutputStream)System.out);
            returnCode = exec.waitFor();
        }
    }

    private void disableLinux() throws Exception {
        String oldBackground = null;
        File oldLinuxBackgroundFile = new File("oldLinuxBackground.txt");
        if (WallpaperDisabler.isGnome()) {
            System.out.println("[WallpaperDisabler] Detected Gnome");
            try {
                Process exec = Runtime.getRuntime().exec(new String[]{"gsettings", "get", "org.gnome.desktop.background", "picture-uri"});
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                new ProcessPrinter(exec, (OutputStream)bout, (OutputStream)System.err);
                int ret = exec.waitFor();
                if (ret != 0) {
                    throw new Exception("GSettings failed. Trying alternative.");
                }
                oldBackground = new String(bout.toByteArray(), StandardCharsets.US_ASCII);
            }
            catch (Throwable t) {
                System.out.println("[WallpaperDisabler] Unable to use gsettings to set background. Trying alternative. (" + t.getMessage() + ")");
                Process exec = Runtime.getRuntime().exec("gconftool-2 -type string -get /desktop/gnome/background/picture_filename");
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                new ProcessPrinter(exec, (OutputStream)bout, (OutputStream)System.err);
                int ret = exec.waitFor();
                if (ret != 0) {
                    exec = Runtime.getRuntime().exec("gconftool-1 -type string -get /desktop/gnome/background/picture_filename");
                    bout = new ByteArrayOutputStream();
                    new ProcessPrinter(exec, (OutputStream)bout, (OutputStream)System.err);
                    ret = exec.waitFor();
                    if (ret != 0) {
                        throw new Exception("Unable to detect Linux background.");
                    }
                }
                oldBackground = new String(bout.toByteArray(), StandardCharsets.US_ASCII);
            }
        } else if (WallpaperDisabler.isKDE()) {
            System.out.println("[WallpaperDisabler] Detected KDE");
        } else if (WallpaperDisabler.isXFCE()) {
            System.out.println("[WallpaperDisabler] Detected XFCE");
        }
        if (oldBackground != null && !oldLinuxBackgroundFile.exists()) {
            FileOutputStream fout = new FileOutputStream(oldLinuxBackgroundFile);
            fout.write(oldBackground.getBytes(StandardCharsets.US_ASCII));
            fout.close();
        }
    }

    private static void pickupWallpaper(String style, String wpath, String tileWallpaper) {
        System.out.println("[WallpaperDisabler] WallpaperDisabler path is " + wpath);
        System.out.println("[WallpaperDisabler] WallpaperDisabler style is " + style);
        System.out.println("[WallpaperDisabler] WallpaperDisabler tile is " + tileWallpaper);
        String wallpaperPath = "HKU\\.DEFAULT\\Control Panel\\Desktop";
        WReg.set(wallpaperPath, WALLPAPERSTYLEKEY, style, "REG_SZ");
        if (style.trim().length() == 0) {
            System.out.println("[WallpaperDisabler] Blank (missing) wallpaper style - not adjusting wallpaper");
            return;
        }
        try {
            NativeUtils.getInstance().pickupWallpaperChange(Integer.parseInt(style), wpath);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void createTemporaryImage(File output) {
        BufferedImage image = new BufferedImage(128, 128, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(new Color(120, 133, 151));
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2d.dispose();
        try {
            ImageIO.write((RenderedImage)image, "png", output);
        }
        catch (IOException e) {
            System.out.println("[WallpaperDisabler] Unable to generate temporary gray image");
            e.printStackTrace();
        }
    }

    public void restore() {
        if (this.isEnabled()) {
            this.disable();
        }
    }
}

