/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.tools.api;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.sdesktop.client.gui.tools.AudioTool;
import com.aem.sdesktop.client.gui.tools.BlankDesktopTool;
import com.aem.sdesktop.client.gui.tools.CaptureKeys;
import com.aem.sdesktop.client.gui.tools.DisableAeroTool;
import com.aem.sdesktop.client.gui.tools.DisableGraphicsDriver;
import com.aem.sdesktop.client.gui.tools.DisableNumlockTool;
import com.aem.sdesktop.client.gui.tools.LockTool;
import com.aem.sdesktop.client.gui.tools.PreventControl;
import com.aem.sdesktop.client.gui.tools.RecordTool;
import com.aem.sdesktop.client.gui.tools.SendAllHotkeysTool;
import com.aem.sdesktop.client.gui.tools.UseHardwareAcceleratedGrabs;
import com.aem.sdesktop.client.gui.tools.WallpaperTool;
import com.aem.sdesktop.client.gui.tools.ui.AbstractToolButton;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.interfaces.ToolsInterface;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.config.TransientTechUser;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.RootPaneContainer;
import javax.swing.event.ChangeListener;
import utils.message.Message;
import utils.switches.Switches;

public abstract class Tool
implements NodeLinkStatusListener {
    static Tool[] cachedTools = null;
    protected static final String GENERAL_GROUP = Language.get("TOOLS_GROUP_GENERAL");
    protected static final String GRAPHICS_GROUP = Language.get("TOOLS_GROUP_GRAPHICS");
    protected static final String SECURITY_GROUP = Language.get("TOOLS_GROUP_SECURITY");
    protected static final String CONTROL_GROUP = Language.get("TOOLS_GROUP_CONTROL");
    protected static final String CAPTURE_GROUP = Language.get("TOOLS_GROUP_CAPTURE");
    public String group;
    public String title;
    public ImageIcon icon = null;
    protected boolean simulateTool = false;
    protected ToolsInterface toolsInterface;
    protected ClientUserInterface ui;

    public static Tool[] getAllToolsNoUI() {
        if (cachedTools != null) {
            return cachedTools;
        }
        ArrayList<Tool> tools = new ArrayList<Tool>();
        tools.add(new WallpaperTool());
        tools.add(new UseHardwareAcceleratedGrabs());
        tools.add(new DisableGraphicsDriver());
        tools.add(new DisableAeroTool());
        tools.add(new BlankDesktopTool());
        tools.add(new PreventControl());
        tools.add(new LockTool());
        tools.add(new SendAllHotkeysTool());
        tools.add(new CaptureKeys());
        tools.add(new DisableNumlockTool());
        tools.add(new RecordTool());
        if (Switches.SLB_audio) {
            tools.add(new AudioTool());
        }
        cachedTools = tools.toArray(new Tool[0]);
        return cachedTools;
    }

    public static Tool getToolByClass(Class clazz) {
        if (cachedTools == null) {
            return null;
        }
        for (int i = 0; i < cachedTools.length; ++i) {
            if (cachedTools[i].getClass() != clazz) continue;
            return cachedTools[i];
        }
        return null;
    }

    public static Tool[] getToolsAndInitUI(ToolsInterface toolsInterface, ClientUserInterface ui) {
        Tool.getAllToolsNoUI();
        if (toolsInterface != null && ui != null) {
            for (Tool cachedTool : cachedTools) {
                cachedTool.setRunningContext(toolsInterface, ui);
            }
        }
        return cachedTools;
    }

    public Tool(String title, String group, ImageIcon icon) {
        this.title = title;
        this.group = group;
        this.icon = icon;
    }

    public void setRunningContext(ToolsInterface toolsInterface, ClientUserInterface ui) {
        this.toolsInterface = toolsInterface;
        this.ui = ui;
    }

    protected abstract RootPaneContainer getRpcForConfigurationUI();

    public abstract int getUniqueID();

    public abstract boolean showForThisRemoteOS(int var1, int var2);

    public abstract boolean toolActioned();

    public abstract boolean isAdvanced();

    public abstract boolean configure();

    public abstract boolean isTechnicianSideOnly();

    public void setSimulateTool(boolean simulate) {
        this.simulateTool = simulate;
    }

    public boolean isSimulate() {
        return this.simulateTool;
    }

    public void setTechUser(TransientTechUser user) {
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
    }

    @Override
    public void linkOK(NodeLink link) {
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
    }

    public abstract AbstractToolButton initToolButtonUI(ChangeListener var1);

    public abstract void loadFrom(Properties var1, boolean var2);

    public abstract void saveTo(Properties var1);

    public abstract Message getDesiredStateAsMessage();

    public abstract boolean isPermitted(TechGroupPermissions var1);
}

