/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.tools;

import com.aem.nodelink.NodeLink;
import com.aem.sdesktop.client.gui.tools.api.Tool;
import com.aem.sdesktop.client.gui.tools.ui.AbstractToolButton;
import com.aem.sdesktop.client.gui.tools.ui.RecordToolButton;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.tech.video.VideoRecorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import utils.message.Message;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class RecordTool
extends Tool {
    protected boolean isRecording = !VideoRecorder.getInstance().isPaused();
    protected RecordToolButton buttonUI = null;
    private RecordPanel recordPanel;
    private boolean restartWhenLinkOK = false;

    public RecordTool() {
        super(Language.get("TOOLS_RECORD"), CAPTURE_GROUP, null);
    }

    @Override
    public int getUniqueID() {
        return 0xF00011;
    }

    @Override
    protected RootPaneContainer getRpcForConfigurationUI() {
        return (RootPaneContainer)((Object)this.buttonUI.getRootComponent().getRootPane().getParent());
    }

    public void restartRecording() {
        if (this.isRecording) {
            VideoRecorder.getInstance().restartRecording();
            this.ui.requestEntireScreenForRecording();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean toolActioned() {
        RecordTool recordTool = this;
        synchronized (recordTool) {
            if (!this.isSimulate()) {
                boolean isPaused = VideoRecorder.getInstance().isPaused();
                System.out.println("[RecordTool] Action. Currently isRecording:" + this.isRecording + ", recorderOn:" + !isPaused);
                isPaused = !isPaused;
                VideoRecorder.getInstance().setPaused(isPaused);
                if (!isPaused) {
                    this.ui.requestEntireScreenForRecording();
                }
                this.isRecording = !isPaused;
            } else {
                this.isRecording = !this.isRecording;
            }
            this.updateUI(this.isRecording);
            return true;
        }
    }

    @Override
    public boolean isAdvanced() {
        return false;
    }

    @Override
    public boolean configure() {
        return false;
    }

    @Override
    public AbstractToolButton initToolButtonUI(ChangeListener listener) {
        System.out.println("[RecordTool] " + this.title + " initToolButtonUI called");
        this.buttonUI = new RecordToolButton(this, listener);
        if (!this.isRecording) {
            this.buttonUI.setPaused();
        } else {
            this.buttonUI.setRecording();
        }
        return this.buttonUI;
    }

    private void updateUI(boolean isRecording) {
        if (this.buttonUI != null) {
            if (isRecording) {
                this.buttonUI.setRecording();
            } else {
                this.buttonUI.setPaused();
            }
        }
        if (this.recordPanel != null) {
            if (isRecording) {
                this.recordPanel.setIsRecording();
            } else {
                this.recordPanel.setIsPaused();
            }
        }
    }

    @Override
    public void loadFrom(Properties props, boolean applySettings) {
        boolean defaultSetting = !VideoRecorder.getInstance().isPaused();
        String currentSetting = props.getProperty("TOOL_" + this.getUniqueID());
        boolean setting = defaultSetting;
        if (currentSetting != null) {
            setting = currentSetting.equalsIgnoreCase("on");
        }
        this.updateUI(setting);
        this.isRecording = setting;
        System.out.println("[RecordTool] Loaded state for " + this.title + " [" + applySettings + "," + this.isRecording + "," + defaultSetting + "]");
        if (applySettings && this.isRecording != defaultSetting) {
            this.toolActioned();
        }
    }

    @Override
    public void saveTo(Properties props) {
        String currentSetting = "on";
        if (!this.isRecording) {
            currentSetting = "off";
        }
        props.setProperty("TOOL_" + this.getUniqueID(), currentSetting);
    }

    @Override
    public Message getDesiredStateAsMessage() {
        Message message = new Message(1);
        message.append(this.getUniqueID());
        message.append(this.isRecording);
        return message;
    }

    @Override
    public boolean showForThisRemoteOS(int remoteOSBase, int remoteOSVariant) {
        return true;
    }

    @Override
    public boolean isTechnicianSideOnly() {
        return true;
    }

    @Override
    public boolean isPermitted(TechGroupPermissions permissions) {
        boolean canRecord = permissions.canRecord();
        if (!canRecord) {
            return false;
        }
        boolean mustRecord = permissions.mustAlwaysRecord();
        if (mustRecord) {
            System.out.println("[RecordTool] Technician has a permission forcing session recording");
            try {
                if (VideoRecorder.getInstance().isPaused()) {
                    this.toolActioned();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return !mustRecord;
    }

    public RecordPanel getRecordPanel() {
        if (this.recordPanel == null) {
            this.recordPanel = new RecordPanel();
            this.updateUI(this.isRecording);
        }
        return this.recordPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void linkDown(NodeLink link, Throwable reason) {
        RecordTool recordTool = this;
        synchronized (recordTool) {
            if (this.isRecording) {
                System.out.println("[RecordTool] Link down, pausing recording");
                this.restartWhenLinkOK = true;
                this.toolActioned();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void linkDead(NodeLink link, String reason) {
        RecordTool recordTool = this;
        synchronized (recordTool) {
            if (this.isRecording) {
                System.out.println("[RecordTool] Link dead, pausing recording");
                this.restartWhenLinkOK = true;
                this.toolActioned();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void linkOK(NodeLink link) {
        RecordTool recordTool = this;
        synchronized (recordTool) {
            if (!this.isRecording && this.restartWhenLinkOK) {
                System.out.println("[RecordTool] Link OK again, starting recording.");
                this.restartWhenLinkOK = false;
                this.toolActioned();
            }
        }
    }

    public class RecordPanel
    implements ActionListener {
        public GbPanel rootComponent = new GbPanel(new ScaledInsets(3, 5, 3, 3));
        private JLabel sessionRecording;
        private JButton startStopButton;
        private JButton restartButton;

        public RecordPanel() {
            this.initUI();
        }

        private void initUI() {
            this.rootComponent.setBorder((Border)SHBorderFactory.createMatteBorder((int)1, (int)0, (int)0, (int)0, (Color)SHStyle.PANEL_BACKGROUND_DARKER));
            this.sessionRecording = new JLabel(Language.get("HISTORY_SESSION_VIDEOS"));
            this.startStopButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/av/record.svg,16"));
            this.restartButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/av/restart.svg,16"));
            this.startStopButton.addActionListener(this);
            this.restartButton.addActionListener(this);
            int X = 0;
            this.rootComponent.add((Component)this.sessionRecording, X++, 0, 1, 1, 1, 1, 17, 2);
            this.rootComponent.add((Component)this.restartButton, X++, 0, 1, 1, 0, 1, 17, 2, (Insets)new ScaledInsets(3, 3, 3, 0));
            this.rootComponent.add((Component)this.startStopButton, X++, 0, 1, 1, 0, 1, 17, 2, (Insets)new ScaledInsets(3, 0, 3, 5));
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton)this.restartButton, (AbstractButton)this.startStopButton);
        }

        public Component getRootComponent() {
            return this.rootComponent;
        }

        public void setIsRecording() {
            this.startStopButton.setIcon(ImageLoader.getImageIcon((String)"images/svg/av/pause.svg,16"));
            this.startStopButton.repaint();
        }

        public void setIsPaused() {
            this.startStopButton.setIcon(ImageLoader.getImageIcon((String)"images/svg/av/record.svg,16"));
            this.startStopButton.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.startStopButton) {
                RecordTool.this.toolActioned();
            } else if (e.getSource() == this.restartButton) {
                RecordTool.this.restartRecording();
            }
        }

        public void setVisible(boolean isVisible) {
            this.rootComponent.setVisible(isVisible);
        }

        public void setEnabled(boolean b) {
            this.rootComponent.setEnabled(b);
            this.startStopButton.setEnabled(b);
            this.restartButton.setEnabled(b);
            this.sessionRecording.setEnabled(b);
        }
    }
}

