/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.terminal.process;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.gui.terminal.process.AbstractTerminalProcess;
import com.aem.sdesktop.client.gui.terminal.process.TerminalOutputHandler;
import com.aem.utils.NativePTYUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import utils.string.HexData;

public class WinPtyTerminalProcess
extends AbstractTerminalProcess {
    private int pid;
    private String slave;
    private boolean initialised = false;

    public WinPtyTerminalProcess(TerminalOutputHandler handler, boolean cmd) {
        super(handler);
        this.initProcess(cmd);
    }

    private void initProcess(boolean cmd) {
        this.slave = NativePTYUtils.getInstance().openMaster(false);
        ArrayList<String> envList = new ArrayList<String>();
        Map<String, String> getenv = System.getenv();
        for (String key : getenv.keySet()) {
            envList.add(key + "=" + getenv.get(key));
        }
        String[] env = envList.toArray(new String[0]);
        System.out.println("[WinPTY] Slave = " + this.slave);
        if (this.slave == null) {
            System.out.println("[WinPTY] [Error] Unable to initialise slave for WinPTY. Aborting");
            return;
        }
        String command = "powershell.exe";
        if (cmd) {
            command = "cmd.exe";
        }
        this.pid = NativePTYUtils.getInstance().exec(new String[]{command}, env, ".", NativePTYUtils.getInstance().master, false);
        new StdInPrinter(this.slave).start();
        this.initialised = true;
    }

    @Override
    public void writeCommand(byte[] dat) throws IOException {
        if (this.initialised) {
            System.out.println("[WinPTY] Writing command " + Arrays.toString(dat));
            NativePTYUtils.getInstance().write(NativePTYUtils.getInstance().master, dat, dat.length);
        } else {
            System.out.println("[WinPTY] Skipping command as WinPTY not initialised");
        }
    }

    @Override
    public void setWinSize(int cols, int rows) {
        if (this.initialised) {
            System.out.println("[WinPTY] Set win size " + cols + " x " + rows);
            System.out.println(NativePTYUtils.getInstance().changeWindowSize(NativePTYUtils.getInstance().master, cols, rows));
        } else {
            System.out.println("[WinPTY] Skipping command as WinPTY not initialised");
        }
    }

    class StdInPrinter
    extends Thread {
        private String id;

        public StdInPrinter(String id) {
            super("TerminalStdIn");
            this.id = id;
        }

        @Override
        public void run() {
            try {
                byte[] buf = new byte[10240];
                int n = 0;
                System.out.println("[Printer] Printer " + this.id + " is running...");
                while (n != -1) {
                    n = NativePTYUtils.getInstance().read(NativePTYUtils.getInstance().master, buf, buf.length);
                    if (CentralDebugging.TERMINAL_VERBOSE) {
                        System.out.println("[TerminalProcess][in] Received data from process of " + n + " characters");
                        System.out.println("[TerminalProcess][in] Received " + HexData.byteArrayToHexString((byte[])buf, (int)0, (int)n));
                        System.out.println("[TerminalProcess][in] Received " + new String(buf, 0, n));
                    }
                    if (n <= 0) continue;
                    WinPtyTerminalProcess.this.targetOutputStream.write(buf, 0, n);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

