/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.sdesktop.client.gui.DiagnosticsPanel;
import com.aem.shelp.common.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.osstats.Stats;
import utils.osstats.types.BasicInfo;
import utils.simplegraphs.SimpleBarGraph;
import utils.simplegraphs.SimplePieChart;
import utils.simplegraphs.TimeValueModel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class StatsPanel
extends JPanel
implements ActionListener,
DiagnosticsPanel.StatsInterface {
    NumberFormat percentFormat = NumberFormat.getPercentInstance();
    NumberFormat doubleDigitFormat;
    RoundBorderPanel cpuPanel;
    RoundBorderPanel diskPanel;
    RoundBorderPanel memoryPanel;
    SimpleBarGraph cpuGraph = new SimpleBarGraph();
    TimeValueModel cpuModel = new TimeValueModel(200);
    JLabel cpuLabel = new JLabel();
    JLabel idleLabel = new JLabel();
    JLabel cpuAmount = new JLabel();
    JLabel idleAmount = new JLabel();
    SimplePieChart memoryGraph = new SimplePieChart();
    TimeValueModel availableMemory = new TimeValueModel(1);
    TimeValueModel usedMemory = new TimeValueModel(1);
    JLabel memoryPercentageLabel = new JLabel();
    JLabel memoryPercentage = new JLabel();
    JLabel memoryUsedLabel = new JLabel();
    JLabel memoryUsedAmount = new JLabel();
    JLabel memoryFreeLabel = new JLabel();
    JLabel memoryFreeAmount = new JLabel();
    SimplePieChart diskGraph = new SimplePieChart();
    JComboBox diskBox = new JComboBox();
    TimeValueModel diskUsedSpace = new TimeValueModel(1);
    TimeValueModel diskFreeSpace = new TimeValueModel(1);
    JLabel diskPercentageLabel = new JLabel();
    JLabel diskPercentage = new JLabel();
    JLabel diskUsedLabel = new JLabel();
    JLabel diskFreeLabel = new JLabel();
    JLabel diskUsedAmount = new JLabel();
    JLabel diskFreeAmount = new JLabel();
    private String[] oldNames = null;
    private Stats.DiskSpaceStatistic[] space = null;

    public StatsPanel() {
        this.doubleDigitFormat = NumberFormat.getNumberInstance();
        this.doubleDigitFormat.setMaximumFractionDigits(2);
        this.cpuGraph.setData(this.cpuModel);
        this.memoryGraph.addMetric(this.usedMemory, Color.red, Color.red);
        this.memoryGraph.addMetric(this.availableMemory, Color.green, Color.green);
        this.diskGraph.addMetric(this.diskUsedSpace, Color.red, Color.red);
        this.diskGraph.addMetric(this.diskFreeSpace, Color.green, Color.green);
        this.diskGraph.setBorderPie(false);
        this.memoryGraph.setBorderPie(false);
        this.diskGraph.setNoDataString(Language.get("NO_DATA_MESSAGE"));
        this.memoryGraph.setNoDataString(Language.get("NO_DATA_MESSAGE"));
        this.cpuGraph.setNoDataString(Language.get("NO_DATA_MESSAGE"));
        this.setLayout(new GridLayout(3, 1));
        this.cpuPanel = new RoundBorderPanel(Language.get("CPU_USAGE_TITLE"));
        this.cpuPanel.setLayout(new GridLayout(1, 2));
        this.cpuGraph.setBorder(SHBorderFactory.createLineBorder((Color)Color.LIGHT_GRAY));
        this.cpuGraph.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(320, 100)));
        this.cpuPanel.add(this.cpuGraph);
        JPanel cpuStatsPanel = new JPanel();
        cpuStatsPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        GridBagLayout gbl2 = new GridBagLayout();
        cpuStatsPanel.setLayout(gbl2);
        cpuStatsPanel.add(this.cpuLabel);
        cpuStatsPanel.add(this.cpuAmount);
        cpuStatsPanel.add(this.idleLabel);
        cpuStatsPanel.add(this.idleAmount);
        gbl2.setConstraints(this.cpuLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.cpuAmount, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.idleLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.idleAmount, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        this.cpuLabel.setText(Language.get("CPU_USAGE_LABEL") + ": ");
        this.idleLabel.setText(Language.get("CPU_IDLE_LABEL") + ": ");
        this.cpuPanel.add(cpuStatsPanel);
        this.add(this.cpuPanel);
        this.memoryPanel = new RoundBorderPanel(Language.get("MEMORY_USAGE_TITLE"));
        this.memoryPanel.setLayout(new GridLayout(1, 2));
        this.memoryPanel.add(this.memoryGraph);
        this.memoryGraph.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(320, 100)));
        this.memoryGraph.setBorder(SHBorderFactory.createLineBorder((Color)Color.LIGHT_GRAY));
        JPanel memStatsPanel = new JPanel();
        memStatsPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        gbl2 = new GridBagLayout();
        memStatsPanel.setLayout(gbl2);
        memStatsPanel.add(this.memoryPercentageLabel);
        memStatsPanel.add(this.memoryPercentage);
        memStatsPanel.add(this.memoryUsedLabel);
        memStatsPanel.add(this.memoryUsedAmount);
        memStatsPanel.add(this.memoryFreeLabel);
        memStatsPanel.add(this.memoryFreeAmount);
        gbl2.setConstraints(this.memoryPercentageLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.memoryPercentage, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.memoryUsedLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.memoryUsedAmount, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.memoryFreeLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.memoryFreeAmount, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        this.memoryPercentageLabel.setText(Language.get("MEMORY_PERCENT") + ": ");
        this.memoryUsedLabel.setText(Language.get("MEMORY_USED") + ": ");
        this.memoryFreeLabel.setText(Language.get("MEMORY_FREE") + ": ");
        this.memoryPanel.add(memStatsPanel);
        this.add(this.memoryPanel);
        this.diskPanel = new RoundBorderPanel(Language.get("DISK_SPACE_TITLE"));
        this.diskPanel.setLayout(new GridLayout(1, 2));
        this.diskPanel.add(this.diskGraph);
        this.diskGraph.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(320, 100)));
        this.diskGraph.setBorder(SHBorderFactory.createLineBorder((Color)Color.LIGHT_GRAY));
        memStatsPanel = new JPanel();
        memStatsPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        gbl2 = new GridBagLayout();
        memStatsPanel.setLayout(gbl2);
        memStatsPanel.add(this.diskBox);
        memStatsPanel.add(this.diskPercentageLabel);
        memStatsPanel.add(this.diskPercentage);
        memStatsPanel.add(this.diskUsedLabel);
        memStatsPanel.add(this.diskUsedAmount);
        memStatsPanel.add(this.diskFreeLabel);
        memStatsPanel.add(this.diskFreeAmount);
        gbl2.setConstraints(this.diskBox, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.diskPercentageLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.diskPercentage, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.diskUsedLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.diskUsedAmount, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.diskFreeLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        gbl2.setConstraints(this.diskFreeAmount, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 20, 10));
        this.diskPercentageLabel.setText(Language.get("DISK_SPACE_PERCENT") + ": ");
        this.diskUsedLabel.setText(Language.get("DISK_SPACE_USED") + ": ");
        this.diskFreeLabel.setText(Language.get("DISK_SPACE_FREE") + ": ");
        this.diskPanel.add(memStatsPanel);
        this.diskBox.addActionListener(this);
        this.add(this.diskPanel);
    }

    @Override
    public void diagnosticsDataUpdated(Stats diagnostics, byte[] loadAverages) {
        long timestamp = System.currentTimeMillis();
        double cpu = diagnostics.getCpuUsagePercent();
        double idle = 100.0 - cpu;
        this.cpuModel.addData(timestamp, cpu);
        this.cpuAmount.setText(this.percentFormat.format(cpu / 100.0));
        this.idleAmount.setText(this.percentFormat.format(idle / 100.0));
        double mem = 100.0 * diagnostics.getMemoryUsed() / (diagnostics.getMemoryUsed() + diagnostics.getMemoryFree());
        this.usedMemory.addData(timestamp, diagnostics.getMemoryUsed());
        this.availableMemory.addData(timestamp, diagnostics.getMemoryFree());
        this.memoryPercentage.setText(this.percentFormat.format(mem / 100.0));
        this.memoryUsedAmount.setText(this.formatBytesWithUnits(diagnostics.getMemoryUsed()));
        this.memoryFreeAmount.setText(this.formatBytesWithUnits(diagnostics.getMemoryFree()));
        this.space = diagnostics.getDiskSpaceStatistic();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        String[] newNames = new String[this.space.length];
        for (int i = 0; i < this.space.length; ++i) {
            newNames[i] = this.space[i].name;
            model.addElement(this.space[i].name);
        }
        if (this.oldNames == null || this.oldNames.length != this.space.length) {
            this.diskBox.setModel(model);
        }
        this.oldNames = newNames;
        if (this.diskBox.getSelectedIndex() == -1 && this.space.length > 0) {
            this.diskBox.setSelectedIndex(0);
        }
        this.updateDiskStats();
        this.cpuGraph.repaint();
        this.memoryGraph.repaint();
    }

    @Override
    public Component getRootComponent() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateDiskStats();
    }

    private String formatBytesWithUnits(double bytes) {
        String units = Language.get("BYTES");
        if (bytes > 1024.0) {
            bytes /= 1024.0;
            units = Language.get("KBYTES");
        }
        if (bytes > 1024.0) {
            bytes /= 1024.0;
            units = Language.get("MBYTES");
        }
        if (bytes > 1024.0) {
            bytes /= 1024.0;
            units = Language.get("GBYTES");
        }
        return this.doubleDigitFormat.format(bytes) + " " + units;
    }

    private void updateDiskStats() {
        long timestamp = System.currentTimeMillis();
        String name = (String)this.diskBox.getSelectedItem();
        if (name == null) {
            return;
        }
        for (int i = 0; i < this.space.length; ++i) {
            if (!this.space[i].name.equals(name)) continue;
            double disk = (double)this.space[i].used / (double)(this.space[i].used + this.space[i].free);
            this.diskPercentage.setText(this.percentFormat.format(disk));
            this.diskUsedAmount.setText(this.formatBytesWithUnits(this.space[i].used));
            this.diskFreeAmount.setText(this.formatBytesWithUnits(this.space[i].free));
            this.diskUsedSpace.addData(timestamp, this.space[i].used);
            this.diskFreeSpace.addData(timestamp, this.space[i].free);
            this.diskGraph.repaint();
            return;
        }
    }

    @Override
    public void setNoDataMessage(String string) {
        this.cpuGraph.setNoDataString(string);
        this.memoryGraph.setNoDataString(string);
        this.diskGraph.setNoDataString(string);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.cpuGraph.setGrayScale(!enabled);
        this.memoryGraph.setGrayScale(!enabled);
        this.diskGraph.setGrayScale(!enabled);
        this.cpuPanel.setEnabled(enabled);
        this.diskPanel.setEnabled(enabled);
        this.memoryPanel.setEnabled(enabled);
        this.cpuLabel.setEnabled(enabled);
        this.idleLabel.setEnabled(enabled);
        this.cpuAmount.setEnabled(enabled);
        this.idleAmount.setEnabled(enabled);
        this.memoryPercentageLabel.setEnabled(enabled);
        this.memoryPercentage.setEnabled(enabled);
        this.memoryUsedLabel.setEnabled(enabled);
        this.memoryUsedAmount.setEnabled(enabled);
        this.memoryFreeLabel.setEnabled(enabled);
        this.memoryFreeAmount.setEnabled(enabled);
        this.diskBox.setEnabled(enabled);
        this.diskPercentageLabel.setEnabled(enabled);
        this.diskPercentage.setEnabled(enabled);
        this.diskUsedLabel.setEnabled(enabled);
        this.diskFreeLabel.setEnabled(enabled);
        this.diskUsedAmount.setEnabled(enabled);
        this.diskFreeAmount.setEnabled(enabled);
    }

    @Override
    public void setMachineBasicInfo(BasicInfo info) {
    }
}

