/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.shelp.common.Language;
import utils.message.Message;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class ServicesTableModel
extends SimpleTableModel {
    private final TableStructure tableStructure;

    public ServicesTableModel(SimpleList list, TableStructure tableStructure) {
        super(list, tableStructure);
        this.tableStructure = tableStructure;
    }

    private static int[] getMinColWidths() {
        return new int[]{SimpleHelpLookAndFeel.scale((int)100), SimpleHelpLookAndFeel.scale((int)80), SimpleHelpLookAndFeel.scale((int)80), SimpleHelpLookAndFeel.scale((int)100), SimpleHelpLookAndFeel.scale((int)100)};
    }

    private static int[] getMaxColWidths() {
        return new int[]{-1, SimpleHelpLookAndFeel.scale((int)80), SimpleHelpLookAndFeel.scale((int)80), -1, -1};
    }

    private static int[] getPreferredColWidths() {
        return new int[]{SimpleHelpLookAndFeel.scale((int)200), SimpleHelpLookAndFeel.scale((int)80), SimpleHelpLookAndFeel.scale((int)80), SimpleHelpLookAndFeel.scale((int)200), SimpleHelpLookAndFeel.scale((int)200)};
    }

    public static ServicesTableModel getInstance(SimpleList<Service> list) {
        TableStructure structure = TableStructure.createTableStructure(Service.class, new String[]{"name", "started", "mode", "commandLine", "description"}, new String[]{Language.get("SERVICE_COL_NAME"), Language.get("SERVICE_COL_STARTED"), Language.get("SERVICE_COL_MODE"), Language.get("SERVICE_COL_CMDLINE"), Language.get("SERVICE_COL_DESCRIPTION")}, ServicesTableModel.getPreferredColWidths(), null);
        structure.setMaxWidths(ServicesTableModel.getMaxColWidths());
        structure.setMinWidths(ServicesTableModel.getMinColWidths());
        return new ServicesTableModel(list, structure);
    }

    public void initTableDimensions(SHJTable processTable) {
        this.tableStructure.initTableDimensions(processTable);
    }

    public static class Service {
        public boolean isStarted;
        public String name;
        public String started;
        public String mode;
        public String commandLine;
        public String description;

        public Service() {
        }

        public String toString() {
            return "Service " + this.name + " started:" + this.started + "(" + this.isStarted + ") mode:" + this.mode + " commandLine:" + this.commandLine + " description:" + this.description;
        }

        public Service(Message m) {
            this.name = m.getNextString();
            this.started = m.getNextString();
            this.mode = m.getNextString();
            this.commandLine = m.getNextString();
            this.description = m.getNextString();
            if (this.started.equalsIgnoreCase("-1") || this.started.equalsIgnoreCase("YES") || this.started.equalsIgnoreCase("TRUE")) {
                this.started = Language.get("YES");
                this.isStarted = true;
            } else {
                this.started = Language.get("NO");
                this.isStarted = false;
            }
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        public Message toMessage() {
            Message m = new Message();
            m.append(this.name);
            m.append(this.started);
            m.append(this.mode);
            m.append(this.commandLine);
            m.append(this.description);
            return m;
        }
    }
}

