/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.gui.diag.ServicesTableModel;
import com.aem.sdesktop.client.gui.diag.StringRowFilter;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.shelp.common.Language;
import com.aem.shelp.util.filter.FilterInterface;
import com.aem.shelp.util.filter.FilterTablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import utils.message.Message;
import utils.progtools.DataUtil;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.renderers.AlignTableCellRendererWrapper;
import utils.swing.simplelist.SimpleList;

public class ServicesPanel
extends JPanel
implements ActionListener,
CommandResponseListener,
ListSelectionListener,
FilterInterface {
    private final int[] alignments = new int[]{2, 2, 2, 2, 2};
    private ClientController con;
    private ClientUserInterface cui;
    private boolean isWindows = false;
    private JButton refresh;
    private JButton stop;
    private JButton start;
    private JButton remove;
    private JButton mode;
    private boolean controlEnabled = false;
    private SHJTable servicesTable;
    private TableRowSorter tableRowSorter;
    private SimpleList<ServicesTableModel.Service> servicesList = new SimpleList();
    private StringRowFilter tableRowFilter;
    private FilterTablePanel filter;

    public ServicesPanel(ClientController con, ClientUserInterface cui) {
        this.con = con;
        this.cui = cui;
        this.initUI();
    }

    private void initUI() {
        this.servicesTable = new SHJTable();
        this.servicesTable.setRowHeight(SHStyle.ROW_HEIGHT);
        ServiceRenderer serviceRenderer = new ServiceRenderer();
        this.servicesTable.setDefaultRenderer(Object.class, serviceRenderer);
        this.servicesTable.setDefaultRenderer(String.class, serviceRenderer);
        ServicesTableModel servicesModel = ServicesTableModel.getInstance(this.servicesList);
        this.servicesTable.setModel(servicesModel);
        this.servicesTable.getSelectionModel().addListSelectionListener(this);
        this.servicesTable.getTableHeader().setDefaultRenderer(new AlignTableCellRendererWrapper(this.servicesTable.getTableHeader().getDefaultRenderer(), this.alignments));
        servicesModel.initTableDimensions(this.servicesTable);
        this.tableRowFilter = new StringRowFilter();
        this.tableRowSorter = new TableRowSorter<TableModel>(this.servicesTable.getModel());
        this.tableRowSorter.setSortsOnUpdates(true);
        this.tableRowSorter.setRowFilter(this.tableRowFilter);
        this.servicesTable.setRowSorter(this.tableRowSorter);
        ServiceSorter serviceSorter = new ServiceSorter();
        for (int i = 0; i < this.servicesTable.getColumnModel().getColumnCount(); ++i) {
            this.tableRowSorter.setComparator(i, serviceSorter);
        }
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        this.tableRowSorter.setSortKeys(sortKeys);
        JScrollPane pane = new JScrollPane(this.servicesTable);
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
        this.refresh = new JButton(ImageLoader.getImageIcon((String)"images/svg/arrows/refresh.svg,16"));
        this.refresh.setToolTipText(Language.get("REFRESH"));
        this.stop = new JButton(ImageLoader.getImageIcon((String)"images/svg/av/stop.svg,16"));
        this.stop.setToolTipText(Language.get("SERVICE_STOP"));
        this.start = new JButton(ImageLoader.getImageIcon((String)"images/svg/av/play.svg,16"));
        this.start.setToolTipText(Language.get("SERVICE_START"));
        this.remove = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
        this.remove.setToolTipText(Language.get("SERVICE_REMOVE"));
        this.mode = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/switches.svg,16"));
        this.mode.setToolTipText(Language.get("SERVICE_SETMODE"));
        this.filter = new FilterTablePanel(this.servicesTable, (FilterInterface)this);
        this.filter.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)0));
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton)this.start, (AbstractButton)this.stop);
        GbPanel buttonsPanel = new GbPanel();
        buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)10, (int)0, (int)0));
        buttonsPanel.add((Component)this.refresh, 0, 0, 1, 1, 0, 0, 17, 1);
        buttonsPanel.add((Component)this.start, 1, 0, 1, 1, 0, 0, 17, 1, (Insets)new ScaledInsets(0, 10, 0, 0));
        buttonsPanel.add((Component)this.stop, 2, 0, 1, 1, 0, 0, 17, 1, (Insets)new ScaledInsets(0, 0, 0, 10));
        buttonsPanel.add((Component)this.remove, 3, 0, 1, 1, 0, 0, 17, 1, (Insets)new ScaledInsets(0, 0, 0, 10));
        buttonsPanel.add((Component)this.mode, 4, 0, 1, 1, 0, 0, 17, 1, (Insets)new ScaledInsets(0, 0, 0, 10));
        buttonsPanel.add((Component)new JPanel(), 5, 0, 1, 1, 1, 0, 17, 1, (Insets)new ScaledInsets(0, 0, 0, 10));
        JPanel north = new JPanel(new BorderLayout());
        north.add((Component)this.filter, "East");
        north.add((Component)buttonsPanel, "West");
        this.add((Component)north, "North");
        this.refresh.addActionListener(this);
        this.stop.addActionListener(this);
        this.start.addActionListener(this);
        this.remove.addActionListener(this);
        this.mode.addActionListener(this);
        this.servicesTable.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void setFilters(String[] filters) {
        this.tableRowFilter.setFilters(filters);
        this.tableRowSorter.sort();
    }

    @Override
    public String[] getFilters() {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServices(final ServicesTableModel.Service[] services) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServicesPanel.this.setServices(services);
                }
            });
            return;
        }
        if (CentralDebugging.SERVICES_VERBOSE) {
            for (ServicesTableModel.Service service : services) {
                System.out.println("[ServicesPanel] " + service);
            }
        }
        this.servicesList.startBatch();
        try {
            int size = this.servicesList.size();
            while (size > services.length) {
                this.servicesList.remove(--size);
            }
            for (int i = 0; i < services.length; ++i) {
                ServicesTableModel.Service newStatistic = services[i];
                if (this.servicesList.size() > i) {
                    this.servicesList.set(i, newStatistic);
                    continue;
                }
                this.servicesList.add(newStatistic);
            }
        }
        finally {
            this.servicesList.endBatch();
        }
    }

    public ServicesTableModel.Service[] getSelectedServices() {
        int[] rows = this.servicesTable.getSelectedRows();
        ServicesTableModel.Service[] result = new ServicesTableModel.Service[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            result[i] = this.servicesList.get(this.servicesTable.convertRowIndexToModel(rows[i]));
        }
        return result;
    }

    public void requestTableUpdate() {
        if (this.isWindows && this.con != null) {
            this.con.sendAsyncRemoteCommand(new Message(-1061158893), "services");
        }
    }

    public void connectedToWindows() {
        this.isWindows = true;
        if (this.con != null) {
            this.con.registerOngoingListener(this, "services");
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.updateEnabled();
    }

    private void updateEnabled() {
        int stoppedCount = 0;
        int startedCount = 0;
        for (ServicesTableModel.Service service : this.getSelectedServices()) {
            if (service.isStarted()) {
                ++startedCount;
                continue;
            }
            ++stoppedCount;
        }
        boolean buttonsEnabled = this.isEnabled() && this.controlEnabled && this.servicesTable.getSelectedRowCount() > 0;
        this.stop.setEnabled(buttonsEnabled && startedCount > 0);
        this.start.setEnabled(buttonsEnabled && stoppedCount > 0);
        this.remove.setEnabled(buttonsEnabled);
        this.mode.setEnabled(buttonsEnabled);
        this.filter.setEnabled(buttonsEnabled);
        this.refresh.setEnabled(this.isEnabled() && this.controlEnabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(e.getSource());
    }

    public void actionPerformed(Object o) {
        String wmicPreCommand = null;
        String wmicPostCommand = null;
        if (o == this.refresh) {
            this.requestTableUpdate();
        } else if (o == this.stop) {
            wmicPreCommand = "/interactive:off service where DisplayName=\"";
            wmicPostCommand = "\" call StopService";
        } else if (o == this.start) {
            wmicPreCommand = "/interactive:off service where DisplayName=\"";
            wmicPostCommand = "\" call StartService";
        } else if (o == this.remove) {
            if (SHGlassOptionPane.showConfirmDialog((RootPaneContainer)this.cui.getParentFrame(), (String)Language.get("SERVICE_DEL_MESSAGE"), (String)Language.get("SERVICE_DEL_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), (String)Language.get("YES"))) {
                wmicPreCommand = "/interactive:off service where DisplayName=\"";
                wmicPostCommand = "\" call Delete";
            }
        } else if (o == this.mode) {
            String[] options = new String[]{"Automatic", "Manual", "Disabled"};
            int N = SHGlassOptionPane.showOptionDialog((RootPaneContainer)this.cui.getParentFrame(), (String)Language.get("SERVICE_MODE_MESSAGE"), (String)Language.get("SERVICE_MODE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/general/switches.svg,48"), (String[])options, (int)0, (String)Language.get("MODE_ACTION"));
            if (N != -1) {
                wmicPreCommand = "/interactive:off service where DisplayName=\"";
                wmicPostCommand = "\" call ChangeStartMode " + options[N];
            }
        }
        if (wmicPreCommand != null) {
            for (ServicesTableModel.Service service : this.getSelectedServices()) {
                Message m = new Message(-1061158892);
                m.append(wmicPreCommand + service.name + wmicPostCommand);
                System.out.println("Requesting WMIC command " + wmicPreCommand + service.name + wmicPostCommand);
                this.con.sendAsyncRemoteCommand(m, "ignored");
            }
        }
        if (o != this.refresh) {
            new UpdateThread().start();
        }
    }

    @Override
    public void response(Message m) {
        if (m.getType() == -1061158893) {
            ServicesTableModel.Service[] services = new ServicesTableModel.Service[m.length()];
            for (int i = 0; i < m.length(); ++i) {
                Message sub = (Message)m.get(i);
                services[i] = new ServicesTableModel.Service(sub);
            }
            this.setServices(services);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabled();
    }

    public void setControlEnabled(boolean enabled) {
        this.controlEnabled = enabled;
        this.updateEnabled();
    }

    public static void main(String[] args) throws Throwable {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        ServicesPanel panel = new ServicesPanel(null, null);
        panel.setControlEnabled(true);
        frame.getContentPane().add(panel);
        frame.setVisible(true);
        System.out.println("INITIED --------------\n\n");
        ArrayList<ServicesTableModel.Service> services = new ArrayList<ServicesTableModel.Service>();
        for (int i = 0; i < 100; ++i) {
            ServicesTableModel.Service test = new ServicesTableModel.Service();
            test.commandLine = "commandlinea slk djlaksj dlkasj ldkjas lkdjlask jd";
            test.description = "asdlk jalsk dlkasj dlkajs ldkajs lkdjaslk djlaskj dlaskj d";
            test.mode = "mode";
            test.name = "name " + i;
            test.started = i % 3 == 0 ? "NO" : "YES";
            services.add(new ServicesTableModel.Service(test.toMessage()));
        }
        panel.setServices(services.toArray(new ServicesTableModel.Service[0]));
    }

    private static class ServiceSorter
    implements Comparator<Object> {
        private ServiceSorter() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).compareTo((String)o2);
            }
            if (o1 instanceof Byte && o2 instanceof Byte) {
                return (Byte)o1 - (Byte)o2;
            }
            if (o1 instanceof Integer && o2 instanceof Integer) {
                return DataUtil.compare((int)((Integer)o1), (int)((Integer)o2));
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    class UpdateThread
    extends Thread {
        UpdateThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServicesPanel.this.requestTableUpdate();
        }
    }

    class ServiceRenderer
    extends DefaultTableCellRenderer {
        private final Border border = SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)0, (int)0);

        ServiceRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setBorder(this.border);
            ServicesTableModel.Service service = (ServicesTableModel.Service)ServicesPanel.this.servicesList.get(table.convertRowIndexToModel(row));
            if (isSelected) {
                this.setForeground(Color.white);
            } else {
                try {
                    this.setForeground(UIManager.getColor("Label.foreground"));
                    if (service != null && !service.isStarted()) {
                        this.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (column == 1 && service != null) {
                if (!service.isStarted()) {
                    component.setText(Language.get("NO"));
                } else {
                    component.setText(Language.get("YES"));
                }
            }
            return component;
        }
    }
}

