/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.shelp.common.Language;
import com.aem.shelp.util.RequestFocusListener;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.UnsupportedLookAndFeelException;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.icons.RotatingIcon;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ReconnectDialog
extends ScaledGlassDialog
implements ActionListener {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_REBOOT = 1;
    public static final int STATE_LOGOUT_POWEROFF = 2;
    public static final int STATE_SLEEP = 3;
    public static final int STATE_REMOTE_TERMINATE = 4;
    private JButton terminateButton;
    private JButton reconnectButton;
    private ReconnectDialogListener listener;
    private JWrapLabel descriptionLabel;
    private JLabel iconLabel;
    private JLabel titleLabel;
    private boolean amReconnecting = false;
    private boolean allowReconnect = false;
    private int currentState;
    private JLabel machineStatusLabel;

    public ReconnectDialog(RootPaneContainer rootPane, ReconnectDialogListener listener, boolean isDead, boolean allowReconnect, int currentState) {
        super(rootPane, 460, 190, false, true, false);
        this.currentState = currentState;
        if (this.isRebooting()) {
            this.setTitle(Language.get("CONNECTION_REBOOTING"));
        } else if (this.isLogoutOrPowerOff()) {
            this.setTitle(Language.get("CONNECTION_LOGOUT_POWEROFF"));
        } else if (this.isSleeping()) {
            this.setTitle(Language.get("CONNECTION_SLEEP"));
        } else if (this.isRemotelyTerminatedSession()) {
            this.setTitle(Language.get("CONNECTION_REMOTE_TERMINATE"));
        } else {
            this.setTitle(Language.get("CONNECTION_FAILED"));
        }
        this.listener = listener;
        this.allowReconnect = allowReconnect;
        if (this.isRebooting() || this.isLogoutOrPowerOff() || this.isRemotelyTerminatedSession()) {
            isDead = true;
        }
        this.setIsDead(isDead);
        System.out.println("[ReconnectDialog] New reconnect dialog created.");
        this.initUI();
    }

    private boolean isSleeping() {
        return this.currentState == 3;
    }

    private boolean isRebooting() {
        return this.currentState == 1;
    }

    private boolean isLogoutOrPowerOff() {
        return this.currentState == 2;
    }

    private boolean isRemotelyTerminatedSession() {
        return this.currentState == 4;
    }

    public void setIsDead(boolean isDead) {
        if (this.amReconnecting) {
            return;
        }
        if (this.titleLabel == null) {
            this.titleLabel = new JLabel();
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        }
        if (this.isRebooting()) {
            this.titleLabel.setText(Language.get("REBOOT_TITLE_2"));
        } else if (this.isLogoutOrPowerOff()) {
            this.titleLabel.setText(Language.get("LOGOUT_TITLE"));
        } else if (this.isSleeping()) {
            this.titleLabel.setText(Language.get("SLEEP_TITLE"));
        } else if (this.isRemotelyTerminatedSession()) {
            this.titleLabel.setText(Language.get("CONNECTION_REMOTE_TERMINATE_TITLE"));
        } else {
            this.titleLabel.setText(Language.get("DISCONNECTED_TITLE"));
        }
        if (this.descriptionLabel == null) {
            this.descriptionLabel = new JWrapLabel();
        }
        if (this.iconLabel == null) {
            this.iconLabel = new JLabel();
            this.iconLabel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)20));
        }
        if (this.isRebooting()) {
            this.descriptionLabel.setText("<HTML>" + Language.get("REBOOT_DESCRIPTION") + "</HTML>");
            this.iconLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/refresh.svg,33"));
        } else if (this.isLogoutOrPowerOff()) {
            this.descriptionLabel.setText("<HTML>" + Language.get("LOGOUT_DESCRIPTION") + "</HTML>");
            Icon icon = ImageLoader.getOverlayedIcon((Icon)ImageLoader.getImageIcon((String)"O[images/svg/users/technician.svg,48 | images/svg/general/remove.svg,16]"), (Icon)ImageLoader.getImageIcon((String)"images/svg/computing/power-off.svg,16"));
            this.iconLabel.setIcon(icon);
        } else if (this.isSleeping()) {
            this.descriptionLabel.setText("<HTML>" + Language.get("SLEEP_DESCRIPTION") + "</HTML>");
            this.iconLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/sleep.svg,48"));
        } else if (this.isRemotelyTerminatedSession()) {
            this.descriptionLabel.setText("<HTML>" + Language.get("CONNECTION_REMOTE_TERMINATE_DESCRIPTION") + "</HTML>");
            this.iconLabel.setIcon(ImageLoader.getImageIconDisabled((String)"images/svg/technology/screen.svg,48"));
        } else if (isDead) {
            this.descriptionLabel.setText("<HTML>" + Language.get("DISCONNECTED_DESCRIPTION_DEAD") + "</HTML>");
            this.iconLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"));
        } else {
            this.descriptionLabel.setText("<HTML>" + Language.get("DISCONNECTED_DESCRIPTION") + "</HTML>");
            this.iconLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/refresh.svg,33"));
        }
        this.descriptionLabel.repaint();
    }

    public void setMachineOffline() {
        this.machineStatusLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/machine-state/offline.svg,16"));
        this.machineStatusLabel.setText(Language.get("OFFLINE"));
    }

    public void setMachineOnline() {
        this.machineStatusLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/machine-state/online.svg,16"));
        this.machineStatusLabel.setText(Language.get("ONLINE"));
    }

    private void initUI() {
        this.setModal(false);
        GbPanel main = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        main.setBorder(SHBorderFactory.createEmptyBorder((int)20, (int)20, (int)10, (int)10));
        this.setIsDead(false);
        this.terminateButton = this.isRemotelyTerminatedSession() ? new JButton(Language.get("CLOSE"), ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16")) : new JButton(Language.get("CLOSE_SESSION"), ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"));
        this.reconnectButton = new JButton(Language.get("DISCONNECTED_RECONNECT"), ImageLoader.getImageIcon((String)"images/svg/arrows/refresh.svg,16"));
        this.terminateButton.addActionListener(this);
        this.reconnectButton.addActionListener(this);
        this.reconnectButton.addAncestorListener(new RequestFocusListener());
        this.machineStatusLabel = new JLabel();
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(5, 5, 5, 5));
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 3, SimpleHelpLookAndFeel.scale((int)10), 0));
        panel.add(this.machineStatusLabel);
        panel.add(this.terminateButton);
        if (this.allowReconnect) {
            panel.add(this.reconnectButton);
            SHButtonUI.makeButtonBlue((JButton)this.reconnectButton);
        } else {
            SHButtonUI.makeButtonBlue((JButton)this.terminateButton);
        }
        buttonsPanel.add((Component)panel, 0, 0, 1, 1, 1, 0, 13, 0);
        main.add((Component)this.iconLabel, 0, 0, 1, 2, 0, 0, 18, 0);
        main.add((Component)this.titleLabel, 1, 0, 1, 1, 1, 0, 17, 2);
        main.add((Component)this.descriptionLabel, 1, 1, 1, 1, 1, 0, 17, 2);
        main.add((Component)buttonsPanel, 0, 2, 2, 1, 1, 1, 10, 2);
        this.getContentPane().add((Component)main);
        this.setVisible(true);
    }

    public static void main(String[] args) throws UnsupportedLookAndFeelException, IOException, InterruptedException {
        Language.loadTranslations();
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 500);
        frame.setVisible(true);
        ReconnectDialog dialog = new ReconnectDialog((RootPaneContainer)frame, new ReconnectDialogListener(){

            @Override
            public void doReconnect() {
                System.out.println("Reconnect");
            }

            @Override
            public void doTerminate() {
                System.out.println("Terminate");
            }
        }, true, true, 4);
        System.out.println(frame.getFocusOwner());
        dialog.setMachineOffline();
        dialog.reconnectButton.requestFocusInWindow();
        System.out.println(frame.getFocusOwner());
        Thread.sleep(5000L);
        System.out.println("Set is dead");
        dialog.setIsDead(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.terminateButton) {
            System.out.println("[ReconnectDialog] Terminate button pressed");
            this.setVisible(false);
            this.listener.doTerminate();
        } else if (e.getSource() == this.reconnectButton) {
            System.out.println("[ReconnectDialog] Reconnect button pressed");
            this.doReconnect();
        }
    }

    public void doReconnect() {
        this.amReconnecting = true;
        this.reconnectButton.setEnabled(false);
        this.titleLabel.setText(Language.get("RECONNECTION_TITLE"));
        this.descriptionLabel.setText(Language.get("RECONNECTION_DESCRIPTION") + "...");
        RotatingIcon icon = new RotatingIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/refresh.svg,33"));
        this.iconLabel.setIcon(icon);
        this.repaint();
        this.listener.doReconnect();
    }

    public void setReconnectFailed(boolean reconnectedFailed) {
        if (reconnectedFailed) {
            this.iconLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"));
            this.titleLabel.setText(Language.get("UNABLE_RECONNECT_TITLE"));
            this.descriptionLabel.setText(Language.get("UNABLE_RECONNECT_MESSAGE"));
            this.reconnectButton.setEnabled(true);
            this.repaint();
        }
    }

    static interface ReconnectDialogListener {
        public void doReconnect();

        public void doTerminate();
    }
}

