/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.CentralDebugging;
import java.util.ArrayList;

public class HintOverlayManager
implements Runnable {
    private final Object LOCK = new Object();
    private Thread runnerThread = null;
    private ArrayList<HintOverlayListener> listeners = new ArrayList();
    private Hint centreHint = new Hint();
    private Hint topHint = new Hint();
    private Hint bottomHint = new Hint();

    public Hint getTopLeftHint() {
        return this.topHint;
    }

    public Hint getCentreHint() {
        return this.centreHint;
    }

    public Hint getBottomHint() {
        return this.bottomHint;
    }

    public void addOverlayListener(HintOverlayListener listener) {
        this.listeners.add(listener);
    }

    public void setTopHint(String message, long showTimeMS) {
        this.topHint.setMessage(message, showTimeMS, false);
        this.startThreadIfRequired();
    }

    public void setCentreHint(String message, long showTimeMS, boolean showProgress) {
        this.centreHint.setMessage(message, showTimeMS, showProgress);
        this.startThreadIfRequired();
    }

    public void setCentreHint(String[] messages, long showTimeMS, boolean showProgress) {
        this.centreHint.setMessage(messages, showTimeMS, showProgress);
        this.startThreadIfRequired();
    }

    public void setBottomHint(String message, long showTimeMS) {
        this.bottomHint.setMessage(message, showTimeMS, false);
        this.startThreadIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThreadIfRequired() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.topHint.message != null || this.bottomHint.message != null || this.centreHint.message != null) {
                if (this.runnerThread == null) {
                    if (CentralDebugging.GUI_OVERLAYS_DEBUG) {
                        System.out.println("[Overlays] Starting overlays runner thread");
                    }
                    this.runnerThread = new Thread(this);
                    this.runnerThread.start();
                } else {
                    if (CentralDebugging.GUI_OVERLAYS_DEBUG) {
                        System.out.println("[Overlays] Notifying overlays runner thread");
                    }
                    Object object2 = this.LOCK;
                    synchronized (object2) {
                        this.LOCK.notify();
                    }
                }
            } else if (CentralDebugging.GUI_OVERLAYS_DEBUG) {
                System.out.println("[Overlays] [WARNING] Asked to start the overlays thread, but no overlay is set?");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                if (this.topHint.message == null && this.centreHint.message == null) {
                    if (this.bottomHint.message == null) return;
                }
                if (CentralDebugging.GUI_OVERLAYS_DEBUG) {
                    System.out.println("[Overlays] [Processor] Iterating...");
                }
                this.topHint.iterate();
                this.centreHint.iterate();
                this.bottomHint.iterate();
                if (CentralDebugging.GUI_OVERLAYS_DEBUG) {
                    System.out.println("[Overlays] [Processor] Notifying listeners...");
                }
                for (HintOverlayListener listener : this.listeners) {
                    listener.updateHints(this.centreHint, this.topHint, this.bottomHint);
                }
                Object object = this.LOCK;
                synchronized (object) {
                    long nextEvent = Long.MAX_VALUE;
                    if (this.topHint.nextEvent > 0L) {
                        nextEvent = Math.min(nextEvent, this.topHint.nextEvent);
                    }
                    if (this.centreHint.nextEvent > 0L) {
                        nextEvent = Math.min(nextEvent, this.centreHint.nextEvent);
                    }
                    if (this.bottomHint.nextEvent > 0L) {
                        nextEvent = Math.min(nextEvent, this.bottomHint.nextEvent);
                    }
                    if (this.topHint.nextEvent < nextEvent) {
                        this.topHint.nextEvent = 0L;
                    }
                    if (this.centreHint.nextEvent < nextEvent) {
                        this.centreHint.nextEvent = 0L;
                    }
                    if (this.bottomHint.nextEvent < nextEvent) {
                        this.bottomHint.nextEvent = 0L;
                    }
                    if (CentralDebugging.GUI_OVERLAYS_DEBUG) {
                        System.out.println("[Overlays] [Processor] Next event is " + nextEvent);
                    }
                    if (nextEvent >= Long.MAX_VALUE) {
                        this.runnerThread = null;
                        return;
                    }
                    try {
                        long sleep = Math.max(nextEvent - System.currentTimeMillis(), 0L);
                        if (CentralDebugging.GUI_OVERLAYS_DEBUG) {
                            System.out.println("[Overlays] [Processor] Sleeping for " + sleep);
                        }
                        if (sleep > 0L) {
                            this.LOCK.wait(sleep);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            Object object = this.LOCK;
            synchronized (object) {
                this.runnerThread = null;
            }
        }
    }

    public static interface HintOverlayListener {
        public void updateHints(Hint var1, Hint var2, Hint var3);
    }

    public class Hint {
        public String[] message;
        public int alpha;
        public boolean showing;
        private long showUntil;
        private long showFor;
        private long nextEvent;
        public boolean showProgressIcon = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void iterate() {
            Hint hint = this;
            synchronized (hint) {
                if (this.message == null || this.message[0] == null) {
                    return;
                }
                if (this.nextEvent > 0L && System.currentTimeMillis() < this.nextEvent) {
                    return;
                }
                if (this.showing) {
                    if (this.alpha < 255) {
                        this.alpha += 20;
                        if (this.alpha >= 255) {
                            this.alpha = Math.min(255, this.alpha);
                            if (this.showFor > 0L) {
                                this.nextEvent = this.showUntil = System.currentTimeMillis() + this.showFor;
                            } else {
                                this.showUntil = Long.MAX_VALUE;
                                this.nextEvent = 0L;
                            }
                        } else {
                            this.nextEvent = System.currentTimeMillis() + 20L;
                        }
                    } else if (System.currentTimeMillis() > this.showUntil) {
                        this.showing = false;
                        this.nextEvent = System.currentTimeMillis() + 20L;
                    } else if (this.nextEvent == 0L) {
                        if (this.showFor > 0L) {
                            this.nextEvent = this.showUntil = System.currentTimeMillis() + this.showFor;
                        } else {
                            this.showUntil = Long.MAX_VALUE;
                            this.nextEvent = 0L;
                        }
                    }
                } else if (this.alpha == 0) {
                    this.message = null;
                    this.nextEvent = 0L;
                } else {
                    this.alpha = Math.max(0, this.alpha - 20);
                    this.nextEvent = System.currentTimeMillis() + 20L;
                }
            }
        }

        public void setMessage(String message, long showTimeMS, boolean showProgressIcon) {
            this.setMessage(new String[]{message}, showTimeMS, showProgressIcon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMessage(String[] message, long showTimeMS, boolean showProgressIcon) {
            Hint hint = this;
            synchronized (hint) {
                if (CentralDebugging.GUI_OVERLAYS_DEBUG) {
                    System.out.println("[Overlays] Setting message:" + message + " showTimeMS:" + showTimeMS + " progress:" + showProgressIcon);
                }
                this.message = message;
                if (message[0] == null) {
                    this.message = null;
                }
                this.showProgressIcon = showProgressIcon;
                this.nextEvent = 0L;
                this.showFor = showTimeMS;
                this.showing = true;
            }
        }
    }
}

