/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.controller;

import com.aem.sdesktop.client.controller.Controller;
import java.util.Properties;

public class MachinePrefs {
    private static final String UDP_PORT_SCAN = "UDP_PS_OK";
    private static final String PORT_FORWARD = "PORT_FORWARD";
    private static final String TRANSPORT_LOCAL = "TRANSPORT_LOCAL";
    private static final String TRANSPORT_REMOTE = "TRANSPORT_REMOTE";
    Controller controller;

    public MachinePrefs(Controller controller) {
        this.controller = controller;
    }

    private synchronized void save(Properties props) {
        try {
            this.controller.writeMachineSpecificPreferences(props);
        }
        catch (Exception x) {
            System.out.println("[MachinePrefs] Failed to save properties: " + x);
            x.printStackTrace();
        }
    }

    public synchronized void setPortForwards(String portForwardXML) {
        Properties props = this.controller.readMachineSpecificPreferences();
        props.setProperty(PORT_FORWARD, portForwardXML);
        this.save(props);
    }

    public synchronized String getPortForwards() {
        Properties props = this.controller.readMachineSpecificPreferences();
        String prop = props.getProperty(PORT_FORWARD);
        return prop;
    }

    public synchronized void setUdpPortScansOK(boolean b) {
        Properties props = this.controller.readMachineSpecificPreferences();
        props.setProperty(UDP_PORT_SCAN, "" + b);
        this.save(props);
    }

    public synchronized boolean areUdpPortScansOK() {
        Properties props = this.controller.readMachineSpecificPreferences();
        String prop = props.getProperty(UDP_PORT_SCAN);
        if (prop == null) {
            return false;
        }
        return prop.trim().equalsIgnoreCase("true");
    }

    public synchronized int[] getDesiredLocalAndRemoteTransport() {
        Properties props = this.controller.readMachineSpecificPreferences();
        String localProp = props.getProperty(TRANSPORT_LOCAL);
        String remoteProp = props.getProperty(TRANSPORT_REMOTE);
        if (localProp != null && remoteProp != null) {
            int[] result = new int[]{Integer.parseInt(localProp), Integer.parseInt(remoteProp)};
            return result;
        }
        return null;
    }

    public synchronized void setDesiredTransports(int local, int remote) {
        System.out.println("[MachinePrefs] Saving desired transports: " + local + "," + remote);
        Properties props = this.controller.readMachineSpecificPreferences();
        props.setProperty(TRANSPORT_LOCAL, Integer.toString(local));
        props.setProperty(TRANSPORT_REMOTE, Integer.toString(remote));
        this.save(props);
    }
}

