/*
 * Decompiled with CFR 0.152.
 */
package com.aem.profiles.model;

import com.aem.shelp.licence.OemBranding;
import utils.switches.Switches;

public class ProfileType {
    public static BaseApp BASE_APP_ACCESS = new BaseApp("access");
    public static BaseApp BASE_APP_TECHNICIAN = new BaseApp("technician");
    public static BaseApp BASE_APP_CUSTOMER = new BaseApp("customer");
    public static BaseApp BASE_APP_PRESENT = new BaseApp("present");
    public static BaseApp BASE_APP_GROUPACCESS = new BaseApp("present");
    private String name;
    private String iconKey;
    private String id;
    private BaseApp baseApp;
    private String[] keys;

    public ProfileType(String id, String name, BaseApp baseApp, String iconKey, String[] explainerKeys) {
        String[] checks;
        this.id = id;
        this.name = name;
        this.baseApp = baseApp;
        this.iconKey = iconKey;
        this.keys = explainerKeys;
        for (String check : checks = new String[]{OemBranding.OEM_ACCESS_APP_NAME, OemBranding.OEM_SUPPORT_APP_NAME, OemBranding.OEM_TECHNICIAN_APP_NAME, "JWrapper", "Applet"}) {
            if (!name.contains(check) && !check.contains(name) || name.equals(check)) continue;
            throw new Error("ProfileType name " + name + " conflicts with app or reserved string " + check + "!");
        }
        if (name.toLowerCase().equals(name)) {
            throw new Error("ProfileType name " + name + " must have uppercase components to prevent clashes with standard files!");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getIconKey() {
        return this.iconKey;
    }

    public void setExplainerKeys(String[] keys) {
        this.keys = keys;
    }

    public String[] getExplainerKeys() {
        if (this.keys == null) {
            return new String[0];
        }
        return this.keys;
    }

    public String getID() {
        return this.id;
    }

    public String getBaseHtmlFile() {
        if (this.baseApp == BASE_APP_ACCESS) {
            return "access.html";
        }
        if (this.baseApp == BASE_APP_CUSTOMER) {
            return "customer.html";
        }
        if (this.baseApp == BASE_APP_TECHNICIAN) {
            return "technician.html";
        }
        if (this.baseApp == BASE_APP_PRESENT) {
            if (Switches.SH_aliasProfileAppsToBaseApps) {
                return "technician.html";
            }
            return "present.html";
        }
        if (this.baseApp == BASE_APP_GROUPACCESS) {
            if (Switches.SH_aliasProfileAppsToBaseApps) {
                return "technician.html";
            }
            return "groupaccess.html";
        }
        return "";
    }

    public BaseApp getBaseApp() {
        return this.baseApp;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ProfileType)) {
            return false;
        }
        return ((ProfileType)o).getID().equals(this.id);
    }

    static class BaseApp {
        String prefix;

        public BaseApp(String prefix) {
            this.prefix = prefix;
        }
    }
}

