/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.http;

import com.aem.nodelink.Endpoint;
import com.aem.nodelink.Node;
import com.aem.nodelink.Transport;
import com.aem.nodelink.http.BasicHttpTransport;
import com.aem.nodelink.http.DefaultHttpClientFactory;
import com.aem.nodelink.http.DefaultHttpServerFactory;
import com.aem.nodelink.http.FullDuplexHttpTransport;
import com.aem.nodelink.http.OldHttpTransport;
import com.aem.nodelink.http.extend.HttpClientFactory;
import com.aem.nodelink.http.extend.HttpServerFactory;
import java.net.URL;

public class HttpEndpoint
implements Endpoint {
    static boolean USE_OLD_HTTP = false;
    static boolean USE_FULL_DUPLEX_HTTP = true;
    URL url;
    String stringval;
    HttpServerFactory factory = new DefaultHttpServerFactory();
    HttpClientFactory cfactory = new DefaultHttpClientFactory();

    public HttpEndpoint(URL url) {
        this.url = url;
        this.stringval = url.toString();
    }

    public HttpEndpoint(URL url, boolean clientAcceptAllSslCerts) {
        this.url = url;
        this.stringval = url.toString();
        if (clientAcceptAllSslCerts) {
            ((DefaultHttpClientFactory)this.cfactory).setAcceptAnySslCert(true);
        }
    }

    public HttpEndpoint(URL url, HttpClientFactory cfactory, HttpServerFactory factory) {
        this.url = url;
        this.factory = factory;
        this.cfactory = cfactory;
        this.stringval = url.toString();
    }

    public void setHttpServerFactory(HttpServerFactory factory) {
        this.factory = factory;
    }

    public void setHttpClientFactory(HttpClientFactory cfactory) {
        this.cfactory = cfactory;
    }

    public String toString() {
        return this.stringval;
    }

    @Override
    public Transport newTransport(Node n) {
        if (USE_OLD_HTTP) {
            return new OldHttpTransport(n);
        }
        if (USE_FULL_DUPLEX_HTTP) {
            return new FullDuplexHttpTransport(n);
        }
        return new BasicHttpTransport(n);
    }
}

