/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.http;

import com.aem.nodelink.http.extend.HttpClientFactory;
import com.aem.nodelink.http.extend.HttpRequestPoster;
import com.aem.nodelink.utils.BlockingObjectInputStream;
import com.aem.nodelink.utils.DataUtils;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class DefaultHttpClientFactory
implements HttpClientFactory,
HttpRequestPoster {
    public static String MIME_APPLICATION = "application/octet-stream";
    public static String MIME_IMAGE = "image/png";
    public static String MIME_AUDIO = "audio/x-wav";
    public static String MIME_PLAINTEXT = "text/plain";
    public static String MIME_HTML = "text/html";
    public static String MIME_TYPE = MIME_APPLICATION;
    private HttpURLConnection lastconn;
    private boolean acceptAnySslCert = false;

    public static void setMimeType(String mime) {
        MIME_TYPE = mime;
    }

    @Override
    public HttpRequestPoster newClient() {
        return this;
    }

    public void setAcceptAnySslCert(boolean b) {
        this.acceptAnySslCert = b;
    }

    private static ArrayList<String> getSupportedProtocolsList() {
        ArrayList<String> supportedProtocols = new ArrayList<String>();
        String property = System.getProperty("https.protocols");
        if (property != null) {
            String[] protocols;
            for (String s : protocols = property.split("\\,")) {
                supportedProtocols.add(s.trim());
            }
        }
        return supportedProtocols;
    }

    private static void handlePossibleDowngradeException(ArrayList<String> supportedProtocols, IllegalArgumentException ex) {
        String message = ex.getMessage();
        if (message != null && supportedProtocols.size() > 0) {
            System.out.println("[DefaultHttpClientFactory] Failed with " + ex.getClass().getName() + ": " + message);
            String match = null;
            for (String protocol : supportedProtocols) {
                if (!protocol.equalsIgnoreCase(message)) continue;
                match = protocol;
                break;
            }
            if (match != null && supportedProtocols.remove(match)) {
                StringBuilder newProperty = new StringBuilder();
                for (int i = 0; i < supportedProtocols.size(); ++i) {
                    if (i > 0) {
                        newProperty.append(",");
                    }
                    newProperty.append(supportedProtocols.get(i));
                }
                System.setProperty("https.protocols", newProperty.toString());
                return;
            }
        }
        throw ex;
    }

    @Override
    public InputStream doPost(URL url, byte[] initialPost, int contentLen, BlockingObjectInputStream tosend) throws Exception {
        ArrayList<String> supportedProtocolsList = DefaultHttpClientFactory.getSupportedProtocolsList();
        boolean success = false;
        URLConnection conn = null;
        int maxTries = 1;
        if (supportedProtocolsList != null) {
            maxTries = supportedProtocolsList.size() + 1;
        }
        while (!success) {
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.setUseCaches(false);
                if (conn instanceof HttpsURLConnection && this.acceptAnySslCert) {
                    ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String rserver, SSLSession sses) {
                            return true;
                        }
                    });
                    try {
                        SSLContext sc = SSLContext.getInstance("SSL");
                        sc.init(null, new TrustManager[]{new X509TrustManager(){

                            @Override
                            public X509Certificate[] getAcceptedIssuers() {
                                return null;
                            }

                            @Override
                            public void checkClientTrusted(X509Certificate[] certs, String authType) {
                            }

                            @Override
                            public void checkServerTrusted(X509Certificate[] certs, String authType) {
                            }
                        }}, new SecureRandom());
                        ((HttpsURLConnection)conn).setSSLSocketFactory(sc.getSocketFactory());
                    }
                    catch (Exception sc) {
                        // empty catch block
                    }
                }
                if (contentLen > 0) {
                    ((HttpURLConnection)conn).setFixedLengthStreamingMode(contentLen + initialPost.length);
                }
                conn.setDoOutput(true);
                if (MIME_TYPE != null) {
                    conn.setRequestProperty("Content-Type", MIME_TYPE);
                }
                conn.connect();
                success = true;
            }
            catch (IllegalArgumentException ex) {
                if (--maxTries <= 0) {
                    throw ex;
                }
                DefaultHttpClientFactory.handlePossibleDowngradeException(supportedProtocolsList, ex);
            }
        }
        OutputStream out = conn.getOutputStream();
        out.write(initialPost);
        out.flush();
        if (contentLen > 0) {
            int N = 0;
            while (N != -1) {
                byte[] dat = (byte[])tosend.next();
                out.write(dat);
                out.flush();
            }
        }
        out.close();
        this.lastconn = conn;
        return new BufferedInputStream(conn.getInputStream());
    }

    @Override
    public byte[] doPost(URL url, byte[] tosend) throws Exception {
        ArrayList<String> supportedProtocolsList = DefaultHttpClientFactory.getSupportedProtocolsList();
        boolean success = false;
        URLConnection conn = null;
        while (!success) {
            try {
                conn = url.openConnection();
                conn.setUseCaches(false);
                conn.setDoOutput(true);
                if (MIME_TYPE != null) {
                    conn.setRequestProperty("Content-Type", MIME_TYPE);
                }
                conn.connect();
                success = true;
            }
            catch (IllegalArgumentException ex) {
                DefaultHttpClientFactory.handlePossibleDowngradeException(supportedProtocolsList, ex);
            }
        }
        OutputStream out = conn.getOutputStream();
        out.write(tosend);
        out.flush();
        out.close();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        byte[] ret = DataUtils.readAll(in);
        return ret;
    }

    @Override
    public void close() {
        try {
            this.lastconn.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        System.setProperty("sun.net.client.defaultConnectTimeout", "15000");
        System.setProperty("sun.net.client.defaultReadTimeout", "15000");
    }
}

