/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.attempt;

import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.attempt.Attempt;
import com.aem.nodelink.attempt.AttemptValidation;

public class NodelinkAttempt
implements Attempt {
    public static boolean VERBOSE = true;
    String name;
    Node me;
    Node them;
    boolean success = false;
    boolean finished = false;
    boolean abort;
    long delay;
    NodeLink nl;
    int statsType = -1;
    AttemptValidation validator;

    public NodelinkAttempt(String name, Node me, Node them, int statsType, AttemptValidation validator) {
        this(name, me, them, statsType, validator, 0L);
    }

    public NodelinkAttempt(String name, Node me, Node them, int statsType, AttemptValidation validator, long delay) {
        this.name = name;
        this.me = me;
        this.them = them;
        this.statsType = statsType;
        this.delay = delay;
        this.validator = validator;
    }

    public void setValidator(AttemptValidation validator) {
        this.validator = validator;
    }

    public NodelinkAttempt cloneNew() {
        NodelinkAttempt nl = new NodelinkAttempt(this.name, this.me, this.them, this.statsType, this.validator, this.delay);
        return nl;
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Node getMeNode() {
        return this.me;
    }

    public Node getThemNode() {
        return this.them;
    }

    public NodeLink getNodeLink() {
        return this.nl;
    }

    @Override
    public void abortAttempt() {
        this.abort = true;
        try {
            this.nl.stop("attempt aborted (other finished first)");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void attemptNow() throws Throwable {
        try {
            if (this.abort) {
                return;
            }
            this.nl = new NodeLink(this.me, this.them);
            if (this.validator != null) {
                this.validator.validate(this.name, this.nl);
            }
            this.nl.getStats().type = this.statsType;
            if (this.abort) {
                this.nl.stop("attempt aborted (other finished first)");
            } else {
                this.success = true;
            }
        }
        finally {
            this.finished = true;
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean wasSuccessful() {
        return this.success;
    }
}

