/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.attempt;

import com.aem.nodelink.attempt.Attempt;
import com.aem.nodelink.attempt.ConcurrentAttemptListener;
import java.util.ArrayList;
import java.util.Date;

public class ConcurrentAttempt {
    ArrayList list = new ArrayList();
    ConcurrentAttemptListener listener;
    AttemptsThread attempts;

    public ConcurrentAttempt() {
    }

    public ConcurrentAttempt(ConcurrentAttemptListener listener) {
        this.listener = listener;
    }

    public void addAttemptLayer(Attempt[] attempt) {
        this.list.add(attempt);
    }

    public void newAttemptLayer() {
        this.list.add(new Attempt[0]);
    }

    public void appendAttemptToCurrentLayer(Attempt attempt) {
        if (this.list.size() == 0) {
            this.newAttemptLayer();
        }
        Attempt[] layer = (Attempt[])this.list.get(0);
        Attempt[] nlayer = new Attempt[layer.length + 1];
        System.arraycopy(layer, 0, nlayer, 0, layer.length);
        nlayer[layer.length] = attempt;
        this.list.set(this.list.size() - 1, nlayer);
    }

    public void attemptNowNonBlocking() {
        this.attempts = new AttemptsThread();
        this.attempts.start();
    }

    public boolean attemptsFinished() {
        return this.attempts.finished;
    }

    public Attempt getSuccessfulAttempt() {
        return this.attempts.attempt;
    }

    public Attempt attemptNow() {
        block2: for (int i = 0; i < this.list.size(); ++i) {
            Attempt[] attempts = (Attempt[])this.list.get(i);
            for (int a = 0; a < attempts.length; ++a) {
                new AttemptThread(attempts[a]).start();
            }
            while (true) {
                int finishCount = 0;
                for (int a = 0; a < attempts.length; ++a) {
                    Attempt att = attempts[a];
                    if (!att.isFinished()) continue;
                    ++finishCount;
                    if (!att.wasSuccessful()) continue;
                    for (int k = 0; k < attempts.length; ++k) {
                        if (a == k) continue;
                        attempts[k].abortAttempt();
                    }
                    return att;
                }
                if (finishCount >= attempts.length) {
                    if (this.listener == null) continue block2;
                    this.listener.layerFailed(i);
                    continue block2;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    class AttemptThread
    extends Thread {
        Attempt attempt;

        public AttemptThread(Attempt attempt) {
            this.attempt = attempt;
        }

        @Override
        public void run() {
            System.out.println("[ConcAttempt] Trying " + this.attempt);
            if (this.attempt.getDelay() != 0L) {
                try {
                    Thread.sleep(this.attempt.getDelay());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long started = System.currentTimeMillis();
            try {
                this.attempt.attemptNow();
            }
            catch (Throwable t) {
                long ended = System.currentTimeMillis();
                long triedFor = ended - started;
                System.out.println("[ConcAttempt] Attempt " + this.attempt + " quit (finished=" + this.attempt.isFinished() + ",success=" + this.attempt.wasSuccessful() + ",started=" + new Date(started) + ",duration=" + triedFor + "ms): " + t);
            }
        }
    }

    class AttemptsThread
    extends Thread {
        Attempt attempt;
        boolean finished = false;

        AttemptsThread() {
        }

        @Override
        public void run() {
            this.attempt = ConcurrentAttempt.this.attemptNow();
            this.finished = true;
        }
    }
}

