/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink;

import com.aem.nodelink.InfiniteLoop;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkFactoryHandler;
import java.util.ArrayList;

public class NodeLinkFactoryServer {
    public static final int DEFAULT_TIMEOUT = NodeLink.DEFAULT_RECONNECT_TIMEOUT;
    Node me;
    ArrayList accepters = new ArrayList();
    boolean stop = false;
    int timeout;
    NodeLinkFactoryHandler handler;

    public NodeLinkFactoryServer(Node me, NodeLinkFactoryHandler handler) throws Exception {
        this(me, handler, DEFAULT_TIMEOUT);
    }

    public NodeLinkFactoryServer(Node me, NodeLinkFactoryHandler handler, int timeout) throws Exception {
        this.me = me;
        this.timeout = timeout;
        this.handler = handler;
        for (int i = 0; i < 25; ++i) {
            Accepter ac = new Accepter();
            ac.start();
            this.accepters.add(ac);
        }
    }

    public void stop() {
        this.stop = true;
        for (int i = 0; i < this.accepters.size(); ++i) {
            Accepter ac = (Accepter)this.accepters.get(i);
            ac.interrupt();
        }
    }

    class NodeLinkHandler
    extends Thread {
        NodeLink nl;

        public NodeLinkHandler(NodeLink nl) {
            this.setName("NodeLinkFactoryServer$NodeLinkHandler");
            this.nl = nl;
        }

        @Override
        public void run() {
            NodeLinkFactoryServer.this.handler.nodeLinkConnected(this.nl);
        }
    }

    class Accepter
    extends Thread {
        public Accepter() {
            this.setName("NodeLinkFactoryServer$Accepter");
            this.setPriority(10);
        }

        @Override
        public void run() {
            InfiniteLoop il = new InfiniteLoop();
            while (!NodeLinkFactoryServer.this.stop) {
                il.LOOP();
                try {
                    NodeLink nl = new NodeLink(NodeLinkFactoryServer.this.me, NodeLink.INFINITE_TIMEOUT, NodeLinkFactoryServer.this.timeout);
                    new NodeLinkHandler(nl).start();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

