/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkFlowController;
import com.aem.nodelink.utils.ByteArrayUtils;
import com.aem.nodelink.utils.SafeClock;
import utils.stream.FixedBandwidthLimiter;
import utils.switches.Switches;

public class NodeLinkBEFController3
implements NodeLinkFlowController {
    static int ADJUST_EVERY_MS = 1000;
    static final double DESIRED_UTILISATION = 0.75;
    static final double DECREASE_ADJUST_FACTOR = 0.3;
    static final double INCREASE_ADJUST_FACTOR = 0.7;
    double limitKPS = 200.0;
    int typicalPacketSizeB = 512;
    long minBurstMs = 25L;
    int burstForMs = 125;
    byte[] burstPacket = new byte[380];
    long lastBurst = 0L;
    long burstUntil = 0L;
    FixedBandwidthLimiter fbl = new FixedBandwidthLimiter();
    Object LOCK = new Object();
    long lastRTTraw;
    double lastRTTsmooth;

    public boolean maySlowFlow() {
        return false;
    }

    public NodeLinkBEFController3() {
        ByteArrayUtils.writeShort(this.burstPacket, 0, (short)17478);
    }

    @Override
    public byte[] nextRequiredPacket() {
        long sfc = SafeClock.currentTimeMillis();
        if (sfc > this.lastBurst + (long)ADJUST_EVERY_MS) {
            System.out.println("[NL BEF] Bursting now for " + this.burstForMs);
            ByteArrayUtils.writeInt(this.burstPacket, 2, (int)((double)this.burstForMs * 0.8));
            this.lastBurst = SafeClock.currentTimeMillis();
            this.burstUntil = this.lastBurst + (long)this.burstForMs;
        }
        if (this.burstUntil > 0L) {
            if (sfc > this.burstUntil) {
                this.burstUntil = 0L;
                System.out.println("[NL BEF] Burst done");
            }
            return this.burstPacket;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flowControl(int dataLength, boolean allowIncrease) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.burstUntil > 0L) {
                this.fbl.setKBsec(Math.max(2, (int)(this.limitKPS * 2.0)));
            } else {
                this.fbl.setKBsec(Math.max(2, (int)this.limitKPS));
            }
            this.fbl.didWrite(0L, dataLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readRateMeasured(long packetsPerSecond) {
        double maxMeasuredKps = packetsPerSecond;
        maxMeasuredKps *= (double)this.typicalPacketSizeB;
        System.out.println("[NL BEF] Send rate is " + packetsPerSecond + " packets/s, approx " + (int)(maxMeasuredKps /= 1024.0) + " k/s");
        Object object = this.LOCK;
        synchronized (object) {
            boolean increase;
            double desiredKPS = maxMeasuredKps * 0.75;
            boolean bl = increase = maxMeasuredKps > this.limitKPS;
            this.limitKPS = increase ? (Switches.SH_1555_nlBefAdjustUp100 ? desiredKPS : this.limitKPS * 0.30000000000000004 + desiredKPS * 0.7) : this.limitKPS * 0.7 + desiredKPS * 0.3;
            System.out.println("[NL BEF] New send rate is " + (int)this.limitKPS + " k/s (max " + (int)maxMeasuredKps + " k/s)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rttMeasured(long rtt) {
        Object object = this.LOCK;
        synchronized (object) {
            if (NodeLink.FIX_SYSTEM_CLOCK_CHANGES) {
                if (rtt < 0L) {
                    System.out.println("[NL BEF] System clock changed produced erroneous RTT, ignoring");
                    return 30000L;
                }
                if (rtt > 30000L) {
                    System.out.println("[NL BEF] System clock changed produced erroneous RTT, ignoring");
                    return 30000L;
                }
            }
            this.lastRTTraw = rtt;
            this.lastRTTsmooth = this.lastRTTsmooth * 0.9 + (double)this.lastRTTraw * 0.1;
            this.burstForMs = (int)this.bounded(this.minBurstMs, this.lastRTTsmooth / 5.0, 150.0);
            if (Switches.SH_1555_nlBefLongerAdjustPeriods) {
                ADJUST_EVERY_MS = 2500;
            }
        }
        return (long)this.lastRTTsmooth;
    }

    private double bounded(double min, double val, double max) {
        return Math.max(min, Math.min(max, val));
    }

    @Override
    public int getMaxDataPerWrite() {
        return 999999;
    }

    public void setFlexibleFlowRate() {
    }

    @Override
    public void setInitialRateKbPerSec(int kbPerSec) {
        if (kbPerSec > 0 && (double)kbPerSec > this.limitKPS) {
            this.limitKPS = kbPerSec;
        }
    }

    public void resetRateKbPerSec(int kbPerSec) {
        if (kbPerSec > 0) {
            this.limitKPS = kbPerSec;
        }
    }

    @Override
    public double getRateKbPerSec() {
        return this.limitKPS;
    }

    public void setLowLatencyRequired(boolean b) {
    }

    public void setFixedFlowRate(double kbps) {
    }

    @Override
    public void packetLossDetected(long start, long probableHoleSize) {
    }

    @Override
    public void packetLossDuringResendDetected(long start, long probableHoleSize) {
    }

    @Override
    public void writeWasRestricted() {
    }

    @Override
    public void packetSent(long time) {
    }

    @Override
    public void ackReceived(long time) {
    }
}

