/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink;

import com.aem.nodelink.ConnectionTrace;
import com.aem.nodelink.Endpoint;
import com.aem.nodelink.HighPacketLossException;
import com.aem.nodelink.HoleyBigBuffer;
import com.aem.nodelink.InfiniteLoop;
import com.aem.nodelink.NoResponseException;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLinkBEFController;
import com.aem.nodelink.NodeLinkBEFController2;
import com.aem.nodelink.NodeLinkBEFController3;
import com.aem.nodelink.NodeLinkConversation;
import com.aem.nodelink.NodeLinkFlowController;
import com.aem.nodelink.NodeLinkLatencyLossController;
import com.aem.nodelink.NodeLinkStats;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.NodeOutOfBandListener;
import com.aem.nodelink.NodelinkOutOfBandListener;
import com.aem.nodelink.OrphanPacketListener;
import com.aem.nodelink.QuietListener;
import com.aem.nodelink.QuietManager;
import com.aem.nodelink.Transport;
import com.aem.nodelink.TransportStatusListener;
import com.aem.nodelink.fec.ParityReader;
import com.aem.nodelink.fec.ParityWriter;
import com.aem.nodelink.fec.ShardDataTooLongException;
import com.aem.nodelink.utils.BlockingObjectInputStream;
import com.aem.nodelink.utils.ByteArrayUtils;
import com.aem.nodelink.utils.Cache;
import com.aem.nodelink.utils.ContinuousByteOutputStream;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.ForwardCheck;
import com.aem.nodelink.utils.HeadlessByteVisualiserInterface;
import com.aem.nodelink.utils.HistoryBuffer;
import com.aem.nodelink.utils.SafeClock;
import com.aem.nodelink.utils.UnqueuedSemaphore;
import com.aem.nodelink.vis.NLInfoFeed;
import com.aem.nodelink.vis.NLOptimisationFeed;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import utils.progtools.OnDemandThreadPool;
import utils.stream.FixedBandwidthLimiter;
import utils.switches.Switches;

public class NodeLink
implements TransportStatusListener,
NodeOutOfBandListener {
    public static NLInfoFeed INFO_FEED = null;
    public static int KEEPALIVE_WRITE_EVERY = 1500;
    public static int FYI_WRITE_EVERY = 500;
    public static int FLOW_RTT_ECHO_WRITE_EVERY = 750;
    public static final boolean VERBOSE_BEF_FLOWRATE = true;
    public static final boolean VERBOSE_BEF_READRATES = true;
    public static final boolean VERBOSE_HOLE_FILLING = false;
    public static final boolean VERBOSE_PACKET_OVERHEAD = false;
    public static final boolean VERBOSE_CONVERSATION = false;
    public static final boolean VERBOSE_WRITE_RESTRICTOR_CHOKING = true;
    public static final boolean VERBOSE_UITHREAD = false;
    public static final boolean VERBOSE_WRITE_TRACING = false;
    public static final boolean VERBOSE_STOP = false;
    boolean SILENT_CLOSE = false;
    public static boolean DISABLE_NAGLE = true;
    public static boolean USE_HISTORY_BUFFER = true;
    public static boolean USE_BANDWIDTH_EDGE_FINDING = true;
    public static boolean VERBOSE_POSTFIX_ID = true;
    public static boolean VERBOSE_NL_CREATION = true;
    public static final boolean DUMP_ALL_DATA_TO_BYTE_VISUALISER = false;
    public static boolean VERBOSE_PACKET_SEND_RESEND = false;
    public static boolean VERBOSE_PACKET_SEND_NORMAL = false;
    public static boolean VERBOSE_PACKET_READ = false;
    public static boolean VERBOSE_HOLEY_BIG_BUFFER = false;
    public static boolean VERBOSE_OOOP = false;
    public static boolean VERBOSE_RESEND = false;
    public static boolean VERBOSE_PG_MANAGEMENT = false;
    public static boolean VERBOSE_FLOW_RATE = true;
    public static boolean VERBOSE_RTT = false;
    public static boolean VERBOSE_ACKS = false;
    public static boolean VERBOSE_BUFFERS = true;
    public static boolean VERBOSE_KEEPALIVE = false;
    public static boolean VERBOSE_CLOCK_SKEW = false;
    public static boolean VERBOSE_UNACKED_HISTORY = false;
    public static boolean VERBOSE_SOCKETS = false;
    public static boolean VERBOSE_FYI = false;
    public static int PACKET_LOSS_DEBUG_TIME_SECS = 0;
    public static boolean PACKET_LOSS_SIMULATE_FAILURE = false;
    public static boolean FIX_SYSTEM_CLOCK_CHANGES = true;
    private boolean suppressErrorPrintouts = false;
    ParityReader parr = new ParityReader();
    ParityWriter parw = new ParityWriter();
    public static int DEFAULT_MAX_UNACKED_DATA;
    public static int MAX_DATA_PER_WRITE_LIMIT;
    public static int DEFAULT_MAX_DATA_PER_WRITE;
    public static int DEFAULT_BUFFER_SIZE;
    public static int DEFAULT_MAX_FLOW_CONTROLLED_PACKET_SIZE;
    public static int DEFAULT_INITIAL_TIMEOUT;
    public static int DEFAULT_RECONNECT_TIMEOUT;
    public static int DEFAULT_ERROR_TIMEOUT;
    public static int INFINITE_TIMEOUT;
    public static long INFINITE_RECONNECT_TIMEOUT;
    public static int NEW_CHANNEL_GROUP;
    private static final OrphanPacketListener ORPHANS;
    private static final int PROTOCOL_VERSION = 5;
    private static final long FINISHED = -1111111111L;
    private static final short RTT_ECHO = 22391;
    private static final short ACK_DATA = 17476;
    private static final short READ_RATE = 17477;
    static final short MEASURE_READ_RATE = 17478;
    private static final int OK_READY = 50674385;
    boolean reconnecting = false;
    boolean gracefullyTerminated = false;
    Node me;
    Node target;
    Object write_LOCK = new Object();
    Object history_LOCK = new Object();
    NodeLinkConversation conversation;
    NodeLinkConversation conversationKeepalive;
    NodeLinkConversation conversationAck;
    NodeLinkConversation conversationResend;
    long timeoutInitial = DEFAULT_INITIAL_TIMEOUT;
    long timeout = DEFAULT_RECONNECT_TIMEOUT;
    int retriesBeforeTimeout = 5;
    int maxDataPerWrite = DEFAULT_MAX_DATA_PER_WRITE;
    int maxUnackedData = DEFAULT_MAX_UNACKED_DATA;
    int bufferSize = DEFAULT_BUFFER_SIZE;
    int unackedSpace = this.maxUnackedData;
    private UnqueuedSemaphore writeRestrictor = new UnqueuedSemaphore(this.maxUnackedData);
    long written = 0L;
    long writtenAcked = 0L;
    long writtenValid = 0L;
    long historyAcked = 0L;
    long received = 0L;
    long receivedValid = 0L;
    long lastAck = 0L;
    Object resend_WAIT = new Object();
    Object normal_WAIT = new Object();
    HistoryBuffer histy = new HistoryBuffer();
    HistoryBuffer.HistoryInputStream resendFirst = null;
    private HoleyBigBuffer bufin;
    private ContinuousByteOutputStream bufout = new ContinuousByteOutputStream(DEFAULT_BUFFER_SIZE);
    private FixedBandwidthLimiter fbl = new FixedBandwidthLimiter();
    private NodeLinkFlowController benchedFlow;
    private NodeLinkFlowController flow;
    NodeLinkStats stats = new NodeLinkStats();
    String postfixMain = "NL" + System.currentTimeMillis() % 1000000L;
    String postfix = this.postfixMain + " <>";
    String purename = "unnamed";
    Object dead_LOCK = new Object();
    boolean dead = false;
    boolean amclient = false;
    BlockingObjectInputStream acks = new BlockingObjectInputStream();
    BlockingObjectInputStream infos = new BlockingObjectInputStream();
    BlockingObjectInputStream resends = new BlockingObjectInputStream();
    long clock_skew = 0L;
    byte[] empty_packet = new byte[8];
    int REMOTE_PROTOCOL_VERSION = 5;
    public static int MACHID;
    static Object keys_LOCK;
    static int keys;
    static int trkeys;
    NodeLink terminateInTandem;
    Object flowChange_LOCK = new Object();
    int packet_loss_time = 15000;
    int packet_loss_packets_per_sec = 10;
    Object ooblisteners_LOCK = new Object();
    ArrayList ooblisteners = new ArrayList();
    double bwTotalBytes = 0.0;
    long bwLastPeriodStart = SafeClock.currentTimeMillis();
    double bwValidSize = 50000.0;
    double bwMaxKBpsProxied = 0.0;
    double bwMaxKBpsDirect = 0.0;
    PacketWriter pw;
    PacketReader pr;
    KeepaliveReader kr;
    KeepaliveWriter kw;
    AckReader ar;
    AckWriter aw;
    ResendReader rr;
    ResendWriter rw;
    PacketResender rp;
    boolean requestResend = false;
    Object linkstatus_LOCK = new Object();
    boolean linkOK = true;
    long linkLastDown = 0L;
    ArrayList linkListeners = new ArrayList();
    boolean amResending = false;
    long blockAllSendsUntilAckedBeyond = -1L;
    long latestRTT = 100L;
    Object rtt_LOCK = new Object();
    long lastRTTsmooth = -1L;
    long count = 0L;
    long lastDataWritten = System.currentTimeMillis();
    HeadlessByteVisualiserInterface hbv;
    private static String STOP_GRACEFUL;
    private static String STOP_FAILURE;
    static OnDemandThreadPool terms;

    public void setOptimisationFeed(NLOptimisationFeed feed) {
        try {
            if (this.isUsingFlowControl()) {
                this.bufin.setOptimisationFeed(feed);
                feed.resetOptimisation();
            } else {
                feed.receivingFreshData();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void setDebugPacketLoss(int secs) {
        PACKET_LOSS_DEBUG_TIME_SECS = secs;
    }

    public static void setMaxUnacknowlegedDataHalf(int bytes) {
        if (bytes < 512) {
            bytes = 512;
        }
        System.out.println("[NodeLink] Set max unacked data half " + bytes);
        DEFAULT_MAX_UNACKED_DATA = bytes;
        System.out.println("[NodeLink] Max unacked data " + bytes);
        DEFAULT_MAX_DATA_PER_WRITE = Math.min(bytes / 5, MAX_DATA_PER_WRITE_LIMIT);
        System.out.println("[NodeLink] Max data per write " + DEFAULT_MAX_DATA_PER_WRITE + " (limit=" + MAX_DATA_PER_WRITE_LIMIT + ")");
    }

    long getReconnectTimeoutMs() {
        return this.timeout;
    }

    long getTimeSinceIncomingData() {
        long max1 = Math.max(QuietManager.get().lastSeen(this.conversation), QuietManager.get().lastSeen(this.conversationKeepalive));
        long max2 = Math.max(QuietManager.get().lastSeen(this.conversationAck), QuietManager.get().lastSeen(this.conversationResend));
        long max = Math.max(max1, max2);
        return SafeClock.currentTimeMillis() - max;
    }

    private void resetWithQuietManager() {
        QuietManager.get().resetSeen(this.conversation);
        QuietManager.get().resetSeen(this.conversationKeepalive);
        QuietManager.get().resetSeen(this.conversationAck);
        QuietManager.get().resetSeen(this.conversationResend);
    }

    public void removeFromQuietManager() {
        QuietManager.get().clearSeen(this.conversation);
        QuietManager.get().clearSeen(this.conversationKeepalive);
        QuietManager.get().clearSeen(this.conversationAck);
        QuietManager.get().clearSeen(this.conversationResend);
    }

    public void clearReadRate() {
        this.bufin.clearMaxReadRate();
    }

    public NodeLinkStats getStats() {
        this.stats.sent = this.written;
        this.stats.received = this.received;
        this.stats.currentTime = System.currentTimeMillis();
        if (this.bufin != null) {
            this.stats.maxReadRateKB = this.bufin.getMaxReadRate();
        }
        return this.stats;
    }

    private void recreateBuffersFromRemoteSpecification() {
        if (VERBOSE_BUFFERS) {
            System.out.println("[NodeLink] Recreating buffers from remote spec [mxua=" + DEFAULT_MAX_UNACKED_DATA + "] mxwr=" + DEFAULT_MAX_DATA_PER_WRITE + " bfsz=" + DEFAULT_BUFFER_SIZE);
        }
        this.maxDataPerWrite = DEFAULT_MAX_DATA_PER_WRITE;
        this.maxUnackedData = DEFAULT_MAX_UNACKED_DATA;
        this.bufferSize = DEFAULT_BUFFER_SIZE;
        try {
            this.bufin.setClosed();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeRestrictor = null;
        this.bufin = null;
        this.bufout = null;
        this.writeRestrictor = new UnqueuedSemaphore(this.maxUnackedData);
        this.bufin = new HoleyBigBuffer(this, this.parw.getMinPacketsToRetain(), this.bufferSize, this.postfix);
        this.bufout = new ContinuousByteOutputStream(DEFAULT_MAX_DATA_PER_WRITE);
    }

    public String getSimpleID() {
        return this.postfixMain;
    }

    public void setFriendlyName(String name) {
        String oldname = this.purename;
        this.purename = name;
        this.postfix = this.postfixMain + " <" + name + ">";
        if (VERBOSE_POSTFIX_ID) {
            if (oldname.length() == 0) {
                System.out.println("[NodeLink] NL renamed to " + this);
            } else {
                System.out.println("[NodeLink] NL " + oldname + " renamed to " + this);
            }
        }
        if (Switches.SH_1468_suppressTemporaryShellNlFailurePrintouts && (name.startsWith("EOL") || name.startsWith("Temporary"))) {
            this.suppressErrorPrintouts = true;
        }
    }

    public static int peekNextSessionKey() {
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextSessionKey() {
        Object object = keys_LOCK;
        synchronized (object) {
            int next = keys;
            if ((keys += 10) > 2000000000) {
                keys = 0;
            }
            return next;
        }
    }

    public int getConversation() {
        return this.conversation.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextTempResponseKey() {
        Object object = keys_LOCK;
        synchronized (object) {
            int next = trkeys;
            if ((trkeys += 10) > 2000000000) {
                trkeys = 0;
            }
            return next;
        }
    }

    public String getTransportInfo() {
        try {
            Transport t = this.me.getTransportForNode(this.target);
            if (t == null) {
                return "NoTransport";
            }
            if (this.isProxiedConnection()) {
                return t.getClass().getName() + " (proxied) / " + this.getHumanReadableTransportSpecificRemoteIdentifier();
            }
            return t.getClass().getName() + " / " + this.getHumanReadableTransportSpecificRemoteIdentifier();
        }
        catch (Exception x) {
            return "UnknownTransport";
        }
    }

    public String getHumanReadableTransportSpecificRemoteIdentifier() throws Exception {
        Transport t = this.me.getTransportForNode(this.target);
        String ipAddress = t.getHumanReadableTransportIdentifierFor(this.target);
        if (ipAddress != null && ipAddress.startsWith("/")) {
            ipAddress = ipAddress.substring(1);
        }
        return ipAddress;
    }

    public Node getTargetNode() {
        return this.target;
    }

    public Node getMyNode() {
        return this.me;
    }

    public void terminateInTandem(NodeLink nl) {
        if (nl == null) {
            return;
        }
        nl.terminateInTandem = this;
        this.terminateInTandem = nl;
    }

    public NodeLink getNodeLinkToTerminateInTandem() {
        return this.terminateInTandem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseFlowControl(boolean b) {
        Object object = this.flowChange_LOCK;
        synchronized (object) {
            if (b) {
                if (this.flow == null) {
                    this.flow = this.benchedFlow;
                    this.benchedFlow = null;
                }
            } else if (this.flow != null) {
                this.benchedFlow = this.flow;
                this.flow = null;
            }
        }
    }

    public boolean isUsingFlowControl() {
        return this.flow != null;
    }

    public void setLowLatencyRequired(boolean b) {
    }

    public double getCurrentFlowRateKB() {
        return this.flow.getRateKbPerSec();
    }

    public void setFlexibleBandwidth() {
    }

    public void setFixedBandwidth(double kbps) {
    }

    public boolean replaceTransportWithTransportFrom(NodeLink nl, InputStream tin, OutputStream tout, int fwdID, boolean useFlowControl) {
        this.me.setOrphanPacketListener(null);
        nl.getMyNode().setOrphanPacketListener(null);
        try {
            boolean success;
            System.out.println("[NL Transport Replace] Synchronising...");
            System.out.println("[NL Transport Replace] NL to keep is " + this);
            System.out.println("[NL Transport Replace] Pulling transport into " + this + " from " + nl);
            System.out.println("[NL Transport Replace] Initial Sync");
            DataUtils.writeInt(tout, 0);
            tout.flush();
            DataUtils.readInt(tin);
            try {
                System.out.println("[NL Transport Replace] Replacing transport");
                if (Switches.SH_1468_nlQuietManagerDisableOnSwitch) {
                    System.out.println("[NL Transport Replace] Disabling QuietManager temporarily");
                    QuietManager.disableGloballyFor(45000L);
                } else {
                    System.out.println("[NL Transport Replace] Leaving QuietManager live during switch");
                }
                Node copyhome = nl.getMyNode();
                Node copytarget = nl.getTargetNode();
                System.out.println("[NL Transport Replace] Clearing");
                try {
                    nl.clearNodeAndStop("closing shell to replace transport with " + nl.getTransportInfo());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (Switches.SH_1468_nlQuietManagerDisableOnSwitch) {
                    System.out.println("[NL Transport Replace] Disabling QuietManager temporarily");
                    QuietManager.disableGloballyFor(120000L);
                }
                copyhome.waitUntilNoPacketsFor(600, null, 120000L);
                DataUtils.writeInt(tout, 0);
                tout.flush();
                DataUtils.readInt(tin);
                System.out.println("[NL Transport Replace] Pre Switch Sync");
                this.setUseFlowControl(useFlowControl);
                if (useFlowControl) {
                    this.setLowLatencyRequired(true);
                }
                this.getMyNode().swapTransportForNode(this.getTargetNode(), copyhome, copytarget, fwdID);
                System.out.println("[NL Transport Replace] Post Switch");
                System.out.println("[NL Transport Replace] Replaced, shutting down old");
                this.stats = nl.stats;
                if (Switches.SH_1468_clearOldNlStatsOnTransportSwitch) {
                    nl.stats = new NodeLinkStats();
                }
                if (Switches.SH_1468_suppressTemporaryShellNlFailurePrintouts) {
                    nl.suppressErrorPrintouts = true;
                }
                if (Switches.SH_1468_nlQuietManagerDisableOnSwitch) {
                    System.out.println("[NL Transport Replace] Reinstating QuietManager soon");
                    QuietManager.disableGloballyFor(45000L);
                }
                success = true;
            }
            catch (Exception x) {
                x.printStackTrace();
                success = false;
            }
            System.out.println("[NL Transport Replace] Resynchronising...");
            DataUtils.writeInt(tout, 1);
            tout.flush();
            DataUtils.readInt(tin);
            System.out.println("[NL Transport Replace] Done (" + (success ? "Successful" : "Failed") + ")");
            this.me.setOrphanPacketListener(ORPHANS);
            return success;
        }
        catch (IOException x) {
            x.printStackTrace();
            this.me.setOrphanPacketListener(ORPHANS);
            return false;
        }
    }

    private NodeLinkFlowController createFlowController() {
        if (Switches.SH_nlBefUseHighGranularityLimiter) {
            return new NodeLinkBEFController3();
        }
        if (Switches.SH_nlBefUseImprovedGranularityLimiter) {
            return new NodeLinkBEFController2();
        }
        if (USE_BANDWIDTH_EDGE_FINDING) {
            return new NodeLinkBEFController();
        }
        return new NodeLinkLatencyLossController();
    }

    public NodeLink(Node home, Node remote) throws Exception {
        this(home, remote, false, false);
    }

    public NodeLink(Node home, Node remote, boolean flowControlled, boolean verifyConnection) throws Exception {
        this(home, remote, NEW_CHANNEL_GROUP, DEFAULT_INITIAL_TIMEOUT, DEFAULT_RECONNECT_TIMEOUT, flowControlled, verifyConnection);
    }

    public NodeLink(Node home, Node remote, int initialTimeout, long reconnectTimeout) throws Exception {
        this(home, remote, initialTimeout, reconnectTimeout, false, false);
    }

    public NodeLink(Node home, Node remote, int initialTimeout, long reconnectTimeout, boolean flowControlled, boolean verifyConnection) throws Exception {
        this(home, remote, NEW_CHANNEL_GROUP, initialTimeout, reconnectTimeout, flowControlled, verifyConnection);
    }

    public NodeLink(Node home, Node remote, int initialTimeout, long reconnectTimeout, boolean flowControlled, boolean verifyConnection, boolean sendContinuousConnectRequest) throws Exception {
        this(home, remote, NEW_CHANNEL_GROUP, initialTimeout, reconnectTimeout, flowControlled, verifyConnection, sendContinuousConnectRequest);
    }

    public NodeLink(Node home, Node remote, int generalGroup, int initialTimeout, long reconnectTimeout) throws Exception {
        this(home, remote, generalGroup, initialTimeout, reconnectTimeout, false, false);
    }

    public NodeLink(Node home, Node remote, int generalGroup, int initialTimeout, long reconnectTimeout, boolean flowControlled, boolean verifyConnection) throws Exception {
        this(home, remote, generalGroup, initialTimeout, reconnectTimeout, flowControlled, verifyConnection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeLink(Node home, Node remote, int generalGroup, int initialTimeout, long reconnectTimeout, boolean flowControlled, boolean verifyConnection, boolean sendContinuousConnectRequest) throws Exception {
        byte[] p;
        NodeLinkConversation tempConversation;
        if (VERBOSE_POSTFIX_ID) {
            System.out.println("[NodeLink] new connection " + this.postfix);
        }
        if (VERBOSE_NL_CREATION) {
            new Exception("[NodeLink] new connection " + this.postfix).printStackTrace();
        }
        home.setNoRetryOnBrokenTransport(false);
        this.flow = this.createFlowController();
        this.setUseFlowControl(flowControlled);
        this.bufin = new HoleyBigBuffer(this, this.parw.getMinPacketsToRetain(), DEFAULT_BUFFER_SIZE, this.postfix);
        this.timeoutInitial = initialTimeout;
        this.timeout = reconnectTimeout;
        this.amclient = true;
        this.me = home;
        this.me.setOrphanPacketListener(ORPHANS);
        this.conversation = tempConversation = new NodeLinkConversation(NodeLink.nextTempResponseKey());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataUtils.writeString(bout, home.getUID());
        DataUtils.writeInt(bout, tempConversation.key);
        DataUtils.writeInt(bout, 5);
        DataUtils.writeLong(bout, System.currentTimeMillis());
        this.me.setConversationOpen(tempConversation);
        NodeLinkConversation GROUP_NEW_CONV = new NodeLinkConversation(generalGroup);
        ContinuousConnectThread cct = null;
        if (sendContinuousConnectRequest) {
            cct = new ContinuousConnectThread(bout, remote, GROUP_NEW_CONV);
            cct.start();
        } else {
            home.sendToSpecific(bout.toByteArray(), remote, GROUP_NEW_CONV, this.timeoutInitial);
        }
        try {
            p = home.nextPacketFromSpecific(tempConversation, this.timeoutInitial, null);
        }
        finally {
            if (sendContinuousConnectRequest) {
                cct.die();
            }
        }
        if (p == null) {
            try {
                this.bufin.setClosed();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                home.setConversationClosed(tempConversation);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new NoResponseException("No one is responding");
        }
        if (p.length == 0) {
            this.REMOTE_PROTOCOL_VERSION = 1;
            this.clock_skew = 0L;
        } else {
            ByteArrayInputStream bin = new ByteArrayInputStream(p);
            this.REMOTE_PROTOCOL_VERSION = DataUtils.readInt(bin);
            this.setRemoteClock(DataUtils.readLong(bin));
            if (this.REMOTE_PROTOCOL_VERSION >= 3) {
                DEFAULT_MAX_UNACKED_DATA = DataUtils.readInt(bin);
                DataUtils.readInt(bin);
                DEFAULT_MAX_DATA_PER_WRITE = DataUtils.readInt(bin);
                DEFAULT_BUFFER_SIZE = DataUtils.readInt(bin);
                this.recreateBuffersFromRemoteSpecification();
                this.conversation = new NodeLinkConversation(DataUtils.readInt(bin));
                this.conversationKeepalive = new NodeLinkConversation(DataUtils.readInt(bin));
                this.conversationAck = new NodeLinkConversation(DataUtils.readInt(bin));
                this.conversationResend = new NodeLinkConversation(DataUtils.readInt(bin));
                home.setConversationOpen(this.conversation);
                home.setConversationOpen(this.conversationKeepalive);
                home.setConversationOpen(this.conversationAck);
                home.setConversationOpen(this.conversationResend);
                byte[] b = new byte[4];
                ByteArrayUtils.writeInt(b, 0, 50674385);
                if (flowControlled) {
                    home.sendToSpecific(b, remote, tempConversation, this.timeoutInitial);
                    Thread.sleep(150L);
                    home.sendToSpecific(b, remote, tempConversation, this.timeoutInitial);
                    Thread.sleep(150L);
                    home.sendToSpecific(b, remote, tempConversation, this.timeoutInitial);
                    Thread.sleep(150L);
                    home.sendToSpecific(b, remote, tempConversation, this.timeoutInitial);
                } else {
                    home.sendToSpecific(b, remote, tempConversation, this.timeoutInitial);
                }
            }
        }
        home.setConversationClosed(tempConversation);
        this.target = remote;
        if (flowControlled) {
            if (verifyConnection) {
                this.checkPacketLoss();
            }
            if (Switches.SH_estimateUdpBandwidthOnConnect) {
                int rate = this.estimateUdpBandwidth();
                this.flow.setInitialRateKbPerSec(rate);
            }
        }
        this.stats.sessionStarted = System.currentTimeMillis();
        this.startStreams();
    }

    private int estimateUdpBandwidth() throws Exception {
        PacketRateTestThread prt = new PacketRateTestThread();
        prt.start();
        byte[] dat = new byte[DEFAULT_MAX_FLOW_CONTROLLED_PACKET_SIZE];
        ByteArrayUtils.writeInt(dat, 0, 22);
        for (int i = 0; i < 10; ++i) {
            for (int p = 0; p < 50; ++p) {
                this.me.sendToSpecific(dat, this.target, this.conversation, 1L);
            }
            Thread.sleep(25L);
        }
        Thread.sleep(300L);
        ByteArrayUtils.writeInt(dat, 0, 33);
        this.me.sendToSpecific(dat, this.target, this.conversation, 1L);
        prt.join();
        return prt.kbsec;
    }

    private void checkPacketLoss() throws Exception {
        System.out.println("[NodeLink] Checking packet loss on UDP connection");
        if (PACKET_LOSS_DEBUG_TIME_SECS != 0) {
            this.packet_loss_time = PACKET_LOSS_DEBUG_TIME_SECS * 1000;
        }
        int packet_loss_packets = this.packet_loss_time / 1000 * this.packet_loss_packets_per_sec;
        System.out.println("[NodeLink] Checking packet loss, will run for " + this.packet_loss_time + "ms, covering " + packet_loss_packets + " packets");
        byte[] dat = new byte[5];
        int packets = packet_loss_packets;
        long total_T = this.packet_loss_time;
        long packet_T = total_T / (long)packets;
        PacketLossTestThread plt = new PacketLossTestThread(packet_loss_packets);
        plt.start();
        for (int i = 0; i < packets; ++i) {
            ByteArrayUtils.writeInt(dat, 0, i);
            this.me.sendToSpecific(dat, this.target, this.conversation, 1L);
            if (PACKET_LOSS_SIMULATE_FAILURE) break;
            try {
                Thread.sleep(packet_T);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        plt.join();
        if (plt.received < packet_loss_packets / 2) {
            throw new HighPacketLossException("[NodeLink] Too much packet loss in network connection (likely firewall blocking)");
        }
    }

    public NodeLink(Node home) throws Exception {
        this(home, false, false);
    }

    public NodeLink(Node home, boolean flowControlled, boolean verifyConnection) throws Exception {
        this(home, NEW_CHANNEL_GROUP, DEFAULT_INITIAL_TIMEOUT, (long)DEFAULT_RECONNECT_TIMEOUT, flowControlled, verifyConnection);
    }

    public NodeLink(Node home, int initialTimeout, long reconnectTimeout) throws Exception {
        this(home, initialTimeout, reconnectTimeout, false, false);
    }

    public NodeLink(Node home, int initialTimeout, long reconnectTimeout, boolean flowControlled, boolean verifyConnection) throws Exception {
        this(home, NEW_CHANNEL_GROUP, initialTimeout, reconnectTimeout, flowControlled, verifyConnection);
    }

    public NodeLink(Node home, int generalGroup, int initialTimeout, long reconnectTimeout, boolean flowControlled, boolean verifyConnection) throws Exception {
        home.setNoRetryOnBrokenTransport(false);
        this.flow = this.createFlowController();
        this.setUseFlowControl(flowControlled);
        this.timeoutInitial = initialTimeout;
        this.timeout = reconnectTimeout;
        this.me = home;
        this.me.setOrphanPacketListener(ORPHANS);
        byte[] p = home.nextSinglePacketFromSpecific(new NodeLinkConversation(generalGroup), this.timeoutInitial, this.timeoutInitial + 5000L, null);
        if (p == null) {
            throw new NoResponseException("No one is responding");
        }
        this.bufin = new HoleyBigBuffer(this, this.parw.getMinPacketsToRetain(), DEFAULT_BUFFER_SIZE, this.postfix);
        if (VERBOSE_POSTFIX_ID) {
            System.out.println("[NodeLink] new connection " + this.postfix);
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(p);
        this.target = new Node(DataUtils.readNString(bin, 100000));
        System.out.println("[NodeLink] NL Server response target is " + this.target);
        NodeLinkConversation respondOnConversation = new NodeLinkConversation(DataUtils.readInt(bin));
        this.REMOTE_PROTOCOL_VERSION = DataUtils.readInt(bin);
        if (this.REMOTE_PROTOCOL_VERSION >= 2) {
            this.setRemoteClock(DataUtils.readLong(bin));
        }
        this.conversation = new NodeLinkConversation(NodeLink.nextSessionKey());
        this.conversationKeepalive = new NodeLinkConversation(this.conversation.key + 1);
        this.conversationAck = new NodeLinkConversation(this.conversation.key + 2);
        this.conversationResend = new NodeLinkConversation(this.conversation.key + 3);
        this.me.setConversationOpen(this.conversation);
        this.me.setConversationOpen(this.conversationKeepalive);
        this.me.setConversationOpen(this.conversationAck);
        this.me.setConversationOpen(this.conversationResend);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataUtils.writeInt(bout, 5);
        DataUtils.writeLong(bout, System.currentTimeMillis());
        DataUtils.writeInt(bout, DEFAULT_MAX_UNACKED_DATA);
        DataUtils.writeInt(bout, -1);
        DataUtils.writeInt(bout, DEFAULT_MAX_DATA_PER_WRITE);
        DataUtils.writeInt(bout, DEFAULT_BUFFER_SIZE);
        DataUtils.writeInt(bout, this.conversation.key);
        DataUtils.writeInt(bout, this.conversationKeepalive.key);
        DataUtils.writeInt(bout, this.conversationAck.key);
        DataUtils.writeInt(bout, this.conversationResend.key);
        this.me.setConversationOpen(respondOnConversation, System.currentTimeMillis() + 15000L);
        if (flowControlled) {
            this.me.sendToSpecific(bout.toByteArray(), this.target, respondOnConversation, this.timeoutInitial == (long)INFINITE_TIMEOUT ? (long)DEFAULT_INITIAL_TIMEOUT : this.timeoutInitial);
            Thread.sleep(150L);
            this.me.sendToSpecific(bout.toByteArray(), this.target, respondOnConversation, this.timeoutInitial == (long)INFINITE_TIMEOUT ? (long)DEFAULT_INITIAL_TIMEOUT : this.timeoutInitial);
            Thread.sleep(150L);
            this.me.sendToSpecific(bout.toByteArray(), this.target, respondOnConversation, this.timeoutInitial == (long)INFINITE_TIMEOUT ? (long)DEFAULT_INITIAL_TIMEOUT : this.timeoutInitial);
            Thread.sleep(150L);
            this.me.sendToSpecific(bout.toByteArray(), this.target, respondOnConversation, this.timeoutInitial == (long)INFINITE_TIMEOUT ? (long)DEFAULT_INITIAL_TIMEOUT : this.timeoutInitial);
        } else {
            this.me.sendToSpecific(bout.toByteArray(), this.target, respondOnConversation, this.timeoutInitial == (long)INFINITE_TIMEOUT ? (long)DEFAULT_INITIAL_TIMEOUT : this.timeoutInitial);
        }
        this.me.nextPacketFromSpecific(respondOnConversation, this.timeoutInitial == (long)INFINITE_TIMEOUT ? (long)DEFAULT_INITIAL_TIMEOUT : this.timeoutInitial, null);
        this.me.setConversationClosed(respondOnConversation);
        if (flowControlled) {
            if (verifyConnection) {
                this.checkPacketLoss();
            }
            if (Switches.SH_estimateUdpBandwidthOnConnect) {
                int rate = this.estimateUdpBandwidth();
                this.flow.setInitialRateKbPerSec(rate);
            }
        }
        this.stats.sessionStarted = System.currentTimeMillis();
        this.startStreams();
    }

    private void setRemoteClock(long theirtime) {
        this.clock_skew = System.currentTimeMillis() - theirtime;
        if (VERBOSE_CLOCK_SKEW) {
            System.out.println("Clock skew is " + this.clock_skew + "ms");
        }
    }

    private byte[] getTimeBytes(long t) {
        byte[] nowdat = new byte[8];
        ByteArrayUtils.writeLong(nowdat, 0, t);
        return nowdat;
    }

    private String[] getStandardOobNames() {
        return this.getStandardOobNames(null);
    }

    private String[] getStandardOobNames(String[] oobs) {
        return oobs;
    }

    private byte[][] getStandardOobDatas() {
        return this.getStandardOobDatas(null);
    }

    private byte[][] getStandardOobDatas(byte[][] oobs) {
        return oobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutOfBandListener(NodelinkOutOfBandListener l) {
        Object object = this.ooblisteners_LOCK;
        synchronized (object) {
            this.ooblisteners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutOfBandListener(NodelinkOutOfBandListener l) {
        Object object = this.ooblisteners_LOCK;
        synchronized (object) {
            this.ooblisteners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outOfBandData(String key, byte[] data) {
        Object object = this.ooblisteners_LOCK;
        synchronized (object) {
            try {
                for (int i = 0; i < this.ooblisteners.size(); ++i) {
                    NodelinkOutOfBandListener listener = (NodelinkOutOfBandListener)this.ooblisteners.get(i);
                    listener.outOfBandData(key, data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendOutOfBandData_UnecryptedAsync(String name, byte[] data) throws Exception {
        try {
            this.me.sendToSpecific(null, this.target, this.conversation, this.timeout / (long)this.retriesBeforeTimeout, this, this.getStandardOobNames(new String[]{name}), this.getStandardOobDatas(new byte[][]{data}));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendOutOfBandData_Unecrypted(String name, byte[] data) throws Exception {
        if (this.REMOTE_PROTOCOL_VERSION >= 2) {
            InfiniteLoop il2 = new InfiniteLoop();
            while (!this.dead) {
                il2.LOOP();
                try {
                    this.me.sendToSpecific(null, this.target, this.conversation, this.timeout / (long)this.retriesBeforeTimeout, this, this.getStandardOobNames(new String[]{name}), this.getStandardOobDatas(new byte[][]{data}));
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
    }

    public InputStream getInputStream() {
        return this.bufin;
    }

    public OutputStream getOutputStream() {
        return this.bufout;
    }

    public void setBandwidthLimit(int kbPerSec) {
        this.fbl.setKBsec(kbPerSec);
    }

    public void setInitialRateKbPerSec(int kbPerSec) {
        System.out.println("[NodeLink] Initial rate set to greater of " + kbPerSec);
        if (this.flow != null) {
            this.flow.setInitialRateKbPerSec(kbPerSec);
        }
    }

    private void trackBandwidth(int bytesRead) {
        this.bwTotalBytes += (double)bytesRead;
        if (this.bwTotalBytes > this.bwValidSize) {
            long now = SafeClock.currentTimeMillis();
            double secs = (double)(now - this.bwLastPeriodStart) / 1000.0;
            if (secs >= 0.005) {
                double KBps = this.bwTotalBytes / 1024.0 / secs;
                if (this.isUsingFlowControl()) {
                    if (KBps > this.bwMaxKBpsDirect) {
                        this.bwMaxKBpsDirect = KBps;
                        System.out.println("NL connection max KBPS (direct) is now " + this.bwMaxKBpsDirect + " (" + secs + "s)");
                    }
                } else if (KBps > this.bwMaxKBpsProxied) {
                    this.bwMaxKBpsProxied = KBps;
                    System.out.println("NL connection max KBPS (proxied) is now " + this.bwMaxKBpsProxied + " (" + secs + "s)");
                }
            }
            this.bwTotalBytes = 0.0;
            this.bwLastPeriodStart = now;
        }
    }

    public int getMaxReadRateProxiedKBps() {
        return (int)this.bwMaxKBpsProxied;
    }

    public int getMaxReadRateDirectKBps() {
        return (int)this.bwMaxKBpsDirect;
    }

    private void startStreams() {
        this.pr = new PacketReader(this.postfix);
        this.pr.setPriority(10);
        this.pr.start();
        this.pw = new PacketWriter(this.postfix);
        this.pw.setPriority(10);
        this.pw.start();
        this.kr = new KeepaliveReader(this.postfix);
        this.kr.setPriority(10);
        this.kr.start();
        this.kw = new KeepaliveWriter(this.postfix);
        this.kw.setPriority(10);
        this.kw.start();
        this.ar = new AckReader(this.postfix);
        this.ar.setPriority(10);
        this.ar.start();
        this.aw = new AckWriter(this.postfix);
        this.aw.setPriority(10);
        this.aw.start();
        this.rr = new ResendReader(this.postfix);
        this.rr.setPriority(10);
        this.rr.start();
        this.rw = new ResendWriter(this.postfix);
        this.rw.setPriority(10);
        this.rw.start();
        this.rp = new PacketResender(this.postfix);
        this.rp.setPriority(10);
        this.rp.start();
        if (Switches.SH_1468_nlUseQuietManager) {
            QuietManager.get().seen(this.conversation);
            QuietManager.get().seen(this.conversationKeepalive);
            QuietManager.get().seen(this.conversationResend);
            QuietManager.get().seen(this.conversationAck);
            QuietManager.get().registerNodeLink(this);
        } else {
            QuietListener.get().registerNodeLink(this, this.me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllLinkStatusListenersFrom(NodeLink nl) {
        ArrayList copy = new ArrayList();
        Object object = nl.linkstatus_LOCK;
        synchronized (object) {
            copy.addAll(nl.linkListeners);
        }
        object = this.linkstatus_LOCK;
        synchronized (object) {
            for (int i = 0; i < copy.size(); ++i) {
                NodeLinkStatusListener listener = (NodeLinkStatusListener)copy.get(i);
                if (this.linkListeners.contains(listener)) continue;
                this.linkListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinkStatusListener(NodeLinkStatusListener l) {
        Object object = this.linkstatus_LOCK;
        synchronized (object) {
            this.linkListeners.add(l);
            try {
                if (this.dead) {
                    l.linkDead(this, "Setting initial status");
                } else if (this.linkOK) {
                    l.linkOK(this);
                } else {
                    l.linkDown(this, new Throwable("Setting initial status"));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllLinkStatusListeners() {
        Object object = this.linkstatus_LOCK;
        synchronized (object) {
            this.linkListeners = new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLinkStatusListener(NodeLinkStatusListener l) {
        Object object = this.linkstatus_LOCK;
        synchronized (object) {
            this.linkListeners.remove(l);
        }
    }

    @Override
    public void transportLinkDown(Throwable reason) {
        this.linkDown(reason);
    }

    @Override
    public void transportLinkOK() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkDown(Throwable reason) {
        Object object = this.linkstatus_LOCK;
        synchronized (object) {
            if (this.linkOK) {
                this.linkOK = false;
                if (!this.suppressErrorPrintouts) {
                    System.out.println("LINK WENT DOWN " + this + " (" + reason + ") (dead=" + this.dead + ") (ll=" + this.linkListeners.size() + ")");
                }
                if (Switches.SH_resetQuietManagerValidityOnLinkDown) {
                    this.resetWithQuietManager();
                }
                ++this.stats.diedTimes;
                if (reason != null && !(reason instanceof IOException)) {
                    reason.printStackTrace();
                }
                this.linkLastDown = System.currentTimeMillis();
                if (!this.dead) {
                    for (int i = 0; i < this.linkListeners.size(); ++i) {
                        NodeLinkStatusListener l = (NodeLinkStatusListener)this.linkListeners.get(i);
                        System.out.println("[NodeLink] Notifying " + i + " of " + this.linkListeners.size() + " = " + l);
                        l.linkDown(this, reason);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkOK() {
        Object object = this.linkstatus_LOCK;
        synchronized (object) {
            if (!this.linkOK) {
                this.linkOK = true;
                System.out.println("LINK OK " + this);
                this.requestResend = true;
                if (!this.dead) {
                    for (int i = 0; i < this.linkListeners.size(); ++i) {
                        NodeLinkStatusListener l = (NodeLinkStatusListener)this.linkListeners.get(i);
                        l.linkOK(this);
                    }
                }
            }
        }
    }

    public long getLatestRTT() {
        return this.latestRTT;
    }

    public long getSmoothedRTT() {
        return this.lastRTTsmooth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rttMeasured(long rtt) {
        Object object = this.rtt_LOCK;
        synchronized (object) {
            if (FIX_SYSTEM_CLOCK_CHANGES) {
                if (rtt < 0L) {
                    System.out.println("[NL] System clock changed produced erroneous RTT, ignoring");
                    return;
                }
                if (rtt > 30000L) {
                    System.out.println("[NL] System clock changed produced erroneous RTT, ignoring");
                    return;
                }
            }
            this.lastRTTsmooth = this.lastRTTsmooth == -1L ? rtt : (long)((double)this.lastRTTsmooth * 0.9 + (double)rtt * 0.1);
            this.stats.rttMeasured(this.lastRTTsmooth);
        }
    }

    void dumpRecreatedPacketFail(long start) {
        this.parr.recreate(start, true);
    }

    byte[] getRecreatedPacket(long start) {
        byte[] recreated = this.parr.recreate(start);
        if (recreated != null) {
            byte[] tmp = new byte[recreated.length - 16];
            System.arraycopy(recreated, 16, tmp, 0, tmp.length);
            return tmp;
        }
        return null;
    }

    public boolean isProxiedConnection() {
        try {
            return this.me.getTransportForNode(this.target).isProxiedConnection(this.me.getEndpoint((Node)this.target).e);
        }
        catch (Exception x) {
            return false;
        }
    }

    void trimResends() {
        if (Switches.SH_1582_trimNlResendsList) {
            while (this.resends.size() > 5) {
                try {
                    this.resends.next();
                }
                catch (Exception exception) {}
            }
        }
    }

    void requestRestart(String reason, long clock, long fromHere, long fyiHoleSize) {
        byte[] from = new byte[32];
        ByteArrayUtils.writeLong(from, 0, clock);
        ByteArrayUtils.writeLong(from, 8, fromHere);
        ByteArrayUtils.writeLong(from, 16, -1L);
        ByteArrayUtils.writeLong(from, 24, fyiHoleSize);
        if (VERBOSE_RESEND) {
            System.out.println("[NL Resend Writer] Requesting restart from " + fromHere + " c=" + clock + " (" + reason + ")");
        }
        this.resends.add(from);
        this.trimResends();
    }

    void requestSlowdown(String reason) {
        byte[] from = new byte[32];
        ByteArrayUtils.writeLong(from, 0, -1L);
        ByteArrayUtils.writeLong(from, 8, -1L);
        ByteArrayUtils.writeLong(from, 16, -1L);
        ByteArrayUtils.writeLong(from, 24, -1L);
        if (VERBOSE_RESEND) {
            System.out.println("[NL Resend Writer] Requesting slowdown (" + reason + ")");
        }
        this.resends.add(from);
        this.trimResends();
    }

    void requestHolePatch(long clock, long start, long end) {
        byte[] from = new byte[24];
        ByteArrayUtils.writeLong(from, 0, clock);
        ByteArrayUtils.writeLong(from, 8, start);
        ByteArrayUtils.writeLong(from, 16, end);
        this.resends.add(from);
        this.trimResends();
    }

    private void updateTimeInPacket(byte[] tagged) {
        this.lastDataWritten = System.currentTimeMillis();
        long time = System.currentTimeMillis();
        NodeLinkFlowController myflow = this.flow;
        if (myflow != null) {
            myflow.packetSent(time);
        }
        ByteArrayUtils.writeLong(tagged, 8, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataPacket(byte[] p, long packetStart, boolean mustAcquire, boolean slowFlow) throws InterruptedException {
        if (VERBOSE_PACKET_SEND_NORMAL) {
            System.out.println("[NL PacketWriter] Asked to write data packet " + p.length);
        }
        long t = System.currentTimeMillis();
        if (mustAcquire && this.writeRestrictor.acquire(p.length, false)) {
            NodeLinkFlowController myflow = this.flow;
            if (myflow != null) {
                myflow.writeWasRestricted();
            }
            if ((t = System.currentTimeMillis() - t) > 20L) {
                System.out.println("[NL Write] choked for " + t + "ms ");
            }
        }
        byte[] tagged = new byte[p.length + 16];
        System.arraycopy(p, 0, tagged, 16, p.length);
        ByteArrayUtils.writeLong(tagged, 0, packetStart);
        Object object = this.write_LOCK;
        synchronized (object) {
            InfiniteLoop il2 = new InfiniteLoop();
            while (!this.dead) {
                il2.LOOP();
                try {
                    NodeLinkFlowController myflow = this.flow;
                    if (myflow != null) {
                        long Tflow = SafeClock.currentTimeMillis();
                        if (VERBOSE_PACKET_SEND_NORMAL) {
                            System.out.println("[NL PacketWriter] In flow control");
                        }
                        myflow.flowControl(tagged.length, !slowFlow);
                        if (VERBOSE_PACKET_SEND_NORMAL) {
                            System.out.println("[NL PacketWriter] Flow control done");
                        }
                        Tflow = SafeClock.currentTimeMillis() - Tflow;
                    }
                    this.updateTimeInPacket(tagged);
                    if (VERBOSE_PACKET_SEND_NORMAL) {
                        System.out.println("[NL PacketWriter] Sending (Normal) @" + ByteArrayUtils.readLong(tagged, 0) + " (" + tagged.length + " b)...");
                    }
                    myflow = this.flow;
                    try {
                        byte[] tosend = myflow != null ? this.parw.willWriteData(tagged, packetStart, p.length) : tagged;
                        long nanos = System.nanoTime();
                        this.me.sendToSpecific(tosend, this.target, this.conversation, this.timeout / (long)this.retriesBeforeTimeout, this, this.getStandardOobNames(), this.getStandardOobDatas());
                        if (Switches.SH_nlFixedBandwidthLimiting) {
                            nanos = System.nanoTime() - nanos;
                            this.fbl.didWrite(nanos, tosend.length);
                        }
                        if (myflow != null) {
                            byte[] next = myflow.nextRequiredPacket();
                            while (next != null) {
                                myflow.flowControl(next.length, !slowFlow);
                                nanos = System.nanoTime();
                                this.me.sendToSpecific(next, this.target, this.conversation, this.timeout / (long)this.retriesBeforeTimeout, this, this.getStandardOobNames(), this.getStandardOobDatas());
                                if (Switches.SH_nlFixedBandwidthLimiting) {
                                    nanos = System.nanoTime() - nanos;
                                    this.fbl.didWrite(nanos, tosend.length);
                                }
                                next = myflow.nextRequiredPacket();
                            }
                            ArrayList<byte[]> paritys = this.parw.getParityShardsIfAny();
                            if (paritys != null) {
                                for (byte[] parityShard : paritys) {
                                    myflow.flowControl(parityShard.length, !slowFlow);
                                    nanos = System.nanoTime();
                                    this.me.sendToSpecific(parityShard, this.target, this.conversation, this.timeout / (long)this.retriesBeforeTimeout, this, this.getStandardOobNames(), this.getStandardOobDatas());
                                    if (!Switches.SH_nlFixedBandwidthLimiting) continue;
                                    nanos = System.nanoTime() - nanos;
                                    this.fbl.didWrite(nanos, tosend.length);
                                }
                            }
                        }
                        if (VERBOSE_PACKET_SEND_NORMAL) {
                            System.out.println("[NL PacketWriter] Sent (Normal) @" + ByteArrayUtils.readLong(tagged, 0) + " (" + tagged.length + " b)...");
                        }
                        if (INFO_FEED == null) break;
                        long notacked = this.maxUnackedData - this.writeRestrictor.getCurrent();
                        long notvalidated = this.written - this.writtenValid;
                        INFO_FEED.updateBytesWrittenButUnacked(notacked);
                        INFO_FEED.updateBytesWrittenButNotContinuouslyValid(Math.max(0L, notvalidated - notacked));
                        INFO_FEED.updateRTT(Double.NaN);
                        INFO_FEED.updateHoleyBufferSize(Double.NaN);
                        if (myflow != null) {
                            INFO_FEED.updateFlowRate(myflow.getRateKbPerSec());
                        } else {
                            INFO_FEED.updateFlowRate(Double.NaN);
                        }
                        INFO_FEED.addMarker(Double.NaN);
                        if (myflow != null) {
                            if (myflow instanceof NodeLinkLatencyLossController) {
                                INFO_FEED.updateLatencyIncreases(((NodeLinkLatencyLossController)myflow).nlinfoGetLatencyIncreases());
                                INFO_FEED.updateLatencyDecreases(((NodeLinkLatencyLossController)myflow).nlinfoGetLatencyDecreases());
                                break;
                            }
                            INFO_FEED.updateLatencyIncreases(0.0);
                            INFO_FEED.updateLatencyDecreases(0.0);
                            break;
                        }
                        INFO_FEED.updateLatencyIncreases(0.0);
                        INFO_FEED.updateLatencyDecreases(0.0);
                    }
                    catch (ShardDataTooLongException x) {
                        System.out.println("[NL PacketWriter] Shard issue (transport switch?) skipped");
                    }
                    break;
                }
                catch (Exception e) {
                    if (Switches.SH_XXXX_nlSleepOnPacketWriteTimeout) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (Switches.SH_nlNoChannelDiedOnWriteDataPacketException) continue;
                    this.channelDied();
                }
            }
            if (USE_HISTORY_BUFFER && mustAcquire) {
                this.histy.add(p);
            }
            if (mustAcquire) {
                this.written += (long)p.length;
            }
        }
    }

    public boolean wasGracefullyTerminated() {
        return this.gracefullyTerminated;
    }

    public static boolean isGracefulStop(IOException x) {
        if (x instanceof ConnectionTrace) {
            return ((ConnectionTrace)x).wasGraceful();
        }
        return false;
    }

    void channelDiedDueToQuiet() {
        this.channelDied("The channel stopped receiving data and could not reconnect in the allotted time", false, false, null);
    }

    private void channelDied() {
        this.channelDied("The channel died and could not reconnect in the allotted time", false, false, null);
    }

    private void channelDied(String msg, boolean terminatedGracefully) {
        this.channelDied(msg, terminatedGracefully, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelDied(String msg, boolean terminatedGracefully, boolean immediate, ConnectionTrace trace) {
        Object object = this.dead_LOCK;
        synchronized (object) {
            if (this.dead) {
                return;
            }
            this.dead = true;
        }
        this.gracefullyTerminated = terminatedGracefully;
        if (!immediate) {
            try {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                byte[] dat = new byte[8];
                ByteArrayUtils.writeLong(dat, 0, -1111111111L);
                this.me.sendToSpecific(dat, this.target, this.conversationKeepalive, 1L, this, this.getStandardOobNames(), this.getStandardOobDatas());
            }
            catch (Throwable dat) {
                // empty catch block
            }
        }
        if (trace == null) {
            trace = terminatedGracefully ? new ConnectionTrace(terminatedGracefully, this.postfix + " " + this.me + "<=>" + this.target + " (conv" + this.conversation.key + ") " + STOP_GRACEFUL + " (" + msg + ")") : new ConnectionTrace(terminatedGracefully, this.postfix + " " + this.me + "<=>" + this.target + " (conv " + this.conversation.key + ") " + STOP_FAILURE + " (" + msg + ")");
        }
        if (!this.SILENT_CLOSE) {
            if (this.suppressErrorPrintouts) {
                trace.printShort(System.out);
            } else {
                trace.printStackTrace(System.out);
            }
        }
        if (Switches.SH_nlNoTraceClosingBufStreams) {
            this.bufin.setClosed();
            this.bufout.setClosed(trace);
        } else {
            this.bufin.setClosed(trace);
            this.bufout.setClosed(trace);
        }
        try {
            this.pr.interrupt();
        }
        catch (Throwable dat) {
            // empty catch block
        }
        try {
            this.pw.interrupt();
        }
        catch (Throwable dat) {
            // empty catch block
        }
        try {
            this.kw.interrupt();
        }
        catch (Throwable dat) {
            // empty catch block
        }
        try {
            this.kr.interrupt();
        }
        catch (Throwable dat) {
            // empty catch block
        }
        try {
            this.ar.interrupt();
        }
        catch (Throwable dat) {
            // empty catch block
        }
        try {
            this.aw.interrupt();
        }
        catch (Throwable dat) {
            // empty catch block
        }
        try {
            this.rr.interrupt();
        }
        catch (Throwable dat) {
            // empty catch block
        }
        try {
            this.rw.interrupt();
        }
        catch (Throwable dat) {
            // empty catch block
        }
        try {
            if (USE_HISTORY_BUFFER) {
                this.histy = new HistoryBuffer();
            }
            this.writeRestrictor = null;
        }
        catch (Throwable dat) {
            // empty catch block
        }
        try {
            this.me.setConversationClosed(this.conversation);
        }
        catch (Throwable t) {
            if (immediate) {
                // empty if block
            }
        }
        try {
            this.me.setConversationClosed(this.conversationKeepalive);
        }
        catch (Throwable t) {
            if (immediate) {
                // empty if block
            }
        }
        try {
            this.me.setConversationClosed(this.conversationAck);
        }
        catch (Throwable t) {
            if (immediate) {
                // empty if block
            }
        }
        try {
            this.me.setConversationClosed(this.conversationResend);
        }
        catch (Throwable t) {
            if (immediate) {
                // empty if block
            }
        }
        object = this.linkstatus_LOCK;
        synchronized (object) {
            try {
                if (this.terminateInTandem != null) {
                    if (!this.SILENT_CLOSE) {
                        System.out.println("[NodeLink] " + this + " terminating symbiotic connection " + this.terminateInTandem);
                    }
                    this.terminateInTandem.stopSymbiotic(this, immediate);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (immediate) {
                System.out.println("[NodeLink] Stopping - Notifying link listeners");
            }
            for (int i = 0; i < this.linkListeners.size(); ++i) {
                NodeLinkStatusListener l = (NodeLinkStatusListener)this.linkListeners.get(i);
                l.linkDead(this, msg);
            }
        }
        if (this.me.isSingleUse()) {
            new ShutdownSoonThread(this.me).start();
        }
    }

    public boolean isAlive() {
        return !this.dead;
    }

    public boolean isDown() {
        return !this.linkOK;
    }

    public static void patchTransportsAndCloseNL(NodeLink nlA, int convA, int fwdA, NodeLink nlB, int convB, int fwdB, ForwardCheck fcheck) throws Exception {
        Node ahome = nlA.getMyNode();
        Node bhome = nlB.getMyNode();
        Node atarget = nlA.getTargetNode();
        Node btarget = nlB.getTargetNode();
        Transport atrans = ahome.getTransportForNode(atarget);
        Endpoint aep = ahome.getEndpointForNode(atarget);
        Transport btrans = bhome.getTransportForNode(btarget);
        Endpoint bep = bhome.getEndpointForNode(btarget);
        System.out.println("Patching " + ahome + " to " + btarget + " " + bep + " " + btrans + " fwd=" + fwdA);
        System.out.println("Patching " + bhome + " to " + atarget + " " + aep + " " + atrans + " fwd=" + fwdB);
        ahome.setConversationOpen(new NodeLinkConversation(NEW_CHANNEL_GROUP));
        bhome.setConversationOpen(new NodeLinkConversation(NEW_CHANNEL_GROUP));
        for (int N = 0; N < 10; ++N) {
            ahome.setConversationOpen(new NodeLinkConversation(convA + N));
            ahome.setConversationOpen(new NodeLinkConversation(convA + N));
            bhome.setConversationOpen(new NodeLinkConversation(convB + N));
            bhome.setConversationOpen(new NodeLinkConversation(convB + N));
        }
        System.out.println("Patch " + ahome + "/" + bhome + " forwarding packets (fwd:" + fwdA + ", fwd:" + fwdB + ")");
        ahome.forwardPacketsTo(fwdA, btrans, atarget, btarget, bep);
        bhome.forwardPacketsTo(fwdB, atrans, btarget, atarget, aep);
        System.out.println("Patch " + ahome + "/" + bhome + " adding fchecks");
        fcheck.add(ahome, fwdA);
        fcheck.add(bhome, fwdB);
        System.out.println("Patch " + ahome + "/" + bhome + " creating Nodes");
        nlA.me = new Node();
        nlB.me = new Node();
        System.out.println("Patch " + ahome + "/" + bhome + " stopping NLs");
        nlA.SILENT_CLOSE = true;
        nlB.SILENT_CLOSE = true;
        try {
            nlA.stopImmediate("2x NLs patched");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            nlB.stopImmediate("2x NLs patched");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.out.println("Patch " + ahome + "/" + bhome + " returning");
    }

    public void clearNodeAndStop(String reason) {
        this.me = new Node();
        this.stopImmediate(reason);
    }

    private void stopSymbiotic(NodeLink pair, boolean immediate) {
        this.suppressErrorPrintouts = true;
        if (Switches.SH_XXXX_nlSymbioticHonourStopImmediate) {
            this.channelDied("we terminated due to " + pair + " being terminated", true, immediate, null);
        } else {
            this.channelDied("we terminated due to " + pair + " being terminated", true, false, null);
        }
    }

    public void stop(String reason) {
        if (Switches.SH_XXXX_nlStopAsyncAlways) {
            terms.runAsync((Runnable)new StopAsync("The channel was terminated from this side - " + reason, true, false));
        } else {
            this.channelDied("we terminated - " + reason, true);
        }
    }

    public void stopImmediate(String reason) {
        if (Switches.SH_XXXX_nlStopAsyncAlways) {
            terms.runAsync((Runnable)new StopAsync("The channel was terminated from this side - " + reason, true, true));
        } else {
            this.channelDied("we terminated - " + reason, true, true, null);
        }
    }

    public String toString() {
        if (this.amclient) {
            return "NodeLink " + this.postfix + "/conv" + this.conversation + " (" + this.getTransportInfo() + " / " + this.me + "->-" + this.target + ")";
        }
        return "NodeLink " + this.postfix + "/conv" + this.conversation + " (" + this.getTransportInfo() + " / " + this.me + "->-" + this.target + ")";
    }

    public int estimatedBufferSize() {
        return this.bufout.size();
    }

    public void flushAllBuffers(int timeoutMS) throws InterruptedException {
        this.bufout.waitUntilCleared(timeoutMS);
    }

    static {
        System.setProperty("networkaddress.cache.negative.ttl", "0");
        System.setProperty("networkaddress.cache.ttl", "5");
        SafeClock.currentTimeMillis();
        DEFAULT_MAX_UNACKED_DATA = 2500000;
        DEFAULT_MAX_DATA_PER_WRITE = MAX_DATA_PER_WRITE_LIMIT = 200000;
        DEFAULT_BUFFER_SIZE = 2000;
        DEFAULT_MAX_FLOW_CONTROLLED_PACKET_SIZE = 420;
        DEFAULT_INITIAL_TIMEOUT = 10000;
        DEFAULT_RECONNECT_TIMEOUT = 180000;
        DEFAULT_ERROR_TIMEOUT = 300000;
        INFINITE_TIMEOUT = 0;
        INFINITE_RECONNECT_TIMEOUT = 1000000000000L;
        NEW_CHANNEL_GROUP = -1000000000;
        ORPHANS = new NodeLinkOrphanPacketListener();
        MACHID = (int)(System.currentTimeMillis() % 10000L) * 10000;
        System.out.println("[NL MachID] " + MACHID);
        keys_LOCK = new Object();
        keys = MACHID;
        trkeys = (int)(System.currentTimeMillis() % 1000000L);
        trkeys *= 100;
        trkeys += 9;
        STOP_GRACEFUL = "TERMINATED";
        STOP_FAILURE = "DIED/FAILED";
        terms = new OnDemandThreadPool("NL Termination", 8, 100, 1);
    }

    static class NodeLinkOrphanPacketListener
    implements OrphanPacketListener {
        NodeLinkOrphanPacketListener() {
        }

        @Override
        public void processOrphanPacket(byte[] pdat, int conv, Node fromNode, Node receivedBy) {
            NodeLinkConversation conversation = new NodeLinkConversation(conv);
            if (conversation.key % 10 == 1) {
                System.out.println(receivedBy + " responding to orphaned conversation " + fromNode + " (" + conversation.OBJKEY + ") with FINISHED");
                byte[] dat = new byte[8];
                ByteArrayUtils.writeLong(dat, 0, -1111111111L);
                try {
                    receivedBy.sendToSpecific(dat, fromNode, conversation, 1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public long getMaxRegularityInMs() {
            return 1000L;
        }
    }

    class StopAsync
    implements Runnable {
        String message;
        boolean graceful;
        boolean immediate;
        ConnectionTrace trace;

        public StopAsync(String message, boolean graceful, boolean immediate) {
            this.message = message;
            this.graceful = graceful;
            this.immediate = immediate;
            this.trace = graceful ? new ConnectionTrace(graceful, NodeLink.this.postfix + " " + NodeLink.this.me + "<=>" + NodeLink.this.target + " (conv" + NodeLink.this.conversation.key + ") " + STOP_GRACEFUL + " (" + message + ")") : new ConnectionTrace(graceful, NodeLink.this.postfix + " " + NodeLink.this.me + "<=>" + NodeLink.this.target + " (conv " + NodeLink.this.conversation.key + ") " + STOP_FAILURE + " (" + message + ")");
        }

        @Override
        public void run() {
            NodeLink.this.channelDied(this.message, this.graceful, this.immediate, this.trace);
        }
    }

    class ShutdownSoonThread
    extends Thread {
        Node node;

        public ShutdownSoonThread(Node node) {
            this.node = node;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(6000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.node.shutdownTransports();
        }
    }

    class PacketWriter
    extends Thread {
        long waitingSince = SafeClock.currentTimeMillis();
        UnqueuedSemaphore writeRestrictor = NodeLink.access$700(NodeLink.this);

        public PacketWriter(String postfix) {
            this.setName("PacketWriter-" + postfix);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InfiniteLoop il = new InfiniteLoop();
            while (!NodeLink.this.dead) {
                il.LOOP();
                try {
                    while (NodeLink.this.amResending) {
                        Object object = NodeLink.this.normal_WAIT;
                        synchronized (object) {
                            NodeLink.this.normal_WAIT.wait(10000L);
                        }
                        if (!NodeLink.this.dead) continue;
                    }
                    if (VERBOSE_PACKET_SEND_NORMAL) {
                        System.out.println("[NL PacketWriter] Waiting for bytes");
                    }
                    this.waitingSince = SafeClock.currentTimeMillis();
                    NodeLinkFlowController myflow = NodeLink.this.flow;
                    int maxBytes = myflow != null ? Math.min(DEFAULT_MAX_FLOW_CONTROLLED_PACKET_SIZE, myflow.getMaxDataPerWrite()) : NodeLink.this.maxDataPerWrite;
                    long packetStart = NodeLink.this.written;
                    byte[] p = NodeLink.this.bufout.fetchBytes(maxBytes);
                    if (InfiniteLoop.BROKEN) {
                        System.out.println("DELETEME - p " + p);
                        System.out.println("DELETEME - plen " + p.length);
                        System.out.println("DELETEME - bufout " + NodeLink.this.bufout);
                    }
                    NodeLink.this.writeDataPacket(p, packetStart, true, false);
                }
                catch (Exception e) {
                    if (!Switches.SH_XXXX_nlSleepOnPacketTimeout) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    class PacketResender
    extends Thread {
        private int exceptionCounter = 0;
        private long lastCounterReset;

        public PacketResender(String postfix) {
            this.setName("PacketResender-" + postfix);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InfiniteLoop il = new InfiniteLoop();
            while (!NodeLink.this.dead) {
                il.LOOP();
                try {
                    byte[] p;
                    NodeLinkFlowController myflow;
                    while (NodeLink.this.resendFirst == null) {
                        try {
                            Object object = NodeLink.this.resend_WAIT;
                            synchronized (object) {
                                NodeLink.this.resend_WAIT.wait(10000L);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!NodeLink.this.dead) continue;
                    }
                    if (VERBOSE_PACKET_SEND_NORMAL) {
                        System.out.println("[NL PacketResender] Waiting for bytes");
                    }
                    int maxBytes = (myflow = NodeLink.this.flow) != null ? Math.min(DEFAULT_MAX_FLOW_CONTROLLED_PACKET_SIZE, myflow.getMaxDataPerWrite()) : NodeLink.this.maxDataPerWrite;
                    long packetStart = NodeLink.this.written;
                    if (NodeLink.this.resendFirst == null) continue;
                    packetStart = NodeLink.this.resendFirst.getNextReadStartPoint();
                    if (!NodeLink.this.amResending && VERBOSE_RESEND) {
                        System.out.println("[NL Resend] Resending packets from " + packetStart + " (" + (NodeLink.this.written - packetStart) + ")");
                    }
                    NodeLink.this.amResending = true;
                    byte[] buf = new byte[maxBytes];
                    int N = NodeLink.this.resendFirst.read(buf);
                    if (N == -1) {
                        NodeLink.this.resendFirst = null;
                        p = null;
                        if (VERBOSE_RESEND) {
                            System.out.println("[NL Resend] Done resending, sending normal packets again");
                        }
                    } else if (N < buf.length) {
                        byte[] tmp = new byte[N];
                        System.arraycopy(buf, 0, tmp, 0, N);
                        p = tmp;
                    } else {
                        p = buf;
                    }
                    if (NodeLink.this.resendFirst == null) {
                        NodeLink.this.amResending = false;
                        Object object = NodeLink.this.normal_WAIT;
                        synchronized (object) {
                            NodeLink.this.normal_WAIT.notifyAll();
                            continue;
                        }
                    }
                    NodeLink.this.writeDataPacket(p, packetStart, false, true);
                }
                catch (Exception e) {
                    if (Switches.SH_XXXX_nlSleepOnPacketTimeout) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++this.exceptionCounter;
                    if (this.exceptionCounter <= 100) {
                        System.out.println("[NodeLink][PacketResender] Exception " + this.exceptionCounter + ":");
                        e.printStackTrace();
                        this.lastCounterReset = System.currentTimeMillis();
                        continue;
                    }
                    if (this.lastCounterReset + 60000L >= System.currentTimeMillis()) continue;
                    System.out.println("[NodeLink][PacketResender] Summarised Exceptions: " + (this.exceptionCounter - 100) + " in the last minute.");
                    e.printStackTrace();
                    this.exceptionCounter = 100;
                    this.lastCounterReset = System.currentTimeMillis();
                }
            }
        }
    }

    class PacketReader
    extends Thread {
        long sliceStart = 0L;
        long sliceEnd = 0L;
        long sliceLastReceived = 0L;
        long slicePackets = 0L;
        boolean rateSent = false;
        long restart_clock = 10000000000L;

        public PacketReader(String postfix) {
            this.setName("PacketReader-" + postfix);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!NodeLink.this.dead) {
                boolean doResend;
                byte[] ack;
                long Tnow;
                byte[] p = NodeLink.this.me.nextPacketFromSpecific(NodeLink.this.conversation, NodeLink.this.timeout / (long)NodeLink.this.retriesBeforeTimeout, NodeLink.this);
                if (p != null && Switches.SH_nlTrackMaxBandwidth) {
                    NodeLink.this.trackBandwidth(p.length);
                }
                if ((Tnow = SafeClock.currentTimeMillis()) > this.sliceEnd && !this.rateSent && Tnow < this.sliceEnd + 10L) {
                    long sliceDuration = this.sliceEnd - this.sliceStart;
                    long sliceTimed = this.sliceLastReceived - this.sliceStart;
                    System.out.println("Read rate duration: " + sliceDuration + " vs " + sliceTimed);
                    long minDuration = Math.min(sliceDuration, sliceTimed);
                    if (minDuration >= 10L) {
                        long slicePacketsPerSecond = this.slicePackets * (1000L / minDuration);
                        this.rateSent = true;
                        ack = new byte[10];
                        ByteArrayUtils.writeShort(ack, 0, (short)17477);
                        ByteArrayUtils.writeLong(ack, 2, slicePacketsPerSecond);
                        double kbps = slicePacketsPerSecond;
                        kbps *= 512.0;
                        System.out.println("[NL BEF] Receive rate is " + slicePacketsPerSecond + " packets/s (" + (Tnow - this.sliceStart) + "), approx " + (int)(kbps /= 1024.0) + " k/s");
                        NodeLink.this.infos.add(ack);
                    }
                    Tnow = SafeClock.currentTimeMillis();
                }
                this.sliceLastReceived = Tnow;
                ++this.slicePackets;
                if (p != null) {
                    short command = ByteArrayUtils.readShort(p, 0);
                    int ms = ByteArrayUtils.readInt(p, 2);
                    if (command == 17478) {
                        if (Tnow <= this.sliceEnd + 800L) continue;
                        this.slicePackets = 0L;
                        this.sliceStart = Tnow;
                        this.sliceEnd = Tnow + (long)ms;
                        this.sliceLastReceived = Tnow + (long)ms;
                        this.rateSent = false;
                        continue;
                    }
                } else if (Switches.SH_XXXX_nlSleepOnPacketTimeout) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception command) {
                        // empty catch block
                    }
                }
                Object ms = NodeLink.this.linkstatus_LOCK;
                synchronized (ms) {
                    doResend = NodeLink.this.requestResend;
                    NodeLink.this.requestResend = false;
                }
                if (doResend) {
                    NodeLink.this.requestRestart("New link, requesting resend in case all data was sent but we are missing end of data", this.restart_clock++, NodeLink.this.received, 0L);
                }
                try {
                    if (p != null && NodeLink.this.isUsingFlowControl()) {
                        p = NodeLink.this.parr.decodeShard(p);
                    }
                    if (p == null) continue;
                    NodeLink.this.linkOK();
                    long begins = ByteArrayUtils.readLong(p, 0);
                    long time = ByteArrayUtils.readLong(p, 8);
                    byte[] dat = new byte[p.length - 16];
                    System.arraycopy(p, 16, dat, 0, dat.length);
                    if (VERBOSE_PACKET_READ) {
                        System.out.println("[NL PacketReader] Reading packet @" + begins + " (" + p.length + "b)");
                    }
                    long ackValid = NodeLink.this.bufin.addData(dat, begins);
                    if (INFO_FEED != null) {
                        INFO_FEED.updateBytesWrittenButUnacked(Double.NaN);
                        INFO_FEED.updateBytesWrittenButNotContinuouslyValid(Double.NaN);
                        INFO_FEED.updateRTT(Double.NaN);
                        INFO_FEED.updateHoleyBufferSize(NodeLink.this.bufin.getSize());
                        INFO_FEED.updateFlowRate(Double.NaN);
                        INFO_FEED.addMarker(Double.NaN);
                        NodeLinkFlowController myflow = NodeLink.this.flow;
                        if (myflow != null) {
                            if (myflow instanceof NodeLinkLatencyLossController) {
                                INFO_FEED.updateLatencyIncreases(((NodeLinkLatencyLossController)myflow).nlinfoGetLatencyIncreases());
                                INFO_FEED.updateLatencyDecreases(((NodeLinkLatencyLossController)myflow).nlinfoGetLatencyDecreases());
                            } else {
                                INFO_FEED.updateLatencyIncreases(0.0);
                                INFO_FEED.updateLatencyDecreases(0.0);
                            }
                        } else {
                            INFO_FEED.updateLatencyIncreases(0.0);
                            INFO_FEED.updateLatencyDecreases(0.0);
                        }
                    }
                    NodeLink.this.received = Math.max(NodeLink.this.received, begins + (long)dat.length);
                    NodeLink.this.receivedValid = Math.max(NodeLink.this.receivedValid, ackValid);
                    ack = new byte[26];
                    ByteArrayUtils.writeShort(ack, 0, (short)17476);
                    ByteArrayUtils.writeLong(ack, 2, NodeLink.this.received);
                    ByteArrayUtils.writeLong(ack, 10, NodeLink.this.receivedValid);
                    ByteArrayUtils.writeLong(ack, 18, time);
                    if (VERBOSE_ACKS) {
                        System.out.println("[NL Packet Reader] Sending ACK for recv=" + NodeLink.this.received + " / valid=" + NodeLink.this.receivedValid);
                    }
                    if (NodeLink.this.acks.size() > 0) {
                        NodeLink.this.acks.clear();
                    }
                    NodeLink.this.acks.add(ack);
                    NodeLink.this.lastAck = NodeLink.this.received;
                }
                catch (ArrayIndexOutOfBoundsException x) {
                    System.out.println("[NL Packet Reader] Bad NL packet: " + x);
                }
            }
        }
    }

    class AckReader
    extends Thread {
        UnqueuedSemaphore writeRestrictor;

        public AckReader(String postfix) {
            this.writeRestrictor = NodeLink.this.writeRestrictor;
            this.setName("AckReader-" + postfix);
            this.setPriority(10);
        }

        @Override
        public void run() {
            InfiniteLoop il = new InfiniteLoop();
            while (!NodeLink.this.dead) {
                byte[] p = NodeLink.this.me.nextPacketFromSpecific(NodeLink.this.conversationAck, NodeLink.this.timeout / (long)NodeLink.this.retriesBeforeTimeout, NodeLink.this);
                if (p != null) {
                    long rtt;
                    short type;
                    NodeLink.this.linkOK();
                    if (Switches.SH_nlTrackMaxBandwidth) {
                        NodeLink.this.trackBandwidth(p.length);
                    }
                    if ((type = ByteArrayUtils.readShort(p, 0)) == 22391) {
                        long mytime = ByteArrayUtils.readLong(p, 2);
                        long newRTT = System.currentTimeMillis() - mytime;
                        if (VERBOSE_RTT) {
                            System.out.println("[NL RTT Echo] RTT=" + NodeLink.this.latestRTT + " >> " + newRTT + " (side=" + this.hashCode() + ")");
                        }
                        NodeLink.this.latestRTT = newRTT;
                        continue;
                    }
                    if (type == 17477) {
                        long packetsPerSecond = ByteArrayUtils.readLong(p, 2);
                        NodeLinkFlowController myflow = NodeLink.this.flow;
                        if (myflow == null) continue;
                        myflow.readRateMeasured(packetsPerSecond);
                        continue;
                    }
                    long ack = ByteArrayUtils.readLong(p, 2);
                    long ackHistory = ByteArrayUtils.readLong(p, 10);
                    long time = ByteArrayUtils.readLong(p, 18);
                    NodeLink.this.latestRTT = rtt = System.currentTimeMillis() - time;
                    NodeLinkFlowController myflow = NodeLink.this.flow;
                    if (myflow != null) {
                        myflow.ackReceived(time);
                    }
                    long showRtt = myflow != null ? myflow.rttMeasured(rtt) : rtt;
                    NodeLink.this.rttMeasured(rtt);
                    if (ack > NodeLink.this.writtenAcked) {
                        if (VERBOSE_PACKET_SEND_NORMAL) {
                            System.out.println("[NL Write Restrictor] Write restrictor releasing " + (int)(ack - NodeLink.this.writtenAcked) + " (" + NodeLink.this.maxUnackedData + ")... unclaimed=" + this.writeRestrictor.getCurrent());
                        }
                        this.writeRestrictor.release((int)(ack - NodeLink.this.writtenAcked));
                        NodeLink.this.writtenAcked = ack;
                        if (ackHistory != -1L && USE_HISTORY_BUFFER) {
                            if (ackHistory > NodeLink.this.writtenValid) {
                                NodeLink.this.histy.skip(ackHistory - NodeLink.this.writtenValid);
                            }
                            NodeLink.this.writtenValid = Math.max(NodeLink.this.writtenValid, ackHistory);
                        }
                    }
                    if (INFO_FEED == null) continue;
                    long notacked = NodeLink.this.maxUnackedData - this.writeRestrictor.getCurrent();
                    long notvalidated = NodeLink.this.written - NodeLink.this.writtenValid;
                    INFO_FEED.updateBytesWrittenButUnacked(notacked);
                    INFO_FEED.updateBytesWrittenButNotContinuouslyValid(Math.max(0L, notacked - notvalidated));
                    INFO_FEED.updateRTT(showRtt);
                    INFO_FEED.updateHoleyBufferSize(Double.NaN);
                    INFO_FEED.updateFlowRate(Double.NaN);
                    INFO_FEED.addMarker(Double.NaN);
                    myflow = NodeLink.this.flow;
                    if (myflow != null) {
                        if (myflow instanceof NodeLinkLatencyLossController) {
                            INFO_FEED.updateLatencyIncreases(((NodeLinkLatencyLossController)myflow).nlinfoGetLatencyIncreases());
                            INFO_FEED.updateLatencyDecreases(((NodeLinkLatencyLossController)myflow).nlinfoGetLatencyDecreases());
                            continue;
                        }
                        INFO_FEED.updateLatencyIncreases(0.0);
                        INFO_FEED.updateLatencyDecreases(0.0);
                        continue;
                    }
                    INFO_FEED.updateLatencyIncreases(0.0);
                    INFO_FEED.updateLatencyDecreases(0.0);
                    continue;
                }
                if (!Switches.SH_XXXX_nlSleepOnPacketTimeout) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }

    class AckWriter
    extends Thread {
        public AckWriter(String postfix) {
            this.setName("AckWriter-" + postfix);
            this.setPriority(10);
        }

        @Override
        public void run() {
            InfiniteLoop il = new InfiniteLoop();
            while (!NodeLink.this.dead) {
                byte[] pdat = null;
                try {
                    pdat = NodeLink.this.infos.size() > 0 ? (byte[])NodeLink.this.infos.next() : (byte[])NodeLink.this.acks.next();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException iOException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                if (pdat == null) continue;
                InfiniteLoop il2 = new InfiniteLoop();
                while (!NodeLink.this.dead) {
                    il2.LOOP();
                    try {
                        if (VERBOSE_ACKS) {
                            System.out.println("Sending ACK");
                        }
                        NodeLink.this.me.sendToSpecific(pdat, NodeLink.this.target, NodeLink.this.conversationAck, NodeLink.this.timeout / (long)NodeLink.this.retriesBeforeTimeout, NodeLink.this, NodeLink.this.getStandardOobNames(), NodeLink.this.getStandardOobDatas());
                        break;
                    }
                    catch (Exception e) {
                        System.out.println("ACK FAILED! retrying...");
                        try {
                            Thread.sleep(250L);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    class ResendWriter
    extends Thread {
        public ResendWriter(String postfix) {
            this.setName("ResendWriter-" + postfix);
        }

        @Override
        public void run() {
            InfiniteLoop il = new InfiniteLoop();
            block5: while (!NodeLink.this.dead) {
                il.LOOP();
                byte[] pdat = null;
                try {
                    pdat = (byte[])NodeLink.this.resends.next();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (pdat == null) continue;
                InfiniteLoop il2 = new InfiniteLoop();
                while (!NodeLink.this.dead) {
                    il2.LOOP();
                    try {
                        NodeLink.this.me.sendToSpecific(pdat, NodeLink.this.target, NodeLink.this.conversationResend, NodeLink.this.timeout / (long)NodeLink.this.retriesBeforeTimeout, NodeLink.this, NodeLink.this.getStandardOobNames(), NodeLink.this.getStandardOobDatas());
                        continue block5;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
    }

    class ResendReader
    extends Thread {
        Cache seen = new Cache("NodeLink", 500);

        public ResendReader(String postfix) {
            this.setName("ResendReader-" + postfix);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InfiniteLoop il = new InfiniteLoop();
                while (!NodeLink.this.dead) {
                    il.LOOP();
                    byte[] p = NodeLink.this.me.nextPacketFromSpecific(NodeLink.this.conversationResend, NodeLink.this.timeout / (long)NodeLink.this.retriesBeforeTimeout, NodeLink.this);
                    if (p != null) {
                        NodeLink.this.linkOK();
                        if (Switches.SH_nlTrackMaxBandwidth) {
                            NodeLink.this.trackBandwidth(p.length);
                        }
                        Long clock = new Long(ByteArrayUtils.readLong(p, 0));
                        long start = ByteArrayUtils.readLong(p, 8);
                        if (start == -1L) {
                            NodeLinkFlowController myflow = NodeLink.this.flow;
                            if (myflow == null) continue;
                            myflow.packetLossDetected(-1L, -1L);
                            continue;
                        }
                        if (this.seen.getFromCache(clock) != null) {
                            if (!VERBOSE_RESEND) continue;
                            System.out.println("[NL Resend Reader] Disregarding resend request for " + start + " since seen " + clock + " before");
                            continue;
                        }
                        if (VERBOSE_RESEND) {
                            System.out.println("[NL Resend Reader] Accepting new resend request for " + start + " c=" + clock);
                        }
                        this.seen.addToCache(clock, clock);
                        long end = ByteArrayUtils.readLong(p, 16);
                        long fyiHoleSize = ByteArrayUtils.readLong(p, 24);
                        NodeLinkFlowController myflow = NodeLink.this.flow;
                        if (myflow != null) {
                            if (NodeLink.this.amResending) {
                                myflow.packetLossDuringResendDetected(start, fyiHoleSize);
                            } else {
                                myflow.packetLossDetected(start, fyiHoleSize);
                            }
                        }
                        if (VERBOSE_RESEND) {
                            System.out.println("[NL Resend Reader] Trying to configure new resend for " + start + " -> " + end + " (c=" + clock + ") (n=" + (end - start) + ")");
                        }
                        Object object = NodeLink.this.resend_WAIT;
                        synchronized (object) {
                            NodeLink.this.resendFirst = NodeLink.this.histy.getArrayFrom(start);
                            NodeLink.this.resend_WAIT.notifyAll();
                            continue;
                        }
                    }
                    if (!Switches.SH_XXXX_nlSleepOnPacketTimeout) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (OutOfMemoryError x) {
                System.out.println("NL out of memory in RReader");
            }
        }
    }

    class KeepaliveWriter
    extends Thread {
        byte[] empty = new byte[16];

        public KeepaliveWriter(String postfix) {
            this.setName("KeepaliveWriter-" + postfix);
        }

        @Override
        public void run() {
            long nextKeepalive = System.currentTimeMillis() - 100L;
            InfiniteLoop il = new InfiniteLoop();
            while (!NodeLink.this.dead) {
                il.LOOP();
                try {
                    long notvalidated = NodeLink.this.written - NodeLink.this.writtenValid;
                    long T = System.currentTimeMillis();
                    if (VERBOSE_KEEPALIVE) {
                        System.out.println("Checking for keepalive (" + T + " > " + nextKeepalive + ")");
                    }
                    if (T > nextKeepalive || !NodeLink.this.amResending && notvalidated > 0L && T > NodeLink.this.lastDataWritten + (long)FYI_WRITE_EVERY) {
                        if (VERBOSE_KEEPALIVE) {
                            System.out.println("Keepalive sent");
                        }
                        if (!NodeLink.this.amResending && notvalidated > 0L) {
                            if (VERBOSE_FYI) {
                                System.out.println("[NL Keepalive] FYI sent for " + NodeLink.this.written + " nv=" + notvalidated);
                            }
                            ByteArrayUtils.writeLong(this.empty, 0, NodeLink.this.written);
                        } else {
                            if (VERBOSE_FYI) {
                                System.out.println("[NL Keepalive] FYI sent for keepalive only (rs=" + NodeLink.this.amResending + ") nv=" + notvalidated);
                            }
                            ByteArrayUtils.writeLong(this.empty, 0, 0L);
                        }
                        ByteArrayUtils.writeLong(this.empty, 8, System.currentTimeMillis());
                        NodeLink.this.me.sendToSpecific(this.empty, NodeLink.this.target, NodeLink.this.conversationKeepalive, NodeLink.this.timeout, NodeLink.this, NodeLink.this.getStandardOobNames(), NodeLink.this.getStandardOobDatas(), true);
                    }
                    if ((T = System.currentTimeMillis()) > nextKeepalive) {
                        nextKeepalive = NodeLink.this.isUsingFlowControl() ? T + (long)FLOW_RTT_ECHO_WRITE_EVERY : T + (long)KEEPALIVE_WRITE_EVERY;
                    }
                    if (FIX_SYSTEM_CLOCK_CHANGES) {
                        if (Math.abs(T - nextKeepalive) > (long)KEEPALIVE_WRITE_EVERY) {
                            nextKeepalive = T;
                            System.out.println("System clock change, sending keepalive now");
                        }
                        if (T < NodeLink.this.lastDataWritten) {
                            NodeLink.this.lastDataWritten = T;
                            System.out.println("System clock change, sending FYI now");
                        }
                    }
                    if (!Switches.SH_XXXX_nlKeepaliveReaderConfidentSleep) {
                        Thread.sleep(250L);
                    }
                }
                catch (Exception e) {
                    NodeLink.this.channelDied();
                }
                if (!Switches.SH_XXXX_nlKeepaliveReaderConfidentSleep) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {}
            }
        }
    }

    class KeepaliveReader
    extends Thread {
        public KeepaliveReader(String postfix) {
            this.setName("KeepaliveReader-" + postfix);
        }

        @Override
        public void run() {
            InfiniteLoop il = new InfiniteLoop();
            block6: while (true) {
                try {
                    while (!NodeLink.this.dead) {
                        byte[] p;
                        il.LOOP();
                        if (VERBOSE_KEEPALIVE) {
                            System.out.println("Keepalive received on " + NodeLink.this.postfix);
                        }
                        if ((p = NodeLink.this.me.nextPacketFromSpecific(NodeLink.this.conversationKeepalive, NodeLink.this.timeout, NodeLink.this)) == null) {
                            if (VERBOSE_KEEPALIVE) {
                                System.out.println("Keepalive timed out on " + NodeLink.this.postfix + " marking NL as dead and exiting");
                            }
                            NodeLink.this.channelDied("KeepaliveReader timed out (no keepalive packet within " + NodeLink.this.timeout + ")", false);
                            if (!Switches.SH_XXXX_nlBreakLoopOnChannelDied) continue;
                            break block6;
                        }
                        if (p.length <= 0) continue;
                        if (Switches.SH_nlTrackMaxBandwidth) {
                            NodeLink.this.trackBandwidth(p.length);
                        }
                        try {
                            long status = ByteArrayUtils.readLong(p, 0);
                            if (status == -1111111111L) {
                                NodeLink.this.channelDied("Gracefully terminated from the remote side", true);
                                continue block6;
                            }
                            long rttEchoTime = ByteArrayUtils.readLong(p, 8);
                            byte[] packet = new byte[10];
                            ByteArrayUtils.writeShort(packet, 0, (short)22391);
                            ByteArrayUtils.writeLong(packet, 2, rttEchoTime);
                            NodeLink.this.acks.add(packet);
                            if (VERBOSE_FYI) {
                                System.out.println("[NL Keepalive] FYI received for " + status);
                            }
                            NodeLink.this.bufin.fyi(status);
                            continue block6;
                        }
                        catch (Exception exception) {
                        }
                    }
                    break;
                }
                catch (Throwable t) {
                    if (Switches.SH_XXXX_nlSleepOnPacketTimeout) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    t.printStackTrace();
                    NodeLink.this.channelDied("KeepaliveReader thread died " + t, true);
                    break;
                }
            }
        }
    }

    class PacketLossTestThread
    extends Thread {
        int expected_packets;
        int outOfSeq = 0;
        int missed = 0;
        int received = 0;
        int expected = 0;

        public PacketLossTestThread(int expected_packets) {
            this.expected_packets = expected_packets;
        }

        @Override
        public void run() {
            long overall = NodeLink.this.packet_loss_time + 3000;
            long T = System.currentTimeMillis() + overall;
            while (System.currentTimeMillis() < T) {
                byte[] dat = NodeLink.this.me.nextPacketFromSpecific(NodeLink.this.conversation, Math.min(T - System.currentTimeMillis(), 4000L));
                if (dat == null) {
                    System.out.println("[NodeLink] MISSING packet on loss test (timed out)");
                } else {
                    if (dat.length != 5) {
                        System.out.println("[NodeLink] BAD packet on loss test: len=" + dat.length);
                        continue;
                    }
                    int packet = ByteArrayUtils.readInt(dat, 0);
                    System.out.println("[NodeLink] loss test packet: " + packet);
                    if (packet < this.expected) {
                        ++this.outOfSeq;
                    } else if (packet == this.expected) {
                        ++this.received;
                    } else if (packet > this.expected) {
                        this.missed += packet - this.expected;
                    }
                    this.expected = packet + 1;
                }
                if (this.received != this.expected_packets) continue;
                break;
            }
            System.out.println("[NodeLink] Packet loss report:");
            System.out.println("[NodeLink] -- received: " + this.received + "/" + this.expected_packets);
            System.out.println("[NodeLink] -- missed: " + this.missed);
            System.out.println("[NodeLink] -- out of sequence (old): " + this.outOfSeq);
        }
    }

    class PacketRateTestThread
    extends Thread {
        int kbsec = 0;

        PacketRateTestThread() {
        }

        @Override
        public void run() {
            byte[] dat;
            long starttime = -1L;
            long endtime = -1L;
            long diffMs = 0L;
            int packetCount = 0;
            int plen = DEFAULT_MAX_FLOW_CONTROLLED_PACKET_SIZE;
            while ((dat = NodeLink.this.me.nextPacketFromSpecific(NodeLink.this.conversation, 2000L)) != null) {
                int type = ByteArrayUtils.readInt(dat, 0);
                if (type == 22) {
                    if (starttime == -1L) {
                        starttime = System.nanoTime();
                    }
                    endtime = System.nanoTime();
                    ++packetCount;
                    plen = dat.length;
                }
                if (type != 33) continue;
                if (starttime != -1L) {
                    diffMs = (endtime - starttime) / 1000000L;
                    break;
                }
                diffMs = 0L;
                break;
            }
            double secs = (double)diffMs / 1000.0;
            double kb = (double)packetCount * (double)plen / 1024.0;
            this.kbsec = (int)(kb / secs);
            System.out.println("[NodeLink] Packet rate report:");
            System.out.println("[NodeLink] -- diffms: " + diffMs);
            System.out.println("[NodeLink] -- packets: " + packetCount);
            System.out.println("[NodeLink] -- kbsec: " + this.kbsec);
        }
    }

    class ContinuousConnectThread
    extends Thread {
        boolean die = false;
        ByteArrayOutputStream bout;
        Node remote;
        NodeLinkConversation GROUP_NEW_CONV;

        public ContinuousConnectThread(ByteArrayOutputStream bout, Node remote, NodeLinkConversation GROUP_NEW_CONV) {
            this.bout = bout;
            this.remote = remote;
            this.GROUP_NEW_CONV = GROUP_NEW_CONV;
        }

        public void die() {
            this.die = true;
        }

        @Override
        public void run() {
            while (!this.die) {
                try {
                    NodeLink.this.me.sendToSpecific(this.bout.toByteArray(), this.remote, this.GROUP_NEW_CONV, NodeLink.this.timeoutInitial);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(150L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

