/*
 * Decompiled with CFR 0.152.
 */
package com.aem.gstore;

import com.aem.gstore.DataBlock;
import com.aem.gstore.StorePacket;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import utils.message.TypedMap;

public class GenStore {
    public static boolean DEBUG_GENSTORE_UPDATES = false;
    public static boolean DEBUG_COLLATION_TIMEOUTS = false;
    public static boolean DEBUG_COLLATION_CONCURRENCY = false;
    long begin = 0L;
    long end = 0L;
    long maxStored;
    long maxPacketSize;
    Object stored_LOCK = new Object();
    LinkedList<DataBlock> stored = new LinkedList();
    private static final String TM_LONG_LAST = "lastPoint";
    File stateFile;
    TypedMap state;

    public GenStore(long maxStoredBytes, long maxPacketSize, File stateFile) {
        this.maxStored = maxStoredBytes;
        this.maxPacketSize = maxPacketSize;
        this.stateFile = stateFile;
        if (stateFile != null) {
            try {
                long lastPoint;
                this.state = TypedMap.fromFile((File)stateFile);
                this.begin = lastPoint = this.state.getLong(TM_LONG_LAST);
                this.end = lastPoint;
                System.out.println("[GenStore] Loaded, last data point initialised to " + this.end);
            }
            catch (IOException x) {
                this.state = new TypedMap();
            }
            catch (Exception x) {
                System.out.println("Unable to load genstore: " + x);
                x.printStackTrace();
                this.state = new TypedMap();
            }
        }
    }

    private void saveLastPoint() {
        if (this.state != null) {
            try {
                this.state.setLong(TM_LONG_LAST, this.end);
                this.state.toFile(this.stateFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private long length() {
        return (long)this.stored.size() * this.maxPacketSize;
    }

    public long getEarliestDataPoint() {
        return this.begin;
    }

    public long getLatestDataPoint() {
        return this.end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacket(StorePacket packet) {
        Object object = this.stored_LOCK;
        synchronized (object) {
            packet.setPacketIndex(this.end);
            if (DEBUG_GENSTORE_UPDATES) {
                System.out.println("[GenStore] Adding " + packet);
            }
            ArrayList<DataBlock> list = packet.split(this.maxPacketSize);
            for (DataBlock block : list) {
                this.stored.add(block);
                this.end += (long)block.getLength();
                this.saveLastPoint();
                while (this.length() > this.maxStored || this.stored.size() > 0 && this.stored.getFirst().position != 0L) {
                    boolean trimming = false;
                    if (this.stored.size() > 0 && this.stored.getFirst().position != 0L) {
                        trimming = true;
                    }
                    DataBlock removed = this.stored.removeFirst();
                    System.out.println("[GenStore] ...dropped " + removed + " (" + (trimming ? "trimming partial packet" : "making space") + ")");
                    this.begin += (long)removed.getLength();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DataBlock> getBlocksFrom(long from, long maxBytes) {
        Object object = this.stored_LOCK;
        synchronized (object) {
            long cumulativeLength = 0L;
            ArrayList<DataBlock> list = new ArrayList<DataBlock>();
            boolean havePacketStart = false;
            long firstFullPacketUID = -1L;
            for (int i = 0; i < this.stored.size(); ++i) {
                DataBlock block = this.stored.get(i);
                if (DEBUG_GENSTORE_UPDATES) {
                    System.out.println("[GenStore] " + i + " Our scope is " + this.begin + " to " + this.end + " vs block " + block);
                }
                if (block.getOverallEnd() < this.begin || block.getOverallStart() > this.end) {
                    this.stored.remove(i--);
                    System.out.println("[GenStore] Dropped out of scope (" + this.begin + " to " + this.end + ") block " + block);
                    continue;
                }
                if (i == 0) {
                    block.setEarliestBlock(true);
                }
                if (block.getOverallEnd() <= from) continue;
                if (block.isFirstInPacket() && !havePacketStart) {
                    havePacketStart = true;
                    firstFullPacketUID = block.getPacketUID();
                }
                if (list.size() > 0 && havePacketStart && block.getPacketUID() != firstFullPacketUID && cumulativeLength + (long)block.getLength() > maxBytes) break;
                list.add(block);
                cumulativeLength += (long)block.getLength();
            }
            if (list.size() > 0) {
                list.get(list.size() - 1).setNoMoreBlocks(true);
            }
            return list;
        }
    }
}

