/*
 * Decompiled with CFR 0.152.
 */
package com.aem;

import com.aem.CentralDebugging;
import com.aem.shelp.util.FixedByteBuffer;
import com.aem.utils.os.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import jwrapper.jwutils.swing.JWAutomate;
import utils.stream.OpenByteArrayOutputStream;
import utils.swing.TextFieldPrintStream;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;

public class CentralDebugger
extends SimpleHelpFrame
implements ActionListener,
WindowListener,
KeyListener {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy MMM dd (EEE), HH:mm:ss.SSS");
    JPanel tracer = new JPanel();
    JButton trace = new JButton("Trace");
    JButton heap = new JButton("Memory Dump");
    JButton tcopy = new JButton("Copy All");
    JButton sshots = new JButton("SShots");
    JTextArea tshow = new JTextArea();
    JPanel simulation = new JPanel();
    JTextField simname = new JTextField("SimulationOne");
    JToggleButton record = new JToggleButton("Record");
    JToggleButton playback = new JToggleButton("Play");
    JLabel recstatus = new JLabel("");
    ButtonGroup simgroup = new ButtonGroup();
    JPanel logging = new JPanel();
    JToggleButton sclock = new JToggleButton("Scroll", true);
    JButton lcopy = new JButton("Copy All");
    JButton lmark = new JButton("Mark");
    JToggleButton bufA = new JToggleButton("10KB", false);
    JToggleButton bufB = new JToggleButton("100KB", true);
    JToggleButton bufC = new JToggleButton("1MB", false);
    JToggleButton bufD = new JToggleButton("5MB", false);
    JTextArea logs = new JTextArea();
    TextFieldPrintStream logstream;
    JPanel logger = new JPanel();
    JButton log = new JButton("Get Log");
    JPanel switches = new JPanel();
    JButton apply = new JButton("Apply");
    JPanel counters = new JPanel();
    JButton update = new JButton("Update");
    JButton reset = new JButton("Reset All");
    JToggleButton updateo = new JToggleButton("(Off)");
    JToggleButton updatef = new JToggleButton("(Fast)");
    JToggleButton updatem = new JToggleButton("(Medium)");
    JToggleButton updates = new JToggleButton("(Slow)");
    JTabbedPane pane;
    JTextArea cshow = new JTextArea();
    File debugtxt;
    String sysinfo = "(NO SYSTEM INFO)";
    HashMap gens = new HashMap();
    HashMap feds = new HashMap();
    static CentralDebugger INSTANCE = null;
    boolean cutDown;
    int MARK = 0;
    ArrayList keys = new ArrayList();

    public CentralDebugger(String dir, String name, boolean cutDown) {
        super((cutDown ? "Session Console: " : "CDBG: ") + name);
        this.cutDown = cutDown;
        INSTANCE = this;
        if (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        this.debugtxt = new File(dir + File.separator + "debug.txt");
        Field[] fields = CentralDebugging.class.getDeclaredFields();
        this.pane = new JTabbedPane();
        this.getContentPane().add(this.pane);
        Object debug = new Object();
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke("control shift D"), debug);
        this.pane.getActionMap().put(debug, new DebugAction());
        this.pane.addTab("Logging", this.logging);
        this.pane.addTab("Tracing", this.tracer);
        if (!cutDown) {
            this.pane.addTab("Switches", this.switches);
        }
        if (!cutDown) {
            this.pane.addTab("Counters", this.counters);
        }
        this.logging.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        this.logging.add("North", buttons);
        this.logging.add("Center", new JScrollPane(this.logs));
        OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();
        PrintStream pout = new PrintStream((OutputStream)bout);
        this.sysinfo = SystemInfo.getFullInfo();
        pout.println(this.sysinfo);
        try {
            FixedByteBuffer.INSTANCE.writeContentsTo(pout);
        }
        catch (NullPointerException x) {
            x.printStackTrace();
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        this.logs.setText(new String(bout.getByteArray(), 0, bout.size()));
        bout = null;
        String header = this.sysinfo + "\r\n--- Log follows... ---\r\n";
        this.logstream = new TextFieldPrintStream(this.logs, header);
        this.logs.setEditable(false);
        buttons.setLayout((LayoutManager)new ScaledFlowLayout(0));
        buttons.add(this.bufA);
        buttons.add(this.bufB);
        buttons.add(this.bufC);
        buttons.add(this.bufD);
        buttons.add(this.sclock);
        buttons.add(this.lcopy);
        buttons.add(this.lmark);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.bufA);
        bg.add(this.bufB);
        bg.add(this.bufC);
        bg.add(this.bufD);
        this.tracer.setLayout(new BorderLayout());
        buttons = new JPanel();
        this.tracer.add("North", buttons);
        this.tracer.add("Center", new JScrollPane(this.tshow));
        this.tshow.setEditable(false);
        buttons.setLayout((LayoutManager)new ScaledFlowLayout(0));
        buttons.add(this.heap);
        buttons.add(this.trace);
        buttons.add(this.tcopy);
        buttons.add(this.sshots);
        this.counters.setLayout(new BorderLayout());
        buttons = new JPanel();
        this.counters.add("North", buttons);
        this.counters.add("Center", new JScrollPane(this.cshow));
        this.cshow.setFont(new Font("Monospaced", 0, SimpleHelpLookAndFeel.scale((int)12)));
        this.cshow.setEditable(false);
        buttons.setLayout((LayoutManager)new ScaledFlowLayout());
        buttons.add(this.update);
        buttons.add(this.reset);
        buttons.add(this.updateo);
        buttons.add(this.updatef);
        buttons.add(this.updatem);
        buttons.add(this.updates);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.updateo);
        bg2.add(this.updatef);
        bg2.add(this.updatem);
        bg2.add(this.updates);
        this.updateo.setSelected(true);
        this.switches.setLayout(new BorderLayout());
        JPanel inner = new JPanel();
        this.switches.add("Center", new JScrollPane(inner, 20, 31));
        Arrays.sort(fields, new FieldComparator());
        int N = 0;
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            if (!Modifier.isPublic(fields[i].getModifiers())) continue;
            ++N;
        }
        GridLayout gl = new GridLayout(N, 2);
        inner.setLayout(gl);
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            if (!Modifier.isPublic(fields[i].getModifiers())) continue;
            inner.add(new JLabel(fields[i].getName()));
            if (Boolean.TYPE.isAssignableFrom(fields[i].getType())) {
                JCheckBox cb = new JCheckBox();
                inner.add(cb);
                this.gens.put(fields[i].getName(), cb);
                this.feds.put(fields[i].getName(), fields[i]);
                try {
                    cb.setSelected((Boolean)fields[i].get(null));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            JTextField tf = new JTextField();
            inner.add(tf);
            this.gens.put(fields[i].getName(), tf);
            this.feds.put(fields[i].getName(), fields[i]);
            try {
                tf.setText("" + fields[i].get(null));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JPanel buttons2 = new JPanel();
        this.switches.add("North", buttons2);
        buttons2.setLayout((LayoutManager)new ScaledFlowLayout());
        buttons2.add(this.apply);
        this.simgroup.add(this.record);
        this.simgroup.add(this.playback);
        this.simulation.setLayout((LayoutManager)new ScaledFlowLayout(1));
        this.simulation.add(this.simname);
        this.simulation.add(this.record);
        this.simulation.add(this.playback);
        this.simulation.add(this.recstatus);
        this.heap.addActionListener(this);
        this.trace.addActionListener(this);
        this.tcopy.addActionListener(this);
        this.sshots.addActionListener(this);
        this.update.addActionListener(this);
        this.reset.addActionListener(this);
        this.updatef.addActionListener(this);
        this.updatem.addActionListener(this);
        this.updates.addActionListener(this);
        this.apply.addActionListener(this);
        this.sclock.addActionListener(this);
        this.lcopy.addActionListener(this);
        this.lmark.addActionListener(this);
        this.bufA.addActionListener(this);
        this.bufB.addActionListener(this);
        this.bufC.addActionListener(this);
        this.bufD.addActionListener(this);
        this.record.addActionListener(this);
        this.playback.addActionListener(this);
        this.addWindowListener(this);
        try {
            this.setIconImage(ImageLoader.getAsImage((String)"images/svg/logos/simplehelp-blue.svg,48"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBounds(0, 0, 640, 480);
        this.setVisible(true);
        new UpdateThread().start();
    }

    public PrintStream getPrintStream() {
        return this.logstream;
    }

    public static void forceMetricsOn() {
        CentralDebugging.ALL_METRICS = true;
    }

    public static void forceMetricsOff() {
        CentralDebugging.ALL_METRICS = false;
    }

    public static void doCountersUpdateAndStop() {
        if (INSTANCE != null) {
            CentralDebugger.INSTANCE.updateo.setSelected(true);
            CentralDebugger.INSTANCE.updatef.setSelected(false);
            CentralDebugger.INSTANCE.updatem.setSelected(false);
            CentralDebugger.INSTANCE.updates.setSelected(false);
            INSTANCE.actionPerformed(CentralDebugger.INSTANCE.update);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    public void actionPerformed(Object o) {
        if (o == this.sclock) {
            this.logstream.setUpdate(this.sclock.isSelected());
        } else if (o == this.lcopy) {
            String data = this.logs.getText();
            try {
                Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection sel = new StringSelection(data);
                clipb.setContents(sel, sel);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (o == this.lmark) {
            StringBuffer sb = new StringBuffer();
            sb.append("\r\n---------------------------------\r\n");
            sb.append("             MARK " + ++this.MARK + "\r\n");
            sb.append("---------------------------------\r\n\r\n");
            System.out.println(sb.toString());
        } else if (o == this.bufA) {
            this.logstream.setMax(10000);
        } else if (o == this.bufB) {
            this.logstream.setMax(100000);
        } else if (o == this.bufC) {
            this.logstream.setMax(1000000);
        } else if (o == this.bufD) {
            this.logstream.setMax(5000000);
        } else if (o == this.sshots) {
            File[] files;
            FileDialog fd = new FileDialog((Frame)((Object)this));
            fd.setMode(1);
            fd.setVisible(true);
            try {
                Method m = fd.getClass().getMethod("getFiles", new Class[0]);
                files = (File[])m.invoke((Object)fd, new Object[0]);
            }
            catch (Throwable t) {
                files = new File[]{new File(new File(fd.getDirectory()), fd.getFile())};
            }
            if (files != null && files.length > 0) {
                File parent = files[0].getParentFile();
                String file = files[0].getName();
                System.out.println("Selected file " + files[0]);
                Component[] frames = Frame.getFrames();
                if (!file.toLowerCase().endsWith("html")) {
                    file = file + ".html";
                }
                System.out.println("Target file " + file);
                File target = new File(parent, file);
                System.out.println("Dumping screenshots to " + target);
                try {
                    JWAutomate.dumpScreenshots((Component[])frames, (File)target, (boolean)false, (Class[])new Class[]{JLabel.class, AbstractButton.class, Scrollbar.class});
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        } else if (o == this.tcopy) {
            String data = this.tshow.getText();
            try {
                Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection sel = new StringSelection(data);
                clipb.setContents(sel, sel);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (o == this.heap) {
            String targetFile;
            FileDialog fd = new FileDialog((Frame)((Object)this), "Save Memory Dump", 1);
            fd.setVisible(true);
            String dir = fd.getDirectory();
            if (!dir.endsWith(File.separator)) {
                dir = dir + File.separator;
            }
            if ((targetFile = dir + fd.getFile()) != null) {
                System.out.println("[MemoryTracking] Dumping heap to '" + targetFile + "' now");
                try {
                    Class.forName("utils.progtools.HeapDumper").getMethod("dumpHeap", String.class, Boolean.TYPE).invoke(null, targetFile, Boolean.TRUE);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else if (o == this.trace) {
            StringBuffer sb = new StringBuffer();
            try {
                Method method = Thread.class.getMethod("getAllStackTraces", new Class[0]);
                Map map = (Map)method.invoke(null, new Object[0]);
                Object[] keys = map.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    Thread th = (Thread)keys[i];
                    StackTraceElement[] stack = (StackTraceElement[])map.get(th);
                    sb.append("(id " + CentralDebugging.getThreadID(th) + ") " + th.getName() + "\n");
                    for (int k = 0; k < stack.length; ++k) {
                        sb.append("\tat " + stack[k] + "\n");
                    }
                    sb.append("\n");
                }
                this.tshow.setText(sb.toString());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else if (o == this.reset) {
            CentralDebugging.ALL_METRICS = true;
            CentralDebugging.clearAllMetrics();
        } else if (o == this.update) {
            CentralDebugging.ALL_METRICS = true;
            CentralDebugging.timerStart("test");
            CentralDebugging.timerStop("test");
            HashMap map = CentralDebugging.getMetricsSnapshot();
            Object[] keys = map.keySet().toArray();
            Arrays.sort(keys);
            StringBuffer sb = new StringBuffer();
            sb.append(this.sdf.format(new Date()));
            sb.append("\n\n");
            for (int i = 0; i < keys.length; ++i) {
                sb.append(keys[i] + " = " + map.get(keys[i]));
                sb.append("\n");
            }
            sb.append("\n");
            sb.append(CentralDebugging.getTimerSummary());
            this.cshow.setText(sb.toString());
            this.cshow.repaint();
        } else if (o == this.apply) {
            Object[] keys = this.feds.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                Field field = (Field)this.feds.get(keys[i]);
                JComponent comp = (JComponent)this.gens.get(keys[i]);
                try {
                    if (comp instanceof JCheckBox) {
                        field.set(null, new Boolean(((JCheckBox)comp).isSelected()));
                        continue;
                    }
                    JTextField tf = (JTextField)comp;
                    String val = tf.getText();
                    if (Long.class.isAssignableFrom(field.getType())) {
                        field.set(null, new Long(val));
                        continue;
                    }
                    if (Integer.class.isAssignableFrom(field.getType())) {
                        field.set(null, new Integer(val));
                        continue;
                    }
                    if (Double.class.isAssignableFrom(field.getType())) {
                        field.set(null, new Double(val));
                        continue;
                    }
                    if (String.class.isAssignableFrom(field.getType())) {
                        field.set(null, val);
                        continue;
                    }
                    if (Float.class.isAssignableFrom(field.getType())) {
                        field.set(null, new Float(val));
                        continue;
                    }
                    if (Short.class.isAssignableFrom(field.getType())) {
                        field.set(null, new Short(val));
                        continue;
                    }
                    if (!Character.class.isAssignableFrom(field.getType())) continue;
                    field.set(null, new Character(val.charAt(0)));
                    continue;
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            CentralDebugging.applyDebugSettings();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keys.add(new Integer(e.getKeyCode()));
        if (this.keys.contains(new Integer(17)) && this.keys.contains(new Integer(16)) && this.keys.contains(new Integer(68))) {
            System.out.println("[CentralDebugger] debugging enabled");
            if (this.cutDown) {
                this.cutDown = false;
                this.pane.addTab("Switches", this.switches);
                this.pane.addTab("Counters", this.counters);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keys.clear();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    class DebugAction
    extends AbstractAction {
        DebugAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("[CentralDebugger] debugging enabled");
            if (CentralDebugger.this.cutDown) {
                CentralDebugger.this.cutDown = false;
                CentralDebugger.this.pane.addTab("Switches", CentralDebugger.this.switches);
                CentralDebugger.this.pane.addTab("Counters", CentralDebugger.this.counters);
            }
        }
    }

    class FieldComparator
    implements Comparator {
        FieldComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Field f1 = (Field)arg0;
            Field f2 = (Field)arg1;
            return f1.getName().compareTo(f2.getName());
        }
    }

    class RecordingThread
    extends Thread {
        RecordingThread() {
        }

        @Override
        public void run() {
            try {
                CentralDebugger.this.recstatus.setText("Recording in 4...");
                CentralDebugger.this.recstatus.repaint();
                Thread.sleep(1000L);
                CentralDebugger.this.recstatus.setText("Recording in 3...");
                CentralDebugger.this.recstatus.repaint();
                Thread.sleep(1000L);
                CentralDebugger.this.recstatus.setText("Recording in 2...");
                CentralDebugger.this.recstatus.repaint();
                Thread.sleep(1000L);
                CentralDebugger.this.recstatus.setText("Recording in 1...");
                CentralDebugger.this.recstatus.repaint();
                Thread.sleep(1000L);
                CentralDebugger.this.recstatus.setText("Recording now...");
                CentralDebugger.this.recstatus.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class UpdateThread
    extends Thread {
        UpdateThread() {
        }

        @Override
        public void run() {
            int N = 0;
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++N;
                if (CentralDebugger.this.updatef.isSelected()) {
                    CentralDebugger.this.actionPerformed(CentralDebugger.this.update);
                    N = 0;
                }
                if (CentralDebugger.this.updatem.isSelected() && N >= 5) {
                    CentralDebugger.this.actionPerformed(CentralDebugger.this.update);
                    N = 0;
                }
                if (!CentralDebugger.this.updates.isSelected() || N < 25) continue;
                CentralDebugger.this.actionPerformed(CentralDebugger.this.update);
                N = 0;
            }
        }
    }
}

