/*
 * Decompiled with CFR 0.152.
 */
package bcutil;

import bcutil.BCUMTInputStream;
import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import bcutil.BCUtilOutputStream;
import bcutil.BCUtilPool;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.progtools.OnDemandPipeline;
import utils.progtools.PipelineJob;
import utils.stream.OpenBoutPool;
import utils.stream.OpenByteArrayOutputStream;

public class BCUMTOutputStream
extends OutputStream {
    private static final int MAX = 40960;
    private DataOutputStream out;
    private BCUtil origBCU;
    private BCUtilPool bcus;
    OnDemandPipeline pipeline = new OnDemandPipeline();
    OpenBoutPool pool = new OpenBoutPool(this.pipeline.getConcurrency() * 4, 100000);
    private OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();
    IOException failure;

    public BCUMTOutputStream(OutputStream out, BCUtil bcu) {
        this.out = new DataOutputStream(out);
        this.origBCU = bcu;
        this.bcus = new BCUtilPool(bcu, this.pipeline.getConcurrency() * 4);
    }

    @Override
    public final void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public final void flush() throws IOException {
        if (this.bout.size() > 0) {
            this.writeChunk();
        }
        this.pipeline.add(new PipelineJob(){

            @Override
            public void parallelTask() {
            }

            @Override
            public void finalOrderedTask() {
                try {
                    BCUMTOutputStream.this.out.flush();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        });
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.bout.write(b);
        if (this.bout.size() > 40960) {
            this.writeChunk();
        }
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.bout.write(b, off, len);
        if (this.bout.size() > 40960) {
            this.writeChunk();
        }
    }

    @Override
    public final void write(int b) throws IOException {
        this.bout.write(b);
        if (this.bout.size() > 40960) {
            this.writeChunk();
        }
    }

    private void writeChunk() throws IOException {
        if (this.failure != null) {
            IOException throwme = this.failure;
            this.failure = null;
            throw throwme;
        }
        final OpenByteArrayOutputStream unencrypted = this.pool.getBout();
        unencrypted.reset();
        unencrypted.write(this.bout.getByteArray(), 0, this.bout.size());
        this.bout.reset();
        final OpenByteArrayOutputStream encrypted = this.pool.getBout();
        encrypted.reset();
        final BCUtil mybcu = this.bcus.getBCU();
        this.pipeline.add(new PipelineJob(){

            @Override
            public void parallelTask() {
                try {
                    mybcu.wrap(unencrypted.getByteArray(), unencrypted.size(), new DataOutputStream((OutputStream)encrypted));
                }
                catch (IOException x) {
                    BCUMTOutputStream.this.failure = x;
                }
                finally {
                    BCUMTOutputStream.this.bcus.done((Object)mybcu);
                    BCUMTOutputStream.this.pool.done((Object)unencrypted);
                }
            }

            @Override
            public void finalOrderedTask() {
                try {
                    BCUMTOutputStream.this.out.write(encrypted.getByteArray(), 0, encrypted.size());
                }
                catch (IOException x) {
                    BCUMTOutputStream.this.failure = x;
                }
                finally {
                    BCUMTOutputStream.this.pool.done((Object)encrypted);
                }
            }
        });
    }

    public static void main(String[] args) throws IOException {
        int i;
        BCUtil.removeCpuBounding();
        int max = 400000000;
        OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream(max);
        BCUtil orig = new BCUtil();
        orig.initFromSecret("x", "x", 1);
        double megs = max / 1000000;
        byte[] dat = new byte[100000];
        Object mtout = new BCUtilOutputStream((OutputStream)bout, orig);
        int iterations = max / dat.length;
        long T = System.currentTimeMillis();
        for (i = 0; i < iterations; ++i) {
            mtout.write(dat);
        }
        T = System.currentTimeMillis() - T;
        System.out.println("BCU ST Write: " + megs / ((double)T / 1000.0) + " MB/s");
        dat = new byte[100000];
        mtout = new BCUMTOutputStream((OutputStream)bout, orig);
        iterations = max / dat.length;
        T = System.currentTimeMillis();
        for (i = 0; i < iterations; ++i) {
            ((BCUMTOutputStream)mtout).write(dat);
        }
        T = System.currentTimeMillis() - T;
        System.out.println("BCU MT Write: " + megs / ((double)T / 1000.0) + " MB/s");
        dat = new byte[100000];
        Object mtin = new BCUtilInputStream((InputStream)new ByteArrayInputStream(bout.getByteArray(), 0, bout.size()), orig);
        long T2 = System.currentTimeMillis();
        int N = 0;
        try {
            while (N != -1) {
                N = mtin.read(dat, 0, dat.length);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        T2 = System.currentTimeMillis() - T2;
        System.out.println("BCU ST Read: " + megs / ((double)T2 / 1000.0) + " MB/s");
        dat = new byte[100000];
        mtin = new BCUMTInputStream(new ByteArrayInputStream(bout.getByteArray(), 0, bout.size()), orig);
        T2 = System.currentTimeMillis();
        N = 0;
        try {
            while (N != -1) {
                N = ((BCUMTInputStream)mtin).read(dat, 0, dat.length);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        T2 = System.currentTimeMillis() - T2;
        System.out.println("BCU MT Read: " + megs / ((double)T2 / 1000.0) + " MB/s");
        System.exit(0);
    }
}

