/*
 * Decompiled with CFR 0.152.
 */
package bcutil;

import bcutil.BCUtil;
import bcutil.BCUtilPool;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.SynchronousQueue;
import utils.progtools.BufferPool;
import utils.progtools.OnDemandPipeline;
import utils.progtools.PipelineJob;
import utils.stream.OpenBoutPool;
import utils.stream.OpenByteArrayOutputStream;

public class BCUMTInputStream
extends InputStream {
    private DataInputStream in;
    private BCUtil bcu;
    private int cptr = 0;
    private int clen = 0;
    private byte[] chunk = new byte[0];
    private BCUtil origBCU;
    private BCUtilPool bcus;
    OnDemandPipeline pipeline = new OnDemandPipeline();
    OpenBoutPool pool = new OpenBoutPool(this.pipeline.getConcurrency() * 4, 100000);
    BufferPool buffers = new BufferPool(this.pipeline.getConcurrency() * 4);
    private OpenByteArrayOutputStream plain = new OpenByteArrayOutputStream();
    SynchronousQueue<OpenByteArrayOutputStream> synchronousQueue = new SynchronousQueue();
    Thread reader;
    IOException failState;

    public BCUMTInputStream(InputStream in, BCUtil bcu) {
        this.in = new DataInputStream(in);
        this.bcu = bcu;
        this.bcus = new BCUtilPool(bcu, this.pipeline.getConcurrency() * 4);
    }

    @Override
    public int read() throws IOException {
        if (this.readNextChunk() == -1) {
            return -1;
        }
        return 0xFF & this.chunk[this.cptr++];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.readNextChunk() == -1) {
            return -1;
        }
        int rem_clen = this.clen - this.cptr;
        int minlen = Math.min(len, rem_clen);
        System.arraycopy(this.chunk, this.cptr, b, off, minlen);
        this.cptr += minlen;
        return minlen;
    }

    public int readNextChunk() throws IOException {
        if (this.cptr < this.clen) {
            return 0;
        }
        try {
            int n = this.readChunk();
            if (n == -1) {
                return -1;
            }
            while (this.plain.size() == 0) {
                n = this.readChunk();
                if (n != -1) continue;
                return -1;
            }
            this.chunk = this.plain.getByteArray();
            this.cptr = 0;
            this.clen = this.plain.size();
            return this.plain.size();
        }
        catch (EOFException e) {
            return -1;
        }
    }

    private int readChunk() throws IOException {
        boolean DEBUG = false;
        if (this.reader == null) {
            this.reader = new Thread(){

                @Override
                public void run() {
                    this.setPriority(9);
                    try {
                        while (true) {
                            final OpenByteArrayOutputStream mypacket = BCUMTInputStream.this.pool.getBout();
                            final OpenByteArrayOutputStream myinterim = BCUMTInputStream.this.pool.getBout();
                            final OpenByteArrayOutputStream myplain = BCUMTInputStream.this.pool.getBout();
                            mypacket.reset();
                            myinterim.reset();
                            myplain.reset();
                            final byte[] buffer = (byte[])BCUMTInputStream.this.buffers.get();
                            int size = BCUMTInputStream.this.bcu.grabPacket(BCUMTInputStream.this.in, mypacket, buffer);
                            final BCUtil mybcu = BCUMTInputStream.this.bcus.getBCU();
                            BCUMTInputStream.this.pipeline.add(new PipelineJob(){
                                int read;

                                @Override
                                public void parallelTask() {
                                    try {
                                        DataInputStream din = new DataInputStream(new ByteArrayInputStream(mypacket.getByteArray(), 0, mypacket.size()));
                                        this.read = mybcu.unwrapHighPerformance(din, myinterim, buffer, myplain);
                                    }
                                    catch (IOException x) {
                                        x.printStackTrace();
                                    }
                                    finally {
                                        BCUMTInputStream.this.pool.done((Object)mypacket);
                                        BCUMTInputStream.this.pool.done((Object)myinterim);
                                    }
                                }

                                @Override
                                public void finalOrderedTask() {
                                    try {
                                        BCUMTInputStream.this.synchronousQueue.put(myplain);
                                    }
                                    catch (InterruptedException x) {
                                        x.printStackTrace();
                                    }
                                    BCUMTInputStream.this.buffers.done((Object)buffer);
                                    BCUMTInputStream.this.bcus.done((Object)mybcu);
                                }
                            });
                        }
                    }
                    catch (IOException x) {
                        BCUMTInputStream.this.failState = x;
                        System.out.println("Closing synchronous queue");
                        try {
                            BCUMTInputStream.this.synchronousQueue.put(new OpenByteArrayOutputStream());
                        }
                        catch (InterruptedException xx) {
                            xx.printStackTrace();
                        }
                        return;
                    }
                }
            };
            this.reader.start();
        }
        try {
            if (this.failState != null) {
                throw this.failState;
            }
            OpenByteArrayOutputStream myplain = this.synchronousQueue.take();
            if (this.failState != null) {
                throw this.failState;
            }
            this.plain.reset();
            this.plain.write(myplain.getByteArray(), 0, myplain.size());
            int read = myplain.size();
            this.pool.done((Object)myplain);
            return read;
        }
        catch (InterruptedException x) {
            x.printStackTrace();
            return -1;
        }
    }
}

