/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.slidinglayout;

import aurelienribon.tweenengine.Tween;
import aurelienribon.tweenengine.TweenAccessor;
import aurelienribon.tweenengine.TweenManager;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SLAnimator {
    private static final List<TweenManager> tweenManagers = new ArrayList<TweenManager>();
    private static boolean running = false;

    public static TweenManager createTweenManager() {
        TweenManager tm = new TweenManager();
        tweenManagers.add(tm);
        return tm;
    }

    public static void start() {
        running = true;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                long lastMillis = System.currentTimeMillis();
                long deltaLastMillis = System.currentTimeMillis();
                while (running) {
                    long newMillis = System.currentTimeMillis();
                    long sleep = 15L - (newMillis - lastMillis);
                    lastMillis = newMillis;
                    if (sleep > 1L) {
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    long deltaNewMillis = System.currentTimeMillis();
                    final float delta = (float)(deltaNewMillis - deltaLastMillis) / 1000.0f;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                int n = tweenManagers.size();
                                for (int i = 0; i < n; ++i) {
                                    ((TweenManager)tweenManagers.get(i)).update(delta);
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    deltaLastMillis = newMillis;
                }
            }
        };
        new Thread(runnable).start();
    }

    public static void stop() {
        running = false;
    }

    static {
        Tween.registerAccessor(JComponent.class, (TweenAccessor)new ComponentAccessor());
        Tween.setCombinedAttributesLimit((int)4);
    }

    public static class ComponentAccessor
    implements TweenAccessor<Component> {
        public static final int X = 1;
        public static final int Y = 2;
        public static final int XY = 3;
        public static final int W = 4;
        public static final int H = 5;
        public static final int WH = 6;
        public static final int XYWH = 7;

        public int getValues(Component target, int tweenType, float[] returnValues) {
            switch (tweenType) {
                case 1: {
                    returnValues[0] = target.getX();
                    return 1;
                }
                case 2: {
                    returnValues[0] = target.getY();
                    return 1;
                }
                case 3: {
                    returnValues[0] = target.getX();
                    returnValues[1] = target.getY();
                    return 2;
                }
                case 4: {
                    returnValues[0] = target.getWidth();
                    return 1;
                }
                case 5: {
                    returnValues[0] = target.getHeight();
                    return 1;
                }
                case 6: {
                    returnValues[0] = target.getWidth();
                    returnValues[1] = target.getHeight();
                    return 2;
                }
                case 7: {
                    returnValues[0] = target.getX();
                    returnValues[1] = target.getY();
                    returnValues[2] = target.getWidth();
                    returnValues[3] = target.getHeight();
                    return 4;
                }
            }
            return -1;
        }

        public void setValues(Component target, int tweenType, float[] newValues) {
            switch (tweenType) {
                case 1: {
                    target.setLocation(Math.round(newValues[0]), target.getY());
                    break;
                }
                case 2: {
                    target.setLocation(target.getX(), Math.round(newValues[0]));
                    break;
                }
                case 3: {
                    target.setLocation(Math.round(newValues[0]), Math.round(newValues[1]));
                    break;
                }
                case 4: {
                    target.setSize(Math.round(newValues[0]), target.getHeight());
                    target.validate();
                    break;
                }
                case 5: {
                    target.setSize(target.getWidth(), Math.round(newValues[0]));
                    target.validate();
                    break;
                }
                case 6: {
                    target.setSize(Math.round(newValues[0]), Math.round(newValues[1]));
                    target.validate();
                    break;
                }
                case 7: {
                    target.setBounds(Math.round(newValues[0]), Math.round(newValues[1]), Math.round(newValues[2]), Math.round(newValues[3]));
                    target.validate();
                }
            }
        }
    }
}

