/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.seaglass;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class MacEditorKit
extends DefaultEditorKit {
    private static final long serialVersionUID = 7463251678121983829L;
    public static final String deletePrevWordAction = "delete-previous-word";
    public static final String deleteNextWordAction = "delete-next-word";
    private static final Action[] actions;

    @Override
    public Action[] getActions() {
        return actions;
    }

    static void provideErrorFeedback(Component component) {
        Toolkit toolkit = null;
        toolkit = component != null ? component.getToolkit() : Toolkit.getDefaultToolkit();
        toolkit.beep();
    }

    static {
        Action[] dekActions = new DefaultEditorKit().getActions();
        HashMap<Object, Action> dekActionMap = new HashMap<Object, Action>();
        for (int i = 0; i < dekActions.length; ++i) {
            dekActionMap.put(dekActions[i].getValue("Name"), dekActions[i]);
        }
        HashMap actionMap = (HashMap)dekActionMap.clone();
        actionMap.put(deleteNextWordAction, new DeleteNextWordAction());
        actionMap.put(deletePrevWordAction, new DeletePrevWordAction());
        actionMap.put("caret-up", new VerticalAction("caret-up", (TextAction)dekActionMap.get("caret-up"), (TextAction)dekActionMap.get("caret-begin")));
        actionMap.put("caret-down", new VerticalAction("caret-down", (TextAction)dekActionMap.get("caret-down"), (TextAction)dekActionMap.get("caret-end")));
        actionMap.put("selection-up", new VerticalAction("selection-up", (TextAction)dekActionMap.get("selection-up"), (TextAction)dekActionMap.get("selection-begin")));
        actionMap.put("selection-down", new VerticalAction("selection-down", (TextAction)dekActionMap.get("selection-down"), (TextAction)dekActionMap.get("selection-end")));
        actions = actionMap.values().toArray(new Action[0]);
    }

    static class DeleteNextWordAction
    extends TextAction {
        private static final long serialVersionUID = 5038003137392979803L;

        DeleteNextWordAction() {
            super(MacEditorKit.deleteNextWordAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            boolean beep = true;
            if (target != null && target.isEditable()) {
                try {
                    int endOffs;
                    int offs = target.getCaretPosition();
                    String s = target.getDocument().getText(offs, 1);
                    if (Character.isWhitespace(s.charAt(0))) {
                        endOffs = Utilities.getNextWord(target, offs);
                        endOffs = Utilities.getWordEnd(target, endOffs);
                    } else {
                        endOffs = Utilities.getWordEnd(target, offs);
                    }
                    target.moveCaretPosition(endOffs);
                    target.replaceSelection("");
                    beep = false;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (beep) {
                MacEditorKit.provideErrorFeedback(target);
            }
        }
    }

    static class DeletePrevWordAction
    extends TextAction {
        private static final long serialVersionUID = -6352466583853318023L;

        DeletePrevWordAction() {
            super(MacEditorKit.deletePrevWordAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            boolean beep = true;
            if (target != null && target.isEditable()) {
                int offs = target.getCaretPosition();
                boolean failed = false;
                try {
                    offs = Utilities.getPreviousWord(target, offs);
                }
                catch (BadLocationException bl) {
                    if (offs != 0) {
                        offs = 0;
                    }
                    failed = true;
                }
                if (!failed) {
                    target.moveCaretPosition(offs);
                    target.replaceSelection("");
                    beep = false;
                }
            }
            if (beep) {
                MacEditorKit.provideErrorFeedback(target);
            }
        }
    }

    static class VerticalAction
    extends TextAction {
        private static final long serialVersionUID = -6471615785308538422L;
        private TextAction verticalAction;
        private TextAction beginEndAction;

        VerticalAction(String name, TextAction verticalAction, TextAction beginEndAction) {
            super(name);
            this.verticalAction = verticalAction;
            this.beginEndAction = beginEndAction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                Caret caret = target.getCaret();
                int dot = caret.getDot();
                this.verticalAction.actionPerformed(e);
                if (dot == caret.getDot()) {
                    Point magic = caret.getMagicCaretPosition();
                    this.beginEndAction.actionPerformed(e);
                    caret.setMagicCaretPosition(magic);
                }
            }
        }
    }
}

