/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.HSLColor;
import utils.switches.oem.OEMSwitches;

public class SHUI {
    public static int TEXT_FIELD_HEIGHT = 28;
    public static final ButtonColor BUTTON_NORMAL = !OEMSwitches.DARK_THEME ? new ButtonColor(SimpleHelpLookAndFeel.isHDPI() ? new Color(90, 140, 232) : new Color(128, 168, 232), new Color(247, 252, 255), new Color(233, 242, 255)) : new ButtonColor(new Color(135, 133, 132), new Color(119, 117, 116), new Color(110, 108, 107));
    public static final ButtonColor BUTTON_GREEN = !OEMSwitches.DARK_THEME ? new ButtonColor(new Color(114, 196, 114), new Color(233, 255, 233), new Color(213, 255, 213)) : new ButtonColor(new Color(114, 196, 114), new Color(111, 179, 88), new Color(90, 145, 71));
    public static final ButtonColor BUTTON_RED;
    public static final ButtonColor BUTTON_BLUE;
    public static final Color SLIDER_TRACK;
    public static final Color SLIDER_TICKS;
    public static final Color TRACK_FILL;
    public static final Color TRACK_LINE;
    public static final Color SCROLL_BUTTON_ARROW;
    public static final Color CHECKBOX_TICK;
    public static final Color CHECKBOX_TICK_DISABLED;
    public static final Color RADIO_BLOB;
    public static final Color RADIO_BLOB_DISABLED;
    public static final Color TEXT_BORDER;
    public static final Color TEXT_BORDER_DISABLED;
    public static final Color DIVIDER_COLOR;
    public static final Color TABLE_HEADER_BORDER;
    public static final Color POPUP_BACKGROUND;
    public static final Color POPUP_BORDER;

    private static final Color disabled(Color c) {
        return new HSLColor(c).adjustSaturation(0.0f);
    }

    static {
        ButtonColor buttonColor = BUTTON_RED = !OEMSwitches.DARK_THEME ? new ButtonColor(new Color(232, 108, 96), new Color(255, 237, 237), new Color(255, 230, 230)) : new ButtonColor(new Color(246, 111, 99), new Color(232, 108, 96), new Color(207, 96, 86));
        BUTTON_BLUE = !OEMSwitches.DARK_THEME ? new ButtonColor(SimpleHelpLookAndFeel.isHDPI() ? new Color(90, 140, 232) : new Color(128, 168, 232), new Color(233, 242, 255), new HSLColor(new Color(233, 242, 255)).adjustTone(-5.0f)) : new ButtonColor(new Color(125, 162, 223), new Color(93, 156, 255), new Color(80, 131, 226));
        SLIDER_TRACK = new Color(164, 164, 164);
        SLIDER_TICKS = new Color(164, 164, 164);
        TRACK_FILL = !OEMSwitches.DARK_THEME ? new Color(244, 244, 244) : new Color(111, 114, 121);
        TRACK_LINE = !OEMSwitches.DARK_THEME ? new Color(200, 200, 200) : new Color(142, 146, 155);
        SCROLL_BUTTON_ARROW = !OEMSwitches.DARK_THEME ? Color.DARK_GRAY : new Color(240, 240, 240);
        CHECKBOX_TICK = !OEMSwitches.DARK_THEME ? Color.DARK_GRAY : Color.WHITE;
        CHECKBOX_TICK_DISABLED = Color.LIGHT_GRAY;
        RADIO_BLOB = !OEMSwitches.DARK_THEME ? new Color(144, 170, 210) : Color.WHITE;
        RADIO_BLOB_DISABLED = Color.LIGHT_GRAY;
        TEXT_BORDER = !OEMSwitches.DARK_THEME ? (SimpleHelpLookAndFeel.isHDPI() ? new Color(123, 140, 200) : RADIO_BLOB) : new Color(125, 125, 127);
        TEXT_BORDER_DISABLED = BUTTON_NORMAL.getDisabledBorder();
        TABLE_HEADER_BORDER = DIVIDER_COLOR = !OEMSwitches.DARK_THEME ? new Color(200, 200, 200) : new Color(100, 100, 100);
        POPUP_BACKGROUND = SHStyle.PANEL_BACKGROUND_LIGHT;
        POPUP_BORDER = SHStyle.BORDER_COLOR;
    }

    public static class ButtonColor {
        public Color border;
        public Color top;
        public Color bottom;
        private Color disabledTop;
        private Color disabledBottom;
        private Color disabledBorder;
        private Color selectedTopAndBottom;

        public ButtonColor(Color border, Color top, Color bottom) {
            this.border = border;
            this.top = top;
            this.bottom = bottom;
        }

        public Color getSelectedBackground() {
            if (this.selectedTopAndBottom == null) {
                this.selectedTopAndBottom = !OEMSwitches.DARK_THEME ? new HSLColor(this.bottom).adjustTone(-5.0f) : new HSLColor(this.bottom).adjustTone(30.0f);
            }
            return this.selectedTopAndBottom;
        }

        public Color getDisabledTop() {
            if (this.disabledTop == null) {
                this.disabledTop = new HSLColor(this.top).adjustSaturation(0.0f);
            }
            return this.disabledTop;
        }

        public Color getDisabledBottom() {
            if (this.disabledBottom == null) {
                this.disabledBottom = new HSLColor(this.bottom).adjustSaturation(0.0f);
            }
            return this.disabledBottom;
        }

        public Color getDisabledBorder() {
            if (this.disabledBorder == null) {
                this.disabledBorder = new HSLColor(this.border).adjustSaturation(0.0f);
            }
            return this.disabledBorder;
        }

        public Paint getGradient(boolean enabled, int height, boolean selected) {
            if (enabled) {
                if (selected) {
                    return new GradientPaint(0.0f, 0.0f, this.getSelectedBackground(), 0.0f, height, this.getSelectedBackground());
                }
                return new GradientPaint(0.0f, 0.0f, this.top, 0.0f, height, this.bottom);
            }
            return new GradientPaint(0.0f, 0.0f, this.getDisabledTop(), 0.0f, height, this.getDisabledBottom());
        }
    }
}

