/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.plaf.basic.BasicArrowButton;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SHScrollButton
extends BasicArrowButton {
    private int buttonWidth;
    private GeneralPath arrowPath;

    public SHScrollButton(int orientation, int width) {
        super(orientation);
        this.buttonWidth = width;
        this.setBorder(null);
        this.setOpaque(false);
        this.setRolloverEnabled(true);
        this.setMargin(new ScaledInsets(0, 0, 0, 0));
        float arrowWidth = SimpleHelpLookAndFeel.scale(6);
        this.arrowPath = new GeneralPath();
        this.arrowPath.moveTo(-arrowWidth / 2.0f, arrowWidth / 4.0f);
        this.arrowPath.lineTo(0.0f, -arrowWidth / 4.0f);
        this.arrowPath.lineTo(arrowWidth / 2.0f, arrowWidth / 4.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        float strokeWidth = SHButtonUI.getBorderStrokeWidth();
        g2d.setStroke(SHButtonUI.getBorderStroke());
        g2d.setColor(SHStyle.PANEL_BACKGROUND_MEDIUM);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(SHUI.TRACK_LINE);
        if (this.getDirection() == 1 || this.getDirection() == 5) {
            g2d.draw(new Line2D.Float(this.getWidth(), 0.0f, this.getWidth(), this.getHeight()));
            g2d.draw(new Line2D.Float(0.0f, 0.0f, 0.0f, this.getHeight()));
        } else {
            g2d.draw(new Line2D.Float(0.0f, this.getHeight(), this.getWidth(), this.getHeight()));
            g2d.draw(new Line2D.Float(0.0f, 0.0f, this.getWidth(), 0.0f));
        }
        g2d.setColor(SHUI.SCROLL_BUTTON_ARROW);
        g2d.setStroke(new BasicStroke(SimpleHelpLookAndFeel.scale(1.0f)));
        double theta = 0.0;
        if (this.getDirection() == 5) {
            theta = Math.PI;
        } else if (this.getDirection() == 3) {
            theta = 1.5707963267948966;
        } else if (this.getDirection() == 7) {
            theta = 4.71238898038469;
        }
        AffineTransform oldTransform = g2d.getTransform();
        try {
            g2d.translate((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
            g2d.rotate(theta, 0.0, 0.0);
            g2d.draw(this.arrowPath);
        }
        finally {
            g2d.setTransform(oldTransform);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.buttonWidth, this.buttonWidth);
    }
}

