/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import utils.swing.customlaf.LegacySwingUtils;
import utils.swing.customlaf.SHRadioButtonIcon;
import utils.switches.oem.OEMSwitches;

public class SHRadioButtonUI
extends BasicRadioButtonUI {
    private static final SHRadioButtonUI staticButtonUI = new SHRadioButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return staticButtonUI;
    }

    @Override
    public void installUI(JComponent arg0) {
        super.installUI(arg0);
        this.icon = new SHRadioButtonIcon();
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = LegacySwingUtils.getFontMetrics(c, g);
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            LegacySwingUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else if (!OEMSwitches.DARK_THEME) {
            g.setColor(b.getBackground().brighter());
            LegacySwingUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset() + 1);
            g.setColor(b.getBackground().darker());
            LegacySwingUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(UIManager.getColor("textInactiveText"));
            LegacySwingUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        }
    }
}

